/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.generate.actions.OCCppActionContext;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateConstructorContext;
import com.jetbrains.cidr.lang.generate.handlers.OCClassActionHandlerBase;
import com.jetbrains.cidr.lang.generate.handlers.OCGenerateConstructorHandler;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCConstructorInitializationList;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.quickfixes.OCAddFieldInitializerFix;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureActionHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCAddParametersToConstructorIntentionAction
extends OCClassActionHandlerBase<OCStructSymbol, OCFunctionSymbol, OCCppActionContext<OCStructSymbol, OCFunctionSymbol>>
implements IntentionAction {
    @NotNull
    public String getText() {
        if ("Add as a parameter to constructor" == null) {
            OCAddParametersToConstructorIntentionAction.$$$reportNull$$$0(0);
        }
        return "Add as a parameter to constructor";
    }

    @Override
    protected String getActionTitle() {
        return "Add Parameter to Constructor";
    }

    @Override
    protected String getMembersChooserTitle() {
        return "Select Constructor to Update";
    }

    @Override
    protected Class<? extends OCSymbolDeclarator> getParentClass() {
        return OCStruct.class;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            OCAddParametersToConstructorIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file) {
        if (project2 == null) {
            OCAddParametersToConstructorIntentionAction.$$$reportNull$$$0(2);
        }
        return file instanceof OCFile && ((OCFile)file).isCpp() && this.getField(editor, file) != null;
    }

    @Nullable
    protected OCDeclaratorSymbol getField(Editor editor, PsiFile file) {
        OCDeclaration declaration;
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        OCDeclarator declarator = OCElementUtil.getAdjacentParentOfType(element, OCDeclarator.class);
        if (declarator == null && (declaration = (OCDeclaration)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCDeclaration.class})) != null && declaration.getDeclarators().size() > 0) {
            declarator = declaration.getDeclarators().get(0);
        }
        if (declarator == null) {
            return null;
        }
        OCSymbol symbol = declarator.getSymbol();
        if (symbol instanceof OCDeclaratorSymbol && symbol.getKind() == OCSymbolKind.STRUCT_FIELD) {
            return (OCDeclaratorSymbol)symbol;
        }
        return null;
    }

    @Override
    protected boolean enableChooseDialog(Collection<OCFunctionSymbol> candidates) {
        return candidates.size() > 1;
    }

    @Override
    protected boolean allowMultiSelection(OCCppActionContext<OCStructSymbol, OCFunctionSymbol> context) {
        return false;
    }

    @Override
    protected boolean allowEmptySelection(OCCppActionContext<OCStructSymbol, OCFunctionSymbol> context) {
        return true;
    }

    @Override
    @Nullable
    protected OCCppActionContext<OCStructSymbol, OCFunctionSymbol> evaluateActionContext(final Project project2, @Nullable Editor editor, @NotNull PsiFile file) {
        if (file == null) {
            OCAddParametersToConstructorIntentionAction.$$$reportNull$$$0(3);
        }
        final OCStructSymbol parent = (OCStructSymbol)this.getParent(project2, editor, file);
        final OCDeclaratorSymbol field = this.getField(editor, file);
        if (parent == null || field == null) {
            return null;
        }
        return new OCCppActionContext<OCStructSymbol, OCFunctionSymbol>(parent, field.locateDefinition(project2)){

            @Override
            @NotNull
            public Collection<OCFunctionSymbol> getMemberCandidates() {
                CommonProcessors.CollectProcessor<OCFunctionSymbol> collector = new CommonProcessors.CollectProcessor<OCFunctionSymbol>(){

                    protected boolean accept(OCFunctionSymbol constructor) {
                        OCConstructorInitializationList initializationList;
                        if ((constructor = (OCFunctionSymbol)constructor.getDefinitionSymbol(project2)) == null) {
                            return false;
                        }
                        OCFunctionDefinition function = (OCFunctionDefinition)constructor.locateFunctionDefinition(project2);
                        OCConstructorInitializationList oCConstructorInitializationList = initializationList = function != null ? function.getConstructorInitializationList() : null;
                        if (initializationList != null) {
                            for (OCConstructorFieldInitializer initializer : initializationList.getInitializers()) {
                                OCReferenceElement referenceElement = initializer.getReferenceElement();
                                OCSymbol symbol = referenceElement != null ? referenceElement.resolveToSymbol() : null;
                                if (!field.equals(symbol)) continue;
                                return false;
                            }
                        }
                        return true;
                    }
                };
                parent.processConstructors((Processor<? super OCFunctionSymbol>)collector);
                Collection collection = collector.getResults();
                if (collection == null) {
                    1.$$$reportNull$$$0(0);
                }
                return collection;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/intentions/OCAddParametersToConstructorIntentionAction$1", "getMemberCandidates"));
            }
        };
    }

    @Override
    @Nullable
    protected OCCppActionContext<OCStructSymbol, OCFunctionSymbol> evaluateActionContext(OCStructSymbol parent, @NotNull PsiElement element) {
        if (element == null) {
            OCAddParametersToConstructorIntentionAction.$$$reportNull$$$0(4);
        }
        return null;
    }

    @Override
    protected void performAction(@NotNull Project project2, Editor editor, @NotNull PsiFile file, final @NotNull OCCppActionContext<OCStructSymbol, OCFunctionSymbol> context, @NotNull List<OCFunctionSymbol> chosenCandidates) {
        OCFunctionDefinition constructor;
        if (project2 == null) {
            OCAddParametersToConstructorIntentionAction.$$$reportNull$$$0(5);
        }
        if (file == null) {
            OCAddParametersToConstructorIntentionAction.$$$reportNull$$$0(6);
        }
        if (context == null) {
            OCAddParametersToConstructorIntentionAction.$$$reportNull$$$0(7);
        }
        if (chosenCandidates == null) {
            OCAddParametersToConstructorIntentionAction.$$$reportNull$$$0(8);
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        final OCDeclaratorSymbol field = this.getField(editor, file);
        if (field == null) {
            return;
        }
        if (chosenCandidates.size() == 0) {
            new OCGenerateConstructorHandler(){

                @Override
                @NotNull
                protected OCGenerateConstructorContext evaluateActionContext(OCStructSymbol parent, @NotNull PsiElement context2) {
                    if (context2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    OCGenerateConstructorContext oCGenerateConstructorContext = new OCGenerateConstructorContext(parent, context2){

                        @Override
                        @NotNull
                        public Collection<OCDeclaratorSymbol> getMemberCandidates() {
                            List<OCDeclaratorSymbol> list = Collections.singletonList(field);
                            if (list == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return list;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/intentions/OCAddParametersToConstructorIntentionAction$2$1", "getMemberCandidates"));
                        }
                    };
                    if (oCGenerateConstructorContext == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return oCGenerateConstructorContext;
                }

                @Override
                @NotNull
                protected List<? extends OCStructSymbol> getParents(@NotNull PsiElement at) {
                    if (at == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    List list = Collections.singletonList(context.getParent());
                    if (list == null) {
                        2.$$$reportNull$$$0(3);
                    }
                    return list;
                }

                @Override
                protected boolean enableChooseDialog(Collection<OCDeclaratorSymbol> candidates) {
                    return false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: 
                        case 3: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: 
                        case 3: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "context";
                            break;
                        }
                        case 1: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/jetbrains/cidr/lang/intentions/OCAddParametersToConstructorIntentionAction$2";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "at";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/jetbrains/cidr/lang/intentions/OCAddParametersToConstructorIntentionAction$2";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "evaluateActionContext";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getParents";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "evaluateActionContext";
                            break;
                        }
                        case 1: 
                        case 3: {
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "getParents";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: 
                        case 3: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            }.invoke(project2, null, file);
            return;
        }
        assert (chosenCandidates.size() == 1);
        OCFunctionSymbol constructorSymbol = (OCFunctionSymbol)chosenCandidates.get(0).getDefinitionSymbol(project2);
        OCFunctionDefinition oCFunctionDefinition = constructor = constructorSymbol != null ? (OCFunctionDefinition)constructorSymbol.locateFunctionDefinition(project2) : null;
        if (constructor == null) {
            return;
        }
        OCChangeSignatureHandler handler = OCChangeSignatureActionHandler.getHandler((OCCallable)constructor, constructor);
        String paramName = OCNameSuggester.suggestUniqueName(OCSymbolKind.PARAMETER, field.getName(), null, (Collection<String>)ContainerUtil.map(constructorSymbol.getParameterSymbols(), symbol -> symbol.getName()));
        handler.addParameter(paramName, field.getType(), -1);
        handler.getGeneratedInfo().runOnSuccess(() -> OCAddFieldInitializerFix.addFieldInitializer(constructor, field, paramName));
        handler.setTitle(this.getActionTitle());
        handler.invoke();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/intentions/OCAddParametersToConstructorIntentionAction";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chosenCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/intentions/OCAddParametersToConstructorIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "evaluateActionContext";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "performAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

