/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateMethodActionContext;
import com.jetbrains.cidr.lang.generate.actions.OCObjCActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCClassActionHandlerBase;
import com.jetbrains.cidr.lang.generate.handlers.OCGenerateInitWithHandler;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCReleaseVariablesIntentionAction;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureActionHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCParameterInfo;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCAddParametersToInitWithIntentionAction
extends OCClassActionHandlerBase<OCClassSymbol, OCMethodSymbol, OCObjCActionContext<OCMethodSymbol>>
implements IntentionAction {
    @NotNull
    public String getText() {
        if ("Add as a parameter to 'initWith...'" == null) {
            OCAddParametersToInitWithIntentionAction.$$$reportNull$$$0(0);
        }
        return "Add as a parameter to 'initWith...'";
    }

    @Override
    protected String getActionTitle() {
        return "Add Parameter to 'initWith...'";
    }

    @Override
    protected String getMembersChooserTitle() {
        return "Select 'initWith...' Method to Update";
    }

    @Override
    protected Class<? extends OCSymbolDeclarator> getParentClass() {
        return OCClassDeclaration.class;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            OCAddParametersToInitWithIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file) {
        if (project2 == null) {
            OCAddParametersToInitWithIntentionAction.$$$reportNull$$$0(2);
        }
        return OCAddParametersToInitWithIntentionAction.getInstanceVariable(editor, file) != null;
    }

    @Nullable
    private static OCInstanceVariableSymbol getInstanceVariable(Editor editor, PsiFile file) {
        OCDeclaration declaration;
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        OCDeclarator declarator = OCElementUtil.getAdjacentParentOfType(element, OCDeclarator.class);
        if (declarator == null && (declaration = (OCDeclaration)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCDeclaration.class})) != null && declaration.getDeclarators().size() > 0) {
            declarator = declaration.getDeclarators().get(0);
        }
        if (declarator == null) {
            return null;
        }
        OCSymbol symbol = declarator.getSymbol();
        if (symbol instanceof OCInstanceVariableSymbol) {
            return (OCInstanceVariableSymbol)symbol;
        }
        if (symbol instanceof OCPropertySymbol) {
            return ((OCPropertySymbol)symbol).getAssociatedIvar(file.getProject());
        }
        return null;
    }

    @Nullable
    private static PsiElement getTargetInitializationBlock(OCMethod method) {
        if (method == null) {
            return null;
        }
        OCBlockStatement body = method.getBody();
        if (body == null) {
            return null;
        }
        List<OCStatement> statements = body.getStatements();
        if (statements.size() < 2 || !(statements.get(1) instanceof OCIfStatement)) {
            return null;
        }
        OCIfStatement ifStmt = (OCIfStatement)statements.get(1);
        if (ifStmt.getThenBranch() instanceof OCBlockStatement) {
            return ifStmt.getThenBranch();
        }
        return null;
    }

    @Override
    protected boolean enableChooseDialog(Collection<OCMethodSymbol> candidates) {
        return candidates.size() > 1;
    }

    @Override
    protected boolean allowMultiSelection(OCObjCActionContext<OCMethodSymbol> context) {
        return false;
    }

    @Override
    protected boolean allowEmptySelection(OCObjCActionContext<OCMethodSymbol> context) {
        return true;
    }

    @Override
    @NotNull
    protected OCObjCActionContext<OCMethodSymbol> evaluateActionContext(OCClassSymbol parent, @NotNull PsiElement element) {
        if (element == null) {
            OCAddParametersToInitWithIntentionAction.$$$reportNull$$$0(3);
        }
        OCObjCActionContext<OCMethodSymbol> oCObjCActionContext = new OCObjCActionContext<OCMethodSymbol>(parent, element, parent.getResolvedType(OCResolveContext.forPsi(element), true)){

            @Override
            protected Class<OCMethodSymbol> getMemberSymbolClass() {
                return OCMethodSymbol.class;
            }

            @Override
            @NotNull
            public Collection<OCMethodSymbol> getMemberCandidates() {
                CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor();
                this.getImplementationSymbol().processMembers(this.getMemberSymbolClass(), collector);
                Collection collection = collector.getResults();
                if (collection == null) {
                    1.$$$reportNull$$$0(0);
                }
                return collection;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/intentions/OCAddParametersToInitWithIntentionAction$1", "getMemberCandidates"));
            }
        };
        if (oCObjCActionContext == null) {
            OCAddParametersToInitWithIntentionAction.$$$reportNull$$$0(4);
        }
        return oCObjCActionContext;
    }

    @Override
    @NotNull
    protected Condition<OCMethodSymbol> getCandidatesFilter(@NotNull OCObjCActionContext<OCMethodSymbol> actionContext) {
        if (actionContext == null) {
            OCAddParametersToInitWithIntentionAction.$$$reportNull$$$0(5);
        }
        Condition condition = methodSymbol -> {
            if (actionContext == null) {
                OCAddParametersToInitWithIntentionAction.$$$reportNull$$$0(13);
            }
            if (!methodSymbol.getName().startsWith("initWith")) {
                return false;
            }
            Object method = methodSymbol.locateDefinition(actionContext.getProject());
            return method instanceof OCMethod && OCAddParametersToInitWithIntentionAction.getTargetInitializationBlock((OCMethod)method) != null;
        };
        if (condition == null) {
            OCAddParametersToInitWithIntentionAction.$$$reportNull$$$0(6);
        }
        return condition;
    }

    @Override
    protected void performAction(@NotNull Project project2, @Nullable Editor editor, @NotNull PsiFile file, @NotNull OCObjCActionContext<OCMethodSymbol> context, @NotNull List<OCMethodSymbol> chosenCandidates) {
        if (project2 == null) {
            OCAddParametersToInitWithIntentionAction.$$$reportNull$$$0(7);
        }
        if (file == null) {
            OCAddParametersToInitWithIntentionAction.$$$reportNull$$$0(8);
        }
        if (context == null) {
            OCAddParametersToInitWithIntentionAction.$$$reportNull$$$0(9);
        }
        if (chosenCandidates == null) {
            OCAddParametersToInitWithIntentionAction.$$$reportNull$$$0(10);
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        final OCInstanceVariableSymbol ivar = OCAddParametersToInitWithIntentionAction.getInstanceVariable(editor, file);
        if (ivar == null) {
            return;
        }
        if (chosenCandidates.size() == 0) {
            new OCGenerateInitWithHandler(){

                @Override
                @NotNull
                protected OCGenerateMethodActionContext evaluateActionContext(OCClassSymbol parent, @NotNull PsiElement element) {
                    if (element == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    OCGenerateMethodActionContext superContext = super.evaluateActionContext(parent, element);
                    OCGenerateMethodActionContext oCGenerateMethodActionContext = new OCGenerateMethodActionContext((OCClassSymbol)superContext.getParent(), Collections.singletonList(superContext.getBaseMethod()), superContext.getType(), element){

                        @Override
                        @NotNull
                        public Collection<OCInstanceVariableSymbol> getMemberCandidates() {
                            List<OCInstanceVariableSymbol> list = Collections.singletonList(ivar);
                            if (list == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return list;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/intentions/OCAddParametersToInitWithIntentionAction$2$1", "getMemberCandidates"));
                        }
                    };
                    if (oCGenerateMethodActionContext == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return oCGenerateMethodActionContext;
                }

                @Override
                protected boolean enableChooseDialog(Collection<OCInstanceVariableSymbol> candidates) {
                    return false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/jetbrains/cidr/lang/intentions/OCAddParametersToInitWithIntentionAction$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/jetbrains/cidr/lang/intentions/OCAddParametersToInitWithIntentionAction$2";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "evaluateActionContext";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "evaluateActionContext";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            }.invoke(project2, editor, file);
            return;
        }
        assert (chosenCandidates.size() == 1);
        Object method = chosenCandidates.get(0).locateDefinition(project2);
        if (!(method instanceof OCMethod)) {
            return;
        }
        OCClassDeclaration methodParent = (OCClassDeclaration)PsiTreeUtil.getParentOfType(method, OCClassDeclaration.class);
        OCChangeSignatureHandler handler = OCChangeSignatureActionHandler.getHandler((OCCallable)method, method);
        final OCParameterInfo newParameter = handler.addParameter(OCNameSuggester.getNonCollidingName(ivar, true, project2), OCNameSuggester.getNonCollidingName(ivar, project2), ivar.getType(), -1, false);
        handler.getGeneratedInfo().runOnSuccess(() -> {
            if (project2 == null) {
                OCAddParametersToInitWithIntentionAction.$$$reportNull$$$0(11);
            }
            if (context == null) {
                OCAddParametersToInitWithIntentionAction.$$$reportNull$$$0(12);
            }
            for (final OCCallable callable : handler.getNewCallables()) {
                if (methodParent != PsiTreeUtil.getParentOfType((PsiElement)callable, OCClassDeclaration.class)) continue;
                PsiElement block = OCAddParametersToInitWithIntentionAction.getTargetInitializationBlock((OCMethod)callable);
                if (block != null) {
                    OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project2).getCustomSettings(OCCodeStyleSettings.class);
                    ArrayList<OCInstanceVariableSymbol> nonReleasedIvars = new ArrayList<OCInstanceVariableSymbol>();
                    boolean useSetters = settings != null && settings.USE_SETTERS_IN_CONSTRUCTOR;
                    boolean retainObjects = settings == null || settings.RETAIN_OBJECT_PARAMETERS_IN_CONSTRUCTOR;
                    PsiFile file1 = block.getContainingFile();
                    String text = OCGenerateInitWithHandler.getInitializerText(Collections.singletonList(ivar), Collections.singletonList(newParameter), newParameter.getOldIndex(), file1, useSetters, retainObjects, nonReleasedIvars);
                    OCChangeUtil.add(block, OCElementFactory.statementFromText(text, block));
                    if (!nonReleasedIvars.isEmpty()) {
                        Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(file1);
                        if (document != null) {
                            PsiDocumentManager.getInstance((Project)project2).doPostponedOperationsAndUnblockDocument(document);
                        }
                        new OCReleaseVariablesIntentionAction(nonReleasedIvars, project2).invoke(project2, editor, file1);
                    }
                }
                List<OCMethodSelectorPart> parameters = ((OCMethod)callable).getParameters();
                int index = -1;
                for (int i = 0; i < parameters.size(); ++i) {
                    if (!newParameter.getName().equals(parameters.get(i).getParameterName())) continue;
                    index = i;
                }
                if (index == -1) {
                    return;
                }
                String objectMethodName = OCGenerateInitWithHandler.getObjectMethodSignature(((OCMethod)method).getSelector(), false, context.getType(), OCResolveContext.forPsi(method));
                for (PsiElement child : methodParent.getChildren()) {
                    if (!(child instanceof OCMethod) || !((OCMethod)child).getSelector().equals(objectMethodName)) continue;
                    final int finalIndex = index;
                    child.accept((PsiElementVisitor)new OCRecursiveVisitor(){

                        @Override
                        public void visitSendMessageExpression(OCSendMessageExpression expression) {
                            List<OCExpression> params;
                            if (expression.getMessageSelector().equals(((OCMethod)callable).getSelector()) && (params = expression.getArgumentExpressions()).size() > finalIndex) {
                                OCChangeUtil.replaceHandlingMacros(params.get(finalIndex), OCElementFactory.expressionFromText(newParameter.getName(), expression));
                            }
                        }
                    });
                    OCChangeSignatureHandler objectHandler = OCChangeSignatureActionHandler.getHandler((OCCallable)child, child, true);
                    objectHandler.insertParameter(newParameter.getSelector(), newParameter.getName(), newParameter.getType(), finalIndex, -1, false);
                    objectHandler.invokeSynchronously();
                }
                return;
            }
        });
        handler.setTitle(this.getActionTitle());
        handler.invoke();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/intentions/OCAddParametersToInitWithIntentionAction";
                break;
            }
            case 2: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionContext";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chosenCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/intentions/OCAddParametersToInitWithIntentionAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateActionContext";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidatesFilter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "evaluateActionContext";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCandidatesFilter";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "performAction";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$performAction$1";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getCandidatesFilter$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

