/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCondition;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCReturnStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class OCConvertIfToTernaryIntentionAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (project2 == null) {
            OCConvertIfToTernaryIntentionAction.$$$reportNull$$$0(0);
        }
        if (element == null) {
            OCConvertIfToTernaryIntentionAction.$$$reportNull$$$0(1);
        }
        return this.createConverter(element).isAvailable();
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project2 == null) {
            OCConvertIfToTernaryIntentionAction.$$$reportNull$$$0(2);
        }
        if (element == null) {
            OCConvertIfToTernaryIntentionAction.$$$reportNull$$$0(3);
        }
        this.createConverter(element).invoke();
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            OCConvertIfToTernaryIntentionAction.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getText() {
        if ("Replace 'if else' with '?:'" == null) {
            OCConvertIfToTernaryIntentionAction.$$$reportNull$$$0(5);
        }
        return "Replace 'if else' with '?:'";
    }

    protected Converter createConverter(PsiElement element) {
        return new Converter(element);
    }

    protected OCExpression getNewExpression(Converter converter) {
        return OCElementFactory.conditionalExpression(converter.getCondition(), converter.getThenExpression(), converter.getElseExpression());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/intentions/OCConvertIfToTernaryIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/intentions/OCConvertIfToTernaryIntentionAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class Converter {
        private OCStatement myThenStatement;
        private OCStatement myElseStatement;
        private OCStatement myOriginalElseStatement;
        private OCExpression myThenExpression;
        private OCExpression myElseExpression;
        private OCExpression myCondition;
        private OCIfStatement myStatement;

        public Converter(PsiElement element) {
            PsiElement second;
            PsiElement first;
            PsiElement sibling;
            OCIfStatement statement2 = (OCIfStatement)PsiTreeUtil.getParentOfType((PsiElement)element, OCIfStatement.class, (boolean)false);
            if (statement2 == null) {
                return;
            }
            this.myStatement = statement2;
            OCCondition condition = statement2.getCondition();
            if (condition == null || condition.getExpression() == null) {
                return;
            }
            this.myCondition = condition.getExpression();
            this.myThenStatement = statement2.getThenBranch();
            this.myElseStatement = statement2.getElseBranch();
            if (this.myElseStatement == null && (sibling = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)statement2)) instanceof OCReturnStatement) {
                this.myElseStatement = (OCStatement)sibling;
            }
            this.myOriginalElseStatement = this.myElseStatement;
            while (this.myThenStatement instanceof OCBlockStatement && ((OCBlockStatement)this.myThenStatement).getStatements().size() == 1) {
                this.myThenStatement = ((OCBlockStatement)this.myThenStatement).getStatements().get(0);
            }
            while (this.myElseStatement instanceof OCBlockStatement && ((OCBlockStatement)this.myElseStatement).getStatements().size() == 1) {
                this.myElseStatement = ((OCBlockStatement)this.myElseStatement).getStatements().get(0);
            }
            if (this.myThenStatement == null || this.myElseStatement == null) {
                return;
            }
            Pair<PsiElement, PsiElement> diff = OCElementUtil.getElementsDiff(this.myThenStatement, this.myElseStatement);
            if (diff == null) {
                return;
            }
            for (first = (PsiElement)diff.first; first != null && !(first instanceof OCExpression) && first != this.myThenStatement; first = first.getParent()) {
            }
            for (second = (PsiElement)diff.second; second != null && !(second instanceof OCExpression) && second != this.myElseStatement; second = second.getParent()) {
            }
            if (first instanceof OCExpression && second instanceof OCExpression) {
                this.myThenExpression = (OCExpression)first;
                this.myElseExpression = (OCExpression)second;
            }
        }

        public OCExpression getCondition() {
            return this.myCondition;
        }

        public OCExpression getThenExpression() {
            return this.myThenExpression;
        }

        public OCExpression getElseExpression() {
            return this.myElseExpression;
        }

        public boolean isAvailable() {
            OCType guessedType2;
            if (this.myThenExpression == null || this.myElseExpression == null) {
                return false;
            }
            if (!OCCodeInsightUtil.isValid(this.myThenExpression)) {
                return false;
            }
            if (!OCCodeInsightUtil.isValid(this.myThenStatement)) {
                return false;
            }
            if (!OCCodeInsightUtil.isValid(this.myElseExpression)) {
                return false;
            }
            if (!OCCodeInsightUtil.isValid(this.myElseStatement)) {
                return false;
            }
            if (!OCCodeInsightUtil.isValid(this.myCondition)) {
                return false;
            }
            OCType guessedType1 = this.myThenExpression.getResolvedType().getGuessedType();
            OCType type = guessedType1.getLeastCommonType(guessedType2 = this.myElseExpression.getResolvedType().getGuessedType(), OCResolveContext.forPsi(this.myThenExpression));
            return !type.isUnknown() && !type.isVoid();
        }

        public void invoke() {
            OCExpression result = OCConvertIfToTernaryIntentionAction.this.getNewExpression(this);
            OCParenthesesUtils.replaceExpressionAndRemoveAppendParentheses(this.myThenExpression, result);
            OCChangeUtil.replaceHandlingMacros(this.myStatement, this.myThenStatement);
            OCChangeUtil.delete(this.myOriginalElseStatement);
        }
    }
}

