/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateIvarsActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCGenerateIvarsHandler;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.introduce.OCBaseLocalConvertibleHandler;
import com.jetbrains.cidr.lang.refactoring.introduce.OCIvarInplaceIntroducer;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCConvertToIvarIntentionAction
extends OCGenerateIvarsHandler
implements IntentionAction {
    @NotNull
    public String getText() {
        if ("Convert to instance variable" == null) {
            OCConvertToIvarIntentionAction.$$$reportNull$$$0(0);
        }
        return "Convert to instance variable";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            OCConvertToIvarIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    public OCPropertySymbol locateCandidate(@NotNull Project project2, Editor editor, PsiFile file) {
        if (project2 == null) {
            OCConvertToIvarIntentionAction.$$$reportNull$$$0(2);
        }
        PsiElement at = file.findElementAt(editor.getCaretModel().getOffset());
        Object parent = OCElementUtil.getAdjacentParentOfType(at, OCReferenceElement.class, OCDeclarator.class, OCQualifiedExpression.class, OCSendMessageExpression.class);
        OCSymbol symbol = null;
        if (parent instanceof OCReferenceElement) {
            symbol = ((OCReferenceElement)parent).resolveToSymbol();
        } else if (parent instanceof OCDeclarator) {
            symbol = ((OCDeclarator)parent).getSymbol();
        } else if (parent instanceof OCQualifiedExpression) {
            symbol = ((OCQualifiedExpression)parent).resolveToSymbol();
        } else if (parent instanceof OCSendMessageExpression) {
            symbol = ((OCSendMessageExpression)parent).getProbableResponders().getKnownResponder();
        }
        if (symbol instanceof OCMethodSymbol) {
            symbol = ((OCMethodSymbol)symbol).getGeneratedFromProperty();
        }
        return symbol instanceof OCPropertySymbol ? (OCPropertySymbol)symbol : null;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file) {
        if (project2 == null) {
            OCConvertToIvarIntentionAction.$$$reportNull$$$0(3);
        }
        return OCSearchScope.isInProjectSources(this.locateCandidate(project2, editor, file), project2);
    }

    @Override
    protected OCClassSymbol getParent(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file) {
        OCPropertySymbol property;
        if (project2 == null) {
            OCConvertToIvarIntentionAction.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            OCConvertToIvarIntentionAction.$$$reportNull$$$0(5);
        }
        if (file == null) {
            OCConvertToIvarIntentionAction.$$$reportNull$$$0(6);
        }
        return (property = this.locateCandidate(project2, editor, file)) != null ? ((OCClassSymbol)property.getParent()).getMainInterface(project2) : null;
    }

    @Override
    protected boolean replaceAllProperties() {
        return true;
    }

    @Override
    protected boolean enableChooseDialog(Collection<OCPropertySymbol> candidates) {
        return false;
    }

    @Override
    protected void performAction(@NotNull Project project2, Editor editor, final @NotNull PsiFile file, final @NotNull OCGenerateIvarsActionContext context, final @NotNull List<OCPropertySymbol> properties) {
        OCPropertySymbol property;
        if (project2 == null) {
            OCConvertToIvarIntentionAction.$$$reportNull$$$0(7);
        }
        if (file == null) {
            OCConvertToIvarIntentionAction.$$$reportNull$$$0(8);
        }
        if (context == null) {
            OCConvertToIvarIntentionAction.$$$reportNull$$$0(9);
        }
        if (properties == null) {
            OCConvertToIvarIntentionAction.$$$reportNull$$$0(10);
        }
        if ((property = this.locateCandidate(project2, editor, file)) == null) {
            return;
        }
        OCInstanceVariableSymbol associatedIvar = property.getAssociatedIvar(project2);
        PsiElement at = file.findElementAt(editor.getCaretModel().getOffset());
        final OCElement element = (OCElement)OCElementUtil.getAdjacentParentOfType(at, OCReferenceElement.class, OCDeclarator.class, OCQualifiedExpression.class, OCSendMessageExpression.class);
        final String ivarName = associatedIvar != null ? associatedIvar.getName() : OCNameSuggester.getNonCollidingName(property, true, project2);
        final SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)project2).createSmartPsiElementPointer((PsiElement)element);
        OCBaseLocalConvertibleHandler handler = new OCBaseLocalConvertibleHandler("Introduce Ivar"){

            protected OCIvarInplaceIntroducer createIntroducer(Project project2, Editor editor, PsiElement expression, List<PsiElement> occurrences, String refactoringName) {
                return new OCIvarInplaceIntroducer(project2, editor, expression, occurrences, refactoringName){

                    @Override
                    public PsiElement evaluateAnchor() {
                        return element;
                    }

                    public PsiElement[] getOccurrences() {
                        PsiElement[] psiElementArray;
                        PsiElement occurrence = pointer.getElement();
                        if (occurrence != null) {
                            PsiElement[] psiElementArray2 = new PsiElement[1];
                            psiElementArray = psiElementArray2;
                            psiElementArray2[0] = occurrence;
                        } else {
                            psiElementArray = PsiElement.EMPTY_ARRAY;
                        }
                        return psiElementArray;
                    }

                    @Override
                    protected void performIntroduce() {
                        OCConvertToIvarIntentionAction.this.performAction(file, context, properties, this.getInputName(), this.myDeclareInInterfaceCb != null && !this.myDeclareInInterfaceCb.isSelected());
                    }

                    @Override
                    protected boolean askToGenerateProperty() {
                        return false;
                    }

                    @Override
                    protected String[] suggestNames(boolean replaceAll, @Nullable OCDeclarator variable) {
                        if (!ivarName.equals(property.getName())) {
                            return new String[]{ivarName, property.getName()};
                        }
                        return new String[]{ivarName};
                    }
                };
            }

            @Override
            @NotNull
            protected String getFeatureID() {
                if ("refactoring.convertToIvar" == null) {
                    1.$$$reportNull$$$0(0);
                }
                return "refactoring.convertToIvar";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/intentions/OCConvertToIvarIntentionAction$1", "getFeatureID"));
            }
        };
        handler.invoke(project2, editor, element, property.getResolvedType(OCResolveContext.forPsi((PsiElement)file)), true, false, ivarName, (OCSymbol)property.getParent());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/intentions/OCConvertToIvarIntentionAction";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/intentions/OCConvertToIvarIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "locateCandidate";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getParent";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "performAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

