/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCaseStatement;
import com.jetbrains.cidr.lang.psi.OCCondition;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCSwitchStatement;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.refactoring.util.OCBindUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolBase;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeGuesser;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCCreateMissingSwitchCasesIntentionAction
implements IntentionAction {
    @NotNull
    public String getText() {
        if ("Create missing switch cases" == null) {
            OCCreateMissingSwitchCasesIntentionAction.$$$reportNull$$$0(0);
        }
        return "Create missing switch cases";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            OCCreateMissingSwitchCasesIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file) {
        OCSwitchStatement switchStatement;
        if (project2 == null) {
            OCCreateMissingSwitchCasesIntentionAction.$$$reportNull$$$0(2);
        }
        return (switchStatement = this.getSwitchStatement(editor, file)) != null && switchStatement.getBody() instanceof OCBlockStatement && !this.getMissingCases(switchStatement).isEmpty();
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file) throws IncorrectOperationException {
        OCStatement switchBlock;
        OCSwitchStatement stmt;
        if (project2 == null) {
            OCCreateMissingSwitchCasesIntentionAction.$$$reportNull$$$0(3);
        }
        if ((stmt = this.getSwitchStatement(editor, file)) != null && OCCodeInsightUtil.isValid(stmt) && (switchBlock = stmt.getBody()) != null) {
            this.invoke(switchBlock, this.getMissingCases(stmt));
        }
    }

    protected OCSwitchStatement getSwitchStatement(Editor editor, PsiFile file) {
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        return OCElementUtil.getAdjacentParentOfType(element, OCSwitchStatement.class);
    }

    protected void invoke(OCStatement switchBlock, List<OCDeclaratorSymbol> missingCases) {
        OCResolveContext context = OCResolveContext.forPsi(switchBlock);
        for (OCDeclaratorSymbol missingCase : missingCases) {
            OCReferenceElement ref;
            String name2 = missingCase.getName();
            if (missingCase.getParent() != null) {
                name2 = missingCase.getParent().getQualifiedName().getNameWithParent() + "::" + name2;
            }
            OCCaseStatement statement2 = (OCCaseStatement)OCElementFactory.statementFromText("case " + name2 + ":break;", switchBlock);
            OCReferenceExpression expression = (OCReferenceExpression)(statement2 = OCChangeUtil.add(switchBlock, statement2)).getExpression();
            if (expression == null || (ref = expression.getReferenceElement()) == null) continue;
            OCBindUtil.setShortestPossibleName(missingCase.getResolvedQualifiedName(context), ref, missingCase);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    private List<OCDeclaratorSymbol> getMissingCases(@NotNull OCSwitchStatement stmt) {
        if (stmt == null) {
            OCCreateMissingSwitchCasesIntentionAction.$$$reportNull$$$0(4);
        }
        if (OCCodeInsightUtil.isValid(stmt)) {
            OCStatement body = stmt.getBody();
            ArrayList<Pair<Integer, Integer>> ranges = new ArrayList<Pair<Integer, Integer>>();
            ArrayList<OCCaseStatement> caseStmts = new ArrayList<OCCaseStatement>();
            boolean wasDefaultOrUnresolved = true;
            if (body != null) {
                wasDefaultOrUnresolved = OCCreateMissingSwitchCasesIntentionAction.findCaseStatements(body, ranges, caseStmts);
            }
            if (this.proceedIfDefaultOrUnresolved(wasDefaultOrUnresolved)) {
                return OCCreateMissingSwitchCasesIntentionAction.getMissingCases(stmt, ranges, (Ref<Boolean>)Ref.create((Object)false));
            }
        }
        return Collections.emptyList();
    }

    protected boolean proceedIfDefaultOrUnresolved(boolean defaultOrUnresolved) {
        return defaultOrUnresolved;
    }

    @NotNull
    public static List<OCDeclaratorSymbol> getMissingCases(@NotNull OCSwitchStatement stmt, List<Pair<Integer, Integer>> ranges, Ref<Boolean> wasField) {
        OCCondition expr;
        if (stmt == null) {
            OCCreateMissingSwitchCasesIntentionAction.$$$reportNull$$$0(5);
        }
        if ((expr = stmt.getExpression()) == null) {
            List<OCDeclaratorSymbol> list = Collections.emptyList();
            if (list == null) {
                OCCreateMissingSwitchCasesIntentionAction.$$$reportNull$$$0(6);
            }
            return list;
        }
        OCType type = OCTypeUtils.doSwitchImplicitConversion(stmt, expr.getResolvedType());
        ArrayList<OCDeclaratorSymbol> missingCases = new ArrayList<OCDeclaratorSymbol>();
        HashSet missingValues = new HashSet();
        Processor processor2 = field -> {
            if (stmt == null) {
                OCCreateMissingSwitchCasesIntentionAction.$$$reportNull$$$0(9);
            }
            Integer value = OCExpressionEvaluator.evaluateEnumConst(field, stmt.getContainingFile());
            boolean wasHandled = false;
            wasField.set((Object)true);
            if (value != null) {
                for (Pair range : ranges) {
                    if ((Integer)range.getFirst() > value || value > (Integer)range.getSecond()) continue;
                    wasHandled = true;
                    break;
                }
                if (!wasHandled && !missingValues.contains(value)) {
                    missingCases.add((OCDeclaratorSymbol)field);
                    missingValues.add(value);
                }
            }
            return true;
        };
        if (type.getTerminalType() instanceof OCStructType) {
            OCStructType structType = (OCStructType)type.getTerminalType();
            for (OCDeclaratorSymbol field2 : structType.getFields()) {
                processor2.process((Object)field2);
            }
        } else if (type.getTerminalType() instanceof OCIntType) {
            OCTypeGuesser.processGuessedEnumConsts((OCIntType)type.getTerminalType(), (Processor<OCSymbol>)processor2, stmt);
        }
        missingCases.sort(Comparator.comparingLong(OCSymbolBase::getComplexOffset));
        ArrayList<OCDeclaratorSymbol> arrayList = missingCases;
        if (arrayList == null) {
            OCCreateMissingSwitchCasesIntentionAction.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    public static boolean findCaseStatements(@NotNull OCStatement body, final List<Pair<Integer, Integer>> ranges, final List<OCCaseStatement> caseStmts) {
        if (body == null) {
            OCCreateMissingSwitchCasesIntentionAction.$$$reportNull$$$0(8);
        }
        final Ref wasDefault = Ref.create((Object)false);
        final Ref wasUnresolved = Ref.create((Object)false);
        body.accept(new OCRecursiveVisitor(){

            @Override
            public void visitCaseStatement(OCCaseStatement stmt) {
                super.visitCaseStatement(stmt);
                Pair range = null;
                if (stmt.getExpression() != null) {
                    Number integer = OCExpressionEvaluator.evaluate(stmt.getExpression());
                    if (integer != null) {
                        range = Pair.create((Object)integer.intValue(), (Object)integer.intValue());
                    } else {
                        wasUnresolved.set((Object)true);
                    }
                } else if (stmt.getRangeFirst() != null && stmt.getRangeSecond() != null) {
                    Number first = OCExpressionEvaluator.evaluate(stmt.getRangeFirst());
                    Number second = OCExpressionEvaluator.evaluate(stmt.getRangeSecond());
                    if (first != null && second != null) {
                        range = Pair.create((Object)first.intValue(), (Object)second.intValue());
                    } else {
                        wasUnresolved.set((Object)true);
                    }
                } else if (stmt.isDefault()) {
                    wasDefault.set((Object)true);
                }
                if (range != null) {
                    ranges.add(range);
                    caseStmts.add(stmt);
                }
            }

            @Override
            public void visitSwitchStatement(OCSwitchStatement stmt) {
            }
        });
        return (Boolean)wasDefault.get() != false || (Boolean)wasUnresolved.get() != false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/intentions/OCCreateMissingSwitchCasesIntentionAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stmt";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/intentions/OCCreateMissingSwitchCasesIntentionAction";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMissingCases";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMissingCases";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findCaseStatements";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getMissingCases$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

