/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDeMorganIntentionAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        OCBinaryExpression expression;
        if (project2 == null) {
            OCDeMorganIntentionAction.$$$reportNull$$$0(0);
        }
        if (element == null) {
            OCDeMorganIntentionAction.$$$reportNull$$$0(1);
        }
        if ((expression = (OCBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)element, OCBinaryExpression.class, (boolean)false)) != null && expression.getRight() != null) {
            if (expression.getOperationSign() == OCTokenTypes.ANDAND) {
                this.setText("Replace '&&' with '||'");
                return true;
            }
            if (expression.getOperationSign() == OCTokenTypes.OROR) {
                this.setText("Replace '||' with '&&'");
                return true;
            }
        }
        return false;
    }

    @NotNull
    public String getFamilyName() {
        if ("DeMorgan Law" == null) {
            OCDeMorganIntentionAction.$$$reportNull$$$0(2);
        }
        return "DeMorgan Law";
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        OCBinaryExpression binaryExpression;
        if (project2 == null) {
            OCDeMorganIntentionAction.$$$reportNull$$$0(3);
        }
        if (element == null) {
            OCDeMorganIntentionAction.$$$reportNull$$$0(4);
        }
        if ((binaryExpression = (OCBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)element, OCBinaryExpression.class, (boolean)false)) != null) {
            OCElementType operationSign = binaryExpression.getOperationSign();
            PsiElement parent = binaryExpression.getParent();
            while (OCDeMorganIntentionAction.isConjunctionExpression(parent, operationSign)) {
                binaryExpression = (OCBinaryExpression)parent;
                parent = binaryExpression.getParent();
            }
            OCExpression newExpression = OCDeMorganIntentionAction.convertConjunctionExpression(binaryExpression, operationSign);
            if (newExpression != null) {
                OCDeMorganIntentionAction.replaceExpression(newExpression, binaryExpression);
            }
        }
    }

    @Nullable
    private static OCExpression convertConjunctionExpression(@NotNull OCBinaryExpression expression, @NotNull OCElementType operatorSign) {
        if (expression == null) {
            OCDeMorganIntentionAction.$$$reportNull$$$0(5);
        }
        if (operatorSign == null) {
            OCDeMorganIntentionAction.$$$reportNull$$$0(6);
        }
        OCExpression leftExpression = OCDeMorganIntentionAction.convertExpressionPart(expression.getLeft(), operatorSign);
        OCExpression rightExpression = OCDeMorganIntentionAction.convertExpressionPart(expression.getRight(), operatorSign);
        if (leftExpression == null || rightExpression == null) {
            return null;
        }
        return OCElementFactory.binaryExpression(leftExpression, rightExpression, OCCodeInsightUtil.getInversedLogicalOperator(operatorSign));
    }

    @Nullable
    private static OCExpression convertExpressionPart(@Nullable OCExpression expression, @NotNull OCElementType operatorSign) {
        if (operatorSign == null) {
            OCDeMorganIntentionAction.$$$reportNull$$$0(7);
        }
        if (expression == null) {
            return null;
        }
        if (OCDeMorganIntentionAction.isConjunctionExpression(expression, operatorSign)) {
            return OCDeMorganIntentionAction.convertConjunctionExpression((OCBinaryExpression)expression, operatorSign);
        }
        return OCDeMorganIntentionAction.convertLeafExpression(expression);
    }

    @Nullable
    private static OCExpression convertLeafExpression(@NotNull OCExpression expression) {
        OCBinaryExpression binaryExpression;
        OCElementType operationSign;
        OCElementType oppositeOperator;
        if (expression == null) {
            OCDeMorganIntentionAction.$$$reportNull$$$0(8);
        }
        if (OCDeMorganIntentionAction.isNegated(expression)) {
            OCExpression negated = OCDeMorganIntentionAction.stripNegation((OCUnaryExpression)expression);
            if (negated == null) {
                return null;
            }
            if (OCParenthesesUtils.getPrecedence(negated, false) > 14) {
                return OCParenthesesUtils.appendParentheses(negated);
            }
            return negated;
        }
        if (expression instanceof OCBinaryExpression && (oppositeOperator = OCCodeInsightUtil.getOppositeOperator(operationSign = (binaryExpression = (OCBinaryExpression)expression).getOperationSign())) != null) {
            OCExpression left = binaryExpression.getLeft();
            OCExpression right = binaryExpression.getRight();
            return left != null && right != null ? OCElementFactory.binaryExpression(left, right, oppositeOperator) : null;
        }
        boolean appendParentheses = OCParenthesesUtils.getPrecedence(expression, false) > 3;
        return OCElementFactory.unaryExpression(appendParentheses ? OCParenthesesUtils.appendParentheses(expression) : expression, OCTokenTypes.EXCL);
    }

    private static boolean isConjunctionExpression(@Nullable PsiElement element, @NotNull OCElementType operatorSign) {
        if (operatorSign == null) {
            OCDeMorganIntentionAction.$$$reportNull$$$0(9);
        }
        if (element instanceof OCBinaryExpression) {
            OCBinaryExpression binaryExpression = (OCBinaryExpression)element;
            OCElementType tokenType = binaryExpression.getOperationSign();
            return ((Object)((Object)tokenType)).equals((Object)operatorSign);
        }
        return false;
    }

    private static void replaceExpression(@NotNull OCExpression newExpression, @NotNull OCExpression oldExpression) throws IncorrectOperationException {
        boolean parenthesesAreRequired;
        OCExpression negatedParent;
        OCExpression expressionToReplace;
        if (newExpression == null) {
            OCDeMorganIntentionAction.$$$reportNull$$$0(10);
        }
        if (oldExpression == null) {
            OCDeMorganIntentionAction.$$$reportNull$$$0(11);
        }
        OCExpression oCExpression = expressionToReplace = (negatedParent = OCDeMorganIntentionAction.findFirstNegatedParent(oldExpression)) != null ? negatedParent : oldExpression;
        if (negatedParent == null) {
            newExpression = OCElementFactory.unaryExpression(OCParenthesesUtils.appendParentheses(newExpression), OCTokenTypes.EXCL);
        }
        if (parenthesesAreRequired = OCDeMorganIntentionAction.parenthesesAreRequired(newExpression, expressionToReplace)) {
            newExpression = OCParenthesesUtils.appendParentheses(newExpression);
        }
        OCChangeUtil.replaceHandlingMacros(expressionToReplace, newExpression);
    }

    @Nullable
    private static OCExpression findFirstNegatedParent(@NotNull OCExpression expression) {
        OCUnaryExpression prefixAncestor;
        if (expression == null) {
            OCDeMorganIntentionAction.$$$reportNull$$$0(12);
        }
        OCExpression ancestor = expression;
        while (ancestor.getParent() instanceof OCParenthesizedExpression) {
            ancestor = (OCExpression)ancestor.getParent();
        }
        if (ancestor.getParent() instanceof OCUnaryExpression && OCTokenTypes.EXCL == (prefixAncestor = (OCUnaryExpression)ancestor.getParent()).getOperationSign()) {
            return prefixAncestor;
        }
        return null;
    }

    private static boolean isNegated(@Nullable OCExpression expression) {
        if (expression instanceof OCUnaryExpression) {
            OCUnaryExpression unary = (OCUnaryExpression)expression;
            return unary.getOperationSign() == OCTokenTypes.EXCL;
        }
        return false;
    }

    @Nullable
    private static OCExpression stripNegation(@NotNull OCUnaryExpression expression) {
        OCExpression operand;
        if (expression == null) {
            OCDeMorganIntentionAction.$$$reportNull$$$0(13);
        }
        if ((operand = expression.getOperand()) != null) {
            return OCParenthesesUtils.diveIntoParentheses(operand);
        }
        return null;
    }

    private static boolean parenthesesAreRequired(@NotNull OCExpression newExpression, @NotNull OCExpression sourceExpression) {
        if (newExpression == null) {
            OCDeMorganIntentionAction.$$$reportNull$$$0(14);
        }
        if (sourceExpression == null) {
            OCDeMorganIntentionAction.$$$reportNull$$$0(15);
        }
        if (newExpression instanceof OCParenthesizedExpression) {
            return false;
        }
        PsiElement parent = sourceExpression.getParent();
        if (!(parent instanceof OCExpression)) {
            return false;
        }
        OCExpression parentExpression = (OCExpression)parent;
        int newExpressionPrecedence = OCParenthesesUtils.getPrecedence(newExpression, false);
        int parentExpressionPrecedence = OCParenthesesUtils.getPrecedence(parentExpression, false);
        if (newExpressionPrecedence <= 0 || parentExpressionPrecedence <= 0) {
            return false;
        }
        return newExpressionPrecedence > parentExpressionPrecedence;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/intentions/OCDeMorganIntentionAction";
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operatorSign";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldExpression";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/intentions/OCDeMorganIntentionAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convertConjunctionExpression";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "convertExpressionPart";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "convertLeafExpression";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isConjunctionExpression";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "replaceExpression";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findFirstNegatedParent";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "stripNegation";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parenthesesAreRequired";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

