/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public class OCFlipComparisonIntentionAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (project2 == null) {
            OCFlipComparisonIntentionAction.$$$reportNull$$$0(0);
        }
        if (element == null) {
            OCFlipComparisonIntentionAction.$$$reportNull$$$0(1);
        }
        OCBinaryExpression binaryExpression = (OCBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)element, OCBinaryExpression.class, (boolean)false);
        while (binaryExpression != null) {
            OCElementType operator = binaryExpression.getOperationSign();
            OCElementType flippedOperator = OCCodeInsightUtil.getFlippedOperator(operator);
            if (flippedOperator != null) {
                if (binaryExpression.getRight() == null) {
                    return false;
                }
                if (!OCCodeInsightUtil.isValid(binaryExpression.getLeft())) {
                    return false;
                }
                if (!OCCodeInsightUtil.isValid(binaryExpression.getRight())) {
                    return false;
                }
                String operatorText = binaryExpression.getOperationSignNode().getText();
                String flippedOperatorText = flippedOperator.getName();
                if (flippedOperatorText.equals(operatorText)) {
                    this.setText("Flip " + operatorText);
                } else {
                    this.setText("Flip " + operatorText + " to " + flippedOperatorText);
                }
                return true;
            }
            binaryExpression = (OCBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)binaryExpression, OCBinaryExpression.class);
        }
        return false;
    }

    @NotNull
    public String getFamilyName() {
        if ("Flip Binary Operation" == null) {
            OCFlipComparisonIntentionAction.$$$reportNull$$$0(2);
        }
        return "Flip Binary Operation";
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project2 == null) {
            OCFlipComparisonIntentionAction.$$$reportNull$$$0(3);
        }
        if (element == null) {
            OCFlipComparisonIntentionAction.$$$reportNull$$$0(4);
        }
        OCBinaryExpression binaryExpression = OCElementUtil.getAdjacentParentOfType(element, OCBinaryExpression.class);
        while (binaryExpression != null) {
            OCElementType sign = binaryExpression.getOperationSign();
            OCElementType flippedOperator = OCCodeInsightUtil.getFlippedOperator(sign);
            if (flippedOperator != null) {
                OCExpression right = binaryExpression.getRight();
                if (right == null) {
                    return;
                }
                String newSign = flippedOperator.getName();
                OCBinaryExpression newBinaryExpression = (OCBinaryExpression)OCElementFactory.expressionFromText("1" + newSign + "2", element);
                OCChangeUtil.replaceHandlingMacros(newBinaryExpression.getLeft(), binaryExpression.getRight());
                OCChangeUtil.replaceHandlingMacros(newBinaryExpression.getRight(), binaryExpression.getLeft());
                binaryExpression.replace(newBinaryExpression);
                return;
            }
            binaryExpression = (OCBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)binaryExpression, OCBinaryExpression.class);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/intentions/OCFlipComparisonIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/intentions/OCFlipComparisonIntentionAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

