/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.generate.OCCaretLocation;
import com.jetbrains.cidr.lang.generate.OCCppDefinitionsUtil;
import com.jetbrains.cidr.lang.generate.OCGenerateUtil;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCGenerateDefinitionsIntentionActionBase
implements IntentionAction {
    @Nls
    @NotNull
    public String getFamilyName() {
        String string = OCBundle.message("generate.definitions.intention.familyName", new Object[0]);
        if (string == null) {
            OCGenerateDefinitionsIntentionActionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file) {
        if (project2 == null) {
            OCGenerateDefinitionsIntentionActionBase.$$$reportNull$$$0(1);
        }
        assert (editor != null);
        OCFunctionSymbol function = OCGenerateDefinitionsIntentionActionBase.findFunction(editor, file);
        if (function == null || function.getQualifier() != null) {
            return false;
        }
        if (function.getParent() instanceof OCStructSymbol) {
            return false;
        }
        return OCGenerateDefinitionsIntentionActionBase.isAvailable(function, project2);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project2 == null) {
            OCGenerateDefinitionsIntentionActionBase.$$$reportNull$$$0(2);
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        OCFunctionSymbol symbol = OCGenerateDefinitionsIntentionActionBase.findFunction(editor, file);
        if (OCGenerateDefinitionsIntentionActionBase.isAvailable(symbol, project2)) {
            List<OCGenerateUtil.Replacement> replacements = OCCppDefinitionsUtil.getGenerateDefinitionReplacements(OCCaretLocation.byFile(file), OCCppDefinitionsUtil.getFunctionParent(symbol, project2), Collections.singletonList(symbol), Collections.singletonList(symbol.locateFunctionDefinition(project2)), OCCppDefinitionsUtil.InlinePolicy.get(this.isInline()));
            WriteCommandAction.runWriteCommandAction((Project)project2, (String)OCBundle.message("generate.definitions.commandName", new Object[0]), null, () -> {
                if (project2 == null) {
                    OCGenerateDefinitionsIntentionActionBase.$$$reportNull$$$0(6);
                }
                OCGenerateUtil.applyReplacements(project2, replacements, true);
            }, (PsiFile[])OCGenerateUtil.getAffectedFiles(replacements).toArray(PsiFile.EMPTY_ARRAY));
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    protected abstract boolean isInline();

    @Nullable
    private static OCFunctionSymbol findFunction(@NotNull Editor editor, @NotNull PsiFile file) {
        PsiElement at;
        OCFunctionDeclaration function;
        if (editor == null) {
            OCGenerateDefinitionsIntentionActionBase.$$$reportNull$$$0(3);
        }
        if (file == null) {
            OCGenerateDefinitionsIntentionActionBase.$$$reportNull$$$0(4);
        }
        OCSymbolWithQualifiedName symbol = (function = (OCFunctionDeclaration)PsiTreeUtil.getParentOfType((PsiElement)(at = file.findElementAt(editor.getCaretModel().getOffset())), OCFunctionDeclaration.class)) != null ? (OCSymbolWithQualifiedName)function.getSymbol() : null;
        return (OCFunctionSymbol)ObjectUtils.tryCast((Object)symbol, OCFunctionSymbol.class);
    }

    @Contract(value="null, _ -> false")
    private static boolean isAvailable(OCFunctionSymbol function, @NotNull Project project2) {
        if (project2 == null) {
            OCGenerateDefinitionsIntentionActionBase.$$$reportNull$$$0(5);
        }
        return function != null && OCCppDefinitionsUtil.shouldGenerateDefinitionsFor(function, true, project2) == OCCppDefinitionsUtil.SHOULD_GENERATE_DEFINITION.POSSIBLE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/intentions/OCGenerateDefinitionsIntentionActionBase";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/intentions/OCGenerateDefinitionsIntentionActionBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findFunction";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

