/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCIntroduceTypeDefIntentionAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        OCDeclarator declarator;
        if (project2 == null) {
            OCIntroduceTypeDefIntentionAction.$$$reportNull$$$0(0);
        }
        if (element == null) {
            OCIntroduceTypeDefIntentionAction.$$$reportNull$$$0(1);
        }
        if ((declarator = (OCDeclarator)PsiTreeUtil.getParentOfType((PsiElement)element, OCDeclarator.class, (boolean)false)) == null) {
            return false;
        }
        OCDeclaration declaration = (OCDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, OCDeclaration.class, (boolean)false);
        if (declaration == null || declaration instanceof OCFunctionDefinition || declaration instanceof OCParameterDeclaration) {
            return false;
        }
        if (declarator.getParameterList() != null) {
            return false;
        }
        List<OCDeclarator> declarators = declaration.getDeclarators();
        if (declarators.size() == 0 || declarators.size() > 1) {
            return false;
        }
        OCType type = declarator.getType();
        if (declarator.getName() != null && OCIntroduceTypeDefIntentionAction.isComplexType(type, false, false)) {
            this.setText("Introduce typedef for type " + type.getBestNameInContext(element));
            return true;
        }
        return false;
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        OCDeclarator declarator;
        if (project2 == null) {
            OCIntroduceTypeDefIntentionAction.$$$reportNull$$$0(2);
        }
        if (element == null) {
            OCIntroduceTypeDefIntentionAction.$$$reportNull$$$0(3);
        }
        if ((declarator = (OCDeclarator)PsiTreeUtil.getParentOfType((PsiElement)element, OCDeclarator.class, (boolean)false)) != null) {
            String name2 = declarator.getName();
            if (declarator.getParent() instanceof OCDeclaration) {
                OCDeclaration declaration = (OCDeclaration)declarator.getParent();
                OCDeclaration typedefDeclaration = (OCDeclaration)declaration.copy();
                PsiFile psiFile = element.getContainingFile();
                PsiElement typedef = OCElementFactory.typeElementFromText("typedef int", (PsiElement)psiFile).getFirstChild();
                typedefDeclaration.addBefore(typedef.getNextSibling(), typedefDeclaration.getFirstChild());
                typedefDeclaration.addBefore(typedef, typedefDeclaration.getFirstChild());
                OCChangeUtil.addBefore((PsiElement)psiFile, typedefDeclaration, declaration);
                OCTypeElement type = OCElementFactory.typeElementFromText(name2, declaration);
                declaration.replace(OCElementFactory.declarationByNameAndType(name2, type.getType(), declaration));
            }
        }
    }

    private static boolean isComplexType(@NotNull OCType type, boolean hasPointer, boolean hasArray) {
        if (type == null) {
            OCIntroduceTypeDefIntentionAction.$$$reportNull$$$0(4);
        }
        if (type instanceof OCPointerType) {
            if (hasArray) {
                return true;
            }
            if (hasPointer) {
                return true;
            }
            return OCIntroduceTypeDefIntentionAction.isComplexType(((OCPointerType)type).getRefType(), true, hasArray);
        }
        if (type instanceof OCReferenceType) {
            return false;
        }
        return type instanceof OCFunctionType;
    }

    @NotNull
    public String getFamilyName() {
        if ("Introduce Typedef" == null) {
            OCIntroduceTypeDefIntentionAction.$$$reportNull$$$0(5);
        }
        return "Introduce Typedef";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/intentions/OCIntroduceTypeDefIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/intentions/OCIntroduceTypeDefIntentionAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isComplexType";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

