/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.quickfixes.OCProvideStringLocalizationsIntentionAction;
import com.jetbrains.cidr.lang.refactoring.rename.OCInplaceRenameHandler;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.resolve.references.OCStringResourceReference;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLocalizeStringIntentionAction
implements IntentionAction {
    @NotNull
    public String getText() {
        if ("Localize the string" == null) {
            OCLocalizeStringIntentionAction.$$$reportNull$$$0(0);
        }
        return "Localize the string";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            OCLocalizeStringIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file) {
        OCReferenceElement referenceElement;
        OCLiteralExpression literal;
        if (project2 == null) {
            OCLocalizeStringIntentionAction.$$$reportNull$$$0(2);
        }
        if (!OCCodeInsightUtil.isValid(literal = OCLocalizeStringIntentionAction.getStringLiteral(editor, file))) {
            return false;
        }
        String literalText = OCElementUtil.getStringLiteral(literal);
        if (literalText == null || literalText.isEmpty()) {
            return false;
        }
        OCSendMessageExpression callExpr = (OCSendMessageExpression)PsiTreeUtil.getParentOfType((PsiElement)literal, OCSendMessageExpression.class);
        if (callExpr != null && callExpr.getMessageSelector().equals("localizedStringForKey:value:table:")) {
            return false;
        }
        OCMacroCall macroCall = (OCMacroCall)PsiTreeUtil.getParentOfType((PsiElement)literal, OCMacroCall.class);
        return macroCall == null || (referenceElement = macroCall.getMacroReferenceElement()) == null || !referenceElement.getName().startsWith("NSLocalizedString");
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project2 == null) {
            OCLocalizeStringIntentionAction.$$$reportNull$$$0(3);
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)file.getProject()).commitAllDocuments();
        OCLiteralExpression literal = OCLocalizeStringIntentionAction.getStringLiteral(editor, file);
        if (literal == null) {
            return;
        }
        String text = literal.getEscapedLiteralText();
        OCStringResourceReference reference = new OCStringResourceReference(literal, "Localizable");
        OCProvideStringLocalizationsIntentionAction action = new OCProvideStringLocalizationsIntentionAction(reference);
        if (!action.checkFilesForWrite()) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(project2, () -> {
            if (project2 == null) {
                OCLocalizeStringIntentionAction.$$$reportNull$$$0(6);
            }
            if (action.invokeBool(file)) {
                WriteAction.run(() -> {
                    if (project2 == null) {
                        OCLocalizeStringIntentionAction.$$$reportNull$$$0(7);
                    }
                    FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.localize");
                    String prefix = "NSLocalizedString(@\"";
                    String keyText = OCLocalizeStringIntentionAction.getKeyString(text);
                    OCExpression expression = OCElementFactory.expressionFromText(prefix + keyText + "\", @\"" + text + "\")", literal);
                    expression = (OCExpression)OCChangeUtil.replaceHandlingMacros(literal, expression);
                    int offset = expression.getRangeWithMacros().getStartOffset() + prefix.length();
                    editor.getCaretModel().moveToOffset(offset);
                    editor.getSelectionModel().setSelection(offset, offset + keyText.length());
                    OCMacroCall macroCall = (OCMacroCall)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(offset), OCMacroCall.class);
                    if (macroCall != null) {
                        PsiElement localizedString;
                        PsiReference ref = macroCall.findReferenceAt(offset - macroCall.getTextOffset());
                        PsiElement psiElement = localizedString = ref != null ? ref.resolve() : null;
                        if (localizedString != null) {
                            PsiDocumentManager.getInstance((Project)project2).doPostponedOperationsAndUnblockDocument(editor.getDocument());
                            new OCInplaceRenameHandler().doRename(localizedString, editor, null);
                        }
                    }
                });
            }
        }, this.getText(), null);
    }

    @NotNull
    public static String getKeyString(@NotNull String text) {
        if (text == null) {
            OCLocalizeStringIntentionAction.$$$reportNull$$$0(4);
        }
        String string = text;
        if (string == null) {
            OCLocalizeStringIntentionAction.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    private static OCLiteralExpression getStringLiteral(Editor editor, PsiFile file) {
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        return OCElementUtil.getAdjacentParentOfType(element, OCLiteralExpression.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/intentions/OCLocalizeStringIntentionAction";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/intentions/OCLocalizeStringIntentionAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyString";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getKeyString";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$1";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

