/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class OCMergeElseIfIntention
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        OCStatement statement2;
        if (project2 == null) {
            OCMergeElseIfIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            OCMergeElseIfIntention.$$$reportNull$$$0(1);
        }
        if ((statement2 = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)element, OCStatement.class)) == null) {
            return false;
        }
        if (this.checkStatement(statement2)) {
            return OCMergeElseIfIntention.checkCursorAtElseKeyword(editor, (OCIfStatement)statement2);
        }
        OCStatement parentStatement = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)statement2, OCStatement.class);
        if (parentStatement instanceof OCBlockStatement) {
            while (parentStatement instanceof OCBlockStatement) {
                parentStatement = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)parentStatement, OCStatement.class);
            }
            return this.checkStatement(parentStatement) && OCMergeElseIfIntention.checkCursorInAppropriatePosition(editor, statement2);
        }
        return false;
    }

    @NotNull
    public String getFamilyName() {
        if ("Merge If Else" == null) {
            OCMergeElseIfIntention.$$$reportNull$$$0(2);
        }
        return "Merge If Else";
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        OCStatement parentStatement;
        if (project2 == null) {
            OCMergeElseIfIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            OCMergeElseIfIntention.$$$reportNull$$$0(4);
        }
        if ((parentStatement = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)element, OCStatement.class)) == null) {
            return;
        }
        if (!this.checkStatement(parentStatement)) {
            parentStatement = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)parentStatement, OCIfStatement.class);
        }
        if (parentStatement == null) {
            return;
        }
        OCIfStatement parentIfStatement = (OCIfStatement)parentStatement;
        OCStatement childStatement = OCParenthesesUtils.stripBraces(parentIfStatement.getElseBranch());
        if (!(childStatement instanceof OCIfStatement)) {
            return;
        }
        parentIfStatement.getElseBranch().replace(childStatement);
    }

    public static boolean checkCursorInAppropriatePosition(@NotNull Editor editor, OCStatement statement2) {
        if (editor == null) {
            OCMergeElseIfIntention.$$$reportNull$$$0(5);
        }
        if (statement2 instanceof OCIfStatement) {
            OCIfStatement ifStatement = (OCIfStatement)statement2;
            ASTNode rParenth = ifStatement.getRParenth();
            ASTNode elseKeyword = ifStatement.getElseKeyword();
            int offset = editor.getCaretModel().getOffset();
            return rParenth != null && offset <= rParenth.getStartOffset() || elseKeyword != null && offset >= elseKeyword.getStartOffset() && offset <= elseKeyword.getStartOffset() + elseKeyword.getTextLength();
        }
        return false;
    }

    public static boolean checkCursorAtElseKeyword(@NotNull Editor editor, OCIfStatement statement2) {
        if (editor == null) {
            OCMergeElseIfIntention.$$$reportNull$$$0(6);
        }
        ASTNode elseKeyword = statement2.getElseKeyword();
        int offset = editor.getCaretModel().getOffset();
        return elseKeyword != null && offset >= elseKeyword.getStartOffset() && offset <= elseKeyword.getStartOffset() + elseKeyword.getTextLength();
    }

    private boolean checkStatement(OCStatement statement2) {
        if (statement2 instanceof OCIfStatement) {
            this.setText(this.getFamilyName());
            OCIfStatement ifStatement = (OCIfStatement)statement2;
            OCStatement elseBranch = ifStatement.getElseBranch();
            if (elseBranch instanceof OCIfStatement) {
                return false;
            }
            elseBranch = OCParenthesesUtils.stripBraces(elseBranch);
            return elseBranch instanceof OCIfStatement;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/intentions/OCMergeElseIfIntention";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/intentions/OCMergeElseIfIntention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkCursorInAppropriatePosition";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkCursorAtElseKeyword";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

