/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.OCPragmaSuppressionUtils;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCPragma;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCRemoveSuppressionIntentionAction
extends PsiElementBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        if ("Remove suppression" == null) {
            OCRemoveSuppressionIntentionAction.$$$reportNull$$$0(0);
        }
        return "Remove suppression";
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            OCRemoveSuppressionIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    private static OCPragma getPragma(PsiElement element) {
        OCPragma pragma = OCElementUtil.getPragmaAt(element);
        return pragma == null || pragma.parsePragma() == null ? null : pragma;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (project2 == null) {
            OCRemoveSuppressionIntentionAction.$$$reportNull$$$0(2);
        }
        if (element == null) {
            OCRemoveSuppressionIntentionAction.$$$reportNull$$$0(3);
        }
        return element.isValid() && OCRemoveSuppressionIntentionAction.getPragma(element) != null;
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project2 == null) {
            OCRemoveSuppressionIntentionAction.$$$reportNull$$$0(4);
        }
        if (element == null) {
            OCRemoveSuppressionIntentionAction.$$$reportNull$$$0(5);
        }
        OCFile file = (OCFile)element.getContainingFile();
        Document document = editor.getDocument();
        OCPragma pragma = OCRemoveSuppressionIntentionAction.getPragma(element);
        if (pragma == null) {
            return;
        }
        Pair<OCPragma.Mode, String> pair2 = pragma.parsePragma();
        int pragmaTextOffset = OCElementUtil.getRangeWithMacros(pragma).getStartOffset();
        OCPragmaSuppressionUtils.Scope scope = OCPragmaSuppressionUtils.findScope(file, pragmaTextOffset);
        if (pair2 != null) {
            if (pair2.first == OCPragma.Mode.PUSH || pair2.first == OCPragma.Mode.POP || !scope.isTopLevel() && scope.getOwnSettingsCnt() <= 1) {
                OCRemoveSuppressionIntentionAction.removeScope(document, scope);
            } else {
                OCRemoveSuppressionIntentionAction.removePragma(document, pragmaTextOffset, scope);
            }
            PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
        }
    }

    private static void removePragma(Document document, int pragmaTextOffset, OCPragmaSuppressionUtils.Scope scope) {
        for (Pair pair2 : scope.getSettings().values()) {
            if (((TextRange)pair2.first).getStartOffset() != pragmaTextOffset) continue;
            document.deleteString(((TextRange)pair2.first).getStartOffset(), ((TextRange)pair2.first).getEndOffset());
            return;
        }
    }

    private static void removeScope(Document document, OCPragmaSuppressionUtils.Scope scope) {
        ArrayList<Object> ranges = new ArrayList<Object>();
        TextRange push = scope.getPush();
        TextRange pop = scope.getPop();
        if (push != null) {
            ranges.add(push);
        }
        if (pop != null) {
            ranges.add(pop);
        }
        for (Pair pair2 : scope.getSettings().values()) {
            if (push != null && ((TextRange)pair2.first).getStartOffset() <= push.getStartOffset()) continue;
            ranges.add(pair2.first);
        }
        ContainerUtil.sort(ranges, Comparator.comparingInt(TextRange::getStartOffset));
        for (int i = ranges.size() - 1; i >= 0; --i) {
            TextRange range = (TextRange)ranges.get(i);
            document.deleteString(range.getStartOffset(), range.getEndOffset());
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/intentions/OCRemoveSuppressionIntentionAction";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/intentions/OCRemoveSuppressionIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

