/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class OCRemoveUnnecessaryParenthesesIntention
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        OCParenthesizedExpression expression;
        if (project2 == null) {
            OCRemoveUnnecessaryParenthesesIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            OCRemoveUnnecessaryParenthesesIntention.$$$reportNull$$$0(1);
        }
        if ((expression = (OCParenthesizedExpression)PsiTreeUtil.getParentOfType((PsiElement)element, OCParenthesizedExpression.class)) == null || OCRemoveUnnecessaryParenthesesIntention.isAssignmentInCondition(expression.getOperand()) && !(expression.getParent() instanceof OCParenthesizedExpression)) {
            return false;
        }
        this.setText(this.getFamilyName());
        PsiElement parent = expression.getParent();
        if (parent instanceof OCParenthesizedExpression) {
            return true;
        }
        OCExpression child = expression.getOperand();
        if (child instanceof OCParenthesizedExpression || child instanceof OCSendMessageExpression) {
            return true;
        }
        if (parent instanceof OCExpression) {
            int destPrecedence;
            int parentPrecedence = OCParenthesesUtils.getPrecedence((OCExpression)parent, true);
            if (parentPrecedence > (destPrecedence = OCParenthesesUtils.getPrecedence(child, false))) {
                return true;
            }
            if (parentPrecedence < destPrecedence) {
                return false;
            }
            if (parent instanceof OCBinaryExpression && expression == ((OCBinaryExpression)parent).getRight()) {
                return !OCParenthesesUtils.isParenthesesNeededInRightArgument((OCBinaryExpression)parent, child);
            }
            return true;
        }
        return true;
    }

    private static boolean isAssignmentInCondition(OCExpression parent) {
        return parent instanceof OCAssignmentExpression && OCIntType.isBool(OCExpectedTypeUtil.getExpectedType(parent), OCResolveContext.forPsi(parent));
    }

    @NotNull
    public String getFamilyName() {
        if ("Remove Unnecessary Parentheses" == null) {
            OCRemoveUnnecessaryParenthesesIntention.$$$reportNull$$$0(2);
        }
        return "Remove Unnecessary Parentheses";
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        OCExpression expression;
        if (project2 == null) {
            OCRemoveUnnecessaryParenthesesIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            OCRemoveUnnecessaryParenthesesIntention.$$$reportNull$$$0(4);
        }
        if ((expression = (OCExpression)PsiTreeUtil.getParentOfType((PsiElement)element, OCParenthesizedExpression.class)) == null) {
            return;
        }
        OCExpression parent = expression;
        OCParenthesizedExpression prevParent = (OCParenthesizedExpression)expression;
        while (parent instanceof OCParenthesizedExpression) {
            prevParent = (OCParenthesizedExpression)parent;
            parent = parent.getParent();
        }
        while (expression instanceof OCParenthesizedExpression) {
            expression = ((OCParenthesizedExpression)expression).getOperand();
        }
        if (OCRemoveUnnecessaryParenthesesIntention.isAssignmentInCondition(expression) && expression.getParent() instanceof OCExpression) {
            expression = (OCExpression)expression.getParent();
        }
        if (parent instanceof OCExpression) {
            int destPrecedence;
            int parentPrecedence = OCParenthesesUtils.getPrecedence(parent, true);
            if (parentPrecedence > (destPrecedence = OCParenthesesUtils.getPrecedence(expression, false)) || expression instanceof OCSendMessageExpression) {
                OCChangeUtil.replaceHandlingMacros(prevParent, expression);
            } else if (parentPrecedence < destPrecedence) {
                OCChangeUtil.replaceHandlingMacros(prevParent, OCParenthesesUtils.appendParentheses(expression));
            } else if (parent instanceof OCBinaryExpression && prevParent == ((OCBinaryExpression)parent).getRight()) {
                if (OCParenthesesUtils.isParenthesesNeededInRightArgument((OCBinaryExpression)parent, expression)) {
                    OCChangeUtil.replaceHandlingMacros(prevParent, OCParenthesesUtils.appendParentheses(expression));
                } else {
                    OCChangeUtil.replaceHandlingMacros(prevParent, expression);
                }
            } else {
                OCChangeUtil.replaceHandlingMacros(prevParent, expression);
            }
        } else {
            OCChangeUtil.replaceHandlingMacros(prevParent, expression);
        }
        CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)parent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/intentions/OCRemoveUnnecessaryParenthesesIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/intentions/OCRemoveUnnecessaryParenthesesIntention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

