/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.codeInsight.CommentUtilCore;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCAttributesList;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class OCReplaceTypeWithAutoIntentionAction
extends PsiElementBaseIntentionAction {
    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project2 == null) {
            OCReplaceTypeWithAutoIntentionAction.$$$reportNull$$$0(0);
        }
        if (element == null) {
            OCReplaceTypeWithAutoIntentionAction.$$$reportNull$$$0(1);
        }
        PsiFile file = element.getContainingFile();
        OCDeclaration declaration = (OCDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, OCDeclaration.class);
        if (declaration == null) {
            return;
        }
        OCReplaceTypeWithAutoIntentionAction.modifyTypeElement(declaration);
        for (OCDeclarator declarator : declaration.getDeclarators()) {
            OCReplaceTypeWithAutoIntentionAction.modifyDeclarator(declarator);
        }
        OCReplaceTypeWithAutoIntentionAction.removeExtraWhitespaces(declaration.getNode());
        PsiDocumentManager.getInstance((Project)project2).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        CodeStyleManager.getInstance((Project)project2).adjustLineIndent(file, declaration.getTextRange());
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        PsiFile file;
        if (project2 == null) {
            OCReplaceTypeWithAutoIntentionAction.$$$reportNull$$$0(2);
        }
        if (element == null) {
            OCReplaceTypeWithAutoIntentionAction.$$$reportNull$$$0(3);
        }
        if (!OCCompilerFeatures.supportsCxxAutoType(file = element.getContainingFile()) || !OCReplaceTypeWithAutoIntentionAction.isAvailableForElement(element)) {
            return false;
        }
        OCDeclaration declaration = (OCDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, OCDeclaration.class);
        if (declaration == null || declaration instanceof OCParameterDeclaration || declaration.getDeclarators().isEmpty() || !OCReplaceTypeWithAutoIntentionAction.canTransformCodeFragment(declaration)) {
            return false;
        }
        OCType type = declaration.getDeclarators().get(0).getType();
        if (type instanceof OCAutoType) {
            return false;
        }
        OCResolveContext resolveContext = OCResolveContext.forPsi(declaration);
        OCType resolvedType = type.resolve(resolveContext);
        if (resolvedType instanceof OCCppReferenceType) {
            OCCppReferenceType referenceType = (OCCppReferenceType)resolvedType;
            if (referenceType.isRvalueRef()) {
                return false;
            }
            resolvedType = referenceType.getRefType();
        }
        if (resolvedType.isUnknown()) {
            return false;
        }
        if (OCReplaceTypeWithAutoIntentionAction.insideForeach(declaration) && OCReplaceTypeWithAutoIntentionAction.canUseAutoInForeach(declaration, resolvedType, resolveContext) || OCReplaceTypeWithAutoIntentionAction.canUseAuto(declaration, resolvedType, resolveContext)) {
            this.setText("Replace type with 'auto'");
            return true;
        }
        return false;
    }

    private static boolean canUseAuto(@NotNull OCDeclaration declaration, @NotNull OCType commonType, @NotNull OCResolveContext resolveContext) {
        if (declaration == null) {
            OCReplaceTypeWithAutoIntentionAction.$$$reportNull$$$0(4);
        }
        if (commonType == null) {
            OCReplaceTypeWithAutoIntentionAction.$$$reportNull$$$0(5);
        }
        if (resolveContext == null) {
            OCReplaceTypeWithAutoIntentionAction.$$$reportNull$$$0(6);
        }
        List<OCDeclarator> declarators = declaration.getDeclarators();
        for (OCDeclarator declarator : declarators) {
            OCType declaratorType = OCTypeUtils.getResolvedCppReferencedType(declarator.getType(), resolveContext);
            if (!commonType.equals(declaratorType, false, resolveContext)) {
                return false;
            }
            OCExpression initializer = declarator.getInitializer();
            if (initializer == null) {
                return false;
            }
            OCType initializerType = OCTypeUtils.getResolvedCppReferencedType(initializer.getType(), resolveContext);
            if (OCReplaceTypeWithAutoIntentionAction.areSameTypes(declaratorType, initializerType, resolveContext)) continue;
            return false;
        }
        return true;
    }

    private static boolean areSameTypes(@NotNull OCType declaratorType, @NotNull OCType initializerType, @NotNull OCResolveContext resolveContext) {
        if (declaratorType == null) {
            OCReplaceTypeWithAutoIntentionAction.$$$reportNull$$$0(7);
        }
        if (initializerType == null) {
            OCReplaceTypeWithAutoIntentionAction.$$$reportNull$$$0(8);
        }
        if (resolveContext == null) {
            OCReplaceTypeWithAutoIntentionAction.$$$reportNull$$$0(9);
        }
        if (declaratorType instanceof OCPointerType) {
            if (declaratorType.isCString() && initializerType.isCString()) {
                return true;
            }
            OCType refType = ((OCPointerType)declaratorType).getRefType();
            if (refType instanceof OCFunctionType && refType.equals(initializerType, false, resolveContext)) {
                return true;
            }
        }
        return declaratorType.equals(initializerType, false, resolveContext);
    }

    private static boolean insideForeach(@NotNull OCDeclaration declaration) {
        OCForeachStatement foreachStatement;
        if (declaration == null) {
            OCReplaceTypeWithAutoIntentionAction.$$$reportNull$$$0(10);
        }
        return (foreachStatement = (OCForeachStatement)PsiTreeUtil.getParentOfType((PsiElement)declaration, OCForeachStatement.class)) != null && PsiTreeUtil.isAncestor((PsiElement)foreachStatement.getVariableDeclaration(), (PsiElement)declaration, (boolean)false);
    }

    private static boolean canUseAutoInForeach(@NotNull OCDeclaration declaration, @NotNull OCType declarationType, @NotNull OCResolveContext resolveContext) {
        OCForeachStatement foreachStatement;
        if (declaration == null) {
            OCReplaceTypeWithAutoIntentionAction.$$$reportNull$$$0(11);
        }
        if (declarationType == null) {
            OCReplaceTypeWithAutoIntentionAction.$$$reportNull$$$0(12);
        }
        if (resolveContext == null) {
            OCReplaceTypeWithAutoIntentionAction.$$$reportNull$$$0(13);
        }
        if ((foreachStatement = (OCForeachStatement)PsiTreeUtil.getParentOfType((PsiElement)declaration, OCForeachStatement.class)) == null) {
            return false;
        }
        OCExpression collectionExpression = foreachStatement.getCollectionExpression();
        if (collectionExpression == null) {
            return false;
        }
        OCType collectionType = collectionExpression.getType().resolve(resolveContext);
        OCType elementType = OCCodeInsightUtil.getCollectionElementType(collectionExpression, collectionType);
        if (elementType == null) {
            return false;
        }
        elementType = OCTypeUtils.getCppReferencedType(elementType);
        return OCReplaceTypeWithAutoIntentionAction.areSameTypes(declarationType, elementType, resolveContext);
    }

    private static void modifyTypeElement(@NotNull OCDeclaration declaration) {
        if (declaration == null) {
            OCReplaceTypeWithAutoIntentionAction.$$$reportNull$$$0(14);
        }
        OCTypeElement typeElement = declaration.getTypeElement();
        assert (typeElement != null);
        OCResolveContext resolveContext = OCResolveContext.forPsi(declaration);
        OCType declarationType = OCTypeUtils.getCppReferencedType(declaration.getDeclarators().get(0).getType().resolve(resolveContext));
        boolean autoWasInsert = false;
        ASTNode node = typeElement.getNode();
        for (ASTNode childNode : node.getChildren(null)) {
            IElementType elementType;
            if (OCReplaceTypeWithAutoIntentionAction.shouldPreserveNode(childNode) || (elementType = childNode.getElementType()) == OCTokenTypes.CONST_KEYWORD && declarationType.isConst() || elementType == OCTokenTypes.VOLATILE_KEYWORD && declarationType.isVolatile()) continue;
            if (!autoWasInsert) {
                autoWasInsert = true;
                node.addLeaf((IElementType)OCTokenTypes.AUTO_KEYWORD, (CharSequence)"auto", childNode);
            }
            node.removeChild(childNode);
        }
        assert (autoWasInsert);
    }

    private static void modifyDeclarator(@NotNull OCDeclarator declarator) {
        ASTNode childNode;
        IElementType elementType;
        ASTNode[] children;
        if (declarator == null) {
            OCReplaceTypeWithAutoIntentionAction.$$$reportNull$$$0(15);
        }
        ASTNode node = declarator.getNode();
        ASTNode[] aSTNodeArray = children = node.getChildren(null);
        int n = aSTNodeArray.length;
        for (int i = 0; i < n && (elementType = (childNode = aSTNodeArray[i]).getElementType()) != OCTokenTypes.EQ; ++i) {
            if (elementType == OCTokenTypes.IDENTIFIER || elementType == OCTokenTypes.AND || OCReplaceTypeWithAutoIntentionAction.shouldPreserveNode(childNode)) continue;
            node.removeChild(childNode);
        }
    }

    private static void removeExtraWhitespaces(@NotNull ASTNode node) {
        ASTNode child;
        IElementType elementType;
        ASTNode[] children;
        if (node == null) {
            OCReplaceTypeWithAutoIntentionAction.$$$reportNull$$$0(16);
        }
        ASTNode[] aSTNodeArray = children = node.getChildren(null);
        int n = aSTNodeArray.length;
        for (int i = 0; i < n && (elementType = (child = aSTNodeArray[i]).getElementType()) != OCTokenTypes.EQ; ++i) {
            if (OCTokenTypes.WHITESPACES.contains(elementType)) {
                PsiElement prevSibling = OCElementUtil.getPrevSiblingOrParentSibling(child.getPsi());
                if (prevSibling == null) continue;
                ASTNode prevSiblingNode = prevSibling.getNode();
                if (!(prevSiblingNode instanceof LeafElement)) {
                    prevSiblingNode = prevSiblingNode.getLastChildNode();
                }
                if (!OCTokenTypes.WHITESPACES.contains(prevSiblingNode.getElementType())) continue;
                node.removeChild(child);
                continue;
            }
            if (child instanceof LeafElement) continue;
            OCReplaceTypeWithAutoIntentionAction.removeExtraWhitespaces(child);
        }
    }

    private static boolean shouldPreserveNode(@NotNull ASTNode node) {
        if (node == null) {
            OCReplaceTypeWithAutoIntentionAction.$$$reportNull$$$0(17);
        }
        if (node.getPsi() instanceof OCAttributesList || node.getPsi() instanceof OCMacroCall) {
            return true;
        }
        IElementType elementType = node.getElementType();
        if (OCTokenTypes.WHITESPACES.contains(elementType)) {
            return true;
        }
        if (CommentUtilCore.isComment((ASTNode)node)) {
            return true;
        }
        if (OCTokenTypes.TYPE_SPECIFIERS.contains(elementType)) {
            return false;
        }
        return OCTokenTypes.DECLARATION_SPECIFIERS_IN_TYPES.contains(elementType);
    }

    private static boolean isAvailableForElement(@NotNull PsiElement element) {
        OCDeclaration declaration;
        if (element == null) {
            OCReplaceTypeWithAutoIntentionAction.$$$reportNull$$$0(18);
        }
        if ((declaration = (OCDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, OCDeclaration.class)) == null) {
            return false;
        }
        for (OCDeclarator declarator : declaration.getDeclarators()) {
            OCExpression initializer = declarator.getInitializer();
            if (initializer == null || !PsiTreeUtil.isAncestor((PsiElement)initializer, (PsiElement)element, (boolean)false)) continue;
            return false;
        }
        return true;
    }

    private static boolean canTransformCodeFragment(@NotNull PsiElement element) {
        ASTNode childNode;
        IElementType elementType;
        ASTNode[] children;
        if (element == null) {
            OCReplaceTypeWithAutoIntentionAction.$$$reportNull$$$0(19);
        }
        if (OCElementUtil.isPartOfMacroSubstitution(element)) {
            return false;
        }
        ASTNode node = element.getNode();
        ASTNode[] aSTNodeArray = children = node.getChildren(null);
        int n = aSTNodeArray.length;
        for (int i = 0; i < n && (elementType = (childNode = aSTNodeArray[i]).getElementType()) != OCTokenTypes.EQ; ++i) {
            PsiElement childElement;
            if (OCReplaceTypeWithAutoIntentionAction.shouldPreserveNode(childNode) || OCReplaceTypeWithAutoIntentionAction.canTransformCodeFragment(childElement = childNode.getPsi())) continue;
            return false;
        }
        return true;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        if ("Replace type with 'auto'" == null) {
            OCReplaceTypeWithAutoIntentionAction.$$$reportNull$$$0(20);
        }
        return "Replace type with 'auto'";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 10: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonType";
                break;
            }
            case 6: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaratorType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializerType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationType";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarator";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/intentions/OCReplaceTypeWithAutoIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/intentions/OCReplaceTypeWithAutoIntentionAction";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canUseAuto";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "areSameTypes";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "insideForeach";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "canUseAutoInForeach";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "modifyTypeElement";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "modifyDeclarator";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeExtraWhitespaces";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "shouldPreserveNode";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableForElement";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "canTransformCodeFragment";
                break;
            }
            case 20: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

