/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCLambdaIntroducer;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSplitDeclarationAndAssignmentIntentionAction
implements IntentionAction {
    @NotNull
    public String getText() {
        if ("Split into declaration and assignment" == null) {
            OCSplitDeclarationAndAssignmentIntentionAction.$$$reportNull$$$0(0);
        }
        return "Split into declaration and assignment";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            OCSplitDeclarationAndAssignmentIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file) {
        if (project2 == null) {
            OCSplitDeclarationAndAssignmentIntentionAction.$$$reportNull$$$0(2);
        }
        if (!OCCodeInsightUtil.isValid((PsiElement)file)) {
            return false;
        }
        OCDeclarator declarator = OCSplitDeclarationAndAssignmentIntentionAction.getDeclarator(editor, file);
        OCSymbol symbol = declarator != null ? declarator.getSymbol() : null;
        return symbol instanceof OCDeclaratorSymbol && declarator.getInitializer() != null && !(declarator.getInitializer() instanceof OCCompoundInitializer) && !(declarator.getParent().getParent() instanceof OCLambdaIntroducer) && PsiTreeUtil.getParentOfType((PsiElement)declarator, OCBlockStatement.class) != null && !((OCDeclaratorSymbol)symbol).isConst();
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project2 == null) {
            OCSplitDeclarationAndAssignmentIntentionAction.$$$reportNull$$$0(3);
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        OCDeclarator declarator = OCSplitDeclarationAndAssignmentIntentionAction.getDeclarator(editor, file);
        if (declarator == null) {
            return;
        }
        String name2 = declarator.getName();
        OCBlockStatement block = (OCBlockStatement)PsiTreeUtil.getParentOfType((PsiElement)declarator, OCBlockStatement.class);
        if (block != null) {
            OCExpressionStatement assignment = OCElementUtil.getTextWithMacros(declarator.getParent()).endsWith(";") ? (OCExpressionStatement)OCElementFactory.statementFromText(name2 + "=0;", declarator, true) : (OCExpressionStatement)((OCForStatement)OCElementFactory.statementFromText("for(" + name2 + "=0;;);", declarator, true)).getInitializer();
            OCExpression initializer = declarator.getInitializer();
            OCType initializerType = initializer != null ? initializer.getType() : null;
            OCChangeUtil.replaceHandlingMacros(((OCAssignmentExpression)assignment.getExpression()).getSourceExpression(), initializer);
            OCChangeUtil.delete(initializer);
            OCTypeElement typeElement = ((OCDeclaration)declarator.getParent()).getTypeElement();
            if (declarator.getType().getTerminalType() instanceof OCAutoType && typeElement != null && initializerType != null) {
                OCChangeUtil.replaceHandlingMacros(typeElement, OCElementFactory.typeElementFromText(initializerType.getBestNameInContext(declarator), declarator));
            }
            OCStatement declStatement = OCElementFactory.statementFromText(OCElementUtil.getTextWithMacros(declarator.getParent()) + ";", declarator);
            OCChangeUtil.addBefore(block, declStatement, declarator);
            OCChangeUtil.replaceHandlingMacros(PsiTreeUtil.getParentOfType((PsiElement)declarator, OCStatement.class), assignment);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Nullable
    private static OCDeclarator getDeclarator(Editor editor, PsiFile file) {
        OCTypeElement typeElement;
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        OCDeclarator declarator = OCElementUtil.getAdjacentParentOfType(element, OCDeclarator.class);
        if (declarator == null && (typeElement = OCElementUtil.getAdjacentParentOfType(element, OCTypeElement.class)) != null && typeElement.getParent() instanceof OCDeclaration && ((OCDeclaration)typeElement.getParent()).getDeclarators().size() == 1) {
            return ((OCDeclaration)typeElement.getParent()).getDeclarators().get(0);
        }
        return declarator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/intentions/OCSplitDeclarationAndAssignmentIntentionAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/intentions/OCSplitDeclarationAndAssignmentIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

