/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCSynthesizePropertiesList;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.refactoring.util.OCNormalizeUtil;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSplitIntoSeparateDeclarationsIntentionAction
implements IntentionAction {
    @NotNull
    public String getText() {
        if ("Split into separate declarations" == null) {
            OCSplitIntoSeparateDeclarationsIntentionAction.$$$reportNull$$$0(0);
        }
        return "Split into separate declarations";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            OCSplitIntoSeparateDeclarationsIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file) {
        boolean isInBlock;
        PsiElement element;
        if (project2 == null) {
            OCSplitIntoSeparateDeclarationsIntentionAction.$$$reportNull$$$0(2);
        }
        if (!OCCodeInsightUtil.isValid(element = OCSplitIntoSeparateDeclarationsIntentionAction.getElement(editor, file))) {
            return false;
        }
        boolean bl = isInBlock = PsiTreeUtil.getParentOfType((PsiElement)element, OCBlockStatement.class) != null;
        if (element instanceof OCDeclaration) {
            return (!isInBlock || element.getParent().getParent() instanceof OCBlockStatement) && ((OCDeclaration)element).getDeclarators().size() > 1;
        }
        if (element instanceof OCDeclarator) {
            return (!isInBlock || element.getParent().getParent().getParent() instanceof OCBlockStatement) && ((OCDeclaration)element.getParent()).getDeclarators().size() > 1;
        }
        if (element instanceof OCSynthesizeProperty) {
            return ((OCSynthesizePropertiesList)element.getParent()).getProperties().size() > 1;
        }
        return false;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project2 == null) {
            OCSplitIntoSeparateDeclarationsIntentionAction.$$$reportNull$$$0(3);
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        PsiElement element = OCSplitIntoSeparateDeclarationsIntentionAction.getElement(editor, file);
        if (element instanceof OCDeclaration) {
            OCNormalizeUtil.normalizeDeclaration((OCDeclaration)element);
        } else if (element instanceof OCDeclarator) {
            OCNormalizeUtil.normalizeDeclarator((OCDeclarator)element);
        } else if (element instanceof OCSynthesizeProperty) {
            OCNormalizeUtil.normalizeSynthesizeStatement((OCSynthesizeProperty)element);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    private static PsiElement getElement(Editor editor, PsiFile file) {
        OCTypeElement typeElement;
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        OCSymbolDeclarator declarator = (OCSymbolDeclarator)OCElementUtil.getAdjacentParentOfType(element, OCDeclarator.class, OCSynthesizeProperty.class);
        if (declarator == null && (typeElement = OCElementUtil.getAdjacentParentOfType(element, OCTypeElement.class)) != null && typeElement.getParent() instanceof OCDeclaration) {
            return typeElement.getParent();
        }
        return declarator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/intentions/OCSplitIntoSeparateDeclarationsIntentionAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/intentions/OCSplitIntoSeparateDeclarationsIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

