/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.lexer;

import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.lexer.OCLexerSettings;
import com.jetbrains.cidr.lang.lexer._OCLexer;
import org.jetbrains.annotations.NotNull;

public class OCLexer
extends FlexAdapter {
    private static final IElementType CHECK_JIT_ADAPTATION1 = _OCLexer.FLEX_ERROR;
    private static final IElementType CHECK_JIT_ADAPTATION2 = _OCLexer.FLEX_JIT_ERROR_GUARD;
    public static final int INITIAL = 0;
    public static final int INITIAL_INSIDE_LINE = 1024;
    public static final int DIRECTIVE_BODY_STATE = 8;
    public static final int PRAGMA_BODY_STATE = 12;
    public static final int INCLUDE_BODY_STATE = 10;
    public static final int MAX_RAW_STRING_PREFIX_LENGTH = 16;

    public OCLexer(@NotNull OCLexerSettings settings) {
        if (settings == null) {
            OCLexer.$$$reportNull$$$0(0);
        }
        super((FlexLexer)new _OCLexer(null){

            @Override
            public void reset(CharSequence buffer, int start, int end, int initialState) {
                boolean isInsideLine = initialState == 1024;
                super.reset(buffer, start, end, isInsideLine ? 0 : initialState);
                this.myLogicalLineStartOffset = isInsideLine ? -1 : start;
            }
        });
        _OCLexer base = (_OCLexer)this.getFlex();
        if (settings.getLanguageKind().isCpp()) {
            base.allowCPPKeywords();
        }
        if (settings.getLanguageKind().isObjC()) {
            base.allowObjCKeywords();
        }
        if (settings.getAllowNullabilityKeywords()) {
            base.allowNullabilityKeywords();
        }
        if (settings.getAllowGccAutoType()) {
            base.allowGccAutoType();
        }
        if (settings.getAllowAvailabilityExpression()) {
            base.allowAvailabilityExpression();
        }
        if (settings.getAllowMsvcExtensions()) {
            base.allowMsvcExtensions();
        }
        if (settings.getTreatCppAltOpsAsKeywords()) {
            base.forHighlighting();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/cidr/lang/lexer/OCLexer", "<init>"));
    }
}

