/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.navigation;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCClassDeclarationBase;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCLocalSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCNamespaceQualifierOwner;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCUnion;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCBreadcrumbsProvider
implements BreadcrumbsProvider {
    private static final int MAX_CRUMB_LENGTH = 48;
    private static final Language[] ourLanguages = new Language[]{OCLanguage.getInstance()};

    public Language[] getLanguages() {
        if (ApplicationManager.getApplication().isUnitTestMode() || Registry.is((String)"cidr.show.breadcrumbs")) {
            return ourLanguages;
        }
        return new Language[0];
    }

    public boolean acceptElement(@NotNull PsiElement e) {
        if (e == null) {
            OCBreadcrumbsProvider.$$$reportNull$$$0(0);
        }
        return e instanceof OCCppNamespace || e instanceof OCStruct || e instanceof OCEnum || e instanceof OCUnion || e instanceof OCFunctionDeclaration || e instanceof OCLambdaExpression || e instanceof OCClassDeclarationBase || e instanceof OCMethod;
    }

    @NotNull
    public String getElementInfo(@NotNull PsiElement e) {
        String symbolName;
        OCClassDeclaration cls;
        String name2;
        if (e == null) {
            OCBreadcrumbsProvider.$$$reportNull$$$0(1);
        }
        if (e instanceof OCLambdaExpression) {
            if (e.getParent() instanceof OCDeclarator) {
                OCDeclarator declarator = (OCDeclarator)e.getParent();
                String string = OCBreadcrumbsProvider.prepareCrumb(declarator.getName());
                if (string == null) {
                    OCBreadcrumbsProvider.$$$reportNull$$$0(2);
                }
                return string;
            }
            OCLambdaExpression exprNode = (OCLambdaExpression)e;
            String string = OCBreadcrumbsProvider.prepareCrumb(OCBreadcrumbsProvider.getLambdaPresentableName(exprNode));
            if (string == null) {
                OCBreadcrumbsProvider.$$$reportNull$$$0(3);
            }
            return string;
        }
        if (e instanceof OCClassDeclaration && (name2 = (cls = (OCClassDeclaration)e).getName()) != null) {
            String string = OCBreadcrumbsProvider.prepareCrumb(OCCodeInsightUtil.getClassNameWithCategory(name2, cls.getCategory()));
            if (string == null) {
                OCBreadcrumbsProvider.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (e instanceof OCNamespaceQualifierOwner) {
            String symbolName2;
            String qualText;
            OCCppNamespaceQualifier qualifier = ((OCNamespaceQualifierOwner)e).getNamespaceQualifier();
            String string = qualText = qualifier != null ? qualifier.getText() : null;
            if (qualText != null && (symbolName2 = OCElementUtil.getSymbolName(e)) != null) {
                String string2 = OCBreadcrumbsProvider.prepareCrumb(qualText + OCTokenTypes.COLON2X.getName() + symbolName2);
                if (string2 == null) {
                    OCBreadcrumbsProvider.$$$reportNull$$$0(5);
                }
                return string2;
            }
        }
        if ((symbolName = OCElementUtil.getSymbolName(e)) != null) {
            String string = OCBreadcrumbsProvider.prepareCrumb(symbolName);
            if (string == null) {
                OCBreadcrumbsProvider.$$$reportNull$$$0(6);
            }
            return string;
        }
        if ("<unnamed>" == null) {
            OCBreadcrumbsProvider.$$$reportNull$$$0(7);
        }
        return "<unnamed>";
    }

    @Nullable
    public Icon getElementIcon(@NotNull PsiElement element) {
        Object symbol;
        if (element == null) {
            OCBreadcrumbsProvider.$$$reportNull$$$0(8);
        }
        if (element instanceof OCLocalSymbolDeclarator && (symbol = ((OCLocalSymbolDeclarator)element).getLocalSymbol()) != null) {
            return symbol.getIcon(element.getProject());
        }
        if (element instanceof OCCppNamespace) {
            return OCSymbolKind.NAMESPACE.getIcon();
        }
        if (element instanceof OCStruct) {
            return OCSymbolKind.STRUCT.getIcon();
        }
        if (element instanceof OCEnum) {
            return OCSymbolKind.ENUM.getIcon();
        }
        if (element instanceof OCUnion) {
            return OCSymbolKind.UNION.getIcon();
        }
        if (element instanceof OCFunctionDeclaration) {
            return OCSymbolKind.FUNCTION_DECLARATION.getIcon();
        }
        if (element instanceof OCLambdaExpression) {
            return OCSymbolKind.FUNCTION_DECLARATION.getIcon();
        }
        return null;
    }

    @Nullable
    public String getElementTooltip(@NotNull PsiElement e) {
        if (e == null) {
            OCBreadcrumbsProvider.$$$reportNull$$$0(9);
        }
        return null;
    }

    @NotNull
    private static String getLambdaPresentableName(@NotNull OCLambdaExpression lambdaNode) {
        if (lambdaNode == null) {
            OCBreadcrumbsProvider.$$$reportNull$$$0(10);
        }
        StringBuilder lambdaText = new StringBuilder();
        String introducerText = lambdaNode.getLambdaIntroducer().getText();
        lambdaText.append(introducerText != null ? introducerText : "[]");
        lambdaText.append("(");
        OCParameterList parameterList = lambdaNode.getParameterList();
        if (parameterList != null && !parameterList.isEmpty()) {
            boolean first = true;
            for (OCDeclarator param : parameterList.getParameters()) {
                if (!first) {
                    lambdaText.append(", ");
                }
                OCType paramType = param.getType();
                lambdaText.append(paramType.getName());
                first = false;
            }
        }
        lambdaText.append(")");
        String string = lambdaText.toString();
        if (string == null) {
            OCBreadcrumbsProvider.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    private static String prepareCrumb(@NotNull String crumb) {
        if (crumb == null) {
            OCBreadcrumbsProvider.$$$reportNull$$$0(12);
        }
        String string = OCBreadcrumbsProvider.ensureFits(OCBreadcrumbsProvider.trimWhitespaces(crumb));
        if (string == null) {
            OCBreadcrumbsProvider.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    private static String trimWhitespaces(@NotNull String text) {
        if (text == null) {
            OCBreadcrumbsProvider.$$$reportNull$$$0(14);
        }
        if (StringUtil.containsWhitespaces((CharSequence)text)) {
            StringBuilder sb = new StringBuilder();
            boolean wsFound = false;
            for (int i = 0; i < text.length(); ++i) {
                char ch = text.charAt(i);
                if (Character.isWhitespace(ch)) {
                    if (wsFound) continue;
                    sb.append(" ");
                    wsFound = true;
                    continue;
                }
                sb.append(ch);
                wsFound = false;
            }
            String string = sb.toString();
            if (string == null) {
                OCBreadcrumbsProvider.$$$reportNull$$$0(15);
            }
            return string;
        }
        String string = text;
        if (string == null) {
            OCBreadcrumbsProvider.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    private static String ensureFits(@NotNull String text) {
        if (text == null) {
            OCBreadcrumbsProvider.$$$reportNull$$$0(17);
        }
        String string = StringUtil.shortenTextWithEllipsis((String)text, (int)48, (int)0);
        if (string == null) {
            OCBreadcrumbsProvider.$$$reportNull$$$0(18);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/navigation/OCBreadcrumbsProvider";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambdaNode";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "crumb";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/navigation/OCBreadcrumbsProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementInfo";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLambdaPresentableName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareCrumb";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "trimWhitespaces";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureFits";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "acceptElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getElementInfo";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 18: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getElementIcon";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getElementTooltip";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLambdaPresentableName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "prepareCrumb";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "trimWhitespaces";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "ensureFits";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

