/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.navigation;

import com.intellij.codeInsight.navigation.GotoTargetHandler;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.awt.RelativePoint;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.navigation.OCGotoAction;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCGotoActionSync<Psi extends PsiElement>
extends OCGotoAction<Psi> {
    private final CachedValue<? extends Collection<? extends OCSymbol>> myTargets;

    public OCGotoActionSync(@NotNull Psi source, @NotNull String name2, @NotNull Icon icon) {
        if (source == null) {
            OCGotoActionSync.$$$reportNull$$$0(0);
        }
        if (name2 == null) {
            OCGotoActionSync.$$$reportNull$$$0(1);
        }
        if (icon == null) {
            OCGotoActionSync.$$$reportNull$$$0(2);
        }
        super(source, name2, icon);
        Project project2 = source.getProject();
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)project2);
        this.myTargets = cachedValuesManager.createCachedValue(() -> {
            Object currentSource = this.getSource();
            if (currentSource == null) {
                return CachedValueProvider.Result.create(null, (Object[])new Object[0]);
            }
            SimpleModificationTracker tracker = FileSymbolTablesCache.getInstance(currentSource.getProject()).getOutOfBlockModificationTracker();
            Collection<OCSymbol> result = this.evaluateTargets(currentSource);
            return CachedValueProvider.Result.create(result, (Object[])new Object[]{tracker});
        }, false);
    }

    @Override
    @Nullable
    public Collection<? extends OCSymbol> getTargets() {
        return (Collection)this.myTargets.getValue();
    }

    @NotNull
    protected abstract Collection<? extends OCSymbol> evaluateTargets(@NotNull Psi var1);

    @Override
    public void navigate(@Nullable MouseEvent mouseEvent, @Nullable Editor editor) {
        Object source = this.getSource();
        if (source == null) {
            return;
        }
        Collection<OCSymbol> targets = this.getTargets();
        if (targets == null) {
            return;
        }
        if (targets.size() == 1) {
            OCSymbol target = targets.iterator().next();
            if (target != null) {
                target.navigate(true);
            }
            return;
        }
        List<PsiElement> targetElements = OCResolveUtil.locateDefinitions(targets, source.getProject());
        if (targetElements.isEmpty()) {
            return;
        }
        PsiElement[] targetElementsArray = PsiUtilCore.toPsiElementArray(targetElements);
        GotoTargetHandler.GotoData gotoData = new GotoTargetHandler.GotoData(source, targetElementsArray, Collections.emptyList());
        OCGotoAction.CellRenderer renderer = new OCGotoAction.CellRenderer(gotoData);
        JBPopup popup = NavigationUtil.getPsiElementPopup((PsiElement[])targetElementsArray, (PsiElementListCellRenderer)renderer, (String)this.getName());
        if (mouseEvent != null) {
            popup.show(new RelativePoint(mouseEvent));
        } else if (editor != null) {
            popup.showInBestPositionFor(editor);
        } else {
            OCLog.LOG.error("mouseEvent and editor are null!");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "source";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "name";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "icon";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/lang/navigation/OCGotoActionSync";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

