/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.navigation;

import com.intellij.navigation.GotoClassContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCForeignSymbol;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.util.OCMostlySingularMultiUniqueMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGotoByNameContributor
implements GotoClassContributor {
    private Condition<OCSymbol> myFilter;

    public OCGotoByNameContributor(Condition<OCSymbol> filter) {
        this.myFilter = filter;
    }

    @NotNull
    public String[] getNames(Project project2, boolean includeNonProjectItems) {
        if (((Boolean)OCLanguage.LANGUAGE_SUPPORT_DISABLED.get((UserDataHolder)project2, (Object)false)).booleanValue()) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                OCGotoByNameContributor.$$$reportNull$$$0(0);
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        Set<String> allSymbolNames = OCGlobalProjectSymbolsCache.getAllSymbolNames(project2);
        OCMostlySingularMultiUniqueMap<String, OCClassSymbol> allCategories = OCGlobalProjectSymbolsCache.getAllCategories(project2);
        ArrayList<String> result = new ArrayList<String>(allSymbolNames.size() + allCategories.size());
        result.addAll(allSymbolNames);
        allCategories.processAllValues((Processor<OCClassSymbol>)((Processor)symbol -> {
            result.add(symbol.getName() + "+" + symbol.getCategoryName());
            return true;
        }));
        String[] stringArray = result.toArray(ArrayUtil.EMPTY_STRING_ARRAY);
        if (stringArray == null) {
            OCGotoByNameContributor.$$$reportNull$$$0(1);
        }
        return stringArray;
    }

    @NotNull
    public NavigationItem[] getItemsByName(String name2, String pattern, Project project2, boolean includeNonProjectItems) {
        if (((Boolean)OCLanguage.LANGUAGE_SUPPORT_DISABLED.get((UserDataHolder)project2, (Object)false)).booleanValue()) {
            if (NavigationItem.EMPTY_NAVIGATION_ITEM_ARRAY == null) {
                OCGotoByNameContributor.$$$reportNull$$$0(2);
            }
            return NavigationItem.EMPTY_NAVIGATION_ITEM_ARRAY;
        }
        OCSymbol[] oCSymbolArray = this.getSymbolsByName(name2, project2, includeNonProjectItems, (Condition<OCSymbol>)((Condition)symbol -> symbol instanceof OCImplementationSymbol), false);
        if (oCSymbolArray == null) {
            OCGotoByNameContributor.$$$reportNull$$$0(3);
        }
        return oCSymbolArray;
    }

    public OCSymbol[] getSymbolsByName(String name2, Project project2, boolean includeNonProjectItems, Condition<OCSymbol> condition, boolean isStrict) {
        ArrayList symbols = new ArrayList();
        HashSet implementations = new HashSet();
        GlobalSearchScope scope = OCSearchScope.getGotoSymbolScope(project2, includeNonProjectItems);
        Processor processor2 = ocSymbol -> {
            if (ocSymbol instanceof OCUsingSymbol) {
                return true;
            }
            if (ocSymbol.getKind().isType() && ocSymbol.isPredeclaration()) {
                return true;
            }
            if (ocSymbol instanceof OCForeignSymbol) {
                return true;
            }
            if (ocSymbol.isSynthetic()) {
                return true;
            }
            if (ocSymbol instanceof OCInterfaceSymbol && implementations.contains(ocSymbol.getPresentableName())) {
                return true;
            }
            VirtualFile file = ocSymbol.getContainingFile();
            if (file != null && this.myFilter.value(ocSymbol) && scope.contains(file)) {
                symbols.add(ocSymbol);
                if (ocSymbol instanceof OCImplementationSymbol) {
                    implementations.add(ocSymbol.getPresentableName());
                }
            }
            return true;
        };
        OCCommonProcessors.OrderedProcessor<OCSymbol> orderedProcessor = new OCCommonProcessors.OrderedProcessor<OCSymbol>(processor2, condition, isStrict ? Conditions.alwaysFalse() : Conditions.alwaysTrue());
        int plus = name2.indexOf(43);
        if (plus != -1) {
            String className = name2.substring(0, plus).trim();
            String categoryName = name2.substring(plus + 1).trim();
            OCGlobalProjectSymbolsCache.processSymbolsByCategory(project2, (Processor<OCSymbol>)((Processor)symbol -> !(symbol instanceof OCClassSymbol) || !symbol.getName().equals(className) || orderedProcessor.process((OCSymbol)symbol)), categoryName);
        } else {
            OCGlobalProjectSymbolsCache.processByQualifiedName(project2, orderedProcessor, name2);
            OCGlobalProjectSymbolsCache.processSymbolsByCategory(project2, orderedProcessor, name2);
        }
        orderedProcessor.finish();
        Object[] result = symbols.toArray(new OCSymbol[0]);
        Arrays.sort(result);
        return result;
    }

    @Nullable
    public String getQualifiedName(NavigationItem item) {
        OCResolveContext context;
        OCQualifiedName qualifiedName;
        OCSymbolWithQualifiedName symbol;
        if (item instanceof OCSymbolHolderVirtualPsiElement) {
            item = ((OCSymbolHolderVirtualPsiElement)item).getSymbol();
        }
        if (item instanceof OCSymbolWithQualifiedName && (symbol = (OCSymbolWithQualifiedName)item).getQualifier() == null && (qualifiedName = symbol.getResolvedQualifiedName(context = OCResolveContext.forSymbol(symbol, symbol.getProject()))) != null) {
            return qualifiedName.getFullName(context);
        }
        if (item instanceof OCSymbol) {
            return ((OCSymbol)item).getPresentableName();
        }
        return null;
    }

    @Nullable
    public String getQualifiedNameSeparator() {
        return "::";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/cidr/lang/navigation/OCGotoByNameContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNames";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemsByName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

