/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.navigation;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.EmptyQuery;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.navigation.OCGotoAction;
import com.jetbrains.cidr.lang.navigation.OCGotoActionAsync;
import com.jetbrains.cidr.lang.navigation.OCGotoRelatedSymbolActionSync;
import com.jetbrains.cidr.lang.navigation.OCGotoSuperHandler;
import com.jetbrains.cidr.lang.navigation.OCLineMarkerInfo;
import com.jetbrains.cidr.lang.navigation.OCMultiGotoActionSync;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCClassPredeclaration;
import com.jetbrains.cidr.lang.psi.OCClassPredeclarationList;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCSynthesizePropertiesList;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.search.OCClassInheritorsSearch;
import com.jetbrains.cidr.lang.search.OCFunctionInheritorsSearch;
import com.jetbrains.cidr.lang.search.OCMemberInheritorsSearch;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.search.OCStructInheritorsSearch;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import icons.CidrLangIcons;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLineMarkerProvider
implements LineMarkerProvider {
    public static final Key<Processor<OCLineMarkerInfo>> TEST_LINE_MARKER_PROCESSOR_KEY = Key.create((String)"TEST_LINE_MARKER_PROCESSOR_KEY");
    private final DaemonCodeAnalyzerSettings myDaemonSettings;
    private final EditorColorsManager myColorsManager;
    private static final Key<CachedValue<Map<PsiElement, OCLineMarkerInfo>>> LINE_MARKERS_CACHE = Key.create((String)"LINE_MARKERS_CACHE");

    public OCLineMarkerProvider(DaemonCodeAnalyzerSettings daemonSettings, EditorColorsManager colorsManager) {
        this.myDaemonSettings = daemonSettings;
        this.myColorsManager = colorsManager;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            OCLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (OCElementUtil.isPartOfMacroSubstitution(element)) {
            return null;
        }
        LineMarkerInfo declDefMarker = this.getDeclDefMarker(element);
        OCLineMarkerInfo implementsMarker = OCLineMarkerProvider.getImplementsMarker(element);
        if (implementsMarker == null) return declDefMarker;
        if (!(declDefMarker instanceof OCLineMarkerInfo)) return implementsMarker;
        PsiElement identifier = OCLineMarkerProvider.getNameElementForMarker(element);
        if (identifier == null) return null;
        return OCLineMarkerProvider.createMultiLineMarkerInfo(identifier, (OCLineMarkerInfo)declDefMarker, implementsMarker);
    }

    @Nullable
    private static PsiNameIdentifierOwner getElementFromNameIdentifier(PsiElement name2) {
        if (OCElementUtil.getElementType(name2) != OCTokenTypes.IDENTIFIER) {
            return null;
        }
        PsiElement parent = name2.getParent();
        if (parent instanceof OCMethodSelectorPart ? !((parent = parent.getParent()) instanceof OCMethod) || ((OCMethod)parent).getParameters().get(0) != name2.getParent() : parent instanceof OCReferenceElement && !((parent = parent.getParent()) instanceof OCStructLike)) {
            return null;
        }
        if (parent instanceof PsiNameIdentifierOwner && ((PsiNameIdentifierOwner)parent).getNameIdentifier() == name2) {
            return (PsiNameIdentifierOwner)parent;
        }
        return null;
    }

    private static boolean isMemberLike(PsiElement element) {
        return element instanceof OCMethod && ((OCMethod)element).getBody() != null || element instanceof OCClassDeclaration || element instanceof OCDeclaration || element instanceof OCProperty || element instanceof OCSynthesizePropertiesList || element instanceof OCClassPredeclarationList || element instanceof OCInstanceVariablesList && !((OCInstanceVariablesList)element).getDeclarations().isEmpty();
    }

    protected static int getCategory(PsiElement element) {
        if (element instanceof OCProperty || element instanceof OCSynthesizePropertiesList || element instanceof OCClassPredeclarationList) {
            return 1;
        }
        if (element instanceof OCClassDeclaration || element instanceof OCInstanceVariablesList) {
            return 2;
        }
        if (element instanceof OCCppNamespace) {
            return 2;
        }
        if (element instanceof OCCppUsingStatement) {
            return 1;
        }
        if (element instanceof OCMethod || element instanceof OCFunctionDeclaration) {
            if (((OCCallable)element).getBody() == null) {
                return 1;
            }
            String text = element.getText();
            return text.indexOf(10) < 0 && text.indexOf(13) < 0 ? 1 : 2;
        }
        if (element instanceof OCDeclaration) {
            OCTypeElement type = ((OCDeclaration)element).getTypeElement();
            OCStructLike struct = (OCStructLike)PsiTreeUtil.findChildOfType((PsiElement)type, OCStructLike.class);
            if (struct != null && struct.isDeclaration()) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result) {
        if (elements == null) {
            OCLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            OCLineMarkerProvider.$$$reportNull$$$0(2);
        }
        if (elements.isEmpty()) {
            return;
        }
        MultiMap inheritanceCache = new MultiMap();
        PsiFile file = elements.get(0).getContainingFile();
        CachedValueProvider provider2 = () -> new CachedValueProvider.Result(new HashMap(), new Object[]{FileSymbolTablesCache.getInstance(file.getProject()).getOutOfBlockModificationTracker()});
        Map lineMarkersCache = (Map)CachedValuesManager.getManager((Project)file.getProject()).getCachedValue((UserDataHolder)file, LINE_MARKERS_CACHE, provider2, false);
        for (PsiElement name2 : elements) {
            PsiNameIdentifierOwner element = OCLineMarkerProvider.getElementFromNameIdentifier(name2);
            OCLineMarkerInfo lineMarkerInfo = null;
            if (lineMarkersCache.containsKey(element)) {
                lineMarkerInfo = (OCLineMarkerInfo)((Object)lineMarkersCache.get(element));
            } else if (element != null && !OCElementUtil.isPartOfMacroSubstitution((PsiElement)element)) {
                lineMarkerInfo = OCLineMarkerProvider.collectInheritingElements(element, (MultiMap<OCQualifiedName, OCQualifiedName>)inheritanceCache);
                lineMarkersCache.put(element, lineMarkerInfo);
            }
            if (lineMarkerInfo == null) continue;
            result.add(lineMarkerInfo);
        }
    }

    @Nullable
    private LineMarkerInfo getDeclDefMarker(PsiElement element) {
        PsiElement identifier;
        if (this.myDaemonSettings != null && element != null && this.myDaemonSettings.SHOW_METHOD_SEPARATORS && element.getFirstChild() == null) {
            PsiElement element1 = element;
            boolean isMember = false;
            while (element1 != null && !(element1 instanceof PsiFile) && element1.getPrevSibling() == null) {
                if (!OCLineMarkerProvider.isMemberLike(element1 = element1.getParent())) continue;
                isMember = true;
                break;
            }
            if (isMember) {
                PsiElement identifier2;
                boolean drawSeparator = false;
                int n = OCLineMarkerProvider.getCategory(element1);
                for (PsiElement child = element1.getPrevSibling(); child != null; child = child.getPrevSibling()) {
                    int category1 = OCLineMarkerProvider.getCategory(child);
                    if (category1 == 0) continue;
                    drawSeparator = n != 1 || category1 != 1;
                    break;
                }
                if (drawSeparator && (identifier2 = OCLineMarkerProvider.getNameElementForMarker(element)) != null) {
                    LineMarkerInfo info = new LineMarkerInfo(identifier2, identifier2.getTextRange(), null, 11, (Function)FunctionUtil.nullConstant(), null, GutterIconRenderer.Alignment.RIGHT);
                    EditorColorsScheme scheme = this.myColorsManager.getGlobalScheme();
                    info.separatorColor = scheme.getColor(CodeInsightColors.METHOD_SEPARATORS_COLOR);
                    info.separatorPlacement = SeparatorPlacement.TOP;
                    return info;
                }
            }
        }
        List<OCSymbolDeclarator<OCClassSymbol>> kids = null;
        if (element instanceof OCClassPredeclarationList) {
            kids = ((OCClassPredeclarationList)element).getPredeclarations();
        } else if (element instanceof OCDeclaration) {
            kids = ((OCDeclaration)element).getDeclarators();
        } else if (element instanceof OCSynthesizePropertiesList) {
            kids = ((OCSynthesizePropertiesList)element).getProperties();
        }
        if (kids != null) {
            LinkedList<OCLineMarkerInfo> markers = new LinkedList<OCLineMarkerInfo>();
            for (PsiElement psiElement : kids) {
                PsiElement identifier3;
                OCGotoAction action = OCLineMarkerProvider.getAction(psiElement);
                if (action == null || (identifier3 = OCLineMarkerProvider.getNameElementForMarker(psiElement)) == null) continue;
                markers.add(new OCLineMarkerInfo(action, identifier3));
            }
            PsiElement identifier4 = OCLineMarkerProvider.getNameElementForMarker(element);
            if (identifier4 != null) {
                return OCLineMarkerProvider.createMultiLineMarkerInfo(identifier4, markers.toArray(new OCLineMarkerInfo[0]));
            }
        }
        if ((element = OCLineMarkerProvider.getElementFromNameIdentifier(element)) instanceof OCClassPredeclaration || element instanceof OCSynthesizeProperty || element instanceof OCDeclarator || element instanceof OCMethodSelectorPart || element instanceof OCReferenceElement && element.getParent() instanceof OCSynthesizeProperty) {
            return null;
        }
        OCGotoAction action = OCLineMarkerProvider.getAction(element);
        if (action != null && (identifier = ((PsiNameIdentifierOwner)element).getNameIdentifier()) != null) {
            return new OCLineMarkerInfo(action, identifier);
        }
        return null;
    }

    @Nullable
    private static PsiElement getNameElementForMacroRange(@Nullable OCMacroRange range) {
        if (range == null) {
            return null;
        }
        OCMacroCall call = range.getMacroCall();
        if (call == null) {
            return null;
        }
        OCReferenceElement ref = call.getMacroReferenceElement();
        if (ref == null) {
            return null;
        }
        return ref.getNameIdentifier();
    }

    @Nullable
    private static PsiElement getNameElementForMarker(@Nullable PsiElement element) {
        PsiElement name2 = OCLineMarkerProvider.getIdElement(element);
        if (name2 != null) {
            PsiElement nameFromMacro = OCLineMarkerProvider.getNameElementForMacroRange(OCElementUtil.getRangeInMacroCall(name2));
            return nameFromMacro != null ? nameFromMacro : name2;
        }
        return element;
    }

    @Contract(value="null -> null")
    public static PsiElement getIdElement(@Nullable PsiElement owner2) {
        OCReferenceElement referenceElement;
        if (owner2 instanceof OCFunctionDeclaration) {
            return ((OCFunctionDeclaration)owner2).getNameIdentifier();
        }
        if (owner2 instanceof PsiNameIdentifierOwner) {
            return ((PsiNameIdentifierOwner)owner2).getNameIdentifier();
        }
        if (owner2 instanceof OCMacroCall && (referenceElement = ((OCMacroCall)owner2).getMacroReferenceElement()) != null) {
            return referenceElement.getNameIdentifier();
        }
        return null;
    }

    @Contract(value="null -> null")
    public static PsiElement getOwnerById(@Nullable PsiElement maybeId) {
        if (OCLineMarkerProvider.isIdentifier(maybeId)) {
            PsiElement parent = maybeId.getParent();
            if (parent instanceof OCMethodSelectorPart) {
                parent = parent.getParent();
            }
            if (parent instanceof OCReferenceElement && maybeId == ((OCReferenceElement)parent).getNameIdentifier()) {
                PsiElement grandpa = parent.getParent();
                if (grandpa instanceof OCMacroCall) {
                    return grandpa;
                }
            } else if (parent instanceof PsiNameIdentifierOwner && maybeId == ((PsiNameIdentifierOwner)parent).getNameIdentifier()) {
                PsiElement grandpa = parent.getParent();
                if (grandpa instanceof OCFunctionDefinition) {
                    return grandpa;
                }
                return parent;
            }
        }
        return null;
    }

    @Contract(value="null -> false")
    public static boolean isIdentifier(@Nullable PsiElement maybeId) {
        if (maybeId instanceof LeafElement) {
            String name2 = OCElementUtil.getElementType(maybeId).toString();
            return "IDENTIFIER".equals(name2) || "extension".equals(name2);
        }
        return false;
    }

    @Nullable
    private static OCLineMarkerInfo getImplementsMarker(PsiElement element) {
        PsiElement identifier;
        List<PsiNameIdentifierOwner> kids = null;
        if (element instanceof OCClassPredeclarationList) {
            kids = ((OCClassPredeclarationList)element).getPredeclarations();
        } else if (element instanceof OCDeclaration) {
            kids = ((OCDeclaration)element).getDeclarators();
        }
        if (kids != null) {
            LinkedList<OCLineMarkerInfo> markers = new LinkedList<OCLineMarkerInfo>();
            for (PsiElement psiElement : kids) {
                PsiElement identifier2;
                OCGotoAction action = OCGotoSuperHandler.getAction(psiElement);
                if (action == null || (identifier2 = OCLineMarkerProvider.getNameElementForMarker(psiElement)) == null) continue;
                markers.add(new OCLineMarkerInfo(action, identifier2));
            }
            identifier = OCLineMarkerProvider.getNameElementForMarker(element);
            if (identifier != null) {
                return OCLineMarkerProvider.createMultiLineMarkerInfo(identifier, markers.toArray(new OCLineMarkerInfo[0]));
            }
        }
        if ((element = OCLineMarkerProvider.getElementFromNameIdentifier(element)) instanceof OCClassPredeclaration || element instanceof OCDeclarator) {
            return null;
        }
        OCGotoAction action = OCGotoSuperHandler.getAction(element);
        if (action != null && element != null && (identifier = ((PsiNameIdentifierOwner)element).getNameIdentifier()) != null) {
            return new OCLineMarkerInfo(action, identifier);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static OCLineMarkerInfo collectInheritingElements(PsiNameIdentifierOwner element, MultiMap<OCQualifiedName, OCQualifiedName> inheritanceCache) {
        String actionName;
        Function queryProvider;
        if (element instanceof OCClassDeclaration) {
            if (element instanceof OCClassPredeclaration || ((OCClassDeclaration)element).getCategory() != null || "NSObject".equals(element.getName())) {
                return null;
            }
            queryProvider = psiElement -> OCClassInheritorsSearch.search((OCClassDeclaration)psiElement);
            actionName = "Go to subclass";
        } else if (element instanceof OCMethod) {
            queryProvider = psiElement -> {
                OCMethod method = (OCMethod)psiElement;
                OCMemberInheritorsSearch.SearchParameters<OCMethodSymbol> parameters = OCMemberInheritorsSearch.getParameters(method);
                if (method.getContainingClass() instanceof OCImplementation) {
                    parameters.setImplementationsThenInterfaces(true);
                } else {
                    parameters.setInterfacesThenImplementations(true);
                }
                return OCMemberInheritorsSearch.search(parameters);
            };
            actionName = "Go to overridden methods";
        } else if (element instanceof OCStruct) {
            if (!((OCStruct)element).isDeclaration()) return null;
            queryProvider = psiElement -> OCStructInheritorsSearch.search((OCStruct)psiElement);
            actionName = "Go to subclass";
        } else {
            if (!(element instanceof OCDeclarator)) return null;
            OCSymbol symbol = ((OCDeclarator)element).getSymbol();
            if (symbol instanceof OCMemberSymbol) {
                queryProvider = psiElement -> {
                    if (!(psiElement instanceof OCDeclarator)) {
                        OCLog.LOG.error("OCDeclarator expected but was: " + psiElement.getClass());
                        return EmptyQuery.getEmptyQuery();
                    }
                    OCSymbol s = ((OCDeclarator)psiElement).getSymbol();
                    if (!(s instanceof OCMemberSymbol)) {
                        OCLog.LOG.error("OCMemberSymbol expected but was: " + s);
                        return EmptyQuery.getEmptyQuery();
                    }
                    OCMemberInheritorsSearch.SearchParameters<OCMemberSymbol> parameters = OCMemberInheritorsSearch.getParameters((OCMemberSymbol)s, element.getProject());
                    return OCMemberInheritorsSearch.search(parameters);
                };
                actionName = "Go to overridden " + StringUtil.pluralize((String)symbol.getKind().getNameLowercase());
            } else {
                if (((OCDeclarator)element).getParameterList() == null || !((OCDeclarator)element).isPossibleStructMember() || !(symbol instanceof OCFunctionSymbol)) return null;
                queryProvider = psiElement -> {
                    OCSymbol s = ((OCDeclarator)psiElement).getSymbol();
                    if (!(s instanceof OCFunctionSymbol)) {
                        return EmptyQuery.getEmptyQuery();
                    }
                    OCFunctionInheritorsSearch.SearchParameters parameters = OCFunctionInheritorsSearch.getParameters((OCFunctionSymbol)s, ((OCDeclarator)psiElement).getContainingOCFile(), true);
                    if (s.isPredeclaration()) {
                        parameters.setPredeclarationsThenImplementations(true);
                    } else {
                        parameters.setImplementationsThenPredeclarations(true);
                    }
                    return OCFunctionInheritorsSearch.search(parameters, inheritanceCache);
                };
                actionName = "Go to overridden functions";
            }
        }
        if (((Query)queryProvider.fun((Object)element)).findFirst() == null) return null;
        PsiElement name2 = element.getNameIdentifier();
        assert (name2 != null);
        Icon icon = element instanceof OCProtocol ? AllIcons.Gutter.ImplementedMethod : AllIcons.Gutter.OverridenMethod;
        OCGotoActionAsync<PsiNameIdentifierOwner> action = new OCGotoActionAsync<PsiNameIdentifierOwner>(element, actionName, icon, queryProvider);
        return new OCLineMarkerInfo(action, name2);
    }

    @Nullable
    public static OCGotoAction getAction(PsiElement element) {
        if (!(element instanceof OCSymbolDeclarator)) {
            return null;
        }
        OCSymbolDeclarator declarator = (OCSymbolDeclarator)element;
        Object symbol = declarator.getSymbol();
        if (symbol == null || symbol.getKind() == OCSymbolKind.PARAMETER) {
            return null;
        }
        OCSymbol relatedSymbol = OCLineMarkerProvider.getRelatedSymbol(symbol, element.getProject());
        if (relatedSymbol != null && relatedSymbol.locateDefinition(element.getProject()) != null || symbol instanceof OCStructSymbol && OCSearchUtil.hasRelatedSymbols((OCStructSymbol)symbol, declarator.getProject())) {
            return new OCGotoRelatedSymbolActionSync(declarator);
        }
        return null;
    }

    @Nullable
    static OCSymbol getRelatedSymbol(@Nullable OCSymbol symbol, @NotNull Project project2) {
        OCSymbol relatedSymbol;
        if (project2 == null) {
            OCLineMarkerProvider.$$$reportNull$$$0(3);
        }
        OCSymbol oCSymbol = relatedSymbol = symbol != null ? symbol.getAssociatedSymbol(project2) : null;
        if (relatedSymbol instanceof OCInstanceVariableSymbol && ((OCInstanceVariableSymbol)relatedSymbol).getGeneratedFromProperty() != null) {
            return ((OCInstanceVariableSymbol)relatedSymbol).getAssociatedProperty(project2);
        }
        if (relatedSymbol == null && symbol instanceof OCPropertySymbol) {
            OCInstanceVariableSymbol ivar = ((OCPropertySymbol)symbol).getAssociatedIvar(project2);
            if (ivar != null && !ivar.isClang4ImplicitIvar(project2)) {
                return ivar;
            }
            CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
            ((OCPropertySymbol)symbol).processAccessorMethods((Processor<? super OCMethodSymbol>)finder, false, project2);
            return (OCSymbol)finder.getFoundValue();
        }
        return relatedSymbol;
    }

    @Nullable
    private static OCLineMarkerInfo createMultiLineMarkerInfo(PsiElement element, OCLineMarkerInfo ... markers) {
        if (markers.length == 0) {
            return null;
        }
        if (markers.length == 1) {
            return markers[0];
        }
        Icon icon = null;
        for (OCLineMarkerInfo marker : markers) {
            icon = icon == null ? marker.getAction().getIcon() : CidrLangIcons.GutterMultiArrows;
        }
        return new OCLineMarkerInfo(new OCMultiGotoActionSync(element, icon, markers), element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/navigation/OCLineMarkerProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineMarkerInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "collectSlowLineMarkers";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getRelatedSymbol";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

