/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.parser;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.PsiPlainTextFileImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.editor.OCInjectionListener;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCParser;
import com.jetbrains.cidr.lang.parser.OCPsiElementType;
import com.jetbrains.cidr.lang.parser.OCStubElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCPreprocessingLexer;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.impl.OCCodeFragmentImpl;
import com.jetbrains.cidr.lang.psi.impl.OCFileImpl;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import org.jetbrains.annotations.NotNull;

public class OCParserDefinition
implements ParserDefinition {
    private static final NotNullLazyKey<PsiFile, Project> DUMMY_FILE = NotNullLazyKey.create((String)"PARSER_DEFINITION_DUMMY", project2 -> OCParserDefinition.createDummyFile(project2));

    @NotNull
    public Lexer createLexer(Project project2) {
        PsiFile file = (PsiFile)DUMMY_FILE.getValue((UserDataHolder)project2);
        OCInclusionContext context = OCInclusionContext.empty(OCLanguageKindCalculator.calculateLanguageKindFast(file), file);
        OCPreprocessingLexer oCPreprocessingLexer = new OCPreprocessingLexer(context, (OCFile)file);
        if (oCPreprocessingLexer == null) {
            OCParserDefinition.$$$reportNull$$$0(0);
        }
        return oCPreprocessingLexer;
    }

    public PsiParser createParser(Project project2) {
        return OCParser.getInstance();
    }

    public IFileElementType getFileNodeType() {
        return OCTokenTypes.OC_FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = OCTokenTypes.WHITESPACES;
        if (tokenSet == null) {
            OCParserDefinition.$$$reportNull$$$0(1);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = OCTokenTypes.COMMENTS;
        if (tokenSet == null) {
            OCParserDefinition.$$$reportNull$$$0(2);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = OCTokenTypes.ALL_STRINGS;
        if (tokenSet == null) {
            OCParserDefinition.$$$reportNull$$$0(3);
        }
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        IElementType type = node.getElementType();
        if (type instanceof OCPsiElementType) {
            PsiElement psiElement = ((OCPsiElementType)type).createPsi(node);
            if (psiElement == null) {
                OCParserDefinition.$$$reportNull$$$0(4);
            }
            return psiElement;
        }
        if (type instanceof OCStubElementType) {
            PsiElement psiElement = ((OCStubElementType)type).createPsi(node);
            if (psiElement == null) {
                OCParserDefinition.$$$reportNull$$$0(5);
            }
            return psiElement;
        }
        ASTWrapperPsiElement aSTWrapperPsiElement = new ASTWrapperPsiElement(node);
        if (aSTWrapperPsiElement == null) {
            OCParserDefinition.$$$reportNull$$$0(6);
        }
        return aSTWrapperPsiElement;
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        Project project2 = viewProvider.getManager().getProject();
        if (project2.getUserData(OCLanguage.LANGUAGE_SUPPORT_DISABLED) == Boolean.TRUE) {
            return new PsiPlainTextFileImpl(viewProvider);
        }
        if (viewProvider instanceof InjectedFileViewProvider) {
            OCCodeFragmentImpl fragment = new OCCodeFragmentImpl(viewProvider, true, (IElementType)OCElementTypes.EXPRESSION_CODE_FRAGMENT);
            PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)project2).getInjectionHost(viewProvider);
            ((OCInjectionListener)project2.getMessageBus().syncPublisher(OCInjectionListener.INJECTION_TOPIC)).didInject(fragment, host);
            return fragment;
        }
        return new OCFileImpl(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MAY;
    }

    private static PsiFile createDummyFile(@NotNull Project project2) {
        if (project2 == null) {
            OCParserDefinition.$$$reportNull$$$0(7);
        }
        CLanguageKind kind = CLanguageKind.maxLanguage(project2);
        PsiFileFactory factory2 = PsiFileFactory.getInstance((Project)project2);
        String name2 = "dummy." + kind.getDefaultSourceExtension();
        return factory2.createFileFromText(name2, (Language)OCLanguage.getInstance(), (CharSequence)"");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/parser/OCParserDefinition";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhitespaceTokens";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentTokens";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteralElements";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/parser/OCParserDefinition";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createDummyFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

