/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.preprocessor.OCContextChange;
import com.jetbrains.cidr.lang.preprocessor.OCContextChangeBuilder;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class OCContextChangeBuilderImpl
implements OCContextChange,
OCContextChangeBuilder {
    private final int myOffset;
    @NotNull
    private final Map<String, OCMacroSymbol> myDefinitions = new THashMap();
    @NotNull
    private final Set<String> myUndefs = new THashSet();
    @NotNull
    private final List<OCSymbol> mySymbols = new ArrayList<OCSymbol>();
    @NotNull
    private final Set<VirtualFile> myProcessedFiles = new THashSet();

    public OCContextChangeBuilderImpl(int offset) {
        this.myOffset = offset;
    }

    @Override
    public void define(@NotNull String name2, @NotNull OCMacroSymbol macro) {
        if (name2 == null) {
            OCContextChangeBuilderImpl.$$$reportNull$$$0(0);
        }
        if (macro == null) {
            OCContextChangeBuilderImpl.$$$reportNull$$$0(1);
        }
        this.myUndefs.remove(name2);
        this.myDefinitions.put(name2, macro);
    }

    @Override
    public void undef(@NotNull String name2) {
        if (name2 == null) {
            OCContextChangeBuilderImpl.$$$reportNull$$$0(2);
        }
        this.myDefinitions.remove(name2);
        this.myUndefs.add(name2);
    }

    @Override
    public void addSymbol(@NotNull OCSymbol symbol) {
        if (symbol == null) {
            OCContextChangeBuilderImpl.$$$reportNull$$$0(3);
        }
        this.mySymbols.add(symbol);
    }

    @Override
    public void addProcessedFile(@NotNull VirtualFile file) {
        if (file == null) {
            OCContextChangeBuilderImpl.$$$reportNull$$$0(4);
        }
        this.myProcessedFiles.add(file);
    }

    @Override
    public int getOffset() {
        return this.myOffset;
    }

    @Override
    public void apply(@NotNull Project project2, @NotNull OCInclusionContext context) {
        if (project2 == null) {
            OCContextChangeBuilderImpl.$$$reportNull$$$0(5);
        }
        if (context == null) {
            OCContextChangeBuilderImpl.$$$reportNull$$$0(6);
        }
        for (OCMacroSymbol macro : this.myDefinitions.values()) {
            context.define(macro);
        }
        for (String name2 : this.myUndefs) {
            context.undef(name2);
        }
        context.preprocessFile(null, null, null, 1, -1, -1, this.mySymbols, null);
        for (VirtualFile file : this.myProcessedFiles) {
            context.addProcessedFile(file);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCContextChangeBuilderImpl builder = (OCContextChangeBuilderImpl)o;
        if (this.myOffset != builder.myOffset) {
            return false;
        }
        if (!this.myDefinitions.equals(builder.myDefinitions)) {
            return false;
        }
        if (!this.myProcessedFiles.equals(builder.myProcessedFiles)) {
            return false;
        }
        if (!this.mySymbols.equals(builder.mySymbols)) {
            return false;
        }
        return this.myUndefs.equals(builder.myUndefs);
    }

    public int hashCode() {
        int result = this.myOffset;
        result = 31 * result + this.myDefinitions.hashCode();
        result = 31 * result + this.myUndefs.hashCode();
        result = 31 * result + this.mySymbols.hashCode();
        result = 31 * result + this.myProcessedFiles.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macro";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/preprocessor/OCContextChangeBuilderImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "define";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "undef";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addSymbol";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addProcessedFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

