/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import com.jetbrains.cidr.lang.preprocessor.OCContextChange;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCContextChangeSet {
    @NotNull
    private final String myText;
    @NotNull
    private TIntObjectHashMap<OCContextChange> myChangeMap;
    private int myLastOffset;
    private boolean myIsUpdated;
    private boolean myUsingOriginalMap;

    private OCContextChangeSet(@NotNull String text, @NotNull TIntObjectHashMap<OCContextChange> changeMap, boolean isUpdated, int lastOffset, boolean reusingMap) {
        if (text == null) {
            OCContextChangeSet.$$$reportNull$$$0(0);
        }
        if (changeMap == null) {
            OCContextChangeSet.$$$reportNull$$$0(1);
        }
        this.myText = text;
        this.myIsUpdated = isUpdated;
        this.myChangeMap = changeMap;
        this.myLastOffset = lastOffset;
        this.myUsingOriginalMap = reusingMap;
    }

    public boolean isUpdated() {
        return this.myIsUpdated;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            OCContextChangeSet.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public OCContextChange getChange(int offsetAfterInclude) {
        if (offsetAfterInclude > this.myLastOffset) {
            return null;
        }
        return (OCContextChange)this.myChangeMap.get(offsetAfterInclude);
    }

    public void setChange(int offsetAfterInclude, @NotNull OCContextChange change) {
        if (change == null) {
            OCContextChangeSet.$$$reportNull$$$0(3);
        }
        if (this.myUsingOriginalMap) {
            this.myUsingOriginalMap = false;
            this.myChangeMap = this.myChangeMap.clone();
        }
        if (offsetAfterInclude > this.myLastOffset) {
            this.myLastOffset = offsetAfterInclude;
        }
        this.myChangeMap.put(offsetAfterInclude, (Object)change);
        this.myIsUpdated = true;
    }

    @NotNull
    public static OCContextChangeSet reuse(@NotNull String newText, @Nullable OCContextChangeSet from, int validateFrom, int validateTo) {
        int diffOffset;
        if (newText == null) {
            OCContextChangeSet.$$$reportNull$$$0(4);
        }
        if (from == null) {
            OCContextChangeSet oCContextChangeSet = new OCContextChangeSet(newText, (TIntObjectHashMap<OCContextChange>)new TIntObjectHashMap(), true, 0, false);
            if (oCContextChangeSet == null) {
                OCContextChangeSet.$$$reportNull$$$0(5);
            }
            return oCContextChangeSet;
        }
        if (validateTo < 0) {
            validateTo = newText.length();
        }
        assert (validateFrom >= 0);
        assert (validateTo >= validateFrom && validateTo <= newText.length());
        int oldLastOffset = from.myLastOffset;
        String oldText = from.getText();
        validateTo = Math.min(oldText.length(), Math.min(validateTo, oldLastOffset + 1));
        if (validateTo == (diffOffset = (validateFrom = Math.min(validateTo, Math.min(Math.min(validateFrom, oldText.length()), newText.length()))) + StringUtil.commonPrefixLength((CharSequence)OCContextChangeSet.subSequence(oldText, validateFrom, validateTo), (CharSequence)OCContextChangeSet.subSequence(newText, validateFrom, newText.length())))) {
            OCContextChangeSet oCContextChangeSet = new OCContextChangeSet(newText, from.myChangeMap, false, oldLastOffset, true);
            if (oCContextChangeSet == null) {
                OCContextChangeSet.$$$reportNull$$$0(6);
            }
            return oCContextChangeSet;
        }
        final int[] loRef = new int[]{0};
        TIntObjectHashMap fromMap = from.myChangeMap.clone();
        fromMap.retainEntries((TIntObjectProcedure)new TIntObjectProcedure<OCContextChange>(){

            public boolean execute(int offset, OCContextChange change) {
                boolean valid;
                boolean bl = valid = change.getOffset() < diffOffset;
                if (valid && loRef[0] < offset) {
                    loRef[0] = offset;
                }
                return valid;
            }
        });
        int lastOffset = loRef[0];
        OCContextChangeSet oCContextChangeSet = new OCContextChangeSet(newText, (TIntObjectHashMap<OCContextChange>)fromMap, true, lastOffset, false);
        if (oCContextChangeSet == null) {
            OCContextChangeSet.$$$reportNull$$$0(7);
        }
        return oCContextChangeSet;
    }

    @NotNull
    public List<OCContextChange> getChanges() {
        ArrayList<OCContextChange> result = new ArrayList<OCContextChange>();
        this.myChangeMap.forEachValue(object -> {
            result.add((OCContextChange)object);
            return true;
        });
        Collections.sort(result, (o1, o2) -> o1.getOffset() - o2.getOffset());
        ArrayList<OCContextChange> arrayList = result;
        if (arrayList == null) {
            OCContextChangeSet.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static CharSequence subSequence(CharSequence seq, int start, int end) {
        return new CharSequenceSubSequence(seq, start, end);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeMap";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/preprocessor/OCContextChangeSet";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/preprocessor/OCContextChangeSet";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "reuse";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setChange";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "reuse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

