/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Processor;
import com.intellij.util.containers.ConcurrentMultiMap;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCConfigurationOwner;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.impl.OCFileImpl;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationTrackers;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCImportGraph {
    private static final NotNullLazyKey<CachedValue<MultiMap<VirtualFile, VirtualFile>>, Project> HEADER_TO_ALL_ROOTS_CACHE = NotNullLazyKey.create((String)"HEADER_TO_ALL_ROOTS_CACHE", project2 -> CachedValuesManager.getManager((Project)project2).createCachedValue(() -> {
        OCWorkspaceModificationTrackers trackers = OCWorkspaceModificationTrackers.getInstance(project2);
        return new CachedValueProvider.Result((Object)new ConcurrentMultiMap(), new Object[]{trackers.getProjectFilesListTracker(), trackers.getSourceFilesListTracker(), trackers.getBuildSettingsChangesTracker()});
    }, false));
    private static final NotNullLazyKey<Map<VirtualFile, Set<VirtualFile>>, OCResolveConfiguration> ROOT_TO_ALL_HEADERS_CACHE = NotNullLazyKey.create((String)"ROOT_TO_ALL_HEADERS_CACHE", dom -> new ConcurrentHashMap());
    private static final NotNullLazyKey<Cache, Project> IMPORTS_GRAPH = NotNullLazyKey.create((String)"IMPORT_GRAPH", project2 -> new Cache((Project)project2));

    public static void invalidateHeaderRootsCache(@NotNull Project project2) {
        if (project2 == null) {
            OCImportGraph.$$$reportNull$$$0(0);
        }
        project2.putUserData(HEADER_TO_ALL_ROOTS_CACHE, null);
    }

    @NotNull
    public static Collection<VirtualFile> getAllHeaderRoots(@NotNull Project project2, @NotNull VirtualFile header) {
        MultiMap value;
        if (project2 == null) {
            OCImportGraph.$$$reportNull$$$0(1);
        }
        if (header == null) {
            OCImportGraph.$$$reportNull$$$0(2);
        }
        if (!(value = (MultiMap)((CachedValue)HEADER_TO_ALL_ROOTS_CACHE.getValue((UserDataHolder)project2)).getValue()).containsKey((Object)header)) {
            Collection<VirtualFile> roots = OCImportGraph.findAllRootsThatIncludes(project2, header, true);
            assert (!roots.isEmpty());
            value.put((Object)header, roots);
        }
        Collection collection = value.get((Object)header);
        if (collection == null) {
            OCImportGraph.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @Nullable
    public static Set<VirtualFile> buildSymbolAndRootHeaderCache(@NotNull OCResolveConfiguration configuration, @NotNull VirtualFile rootFile, @Nullable OCLanguageKind kind, @Nullable ProgressIndicator indicator) {
        if (configuration == null) {
            OCImportGraph.$$$reportNull$$$0(4);
        }
        if (rootFile == null) {
            OCImportGraph.$$$reportNull$$$0(5);
        }
        if (indicator != null) {
            indicator.checkCanceled();
        }
        if (!rootFile.isValid()) {
            return null;
        }
        Project project2 = configuration.getProject();
        if (!OCInclusionContextUtil.isNeedToFindRoot(rootFile, project2)) {
            OCImportGraph.invalidateRootHeadersCache(configuration, rootFile);
            return OCImportGraph.getAllRootHeaders(configuration, rootFile, indicator);
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(rootFile);
        if (psiFile instanceof OCConfigurationOwner) {
            if (kind == null) {
                kind = ((OCConfigurationOwner)psiFile).getKind();
            }
            OCInclusionContext context = OCInclusionContext.sourceParsingContext(configuration, kind, psiFile);
            context.preprocessInclude(psiFile, true);
            return context.getProcessedFiles();
        }
        return null;
    }

    public static void invalidateRootHeadersCache(OCResolveConfiguration configuration, VirtualFile file) {
        ((Map)ROOT_TO_ALL_HEADERS_CACHE.getValue((UserDataHolder)configuration)).remove(file);
    }

    public static void invalidateRootHeadersCache(OCResolveConfiguration configuration) {
        ((Map)ROOT_TO_ALL_HEADERS_CACHE.getValue((UserDataHolder)configuration)).clear();
    }

    @NotNull
    public static Set<VirtualFile> getAllRootHeaders(@NotNull OCResolveConfiguration configuration, @NotNull VirtualFile root, @Nullable ProgressIndicator indicator) {
        if (configuration == null) {
            OCImportGraph.$$$reportNull$$$0(6);
        }
        if (root == null) {
            OCImportGraph.$$$reportNull$$$0(7);
        }
        Project project2 = configuration.getProject();
        assert (!OCInclusionContextUtil.isNeedToFindRoot(root, project2)) : "Not a root file";
        Map value = (Map)ROOT_TO_ALL_HEADERS_CACHE.getValue((UserDataHolder)configuration);
        Set<Object> result = (Set)value.get(root);
        if (result == null) {
            PsiFile rootPsi;
            PsiManager psiManager = PsiManager.getInstance((Project)project2);
            PsiFile psiFile = rootPsi = root.isValid() ? psiManager.findFile(root) : null;
            if (rootPsi instanceof OCConfigurationOwner) {
                if (OCInclusionContext.isPrecompiledHeader(root, configuration)) {
                    result = OCImportGraph.getAllPCHRootHeaders(psiManager, project2, configuration, root, indicator);
                } else {
                    OCInclusionContext context = OCInclusionContext.sourceParsingContext(configuration, ((OCConfigurationOwner)rootPsi).getKind(), rootPsi);
                    context.preprocessInclude(rootPsi, true);
                    result = context.getProcessedFiles();
                }
            } else {
                result = Collections.emptySet();
            }
            value.put(root, result);
        }
        Set set = result;
        if (set == null) {
            OCImportGraph.$$$reportNull$$$0(8);
        }
        return set;
    }

    private static Set<VirtualFile> getAllPCHRootHeaders(@NotNull PsiManager psiManager, @NotNull Project project2, @NotNull OCResolveConfiguration configuration, @NotNull VirtualFile pch, @Nullable ProgressIndicator indicator) {
        if (psiManager == null) {
            OCImportGraph.$$$reportNull$$$0(9);
        }
        if (project2 == null) {
            OCImportGraph.$$$reportNull$$$0(10);
        }
        if (configuration == null) {
            OCImportGraph.$$$reportNull$$$0(11);
        }
        if (pch == null) {
            OCImportGraph.$$$reportNull$$$0(12);
        }
        HashSet<Pair> srcs = new HashSet<Pair>();
        OCWorkspace workspace = OCWorkspace.getInstance(project2);
        for (VirtualFile vroot : OCSearchScope.getExplicitlySpecifiedProjectSourceFiles(project2)) {
            OCLanguageKind kind;
            PsiFile rootPsi;
            if (!OCFileImpl.isSourceCodeFile(vroot.getName()) || pch.equals(vroot)) continue;
            if (indicator != null) {
                indicator.checkCanceled();
            }
            if (!workspace.getConfigurationsForFile(vroot).contains(configuration) || !((rootPsi = vroot.isValid() ? psiManager.findFile(vroot) : null) instanceof OCConfigurationOwner) || !(kind = ((OCConfigurationOwner)rootPsi).getKind()).supportsPrecompiledHeaders()) continue;
            srcs.add(Pair.create((Object)kind, (Object)rootPsi));
        }
        THashSet result = new THashSet();
        for (Pair src : srcs) {
            if (indicator != null) {
                indicator.checkCanceled();
            }
            result.addAll(OCInclusionContext.initialPCHContextWithoutRoot(configuration, (OCLanguageKind)src.first, (PsiFile)src.second).getProcessedFiles());
        }
        result.remove((Object)pch);
        return Collections.unmodifiableSet(result);
    }

    @NotNull
    public static Set<OCResolveConfiguration> getAllHeaderConfigurations(@NotNull OCFile header, @Nullable ProgressIndicator progress) {
        if (header == null) {
            OCImportGraph.$$$reportNull$$$0(13);
        }
        Project project2 = header.getProject();
        VirtualFile file = OCInclusionContextUtil.getVirtualFile(header);
        if (file == null) {
            Set<OCResolveConfiguration> set = Collections.emptySet();
            if (set == null) {
                OCImportGraph.$$$reportNull$$$0(14);
            }
            return set;
        }
        HashSet<OCResolveConfiguration> ret = new HashSet<OCResolveConfiguration>();
        for (VirtualFile root : OCImportGraph.getAllHeaderRoots(header.getProject(), file)) {
            OCImportGraph.fillHeaderConfigurationsForRoot(project2, file, root, ret, progress);
        }
        Set<OCResolveConfiguration> set = Collections.unmodifiableSet(ret);
        if (set == null) {
            OCImportGraph.$$$reportNull$$$0(15);
        }
        return set;
    }

    public static void fillHeaderConfigurationsForRoot(@NotNull Project project2, @NotNull VirtualFile header, @NotNull VirtualFile root, @NotNull Set<OCResolveConfiguration> result, @Nullable ProgressIndicator progress) {
        if (project2 == null) {
            OCImportGraph.$$$reportNull$$$0(16);
        }
        if (header == null) {
            OCImportGraph.$$$reportNull$$$0(17);
        }
        if (root == null) {
            OCImportGraph.$$$reportNull$$$0(18);
        }
        if (result == null) {
            OCImportGraph.$$$reportNull$$$0(19);
        }
        if (progress != null) {
            progress.checkCanceled();
        }
        Collection<OCResolveConfiguration> configs2 = OCInclusionContextUtil.getAllBuildConfigurationsOfTargetsOfFile(root, project2);
        if (!OCInclusionContextUtil.isNeedToFindRoot(root, project2)) {
            for (OCResolveConfiguration config : configs2) {
                if (progress != null) {
                    progress.checkCanceled();
                }
                if (!OCImportGraph.getAllRootHeaders(config, root, progress).contains(header)) continue;
                result.add(config);
            }
        } else {
            result.addAll(configs2);
        }
    }

    private static boolean processPossibleRootsThatInclude(@NotNull Project project2, @NotNull VirtualFile headerFile, @NotNull Processor<VirtualFile> processor2, boolean strict) {
        if (project2 == null) {
            OCImportGraph.$$$reportNull$$$0(20);
        }
        if (headerFile == null) {
            OCImportGraph.$$$reportNull$$$0(21);
        }
        if (processor2 == null) {
            OCImportGraph.$$$reportNull$$$0(22);
        }
        ArrayList<VirtualFile> importers = new ArrayList<VirtualFile>();
        HashSet<VirtualFile> processed = new HashSet<VirtualFile>();
        importers.add(headerFile);
        while (!importers.isEmpty()) {
            ArrayList<VirtualFile> upperImporters = new ArrayList<VirtualFile>();
            for (VirtualFile headerHolder : importers) {
                if (headerHolder == null || !processed.add(headerHolder)) continue;
                Collection<VirtualFile> maybeUpperImporter = OCImportGraph.findImmediateIncludingFiles(project2, headerHolder, strict);
                for (VirtualFile importHolder : maybeUpperImporter) {
                    if (!importHolder.isValid()) continue;
                    PsiFile psiImportHolder = PsiManager.getInstance((Project)project2).findFile(importHolder);
                    if (psiImportHolder instanceof OCFile && !OCInclusionContextUtil.isNeedToFindRoot(psiImportHolder) && !processor2.process((Object)importHolder)) {
                        return false;
                    }
                    upperImporters.add(importHolder);
                }
            }
            importers = upperImporters;
        }
        return true;
    }

    @NotNull
    public static Collection<VirtualFile> findAllRootsThatIncludes(@NotNull Project project2, @NotNull VirtualFile original, boolean strict) {
        if (project2 == null) {
            OCImportGraph.$$$reportNull$$$0(23);
        }
        if (original == null) {
            OCImportGraph.$$$reportNull$$$0(24);
        }
        if (!OCInclusionContextUtil.isNeedToFindRoot(original, project2)) {
            List<VirtualFile> list = Collections.singletonList(original);
            if (list == null) {
                OCImportGraph.$$$reportNull$$$0(25);
            }
            return list;
        }
        PsiFile originalFile = PsiManager.getInstance((Project)project2).findFile(original);
        if (!(originalFile instanceof OCFile)) {
            List<VirtualFile> list = Collections.singletonList(original);
            if (list == null) {
                OCImportGraph.$$$reportNull$$$0(26);
            }
            return list;
        }
        THashSet result = new THashSet();
        OCImportGraph.processPossibleRootsThatInclude(project2, original, (Processor<VirtualFile>)((Processor)virtualFile -> {
            result.add(virtualFile);
            return true;
        }), strict);
        ArrayList<VirtualFile> arrayList = result.isEmpty() ? Collections.singletonList(original) : new ArrayList<VirtualFile>((Collection<VirtualFile>)result);
        if (arrayList == null) {
            OCImportGraph.$$$reportNull$$$0(27);
        }
        return arrayList;
    }

    @NotNull
    public static Collection<VirtualFile> findImmediateIncludingFiles(@NotNull Project project2, @NotNull VirtualFile file, boolean strict) {
        if (project2 == null) {
            OCImportGraph.$$$reportNull$$$0(28);
        }
        if (file == null) {
            OCImportGraph.$$$reportNull$$$0(29);
        }
        Collection<VirtualFile> collection = ((Cache)IMPORTS_GRAPH.getValue((UserDataHolder)project2)).get(file, strict);
        if (collection == null) {
            OCImportGraph.$$$reportNull$$$0(30);
        }
        return collection;
    }

    public static void addHeaderIncluder(@NotNull Project project2, @NotNull VirtualFile header, @NotNull VirtualFile includer) {
        if (project2 == null) {
            OCImportGraph.$$$reportNull$$$0(31);
        }
        if (header == null) {
            OCImportGraph.$$$reportNull$$$0(32);
        }
        if (includer == null) {
            OCImportGraph.$$$reportNull$$$0(33);
        }
        ((Cache)IMPORTS_GRAPH.getValue((UserDataHolder)project2)).add(header, includer);
    }

    public static void removeHeaderIncluder(@NotNull Project project2, @NotNull VirtualFile header, @NotNull VirtualFile includer) {
        if (project2 == null) {
            OCImportGraph.$$$reportNull$$$0(34);
        }
        if (header == null) {
            OCImportGraph.$$$reportNull$$$0(35);
        }
        if (includer == null) {
            OCImportGraph.$$$reportNull$$$0(36);
        }
        ((Cache)IMPORTS_GRAPH.getValue((UserDataHolder)project2)).remove(header, includer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: 
            case 14: 
            case 15: 
            case 25: 
            case 26: 
            case 27: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: 
            case 14: 
            case 15: 
            case 25: 
            case 26: 
            case 27: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 13: 
            case 17: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "header";
                break;
            }
            case 3: 
            case 8: 
            case 14: 
            case 15: 
            case 25: 
            case 26: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/preprocessor/OCImportGraph";
                break;
            }
            case 4: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootFile";
                break;
            }
            case 7: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pch";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerFile";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/preprocessor/OCImportGraph";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllHeaderRoots";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllRootHeaders";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllHeaderConfigurations";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllRootsThatIncludes";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "findImmediateIncludingFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invalidateHeaderRootsCache";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAllHeaderRoots";
                break;
            }
            case 3: 
            case 8: 
            case 14: 
            case 15: 
            case 25: 
            case 26: 
            case 27: 
            case 30: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildSymbolAndRootHeaderCache";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAllRootHeaders";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAllPCHRootHeaders";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getAllHeaderConfigurations";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "fillHeaderConfigurationsForRoot";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "processPossibleRootsThatInclude";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findAllRootsThatIncludes";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findImmediateIncludingFiles";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addHeaderIncluder";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "removeHeaderIncluder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: 
            case 14: 
            case 15: 
            case 25: 
            case 26: 
            case 27: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Cache {
        private static final boolean IS_STRICT = Registry.is((String)"cidr.indexer.strictImportGraph", (boolean)true);
        @NotNull
        private final Project myProject;
        @NotNull
        private final AtomicInteger isEnsuringFilesProcessed;
        @NotNull
        private final Object myLock;
        MultiMap<VirtualFile, VirtualFile> myHeaderToIncluders;
        MultiMap<VirtualFile, VirtualFile> myAddOnlyHeaderToIncluders;

        private Cache(@NotNull Project project2) {
            if (project2 == null) {
                Cache.$$$reportNull$$$0(0);
            }
            this.isEnsuringFilesProcessed = new AtomicInteger();
            this.myLock = new Object();
            this.myHeaderToIncluders = MultiMap.createConcurrentSet();
            this.myAddOnlyHeaderToIncluders = MultiMap.createConcurrentSet();
            this.myProject = project2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @NotNull
        public Collection<VirtualFile> get(@NotNull VirtualFile header, boolean strict) {
            Collection<VirtualFile> rs;
            if (header == null) {
                Cache.$$$reportNull$$$0(1);
            }
            if (strict) {
                Application app = ApplicationManager.getApplication();
                app.assertReadAccessAllowed();
                boolean sync = app.isUnitTestMode() || IS_STRICT && !app.isDispatchThread();
                this.ensureFilesProcessed(sync);
            }
            Object object = this.myLock;
            // MONITORENTER : object
            if (!strict && (rs = this.getInner(header, true)) != null) {
                Collection<VirtualFile> collection = rs;
                // MONITOREXIT : object
                if (collection != null) return collection;
                Cache.$$$reportNull$$$0(2);
                return collection;
            }
            Collection<VirtualFile> collection = this.getInner(header, false);
            // MONITOREXIT : object
            if (collection != null) return collection;
            Cache.$$$reportNull$$$0(3);
            return collection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        @Contract(value="_, false -> !null")
        private Collection<VirtualFile> getInner(@NotNull VirtualFile header, boolean fromAddOnlyCache) {
            if (header == null) {
                Cache.$$$reportNull$$$0(4);
            }
            Object object = this.myLock;
            synchronized (object) {
                MultiMap<VirtualFile, VirtualFile> h2is;
                MultiMap<VirtualFile, VirtualFile> multiMap = h2is = fromAddOnlyCache ? this.myAddOnlyHeaderToIncluders : this.myHeaderToIncluders;
                if (fromAddOnlyCache && !h2is.containsKey((Object)header)) {
                    return null;
                }
                Collection files = h2is.get((Object)header);
                boolean allValid = true;
                for (VirtualFile file : files) {
                    if (file.isValid()) continue;
                    allValid = false;
                    break;
                }
                if (!allValid) {
                    ArrayList fs = new ArrayList(files);
                    for (VirtualFile file : fs) {
                        if (file.isValid()) continue;
                        h2is.remove((Object)header, (Object)file);
                    }
                    files = h2is.get((Object)header);
                    if (!fromAddOnlyCache) {
                        OCImportGraph.invalidateHeaderRootsCache(this.myProject);
                    }
                }
                return files;
            }
        }

        private void ensureFilesProcessed(boolean sync) {
            if (sync) {
                this.isEnsuringFilesProcessed.incrementAndGet();
                try {
                    this.ensurePendingFilesProcessed(null);
                    return;
                }
                finally {
                    this.isEnsuringFilesProcessed.decrementAndGet();
                }
            }
            if (this.isEnsuringFilesProcessed.incrementAndGet() > 1) {
                this.isEnsuringFilesProcessed.decrementAndGet();
                return;
            }
            ProgressIndicatorUtils.scheduleWithWriteActionPriority((ReadTask)new ReadTask(){

                public void computeInReadAction(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        this.ensurePendingFilesProcessed(indicator);
                    }
                    finally {
                        isEnsuringFilesProcessed.decrementAndGet();
                    }
                }

                public void onCanceled(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    this.ensureFilesProcessed(false);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "indicator";
                    objectArray2[1] = "com/jetbrains/cidr/lang/preprocessor/OCImportGraph$Cache$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "computeInReadAction";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onCanceled";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void ensurePendingFilesProcessed(@Nullable ProgressIndicator indicator) {
            if (this.myProject.isDisposed() || !FileSymbolTablesCache.areSymbolsLoaded(this.myProject)) {
                return;
            }
            FileSymbolTablesCache cache = FileSymbolTablesCache.getInstance(this.myProject);
            cache.ensurePendingFilesProcessed(indicator, true);
            Object object = this.myLock;
            synchronized (object) {
                this.myAddOnlyHeaderToIncluders.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(@NotNull VirtualFile header, @NotNull VirtualFile includer) {
            if (header == null) {
                Cache.$$$reportNull$$$0(5);
            }
            if (includer == null) {
                Cache.$$$reportNull$$$0(6);
            }
            Object object = this.myLock;
            synchronized (object) {
                this.myHeaderToIncluders.putValue((Object)header, (Object)includer);
                if (this.myAddOnlyHeaderToIncluders.containsKey((Object)header)) {
                    this.myAddOnlyHeaderToIncluders.putValue((Object)header, (Object)includer);
                }
                OCImportGraph.invalidateHeaderRootsCache(this.myProject);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(@NotNull VirtualFile header, @NotNull VirtualFile includer) {
            if (header == null) {
                Cache.$$$reportNull$$$0(7);
            }
            if (includer == null) {
                Cache.$$$reportNull$$$0(8);
            }
            Object object = this.myLock;
            synchronized (object) {
                if (this.myHeaderToIncluders.remove((Object)header, (Object)includer)) {
                    if (!this.myAddOnlyHeaderToIncluders.containsKey((Object)header)) {
                        this.myAddOnlyHeaderToIncluders.putValues((Object)header, this.myHeaderToIncluders.get((Object)header));
                        this.myAddOnlyHeaderToIncluders.putValue((Object)header, (Object)includer);
                    }
                    OCImportGraph.invalidateHeaderRootsCache(this.myProject);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "header";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/preprocessor/OCImportGraph$Cache";
                    break;
                }
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "includer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/preprocessor/OCImportGraph$Cache";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "get";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getInner";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "remove";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

