/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.lexer.OCLexer;
import com.jetbrains.cidr.lang.lexer.OCLexerSettings;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCContextChangeBuilder;
import com.jetbrains.cidr.lang.preprocessor.OCContextChangeSet;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextImpl;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCParsingNameScope;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerSettingsKey;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OCInclusionContext
extends OCImmutableInclusionContext {
    public static final Key<Integer> MAX_INCLUSION_LEVEL_KEY = Key.create((String)"MAX_INCLUSION_LEVE_KEY");

    @Override
    @NotNull
    public OCLanguageKind getLanguageKind();

    public OCInclusionContext setRootFile(@Nullable PsiFile var1);

    public void addProcessedFile(@NotNull VirtualFile var1);

    public boolean checkConformanceAndFillSignatures(@NotNull FileSymbolTable var1);

    public void setProcessingListener(@Nullable Processor<OCSymbol> var1);

    public void setResolvePathListener(@Nullable ResolvePathListener var1);

    public void setChangeBuilder(@Nullable OCContextChangeBuilder var1);

    public void setPrecompiledHeaders(@NotNull List<OCFile> var1);

    @NotNull
    public OCParsingNameScope getNameScope();

    @NotNull
    public OCInclusionContext deriveButDontCopyTypes(boolean var1);

    public void define(@NotNull OCMacroSymbol var1);

    public void define(String var1, String var2);

    public void undef(String var1);

    public void hideDefinition(@NotNull String var1);

    public void revealDefinition(@NotNull String var1);

    public void setSignatureBuilder(@Nullable SignatureBuilder var1);

    public void enterNamespace(@NotNull String var1);

    public void exitNamespace();

    @Nullable
    public VirtualFile resolveNextPath(@NotNull OCIncludeSymbol.IncludePath var1, @NotNull PsiFile var2);

    @Nullable
    public VirtualFile resolvePath(@NotNull OCIncludeSymbol.IncludePath var1, @NotNull PsiFile var2);

    public boolean reserveInclude(@NotNull VirtualFile var1, boolean var2);

    public void preprocessContextOf(@Nullable PsiFile var1, @Nullable VirtualFile var2);

    public void preprocessInclude(@Nullable PsiFile var1, boolean var2);

    public boolean preprocessInclude(@Nullable PsiFile var1, boolean var2, @Nullable VirtualFile var3, int var4);

    @Contract(value="_, _, null, _, _, _, _, _ -> !null")
    public OCInclusionContext preprocessFile(@Nullable OCFile var1, @Nullable VirtualFile var2, @Nullable VirtualFile var3, int var4, int var5, int var6, @NotNull List<OCSymbol> var7, @Nullable OCContextChangeSet var8);

    public boolean preprocessInclude(@NotNull PsiFile var1, boolean var2, @Nullable VirtualFile var3, int var4, int var5, @Nullable OCContextChangeSet var6);

    public static int getMaxInclusionLevel(@Nullable Project project2) {
        Integer predefined = project2 != null ? (Integer)project2.getUserData(MAX_INCLUSION_LEVEL_KEY) : null;
        return predefined != null ? predefined : OCInclusionContextImpl.DEFAULT_MAX_INCLUSION_LEVEL;
    }

    public static boolean isPrecompiledHeader(@NotNull VirtualFile file, @NotNull OCResolveConfiguration configuration) {
        if (file == null) {
            OCInclusionContext.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            OCInclusionContext.$$$reportNull$$$0(1);
        }
        return OCInclusionContext.isPrecompiledHeader(file, configuration.getProject());
    }

    public static boolean isPrecompiledHeader(@NotNull VirtualFile file, @NotNull Project project2) {
        if (file == null) {
            OCInclusionContext.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            OCInclusionContext.$$$reportNull$$$0(3);
        }
        return OCInclusionContextImpl.getPCHCache(project2).isPCH(file);
    }

    @NotNull
    public static Collection<OCResolveConfiguration> getBuildConfigurationByPchFile(@Nullable VirtualFile pchFile, @NotNull Project project2) {
        if (project2 == null) {
            OCInclusionContext.$$$reportNull$$$0(4);
        }
        if (pchFile == null) {
            List<OCResolveConfiguration> list = Collections.emptyList();
            if (list == null) {
                OCInclusionContext.$$$reportNull$$$0(5);
            }
            return list;
        }
        Collection<OCResolveConfiguration> collection = OCInclusionContextImpl.getPCHCache(project2).getConfigurations(pchFile);
        if (collection == null) {
            OCInclusionContext.$$$reportNull$$$0(6);
        }
        return collection;
    }

    public static void onPrecompiledContextChange(@Nullable OCResolveConfiguration configuration) {
        if (configuration == null) {
            return;
        }
        Project project2 = configuration.getProject();
        if (project2.isDisposed()) {
            return;
        }
        ((SimpleModificationTracker)OCInclusionContextImpl.PROJECT_MODIFICATION_TRACKER.getValue((UserDataHolder)project2)).incModificationCount();
        configuration.putUserData((Key)OCInclusionContextImpl.INITIAL_PLAIN_AND_PCH_CONTEXTS_KEY, null);
    }

    public static void clearSymbolTableConformanceCache(OCResolveConfiguration configuration) {
        if (configuration == null) {
            return;
        }
        Project project2 = configuration.getProject();
        if (project2.isDisposed()) {
            return;
        }
        ((SimpleModificationTracker)OCInclusionContextImpl.PROJECT_MODIFICATION_TRACKER.getValue((UserDataHolder)project2)).incModificationCount();
        configuration.putUserData((Key)OCInclusionContextImpl.INCLUDE_RESOLVE_CACHE, null);
    }

    @NotNull
    public static OCInclusionContext empty(@NotNull OCLanguageKind kind, @NotNull PsiFile file) {
        if (kind == null) {
            OCInclusionContext.$$$reportNull$$$0(7);
        }
        if (file == null) {
            OCInclusionContext.$$$reportNull$$$0(8);
        }
        OCInclusionContext oCInclusionContext = new OCInclusionContextImpl(null, file.getProject(), kind).setRootFile(file);
        if (oCInclusionContext == null) {
            OCInclusionContext.$$$reportNull$$$0(9);
        }
        return oCInclusionContext;
    }

    @NotNull
    public static OCInclusionContext beforePCHFileContext(@NotNull OCFile file) {
        OCResolveConfiguration configuration;
        if (file == null) {
            OCInclusionContext.$$$reportNull$$$0(10);
        }
        OCInclusionContext oCInclusionContext = (configuration = OCInclusionContextUtil.getActiveConfiguration(file)) == null ? OCInclusionContextImpl.emptyWithBuiltinMacros(file.getKind(), file) : OCInclusionContext.beforePCHFileContext(configuration, file.getKind(), file);
        if (oCInclusionContext == null) {
            OCInclusionContext.$$$reportNull$$$0(11);
        }
        return oCInclusionContext;
    }

    @NotNull
    public static OCInclusionContext beforePCHFileContext(@NotNull OCResolveConfiguration configuration, @NotNull OCLanguageKind kind, @NotNull PsiFile file) {
        if (configuration == null) {
            OCInclusionContext.$$$reportNull$$$0(12);
        }
        if (kind == null) {
            OCInclusionContext.$$$reportNull$$$0(13);
        }
        if (file == null) {
            OCInclusionContext.$$$reportNull$$$0(14);
        }
        OCInclusionContext oCInclusionContext = OCInclusionContextImpl.initialContextWithoutRoot(configuration, kind, file).derive(file);
        if (oCInclusionContext == null) {
            OCInclusionContext.$$$reportNull$$$0(15);
        }
        return oCInclusionContext;
    }

    @NotNull
    public static OCInclusionContext sourceParsingContext(@NotNull OCResolveConfiguration configuration, @NotNull OCLanguageKind kind, @NotNull PsiFile file) {
        if (configuration == null) {
            OCInclusionContext.$$$reportNull$$$0(16);
        }
        if (kind == null) {
            OCInclusionContext.$$$reportNull$$$0(17);
        }
        if (file == null) {
            OCInclusionContext.$$$reportNull$$$0(18);
        }
        OCInclusionContext oCInclusionContext = OCInclusionContext.initialPCHContextWithoutRoot(configuration, kind, file).derive(file);
        if (oCInclusionContext == null) {
            OCInclusionContext.$$$reportNull$$$0(19);
        }
        return oCInclusionContext;
    }

    @NotNull
    public static OCImmutableInclusionContext initialPCHContextWithoutRoot(@NotNull OCResolveConfiguration configuration, @NotNull OCLanguageKind kind, @NotNull PsiFile file) {
        if (configuration == null) {
            OCInclusionContext.$$$reportNull$$$0(20);
        }
        if (kind == null) {
            OCInclusionContext.$$$reportNull$$$0(21);
        }
        if (file == null) {
            OCInclusionContext.$$$reportNull$$$0(22);
        }
        VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(file);
        CompilerSettingsKey key = configuration.getCompilerSettings().getCompilerKey(kind, virtualFile);
        if (key == null || !kind.supportsPrecompiledHeaders() || virtualFile == null || OCInclusionContext.isPrecompiledHeader(virtualFile, configuration)) {
            OCImmutableInclusionContext oCImmutableInclusionContext = OCInclusionContextImpl.initialContextWithoutRoot(configuration, kind, file);
            if (oCImmutableInclusionContext == null) {
                OCInclusionContext.$$$reportNull$$$0(23);
            }
            return oCImmutableInclusionContext;
        }
        ConcurrentHashMap switches2context = (ConcurrentHashMap)((Couple)OCInclusionContextImpl.INITIAL_PLAIN_AND_PCH_CONTEXTS_KEY.getValue((UserDataHolder)configuration)).second;
        OCImmutableInclusionContext context = (OCImmutableInclusionContext)switches2context.get(key);
        if (context != null) {
            OCImmutableInclusionContext oCImmutableInclusionContext = context;
            if (oCImmutableInclusionContext == null) {
                OCInclusionContext.$$$reportNull$$$0(24);
            }
            return oCImmutableInclusionContext;
        }
        List<OCFile> precompiledHeaders = OCInclusionContextImpl.getPrecompiledHeaders(configuration, kind, virtualFile);
        if (precompiledHeaders.isEmpty()) {
            OCImmutableInclusionContext oCImmutableInclusionContext = OCInclusionContextImpl.initialContextWithoutRoot(configuration, kind, file);
            if (oCImmutableInclusionContext == null) {
                OCInclusionContext.$$$reportNull$$$0(25);
            }
            return oCImmutableInclusionContext;
        }
        OCImmutableInclusionContext initial = OCInclusionContextImpl.initialContextWithoutRoot(configuration, kind, file);
        OCInclusionContext ctx = initial.derive(file);
        for (OCFile pch : precompiledHeaders) {
            ctx.preprocessInclude(pch, true);
        }
        ctx.setRootFile(null);
        ctx.setPrecompiledHeaders(precompiledHeaders);
        OCImmutableInclusionContext existing = switches2context.putIfAbsent(key, ctx);
        OCImmutableInclusionContext oCImmutableInclusionContext = existing == null ? ctx : existing;
        if (oCImmutableInclusionContext == null) {
            OCInclusionContext.$$$reportNull$$$0(26);
        }
        return oCImmutableInclusionContext;
    }

    @Nullable
    public static OCImmutableInclusionContext tryFindInCachedPCHPrecompiledContexts(@NotNull OCResolveConfiguration config, @NotNull VirtualFile header, @NotNull VirtualFile pchCandidate) {
        if (config == null) {
            OCInclusionContext.$$$reportNull$$$0(27);
        }
        if (header == null) {
            OCInclusionContext.$$$reportNull$$$0(28);
        }
        if (pchCandidate == null) {
            OCInclusionContext.$$$reportNull$$$0(29);
        }
        if (OCInclusionContext.isPrecompiledHeader(pchCandidate, config) && OCImportGraph.getAllRootHeaders(config, pchCandidate, null).contains(header)) {
            return OCInclusionContextImpl.findInCachedPCHPrecompiledContexts(config, header);
        }
        return null;
    }

    @Nullable
    public static String extractFirstPathLiteralText(@NotNull CharSequence contentWithoutMacros) {
        IElementType tt;
        if (contentWithoutMacros == null) {
            OCInclusionContext.$$$reportNull$$$0(30);
        }
        OCLexer lexer = new OCLexer(OCLexerSettings.forPreprocessor().build());
        lexer.start(contentWithoutMacros, 0, contentWithoutMacros.length(), 10);
        while (lexer.getState() == 10 && (tt = lexer.getTokenType()) != null) {
            if (tt == OCTokenTypes.HEADER_PATH_LITERAL) {
                return lexer.getTokenText();
            }
            lexer.advance();
        }
        return null;
    }

    @NotNull
    public static OCIncludeSymbol.IncludePath extractPath(@Nullable CharSequence rawPathLiteralContext, boolean unescapePath) {
        char maybeSuffixPunctuator;
        int length;
        if (rawPathLiteralContext == null || (length = rawPathLiteralContext.length()) < 2) {
            OCIncludeSymbol.IncludePath includePath = OCIncludeSymbol.IncludePath.EMPTY;
            if (includePath == null) {
                OCInclusionContext.$$$reportNull$$$0(31);
            }
            return includePath;
        }
        int start = 0;
        char prefixPunctuator = rawPathLiteralContext.charAt(0);
        if (prefixPunctuator == '\"' || prefixPunctuator == '<') {
            start = 1;
        }
        if ((maybeSuffixPunctuator = rawPathLiteralContext.charAt(length - 1)) == '\"' && prefixPunctuator == '\"' || maybeSuffixPunctuator == '>' && prefixPunctuator == '<') {
            --length;
        }
        String path = rawPathLiteralContext.subSequence(start, length).toString();
        if (unescapePath) {
            path = path.replace("\\\n", "");
        }
        OCIncludeSymbol.IncludePath includePath = new OCIncludeSymbol.IncludePath(path, prefixPunctuator != '\"');
        if (includePath == null) {
            OCInclusionContext.$$$reportNull$$$0(32);
        }
        return includePath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 15: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 31: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 15: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 31: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 12: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 15: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/preprocessor/OCInclusionContext";
                break;
            }
            case 7: 
            case 13: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "header";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pchCandidate";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentWithoutMacros";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/preprocessor/OCInclusionContext";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildConfigurationByPchFile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "empty";
                break;
            }
            case 11: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "beforePCHFileContext";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "sourceParsingContext";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "initialPCHContextWithoutRoot";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "extractPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isPrecompiledHeader";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getBuildConfigurationByPchFile";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 15: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 31: 
            case 32: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "empty";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "beforePCHFileContext";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "sourceParsingContext";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "initialPCHContextWithoutRoot";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "tryFindInCachedPCHPrecompiledContexts";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "extractFirstPathLiteralText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 15: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 31: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ResolvePathListener {
        public void resolve(@NotNull OCIncludeSymbol.IncludePath var1, boolean var2, @Nullable VirtualFile var3);
    }

    public static interface SignatureBuilder {
        public void setDefined(@NotNull String var1, boolean var2);

        public void setDefinition(@NotNull String var1, @NotNull OCMacroSymbol var2);

        public void enterConformanceCheckMode();

        public void exitConformanceCheckMode(boolean var1);
    }
}

