/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.testFramework.LightVirtualFileBase;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCIncludeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.preprocessor.OCCompilerMacros;
import com.jetbrains.cidr.lang.preprocessor.OCContextChange;
import com.jetbrains.cidr.lang.preprocessor.OCContextChangeBuilder;
import com.jetbrains.cidr.lang.preprocessor.OCContextChangeBuilderImpl;
import com.jetbrains.cidr.lang.preprocessor.OCContextChangeSet;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCModuleResolver;
import com.jetbrains.cidr.lang.preprocessor.OCParsingNameScope;
import com.jetbrains.cidr.lang.preprocessor.OCPreprocessingLexer;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceAliasSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterTypeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterValueSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUndefMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCModuleImportSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.ContextSignature;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.util.OCImmutableList;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerSettingsKey;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCInclusionContextImpl
implements OCInclusionContext {
    static int DEFAULT_MAX_INCLUSION_LEVEL = 256;
    @NotNull
    private final OCLanguageKind myLanguageKind;
    private final boolean myNotifyLocalDefinitions;
    @Nullable
    private final OCResolveConfiguration myConfiguration;
    @NotNull
    private final Project myProject;
    @NotNull
    private final THashMap<String, OCMacroSymbol> mySubstitutions;
    @NotNull
    private final Set<String> myUndefList;
    @NotNull
    private volatile OCParsingNameScope myNameScope;
    @NotNull
    private final Set<VirtualFile> myProcessedFiles;
    @Nullable
    private final OCInclusionContextImpl myParentContext;
    private final int myInclusionLevel;
    @Nullable
    private PsiFile myRootFile;
    private volatile List<OCFile> myPrecompiledHeaders;
    @Nullable
    private OCInclusionContext.SignatureBuilder mySignatureBuilder;
    @NotNull
    private final List<String> myCurrentNamespace;
    private Processor<OCSymbol> myProcessingListener;
    @Nullable
    private OCContextChangeBuilder myChangeBuilder;
    private THashMap<String, OCMacroSymbol> myOverriddenSubstitutions;
    @NotNull
    private static final Object NULL_VALUE = new Object();
    @NotNull
    private final ConcurrentHashMap<OCCompilerFeatures.Type, Object> myCompilerFeatures;
    @Nullable
    private OCInclusionContext.ResolvePathListener myResolvePathListener;
    static final NotNullLazyKey<Map<FileSymbolTable, Boolean>, OCResolveConfiguration> INCLUDE_RESOLVE_CACHE = NotNullLazyKey.create((String)"INCLUDE_RESOLVE_CACHE", dom -> ContainerUtil.createConcurrentWeakMap());
    static final NotNullLazyKey<SimpleModificationTracker, Project> PROJECT_MODIFICATION_TRACKER = NotNullLazyKey.create((String)"PROJECT_MODIFICATION_TRACKER", project2 -> new SimpleModificationTracker());
    private static final Key<CachedValue<PCHCache>> PCH_CACHE_KEY = Key.create((String)"PCH_CACHE_KEY");
    static final NotNullLazyKey<Couple<ConcurrentHashMap<CompilerSettingsKey, OCImmutableInclusionContext>>, OCResolveConfiguration> INITIAL_PLAIN_AND_PCH_CONTEXTS_KEY = NotNullLazyKey.create((String)"INITIAL_CONTEXTS_KEY", p -> Couple.of(new ConcurrentHashMap(), new ConcurrentHashMap()));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    static PCHCache getPCHCache(@NotNull Project project2) {
        CachedValue value;
        if (project2 == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(0);
        }
        if ((value = (CachedValue)project2.getUserData(PCH_CACHE_KEY)) == null) {
            SimpleModificationTracker modificationTracker = (SimpleModificationTracker)PROJECT_MODIFICATION_TRACKER.getValue((UserDataHolder)project2);
            CachedValueProvider provider2 = () -> {
                if (project2 == null) {
                    OCInclusionContextImpl.$$$reportNull$$$0(63);
                }
                return new CachedValueProvider.Result((Object)new PCHCache(project2), new Object[]{modificationTracker});
            };
            CachedValue newValue = CachedValuesManager.getManager((Project)project2).createCachedValue(provider2, false);
            value = (CachedValue)((UserDataHolderEx)project2).putUserDataIfAbsent(PCH_CACHE_KEY, (Object)newValue);
        }
        if (value.hasUpToDateValue()) {
            PCHCache pCHCache = (PCHCache)value.getValue();
            if (pCHCache != null) return pCHCache;
            OCInclusionContextImpl.$$$reportNull$$$0(1);
            return pCHCache;
        }
        CachedValue cachedValue = value;
        // MONITORENTER : cachedValue
        PCHCache pCHCache = (PCHCache)value.getValue();
        // MONITOREXIT : cachedValue
        if (pCHCache != null) return pCHCache;
        OCInclusionContextImpl.$$$reportNull$$$0(2);
        return pCHCache;
    }

    @NotNull
    static List<OCFile> getPrecompiledHeaders(@NotNull OCResolveConfiguration config, @NotNull OCLanguageKind kind, @NotNull VirtualFile sourceFile) {
        List<VirtualFile> pchs;
        if (config == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(3);
        }
        if (kind == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(4);
        }
        if (sourceFile == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(5);
        }
        if ((pchs = config.getPrecompiledHeaders(kind, sourceFile)).isEmpty()) {
            List<OCFile> list = Collections.emptyList();
            if (list == null) {
                OCInclusionContextImpl.$$$reportNull$$$0(6);
            }
            return list;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)config.getProject());
        ArrayList<OCFile> result = new ArrayList<OCFile>(pchs.size());
        for (VirtualFile pch : pchs) {
            PsiFile pchPsi;
            if (!pch.isValid() || !((pchPsi = psiManager.findFile(pch)) instanceof OCFile)) continue;
            result.add((OCFile)pchPsi);
        }
        ArrayList<OCFile> arrayList = result;
        if (arrayList == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    protected OCInclusionContextImpl(@Nullable OCResolveConfiguration configuration, @NotNull Project project2, @NotNull OCLanguageKind languageKind) {
        if (project2 == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(8);
        }
        if (languageKind == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(9);
        }
        this.mySubstitutions = new THashMap();
        this.myUndefList = new THashSet();
        this.myProcessedFiles = new THashSet();
        this.mySignatureBuilder = null;
        assert (configuration == null || project2.equals(configuration.getProject()));
        this.myConfiguration = configuration;
        this.myProject = project2;
        this.myLanguageKind = languageKind;
        this.myNameScope = new OCParsingNameScope();
        this.myParentContext = null;
        this.myInclusionLevel = 0;
        this.myNotifyLocalDefinitions = false;
        this.myCurrentNamespace = new ArrayList<String>();
        this.myOverriddenSubstitutions = new THashMap();
        this.myCompilerFeatures = new ConcurrentHashMap();
    }

    private OCInclusionContextImpl(@Nullable OCResolveConfiguration configuration, @NotNull Project project2, @NotNull OCInclusionContextImpl parentContext, @NotNull PsiFile rootFile, @NotNull OCParsingNameScope nameScope, boolean notifyLocalDefinitions) {
        if (project2 == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(10);
        }
        if (parentContext == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(11);
        }
        if (rootFile == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(12);
        }
        if (nameScope == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(13);
        }
        this.mySubstitutions = new THashMap();
        this.myUndefList = new THashSet();
        this.myProcessedFiles = new THashSet();
        this.mySignatureBuilder = null;
        this.myConfiguration = configuration;
        this.myProject = project2;
        this.myLanguageKind = parentContext.myLanguageKind;
        this.myParentContext = parentContext;
        this.myRootFile = rootFile;
        this.myNameScope = nameScope;
        this.myInclusionLevel = this.myParentContext.myInclusionLevel + 1;
        this.myNotifyLocalDefinitions = notifyLocalDefinitions;
        this.myCurrentNamespace = new ArrayList<String>();
        this.myOverriddenSubstitutions = parentContext.myOverriddenSubstitutions;
        this.myCompilerFeatures = parentContext.myCompilerFeatures;
        this.myResolvePathListener = parentContext.myResolvePathListener;
        Project configurationProject = configuration != null ? configuration.getProject() : null;
        OCLog.LOG.assertTrue(this.myInclusionLevel <= OCInclusionContext.getMaxInclusionLevel(configurationProject) + 2, (Object)"Inclusion level is too high");
    }

    @Override
    @NotNull
    public OCLanguageKind getLanguageKind() {
        OCLanguageKind oCLanguageKind = this.myLanguageKind;
        if (oCLanguageKind == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(14);
        }
        return oCLanguageKind;
    }

    @Override
    public void addProcessedFile(@NotNull VirtualFile file) {
        if (file == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(15);
        }
        if (this.myChangeBuilder != null) {
            this.myChangeBuilder.addProcessedFile(file);
        }
        this.myProcessedFiles.add(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkConformanceAndFillSignatures(@NotNull FileSymbolTable table) {
        if (table == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(16);
        }
        this.enterConformanceCheckMode();
        boolean isCompatibleTable = false;
        try {
            ContextSignature sig = table.getSignature();
            if (sig.isCompatible(this)) {
                isCompatibleTable = this.myConfiguration == null || this.conformsToByIncludes(table);
            }
            boolean bl = isCompatibleTable;
            return bl;
        }
        finally {
            this.exitConformanceCheckMode(isCompatibleTable);
        }
    }

    @Override
    public void setProcessingListener(@Nullable Processor<OCSymbol> processingListener) {
        this.myProcessingListener = processingListener;
    }

    @Override
    public void setResolvePathListener(@Nullable OCInclusionContext.ResolvePathListener resolvePathListener) {
        this.myResolvePathListener = resolvePathListener;
    }

    @Override
    public void setChangeBuilder(@Nullable OCContextChangeBuilder changeBuilder) {
        this.myChangeBuilder = changeBuilder;
    }

    @NotNull
    static OCInclusionContext emptyWithBuiltinMacros(@Nullable OCLanguageKind kind, @NotNull PsiFile file) {
        if (file == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(17);
        }
        if (kind == null) {
            kind = OCLanguageKindCalculator.calculateLanguageKindFast(file);
        }
        OCInclusionContextImpl result = (OCInclusionContextImpl)OCInclusionContext.empty(kind, file);
        result.initContext(file, null);
        OCInclusionContextImpl oCInclusionContextImpl = result;
        if (oCInclusionContextImpl == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(18);
        }
        return oCInclusionContextImpl;
    }

    @NotNull
    static OCImmutableInclusionContext initialContextWithoutRoot(@NotNull OCResolveConfiguration configuration, @NotNull OCLanguageKind kind, @NotNull PsiFile file) {
        if (configuration == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(19);
        }
        if (kind == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(20);
        }
        if (file == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(21);
        }
        ConcurrentHashMap switches2context = (ConcurrentHashMap)((Couple)OCInclusionContextImpl.INITIAL_PLAIN_AND_PCH_CONTEXTS_KEY.getValue((UserDataHolder)configuration)).first;
        VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(file);
        OCInclusionContextImpl result = new OCInclusionContextImpl(configuration, configuration.getProject(), kind);
        if (virtualFile == null && file instanceof OCCodeFragment) {
            result.initContext(file, configuration);
            OCInclusionContextImpl oCInclusionContextImpl = result;
            if (oCInclusionContextImpl == null) {
                OCInclusionContextImpl.$$$reportNull$$$0(22);
            }
            return oCInclusionContextImpl;
        }
        CompilerSettingsKey key = configuration.getCompilerSettings().getCompilerKey(kind, virtualFile);
        if (key == null) {
            result.initContext(file, null);
            OCInclusionContextImpl oCInclusionContextImpl = result;
            if (oCInclusionContextImpl == null) {
                OCInclusionContextImpl.$$$reportNull$$$0(23);
            }
            return oCInclusionContextImpl;
        }
        OCImmutableInclusionContext context = (OCImmutableInclusionContext)switches2context.get(key);
        if (context != null) {
            OCImmutableInclusionContext oCImmutableInclusionContext = context;
            if (oCImmutableInclusionContext == null) {
                OCInclusionContextImpl.$$$reportNull$$$0(24);
            }
            return oCImmutableInclusionContext;
        }
        result.initContext(file, configuration);
        OCImmutableInclusionContext existing = switches2context.putIfAbsent(key, result);
        OCImmutableInclusionContext oCImmutableInclusionContext = existing == null ? result : existing;
        if (oCImmutableInclusionContext == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(25);
        }
        return oCImmutableInclusionContext;
    }

    private void initContext(@NotNull PsiFile sourceFile, @Nullable OCResolveConfiguration configuration) {
        if (sourceFile == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(26);
        }
        assert (this.myParentContext == null) : "initContext is supposed to be called on a root context.";
        OCLanguageKind languageKind = this.getLanguageKind();
        this.mySubstitutions.putAll(OCInclusionContextImpl.getSubstitutions(languageKind, sourceFile, OCCompilerMacros.PREDEFINED_MACROS));
        if (configuration != null) {
            VirtualFile vFile = OCInclusionContextUtil.getVirtualFile(sourceFile);
            this.mySubstitutions.putAll(OCInclusionContextImpl.getSubstitutions(languageKind, sourceFile, configuration.getPreprocessorDefines(languageKind, vFile)));
            this.myCompilerFeatures.putAll(configuration.getCompilerFeatures(languageKind, vFile));
        }
        this.myOverriddenSubstitutions.putAll(OCInclusionContextImpl.getSubstitutions(languageKind, sourceFile, "\n#define __OSX_AVAILABLE_BUT_DEPRECATED(_macIntro, _macDep, _iosIntro, _iosDep)           __CIDR_OSX_AVAILABLE_BUT_DEPRECATED_IMPL(_macIntro, _macDep, _iosIntro, _iosDep)\n#define __OSX_AVAILABLE_BUT_DEPRECATED_MSG(_macIntro, _macDep, _iosIntro, _iosDep, _msg) __CIDR_OSX_AVAILABLE_BUT_DEPRECATED_IMPL(_macIntro, _macDep, _iosIntro, _iosDep)\n#define __OSX_AVAILABLE_STARTING(mac, ios) __CIDR_OSX_AVAILABLE_STARTING_IMPL(mac, ios)\n#define CF_DEPRECATED(_macIntro, _macDep, _iosIntro, _iosDep, ...) __CIDR_OSX_DEPRECATED(_macIntro, _macDep, _iosIntro, _iosDep)\n#define CF_DEPRECATED_MAC(_macIntro, _macDep, ...)                 __CIDR_OSX_DEPRECATED(_macIntro, _macDep, NA,        NA)\n#define CF_DEPRECATED_IOS(_iosIntro, _iosDep, ...)                 __CIDR_OSX_DEPRECATED(NA,        NA,      _iosIntro, _iosDep)\n#define CF_AVAILABLE(mac, ios)       __CIDR_OSX_AVAILABLE(mac, ios)\n#define CF_AVAILABLE_MAC(mac)        __CIDR_OSX_AVAILABLE(mac, NA) \n#define CF_AVAILABLE_IOS(ios)        __CIDR_OSX_AVAILABLE(NA,  ios)\n#define CF_CLASS_AVAILABLE(mac, ios) __CIDR_OSX_AVAILABLE(mac, ios)\n#define CF_CLASS_AVAILABLE_MAC(mac)  __CIDR_OSX_AVAILABLE(mac, NA) \n#define CF_CLASS_AVAILABLE_IOS(ios)  __CIDR_OSX_AVAILABLE(NA,  ios)\n#define NS_AVAILABLE(mac, ios)       __CIDR_OSX_AVAILABLE(mac, ios)\n#define NS_AVAILABLE_MAC(mac)        __CIDR_OSX_AVAILABLE(mac, NA) \n#define NS_AVAILABLE_IOS(ios)        __CIDR_OSX_AVAILABLE(NA,  ios)\n#define NS_CLASS_AVAILABLE(mac, ios) __CIDR_OSX_AVAILABLE(mac, ios)\n#define NS_CLASS_AVAILABLE_MAC(mac)  __CIDR_OSX_AVAILABLE(mac, NA) \n#define NS_CLASS_AVAILABLE_IOS(ios)  __CIDR_OSX_AVAILABLE(NA,  ios)\n#define __CF_NAMED_ENUM(_type, _name) __attribute__((NS_ENUM_MACRO)) enum _name : _type _name; enum __attribute__((NS_ENUM)) _name : _type\n#define __CF_ANON_ENUM(_type) enum __attribute__((NS_ENUM)) : _type\n\n#define NS_OPTIONS(_type, _name) __attribute__((NS_OPTIONS_MACRO)) enum _name : _type _name; enum __attribute__((NS_OPTIONS)) _name : _type\n"));
        this.myOverriddenSubstitutions.trimToSize();
    }

    private static Map<String, OCMacroSymbol> getSubstitutions(@NotNull OCLanguageKind languageKind, @NotNull PsiFile sourceFile, @NotNull String text) {
        if (languageKind == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(27);
        }
        if (sourceFile == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(28);
        }
        if (text == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(29);
        }
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            return Collections.emptyMap();
        }
        Project project2 = sourceFile.getProject();
        Map cache = (Map)CachedValuesManager.getManager((Project)project2).getCachedValue((UserDataHolder)project2, () -> CachedValueProvider.Result.create(new ConcurrentHashMap(), (Object[])new Object[]{ModificationTracker.NEVER_CHANGED}));
        THashMap<String, OCMacroSymbol> cached = (THashMap<String, OCMacroSymbol>)cache.get(text);
        if (cached == null) {
            OCInclusionContextImpl context = (OCInclusionContextImpl)OCInclusionContext.empty(languageKind, sourceFile);
            OCPreprocessingLexer lexer = new OCPreprocessingLexer(context, null);
            lexer.start(text);
            while (lexer.getTokenType() != null) {
                lexer.advance();
            }
            cached = context.mySubstitutions;
            cache.putIfAbsent(text, cached);
        }
        return cached;
    }

    private boolean conformsToByIncludes(@NotNull FileSymbolTable table) {
        Map<FileSymbolTable, Boolean> resolveCache2;
        Boolean conforms;
        if (table == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(30);
        }
        if ((conforms = (resolveCache2 = this.getSymbolTablesConformingCache()).get(table)) == null) {
            conforms = table.processIncludes((Processor<OCSymbol>)((Processor)symbol -> {
                VirtualFile resolved;
                if (table == null) {
                    OCInclusionContextImpl.$$$reportNull$$$0(62);
                }
                if (!(symbol instanceof OCIncludeSymbol)) {
                    return true;
                }
                OCIncludeSymbol includeSymbol = (OCIncludeSymbol)symbol;
                VirtualFile targetFile = includeSymbol.getTargetFile();
                if (targetFile instanceof LightVirtualFileBase) {
                    return true;
                }
                VirtualFile owner2 = table.getContainingFile();
                OCIncludeSymbol.IncludePath path = includeSymbol.getIncludePath();
                Project project2 = table.getProject();
                OCResolveRootAndConfiguration conf = this.getRootAndConfiguration();
                if (includeSymbol.isNext()) {
                    Ref r = new Ref();
                    OCIncludeHelpers.resolveNextIncludedFile(conf, owner2, owner2, path, project2, (Ref<VirtualFile>)r);
                    resolved = (VirtualFile)r.get();
                } else {
                    resolved = OCIncludeHelpers.resolveIncludedFile(conf, owner2, path, project2);
                }
                return Comparing.equal((Object)targetFile, (Object)resolved);
            }));
            resolveCache2.put(table, conforms);
        }
        return conforms;
    }

    @Override
    public int getInclusionLevel() {
        return this.myInclusionLevel;
    }

    @Override
    @Nullable
    public OCImmutableInclusionContext getParent() {
        return this.myParentContext;
    }

    @Override
    public void setPrecompiledHeaders(@NotNull List<OCFile> precompiledHeader) {
        if (precompiledHeader == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(31);
        }
        this.myPrecompiledHeaders = new ArrayList<OCFile>(precompiledHeader);
    }

    @Override
    @NotNull
    public List<OCFile> getPrecompiledHeaders() {
        if (this.myPrecompiledHeaders != null && !this.myPrecompiledHeaders.isEmpty()) {
            List<OCFile> list = Collections.unmodifiableList(this.myPrecompiledHeaders);
            if (list == null) {
                OCInclusionContextImpl.$$$reportNull$$$0(32);
            }
            return list;
        }
        List<OCFile> list = this.myParentContext == null ? Collections.emptyList() : this.myParentContext.getPrecompiledHeaders();
        if (list == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(33);
        }
        return list;
    }

    @Override
    public boolean hasRootFile() {
        return this.myRootFile != null;
    }

    @Override
    @NotNull
    public PsiFile getRootFile() {
        if (this.myRootFile == null) {
            OCLog.LOG.error("No root file");
        }
        PsiFile psiFile = this.myRootFile;
        if (psiFile == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(34);
        }
        return psiFile;
    }

    @Override
    public OCInclusionContext setRootFile(@Nullable PsiFile file) {
        if (this.myRootFile != null && file != null) {
            throw new IllegalStateException("Trying to change root file for inclusion context with existing root file");
        }
        this.myRootFile = file;
        return this;
    }

    @Nullable
    static OCImmutableInclusionContext findInCachedPCHPrecompiledContexts(@NotNull OCResolveConfiguration config, @NotNull VirtualFile header) {
        if (config == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(35);
        }
        if (header == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(36);
        }
        Collection values = ((ConcurrentHashMap)((Couple)OCInclusionContextImpl.INITIAL_PLAIN_AND_PCH_CONTEXTS_KEY.getValue((UserDataHolder)config)).second).values();
        OCImmutableInclusionContext bestContext = null;
        for (OCImmutableInclusionContext each : values) {
            OCLanguageKind eachContextLang = each.getLanguageKind();
            assert (eachContextLang.supportsPrecompiledHeaders());
            if (!each.isProcessed(header)) continue;
            assert (eachContextLang instanceof CLanguageKind);
            if (bestContext != null && bestContext.getLanguageKind() != CLanguageKind.min((CLanguageKind)eachContextLang, (CLanguageKind)bestContext.getLanguageKind())) continue;
            bestContext = each;
        }
        return bestContext;
    }

    private Map<FileSymbolTable, Boolean> getSymbolTablesConformingCache() {
        if (this.myConfiguration == null) {
            return new THashMap();
        }
        return (Map)INCLUDE_RESOLVE_CACHE.getValue((UserDataHolder)this.myConfiguration);
    }

    @Override
    @Nullable
    public <T> T getCompilerFeature(@NotNull OCCompilerFeatures.Type<T> feature) {
        Object result;
        if (feature == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(37);
        }
        if ((result = this.myCompilerFeatures.get(feature)) == null) {
            OCInclusionContextImpl topMost = this;
            while (topMost.myParentContext != null) {
                topMost = topMost.myParentContext;
            }
            result = feature.compute(topMost);
            if (result == null) {
                result = NULL_VALUE;
            }
            this.myCompilerFeatures.putIfAbsent(feature, result);
        }
        return (T)(result == NULL_VALUE ? null : result);
    }

    @Override
    @NotNull
    public OCParsingNameScope getNameScope() {
        OCParsingNameScope oCParsingNameScope = this.myNameScope;
        if (oCParsingNameScope == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(38);
        }
        return oCParsingNameScope;
    }

    @Override
    @NotNull
    public OCInclusionContext derive() {
        if (this.myRootFile == null) {
            throw new IllegalStateException("Deriving from context without root file. Use 'derive(PsiFile)' instead");
        }
        OCInclusionContextImpl oCInclusionContextImpl = new OCInclusionContextImpl(this.myConfiguration, this.myProject, this, this.myRootFile, this.myNameScope.copy(), true);
        if (oCInclusionContextImpl == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(39);
        }
        return oCInclusionContextImpl;
    }

    @Override
    @NotNull
    public OCInclusionContext derive(@NotNull PsiFile file) {
        if (file == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(40);
        }
        if (this.myRootFile != null) {
            throw new IllegalStateException("Deriving from context with existing root file. Use 'derive()' instead");
        }
        OCInclusionContextImpl oCInclusionContextImpl = new OCInclusionContextImpl(this.myConfiguration, this.myProject, this, file, this.myNameScope.copy(), true);
        if (oCInclusionContextImpl == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(41);
        }
        return oCInclusionContextImpl;
    }

    @Override
    @NotNull
    public OCInclusionContext derive(@NotNull OCParsingNameScope nameScope) {
        if (nameScope == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(42);
        }
        if (this.myRootFile == null) {
            throw new IllegalStateException("Deriving from context without root file. Use 'derive(PsiFile)' instead");
        }
        OCInclusionContextImpl oCInclusionContextImpl = new OCInclusionContextImpl(this.myConfiguration, this.myProject, this, this.myRootFile, nameScope, true);
        if (oCInclusionContextImpl == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(43);
        }
        return oCInclusionContextImpl;
    }

    @Override
    @NotNull
    public OCInclusionContext deriveButDontCopyTypes(boolean notifyLocalDefinitions) {
        if (this.myRootFile == null) {
            throw new IllegalStateException("Deriving from context without root file. Use 'derive(PsiFile)' instead");
        }
        OCInclusionContextImpl oCInclusionContextImpl = new OCInclusionContextImpl(this.myConfiguration, this.myProject, this, this.myRootFile, this.myNameScope, notifyLocalDefinitions);
        if (oCInclusionContextImpl == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(44);
        }
        return oCInclusionContextImpl;
    }

    @Override
    public void define(@NotNull OCMacroSymbol def) {
        String name2;
        OCMacroSymbol overridden;
        if (def == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(45);
        }
        if ((overridden = (OCMacroSymbol)this.myOverriddenSubstitutions.get((Object)(name2 = def.getName()))) != null) {
            if (def.getContainingFile() != null && ApplicationManager.getApplication().isUnitTestMode()) {
                int defNum = def.getParameterNames().size();
                int ovNum = overridden.getParameterNames().size();
                boolean defVar = def.isVararg();
                boolean ovVar = overridden.isVararg();
                OCLog.LOG.assertTrue(defNum == ovNum, (Object)(def.getName() + ": overridden with " + ovNum + " params instead of " + defNum));
                OCLog.LOG.assertTrue(defVar == ovVar, (Object)(def.getName() + ": overridden with vararg=" + ovVar + " instead of " + defVar));
            }
            def = overridden;
        }
        this.revealDefinition(name2);
        this.mySubstitutions.put((Object)name2, (Object)def);
        if (this.myChangeBuilder != null) {
            this.myChangeBuilder.define(name2, def);
        }
    }

    @Override
    public void define(String def, String content) {
        this.define(new OCMacroSymbol(this.getProject(), null, 0L, def, OCImmutableList.emptyList(), content));
    }

    @Override
    public void undef(String name2) {
        this.hideDefinition(name2);
        this.mySubstitutions.remove((Object)name2);
        if (this.myChangeBuilder != null) {
            this.myChangeBuilder.undef(name2);
        }
    }

    @Override
    public void hideDefinition(@NotNull String name2) {
        if (name2 == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(46);
        }
        this.myUndefList.add(name2);
    }

    @Override
    public void revealDefinition(@NotNull String name2) {
        if (name2 == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(47);
        }
        this.myUndefList.remove(name2);
    }

    @Override
    public boolean isDefined(@Nullable String name2) {
        return this.getDefinition(name2, OCImmutableInclusionContext.SignaturePart.HAS_DEFINITION) != null;
    }

    @Override
    @Nullable
    public OCMacroSymbol getDefinition(@Nullable String id) {
        return this.getDefinition(id, OCImmutableInclusionContext.SignaturePart.EXACT_DEFINITION);
    }

    private void enterConformanceCheckMode() {
        if (this.mySignatureBuilder != null) {
            this.mySignatureBuilder.enterConformanceCheckMode();
        }
        if (this.myParentContext != null) {
            this.myParentContext.enterConformanceCheckMode();
        }
    }

    private void exitConformanceCheckMode(boolean commit2) {
        if (this.mySignatureBuilder != null) {
            this.mySignatureBuilder.exitConformanceCheckMode(commit2);
        }
        if (this.myParentContext != null) {
            this.myParentContext.exitConformanceCheckMode(commit2);
        }
    }

    @Override
    @Nullable
    public OCMacroSymbol getDefinition(@Nullable String id, @NotNull OCImmutableInclusionContext.SignaturePart sp) {
        OCMacroSymbol answer;
        boolean notify;
        if (sp == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(48);
        }
        if (id == null) {
            return null;
        }
        boolean bl = notify = sp != OCImmutableInclusionContext.SignaturePart.NO;
        if (this.myUndefList.contains(id)) {
            answer = null;
            notify = this.myNotifyLocalDefinitions;
        } else {
            OCMacroSymbol local = (OCMacroSymbol)this.mySubstitutions.get((Object)id);
            if (local != null) {
                answer = local;
                notify = this.myNotifyLocalDefinitions;
            } else {
                OCMacroSymbol oCMacroSymbol = answer = this.myParentContext != null ? this.myParentContext.getDefinition(id, sp) : null;
            }
        }
        if (notify && this.mySignatureBuilder != null) {
            switch (sp) {
                case HAS_DEFINITION: {
                    this.mySignatureBuilder.setDefined(id, answer != null);
                    break;
                }
                case EXACT_DEFINITION: {
                    if (answer == null) break;
                    this.mySignatureBuilder.setDefinition(id, answer);
                    break;
                }
            }
        }
        return answer;
    }

    @Override
    public boolean isProcessed(@Nullable VirtualFile file) {
        return file != null && (this.myProcessedFiles.contains(file) || this.myParentContext != null && this.myParentContext.isProcessed(file));
    }

    @Override
    @NotNull
    public final Set<VirtualFile> getProcessedFiles() {
        THashSet files = new THashSet();
        this.collectProcessedFile((Set<VirtualFile>)files);
        Set<VirtualFile> set = Collections.unmodifiableSet(files);
        if (set == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(49);
        }
        return set;
    }

    private void collectProcessedFile(Set<VirtualFile> result) {
        if (this.myParentContext != null) {
            this.myParentContext.collectProcessedFile(result);
        }
        result.addAll(this.myProcessedFiles);
    }

    @Override
    public void setSignatureBuilder(@Nullable OCInclusionContext.SignatureBuilder signatureBuilder) {
        this.mySignatureBuilder = signatureBuilder;
    }

    @Override
    public void enterNamespace(@NotNull String name2) {
        if (name2 == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(50);
        }
        this.myCurrentNamespace.add(name2);
    }

    @Override
    public void exitNamespace() {
        if (!this.myCurrentNamespace.isEmpty()) {
            this.myCurrentNamespace.remove(this.myCurrentNamespace.size() - 1);
        }
    }

    @Override
    @NotNull
    public List<String> getCurrentNamespace() {
        ArrayList<String> result = new ArrayList<String>(this.myCurrentNamespace.size());
        this.gatherCurrentNamespace(result);
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(51);
        }
        return arrayList;
    }

    private void gatherCurrentNamespace(@NotNull List<String> result) {
        if (result == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(52);
        }
        if (this.myParentContext != null) {
            this.myParentContext.gatherCurrentNamespace(result);
        }
        result.addAll(this.myCurrentNamespace);
    }

    @Override
    @Nullable
    public VirtualFile resolveNextPath(@NotNull OCIncludeSymbol.IncludePath path, @NotNull PsiFile contextFile) {
        if (path == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(53);
        }
        if (contextFile == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(54);
        }
        Ref result = new Ref();
        OCIncludeHelpers.resolveNextIncludedFile(this.getRootAndConfiguration(), OCInclusionContextUtil.getVirtualFile(contextFile), OCInclusionContextUtil.getVirtualFile(contextFile), path, contextFile.getProject(), (Ref<VirtualFile>)result);
        VirtualFile resolved = (VirtualFile)result.get();
        if (this.myResolvePathListener != null) {
            this.myResolvePathListener.resolve(path, true, resolved);
        }
        return resolved;
    }

    @Override
    @Nullable
    public VirtualFile resolvePath(@NotNull OCIncludeSymbol.IncludePath path, @NotNull PsiFile contextFile) {
        if (path == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(55);
        }
        if (contextFile == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(56);
        }
        VirtualFile result = OCIncludeHelpers.resolveIncludedFile(this.getRootAndConfiguration(), OCInclusionContextUtil.getVirtualFile(contextFile), path, contextFile.getProject());
        if (this.myResolvePathListener != null) {
            this.myResolvePathListener.resolve(path, false, result);
        }
        return result;
    }

    @NotNull
    private OCResolveRootAndConfiguration getRootAndConfiguration() {
        OCResolveRootAndConfiguration oCResolveRootAndConfiguration = new OCResolveRootAndConfiguration(this.myConfiguration, this.myLanguageKind, OCInclusionContextUtil.getVirtualFile(this.myRootFile));
        if (oCResolveRootAndConfiguration == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(57);
        }
        return oCResolveRootAndConfiguration;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(58);
        }
        return project2;
    }

    @Override
    @Nullable
    public OCResolveConfiguration getConfiguration() {
        return this.myConfiguration;
    }

    @Override
    public boolean reserveInclude(@NotNull VirtualFile file, boolean once) {
        if (file == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(59);
        }
        if (file.isValid()) {
            String includeId = OCInclusionContextUtil.inclusionId(file);
            if (once && this.isDefined(includeId)) {
                return false;
            }
            String pragmaOnceId = OCInclusionContextUtil.pragmaOnceId(file);
            if (this.isDefined(pragmaOnceId)) {
                return false;
            }
            this.define(OCMacroSymbol.inclusionGuard(includeId, this.myProject));
        }
        return true;
    }

    @Override
    public void preprocessContextOf(@Nullable PsiFile root, @Nullable VirtualFile breakOn) {
        this.preprocessInclude(root, true, breakOn, this.myInclusionLevel);
    }

    @Override
    public void preprocessInclude(@Nullable PsiFile file, boolean once) {
        this.preprocessInclude(file, once, null, this.myInclusionLevel);
    }

    @Override
    public boolean preprocessInclude(@Nullable PsiFile file, boolean once, @Nullable VirtualFile breakOn, int inclusionLevel) {
        if (file == null || inclusionLevel >= OCInclusionContext.getMaxInclusionLevel(null)) {
            return true;
        }
        VirtualFile vFile = OCInclusionContextUtil.getVirtualFile(file);
        if (vFile == null || !this.reserveInclude(vFile, once)) {
            return true;
        }
        this.addProcessedFile(vFile);
        FileSymbolTable table = FileSymbolTable.forFile(file, this);
        if (table != null && file instanceof OCFile) {
            return this.preprocessFile((OCFile)file, vFile, breakOn, inclusionLevel, -1, -1, table.getContents(), null) != null;
        }
        return true;
    }

    @Override
    @Contract(value="_, _, null, _, _, _, _, _ -> !null")
    public OCInclusionContext preprocessFile(@Nullable OCFile file, @Nullable VirtualFile vFile, @Nullable VirtualFile breakOn, int inclusionLevel, int afterOffset, int beforeOffset, @NotNull List<OCSymbol> symbols, @Nullable OCContextChangeSet changeSet) {
        Builder builder;
        if (symbols == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(60);
        }
        class Builder
        implements Processor<OCSymbol> {
            @NotNull
            private OCParsingNameScope myNameScope;
            @Nullable
            private final OCContextChangeBuilder myContextChangeBuilder;
            private boolean wasTruncated;
            final /* synthetic */ int val$afterOffset;
            final /* synthetic */ int val$beforeOffset;
            final /* synthetic */ OCFile val$file;
            final /* synthetic */ VirtualFile val$vFile;
            final /* synthetic */ VirtualFile val$breakOn;
            final /* synthetic */ int val$inclusionLevel;
            final /* synthetic */ OCContextChangeSet val$changeSet;

            public Builder(@Nullable OCParsingNameScope nameScope, OCContextChangeBuilder builder) {
                if (nameScope == null) {
                    Builder.$$$reportNull$$$0(0);
                }
                this.val$afterOffset = n;
                this.val$beforeOffset = n2;
                this.val$file = oCFile;
                this.val$vFile = virtualFile;
                this.val$breakOn = virtualFile2;
                this.val$inclusionLevel = n3;
                this.val$changeSet = oCContextChangeSet;
                this.myNameScope = nameScope;
                this.myContextChangeBuilder = builder;
            }

            public boolean wasTruncated() {
                return this.wasTruncated;
            }

            @NotNull
            public OCParsingNameScope getNameScope() {
                OCParsingNameScope oCParsingNameScope = this.myNameScope;
                if (oCParsingNameScope == null) {
                    Builder.$$$reportNull$$$0(1);
                }
                return oCParsingNameScope;
            }

            public boolean process(OCSymbol symbol) {
                if (OCInclusionContextImpl.this.myProcessingListener != null) {
                    OCInclusionContextImpl.this.myProcessingListener.process((Object)symbol);
                }
                OCContextChangeBuilder changeBuilder = this.myContextChangeBuilder;
                if (symbol instanceof OCModuleImportSymbol) {
                    OCModuleImportSymbol importSymbol = (OCModuleImportSymbol)symbol;
                    Processor processor2 = header -> this.processFileInclude((VirtualFile)header, true, importSymbol.getEndOffset());
                    if (!OCModuleResolver.processModuleImports(OCInclusionContextImpl.this, importSymbol.getNameParts(), (Processor<VirtualFile>)processor2)) {
                        return false;
                    }
                } else if (symbol instanceof OCIncludeSymbol) {
                    OCIncludeSymbol include = (OCIncludeSymbol)symbol;
                    VirtualFile targetFile = include.getTargetFile();
                    include.enterNamespace(OCInclusionContextImpl.this);
                    if (!this.processFileInclude(targetFile, include.isOnce(), include.getEndOffset())) {
                        return false;
                    }
                    include.exitNamespace(OCInclusionContextImpl.this);
                } else if (symbol instanceof OCMacroSymbol) {
                    OCInclusionContextImpl.this.define((OCMacroSymbol)symbol);
                } else if (symbol instanceof OCUndefMacroSymbol) {
                    OCInclusionContextImpl.this.undef(symbol.getName());
                } else {
                    OCSymbolKind kind = symbol.getKind();
                    OCParsingNameScope resultNameScope = this.myNameScope;
                    if (symbol instanceof OCNamespaceSymbol) {
                        OCSymbol lastMember;
                        boolean interrupted;
                        OCParsingNameScope inner;
                        OCNamespaceSymbol namespaceSymbol = (OCNamespaceSymbol)symbol;
                        List<OCSymbol> members = namespaceSymbol.getMembersList();
                        if (changeBuilder != null) {
                            changeBuilder.addSymbol(symbol);
                            changeBuilder = null;
                        }
                        if (this.val$afterOffset != -1 && this.val$afterOffset > symbol.getOffset()) {
                            inner = this.myNameScope;
                        } else {
                            inner = this.myNameScope.defineNamespace(symbol.getName());
                            if (symbol instanceof OCStructSymbol) {
                                for (OCTypeParameterSymbol templateParam : ((OCStructSymbol)symbol).getTemplateParameters()) {
                                    if (templateParam instanceof OCTypeParameterTypeSymbol) {
                                        inner.defineType(templateParam.getName(), true);
                                        continue;
                                    }
                                    if (!(templateParam instanceof OCTypeParameterValueSymbol)) continue;
                                    inner.defineValue(templateParam.getName(), false);
                                }
                            }
                        }
                        OCInclusionContextImpl.this.enterNamespace(namespaceSymbol.getName());
                        Builder innerProcessor = new Builder(inner, null);
                        boolean bl = interrupted = !namespaceSymbol.processMembersAndUsings(innerProcessor, this.val$afterOffset, this.val$beforeOffset);
                        if (!interrupted) {
                            OCInclusionContextImpl.this.exitNamespace();
                        }
                        OCSymbol oCSymbol = lastMember = members != null ? (OCSymbol)ContainerUtil.getLastItem(members) : null;
                        if (this.val$beforeOffset != -1 && lastMember != null && this.val$beforeOffset <= lastMember.getOffset() || innerProcessor.wasTruncated()) {
                            this.wasTruncated = true;
                            resultNameScope = innerProcessor.getNameScope();
                        } else {
                            OCParsingNameScope scope = innerProcessor.getNameScope();
                            resultNameScope = scope.getParent();
                            if (resultNameScope == null) {
                                OCLog.LOG.error("no parent scope found for '" + symbol.getName() + "' (current scope is '" + scope + "')");
                            }
                        }
                    }
                    if (symbol instanceof OCUsingSymbol) {
                        if (changeBuilder != null) {
                            changeBuilder.addSymbol(symbol);
                        }
                        if (symbol.getKind() == OCSymbolKind.NAMESPACE_USING_SYMBOL) {
                            this.myNameScope.defineNamespaceUsing(((OCUsingSymbol)symbol).getSymbolReference().getQualifiedName().flatten());
                        } else {
                            this.myNameScope.defineSymbolUsing(((OCUsingSymbol)symbol).getSymbolReference().getQualifiedName().flatten());
                        }
                    } else if (kind.isType()) {
                        if (changeBuilder != null) {
                            changeBuilder.addSymbol(symbol);
                        }
                        if (kind.isClass()) {
                            if (kind == OCSymbolKind.PROTOCOL) {
                                this.myNameScope.defineProtocol(symbol.getName());
                            } else {
                                this.myNameScope.defineInterface(symbol.getName());
                            }
                            if (symbol instanceof OCClassSymbol) {
                                ((OCClassSymbol)symbol).processMembers((String)null, new OCCommonProcessors.SelfAdapterProcessor(this));
                            }
                        } else if (kind.isClassOrTypedef() || OCInclusionContextImpl.this.myLanguageKind.isCpp()) {
                            boolean isTemplate = symbol instanceof OCTemplateSymbol && ((OCTemplateSymbol)symbol).isTemplateSymbol();
                            boolean isFriendClass = symbol instanceof OCStructSymbol && ((OCStructSymbol)symbol).isFriend();
                            this.myNameScope.defineType(symbol.getName(), isTemplate, isFriendClass, -1);
                        }
                        if (kind == OCSymbolKind.ENUM && symbol instanceof OCStructSymbol) {
                            ((OCStructSymbol)symbol).processFields((Processor<OCDeclaratorSymbol>)((Processor)symbol1 -> {
                                this.myNameScope.defineValue(symbol1.getName(), false);
                                return true;
                            }));
                        }
                    } else if (symbol instanceof OCInstanceVariableSymbol) {
                        this.myNameScope.defineValue(symbol.getName(), false);
                    } else if (symbol instanceof OCFunctionSymbol && !symbol.getKind().isConstructorOrDestructor() && ((OCFunctionSymbol)symbol).getQualifiedName().getQualifier() == null) {
                        if (changeBuilder != null) {
                            changeBuilder.addSymbol(symbol);
                        }
                        this.myNameScope.defineValue(symbol.getName(), ((OCFunctionSymbol)symbol).isTemplateSymbol());
                    } else if (symbol instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)symbol).getQualifiedName().getQualifier() == null) {
                        if (changeBuilder != null) {
                            changeBuilder.addSymbol(symbol);
                        }
                        this.myNameScope.defineValue(symbol.getName(), ((OCDeclaratorSymbol)symbol).isTemplateSymbol());
                    } else if (symbol instanceof OCNamespaceAliasSymbol) {
                        OCSymbolReference namespace;
                        if (changeBuilder != null) {
                            changeBuilder.addSymbol(symbol);
                        }
                        if ((namespace = ((OCNamespaceAliasSymbol)symbol).getNamespaceReference()) != null && namespace.getQualifiedName().getName() != null) {
                            this.myNameScope.defineNamespaceAlias(symbol.getName(), namespace.getQualifiedName().flatten());
                        }
                    }
                    this.myNameScope = resultNameScope;
                }
                return true;
            }

            protected boolean processFileInclude(@Nullable VirtualFile targetFile, boolean once, int endOffset) {
                PsiFile psiFile;
                assert (this.val$file != null);
                assert (this.val$vFile != null);
                PsiFile psiFile2 = psiFile = targetFile == null || !targetFile.isValid() ? null : this.val$file.getManager().findFile(targetFile);
                if (psiFile instanceof OCFile) {
                    if (targetFile.equals(this.val$breakOn)) {
                        return false;
                    }
                    if (!OCInclusionContextImpl.this.preprocessInclude(psiFile, once, this.val$breakOn, this.val$inclusionLevel + 1, endOffset, this.val$changeSet)) {
                        return false;
                    }
                    OCImportGraph.addHeaderIncluder(psiFile.getProject(), targetFile, this.val$vFile);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "nameScope";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextImpl$1Builder";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextImpl$1Builder";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNameScope";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
        if (OCResolveUtil.processSymbolsFromList(builder = new Builder(this.myNameScope, this.myChangeBuilder), symbols, afterOffset, beforeOffset)) {
            this.myNameScope = builder.getNameScope();
            return this;
        }
        return null;
    }

    @Override
    public boolean preprocessInclude(@NotNull PsiFile file, boolean once, @Nullable VirtualFile breakOn, int includeLevel, int offsetAfterInclude, @Nullable OCContextChangeSet changeSet) {
        boolean result;
        if (file == null) {
            OCInclusionContextImpl.$$$reportNull$$$0(61);
        }
        OCContextChangeBuilderImpl builder = null;
        OCContextChange change = null;
        if (changeSet != null && (change = changeSet.getChange(offsetAfterInclude)) == null) {
            builder = new OCContextChangeBuilderImpl(offsetAfterInclude);
            this.setChangeBuilder(builder);
        }
        if (change == null) {
            result = this.preprocessInclude(file, once, breakOn, includeLevel);
        } else {
            change.apply(file.getProject(), this);
            result = true;
        }
        if (builder != null && !this.isProcessed(OCInclusionContextUtil.getVirtualFile(this.myRootFile))) {
            changeSet.setChange(offsetAfterInclude, builder);
            this.setChangeBuilder(null);
        }
        return result;
    }

    public DeepEqual.Equality<OCInclusionContextImpl> equality() {
        return new DeepEqual.Equality<OCInclusionContextImpl>(){

            @Override
            public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull OCInclusionContextImpl first, @NotNull OCInclusionContextImpl second) {
                if (c == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (first == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (second == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (first.myLanguageKind != second.myLanguageKind) {
                    return false;
                }
                if (first.myInclusionLevel != second.myInclusionLevel) {
                    return false;
                }
                if (!Comparing.equal((Object)first.myRootFile, (Object)second.myRootFile)) {
                    return false;
                }
                if (first.myNotifyLocalDefinitions != second.myNotifyLocalDefinitions) {
                    return false;
                }
                if (first.myConfiguration != second.myConfiguration) {
                    return false;
                }
                if (!first.myUndefList.equals(second.myUndefList)) {
                    return false;
                }
                if (!first.myProcessedFiles.equals(second.myProcessedFiles)) {
                    return false;
                }
                if (!Comparing.equal((Object)first.mySignatureBuilder, (Object)second.mySignatureBuilder)) {
                    return false;
                }
                if (!c.equalObjects(first.myParentContext, second.myParentContext)) {
                    return false;
                }
                if (!c.equalMaps((Map)first.mySubstitutions, (Map)second.mySubstitutions)) {
                    return false;
                }
                return c.equalObjects(first.myNameScope, second.myNameScope);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "c";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "first";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "second";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextImpl$1";
                objectArray[2] = "deepEqualStep";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 14: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 32: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 41: 
            case 43: 
            case 44: 
            case 49: 
            case 51: 
            case 57: 
            case 58: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 14: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 32: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 41: 
            case 43: 
            case 44: 
            case 49: 
            case 51: 
            case 57: 
            case 58: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 14: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 32: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 41: 
            case 43: 
            case 44: 
            case 49: 
            case 51: 
            case 57: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextImpl";
                break;
            }
            case 3: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 4: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 5: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 9: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageKind";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentContext";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootFile";
                break;
            }
            case 13: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameScope";
                break;
            }
            case 15: 
            case 17: 
            case 21: 
            case 40: 
            case 59: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 16: 
            case 30: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "precompiledHeader";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "header";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "feature";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "def";
                break;
            }
            case 46: 
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sp";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 53: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 54: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbols";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPCHCache";
                break;
            }
            case 6: 
            case 7: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrecompiledHeaders";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageKind";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyWithBuiltinMacros";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "initialContextWithoutRoot";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootFile";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameScope";
                break;
            }
            case 39: 
            case 41: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "derive";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "deriveButDontCopyTypes";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessedFiles";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentNamespace";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootAndConfiguration";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPCHCache";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 14: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 32: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 41: 
            case 43: 
            case 44: 
            case 49: 
            case 51: 
            case 57: 
            case 58: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPrecompiledHeaders";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addProcessedFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkConformanceAndFillSignatures";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "emptyWithBuiltinMacros";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "initialContextWithoutRoot";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "initContext";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitutions";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "conformsToByIncludes";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "setPrecompiledHeaders";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findInCachedPCHPrecompiledContexts";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getCompilerFeature";
                break;
            }
            case 40: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "derive";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "define";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "hideDefinition";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "revealDefinition";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getDefinition";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "enterNamespace";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "gatherCurrentNamespace";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "resolveNextPath";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "resolvePath";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "reserveInclude";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "preprocessFile";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "preprocessInclude";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "lambda$conformsToByIncludes$4";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getPCHCache$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 14: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 32: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 41: 
            case 43: 
            case 44: 
            case 49: 
            case 51: 
            case 57: 
            case 58: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class PCHCache {
        private final MultiMap<VirtualFile, OCResolveConfiguration> pch2configs;

        public PCHCache(@NotNull Project project2) {
            if (project2 == null) {
                PCHCache.$$$reportNull$$$0(0);
            }
            this.pch2configs = new MultiMap<VirtualFile, OCResolveConfiguration>(){

                @NotNull
                protected Collection<OCResolveConfiguration> createCollection() {
                    LinkedHashSet linkedHashSet = ContainerUtil.newLinkedHashSet();
                    if (linkedHashSet == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return linkedHashSet;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextImpl$PCHCache$1", "createCollection"));
                }
            };
            OCWorkspace workspace = OCWorkspace.getInstance(project2);
            for (OCResolveConfiguration config : workspace.getConfigurations()) {
                for (VirtualFile pch : config.getPrecompiledHeaders()) {
                    this.pch2configs.putValue((Object)pch, (Object)config);
                }
            }
        }

        public Collection<OCResolveConfiguration> getConfigurations(@NotNull VirtualFile pch) {
            if (pch == null) {
                PCHCache.$$$reportNull$$$0(1);
            }
            return Collections.unmodifiableCollection(this.pch2configs.get((Object)pch));
        }

        public boolean isPCH(@NotNull VirtualFile file) {
            if (file == null) {
                PCHCache.$$$reportNull$$$0(2);
            }
            return this.pch2configs.containsKey((Object)file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pch";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextImpl$PCHCache";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getConfigurations";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isPCH";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

