/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.FileContentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IndexingDataKeys;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.preprocessor.OCContextChangeSet;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextImpl;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextListener;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.psi.OCConfigurationOwner;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCParsedLanguageAndConfiguration;
import com.jetbrains.cidr.lang.psi.impl.OCFileImpl;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.SymbolTableProvider;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationTrackers;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceRunConfigurationListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCInclusionContextUtil {
    private static final Key<OCResolveConfiguration> PROJECT_USER_SELECTED_CONFIGURATION = Key.create((String)"PROJECT_USER_SELECTED_CONFIGURATION");
    private static final NotNullLazyKey<CachedValue<OCResolveConfiguration>, PsiFile> FILE_ACTIVE_CONFIGURATION_CACHE = NotNullLazyKey.create((String)"FILE_ACTIVE_CONFIGURATION_CACHE", file -> {
        final Project project2 = file.getProject();
        return CachedValuesManager.getManager((Project)project2).createCachedValue((CachedValueProvider)new CachedValueProvider<OCResolveConfiguration>(){

            public CachedValueProvider.Result<OCResolveConfiguration> compute() {
                if (project2.isDefault()) {
                    return new CachedValueProvider.Result(null, new Object[]{ModificationTracker.NEVER_CHANGED});
                }
                OCWorkspaceModificationTrackers tracker = OCWorkspaceModificationTrackers.getInstance(project2);
                return new CachedValueProvider.Result((Object)this.inferConfiguration(), new Object[]{FileSymbolTablesCache.getInstance(project2).getOutOfBlockModificationTracker(), tracker.getProjectsListTracker(), tracker.getProjectFilesListTracker(), tracker.getSourceFilesListTracker(), tracker.getSelectedResolveConfigurationTracker()});
            }

            private OCResolveConfiguration inferConfiguration() {
                VirtualFile virtualFile;
                if (SymbolTableProvider.isSourceFile(file) && (virtualFile = OCInclusionContextUtil.getVirtualFile(file.getOriginalFile())) != null) {
                    return OCInclusionContextUtil.getResolveRootAndActiveConfiguration(virtualFile, file.getProject()).getConfiguration();
                }
                return null;
            }
        }, false);
    });
    public static final NotNullLazyKey<Map<VirtualFile, OCResolveRootAndConfiguration>, Project> HEADER_ROOT_AND_CONFIGURATION_KEY = NotNullLazyKey.create((String)"HEADER_ROOT_AND_CONFIGURATION_KEY", p -> new ConcurrentHashMap());
    private static final NotNullLazyKey<Map<VirtualFile, OCImmutableInclusionContext>, Project> HEADER_CONTEXT_KEY = NotNullLazyKey.create((String)"HEADER_CONTEXT_KEY", p -> ContainerUtil.createConcurrentSoftValueMap());
    private static final NotNullLazyKey<Map<VirtualFile, OCContextChangeSet>, Project> CONTEXT_CHANGES_KEY = NotNullLazyKey.create((String)"CONTEXT_CHANGES_KEY", p -> ContainerUtil.createConcurrentSoftValueMap());

    @Deprecated
    @Nullable
    public static OCResolveConfiguration computePreselectedConfiguration(@NotNull Project project2, @NotNull Collection<OCResolveConfiguration> configs2) {
        if (project2 == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(0);
        }
        if (configs2 == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(1);
        }
        return (OCResolveConfiguration)OCInclusionContextUtil.findPreselectedOrSuitableConfiguration((Project)project2, configs2).first;
    }

    @Nullable
    private static OCResolveConfiguration findPreselectedConfiguration(@NotNull Project project2, @NotNull Collection<OCResolveConfiguration> configs2) {
        OCResolveConfiguration selectedConfiguration;
        if (project2 == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(2);
        }
        if (configs2 == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(3);
        }
        if (configs2.contains(selectedConfiguration = OCInclusionContextUtil.getUserSelectedConfiguration(project2))) {
            return selectedConfiguration;
        }
        selectedConfiguration = OCWorkspaceRunConfigurationListener.getSelectedResolveConfiguration(project2);
        if (configs2.contains(selectedConfiguration)) {
            return selectedConfiguration;
        }
        return null;
    }

    @NotNull
    private static Pair<OCResolveConfiguration, Boolean> findPreselectedOrSuitableConfiguration(@NotNull Project project2, @NotNull Collection<OCResolveConfiguration> configs2) {
        OCResolveConfiguration selectedConfiguration;
        if (project2 == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(4);
        }
        if (configs2 == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(5);
        }
        if ((selectedConfiguration = OCInclusionContextUtil.findPreselectedConfiguration(project2, configs2)) != null) {
            Pair pair2 = Pair.create((Object)selectedConfiguration, (Object)true);
            if (pair2 == null) {
                OCInclusionContextUtil.$$$reportNull$$$0(6);
            }
            return pair2;
        }
        Pair pair3 = Pair.create((Object)(configs2.isEmpty() ? null : Collections.min(configs2)), (Object)false);
        if (pair3 == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(7);
        }
        return pair3;
    }

    @Nullable
    @Contract(value="null -> null")
    public static VirtualFile getVirtualFile(@Nullable PsiFile file) {
        if (file == null) {
            return null;
        }
        VirtualFile vFile = file.getOriginalFile().getVirtualFile();
        return vFile != null ? vFile : (VirtualFile)file.getUserData(IndexingDataKeys.VIRTUAL_FILE);
    }

    public static boolean isRoot(@NotNull PsiFile file) {
        VirtualFile virtualFile;
        if (file == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(8);
        }
        if ((virtualFile = OCInclusionContextUtil.getVirtualFile(file)) == null) {
            return false;
        }
        if (OCFileImpl.isSourceCodeFile(file.getName())) {
            return !OCWorkspace.getInstance(file.getProject()).getConfigurationsForFile(virtualFile).isEmpty();
        }
        return false;
    }

    public static boolean isNeedToFindRoot(@NotNull PsiFile file) {
        VirtualFile virtualFile;
        if (file == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(9);
        }
        if ((virtualFile = OCInclusionContextUtil.getVirtualFile(file)) == null) {
            return false;
        }
        return OCInclusionContextUtil.isNeedToFindRoot(virtualFile, file.getProject());
    }

    public static boolean isNeedToFindRoot(@NotNull VirtualFile file, @NotNull Project project2) {
        if (file == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(10);
        }
        if (project2 == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(11);
        }
        if (OCFileImpl.isSourceCodeFile(file.getName())) {
            return OCWorkspace.getInstance(project2).getConfigurationsForFile(file).isEmpty();
        }
        return !OCInclusionContext.isPrecompiledHeader(file, project2);
    }

    @NotNull
    public static OCResolveRootAndConfiguration getResolveRootAndActiveConfiguration(@NotNull VirtualFile virtualFile, @NotNull Project project2) {
        Map cache;
        OCResolveRootAndConfiguration cached;
        if (virtualFile == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(12);
        }
        if (project2 == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(13);
        }
        if ((cached = (OCResolveRootAndConfiguration)(cache = (Map)HEADER_ROOT_AND_CONFIGURATION_KEY.getValue((UserDataHolder)project2)).get(virtualFile)) != null) {
            OCResolveRootAndConfiguration oCResolveRootAndConfiguration = cached;
            if (oCResolveRootAndConfiguration == null) {
                OCInclusionContextUtil.$$$reportNull$$$0(14);
            }
            return oCResolveRootAndConfiguration;
        }
        OCResolveRootAndConfiguration result = null;
        if (OCInclusionContextUtil.isNeedToFindRoot(virtualFile, project2)) {
            result = OCInclusionContextUtil.getResolveRootAndActiveConfigurationForHeader(virtualFile, project2);
        }
        if (result == null) {
            result = OCInclusionContextUtil.createResolveRootAndConfiguration(project2, OCInclusionContextUtil.doGetPreselectedConfiguration(virtualFile, project2), virtualFile);
        }
        cache.put(virtualFile, result);
        ((OCInclusionContextListener)project2.getMessageBus().syncPublisher(OCInclusionContextListener.TOPIC)).resolveRootAndActiveConfigurationChanged(virtualFile, result);
        OCResolveRootAndConfiguration oCResolveRootAndConfiguration = result;
        if (oCResolveRootAndConfiguration == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(15);
        }
        return oCResolveRootAndConfiguration;
    }

    @NotNull
    public static OCParsedLanguageAndConfiguration getOrCalculateParsedLanguageAndConfiguration(@NotNull PsiFile file) {
        OCParsedLanguageAndConfiguration langAndConfig;
        if (file == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(16);
        }
        OCParsedLanguageAndConfiguration oCParsedLanguageAndConfiguration = langAndConfig = file instanceof OCConfigurationOwner ? ((OCConfigurationOwner)file).getParsedLanguageAndConfiguration() : null;
        if (langAndConfig != null) {
            OCParsedLanguageAndConfiguration oCParsedLanguageAndConfiguration2 = langAndConfig;
            if (oCParsedLanguageAndConfiguration2 == null) {
                OCInclusionContextUtil.$$$reportNull$$$0(17);
            }
            return oCParsedLanguageAndConfiguration2;
        }
        OCImmutableInclusionContext context = OCInclusionContextUtil.headerContext(file);
        OCParsedLanguageAndConfiguration oCParsedLanguageAndConfiguration3 = new OCParsedLanguageAndConfiguration(context.getConfiguration(), context.getLanguageKind());
        if (oCParsedLanguageAndConfiguration3 == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(18);
        }
        return oCParsedLanguageAndConfiguration3;
    }

    @Nullable
    private static OCResolveRootAndConfiguration getResolveRootAndActiveConfigurationForHeader(@NotNull VirtualFile virtualHeaderFile, @NotNull Project project2) {
        Pair<OCResolveConfiguration, Boolean> c;
        if (virtualHeaderFile == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(19);
        }
        if (project2 == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(20);
        }
        String headerNameWithoutExtension = virtualHeaderFile.getNameWithoutExtension();
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>(OCImportGraph.getAllHeaderRoots(project2, virtualHeaderFile));
        Collections.sort(roots, new VirtualFileComparator(project2, headerNameWithoutExtension));
        ArrayList<VirtualFile> rootsThatMayMatchSelectedConfiguration = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : roots) {
            Collection<OCResolveConfiguration> collection = OCInclusionContextUtil.getAllBuildConfigurationsOfTargetsOfFile(virtualFile, project2);
            if (OCInclusionContextUtil.findPreselectedConfiguration(project2, collection) == null) continue;
            rootsThatMayMatchSelectedConfiguration.add(virtualFile);
        }
        OCResolveRootAndConfiguration fallBack = null;
        for (VirtualFile virtualFile : rootsThatMayMatchSelectedConfiguration) {
            HashSet<OCResolveConfiguration> configurations = new HashSet<OCResolveConfiguration>();
            OCImportGraph.fillHeaderConfigurationsForRoot(project2, virtualHeaderFile, virtualFile, configurations, null);
            if (configurations.isEmpty()) continue;
            OCResolveConfiguration configuration = OCInclusionContextUtil.findPreselectedConfiguration(project2, configurations);
            if (configuration != null) {
                return OCInclusionContextUtil.createResolveRootAndConfiguration(project2, configuration, virtualFile);
            }
            if (fallBack != null) continue;
            c = OCInclusionContextUtil.findPreselectedOrSuitableConfiguration(project2, configurations);
            if (c.first == null) continue;
            fallBack = OCInclusionContextUtil.createResolveRootAndConfiguration(project2, (OCResolveConfiguration)c.first, virtualFile);
        }
        HashSet hashSet = new HashSet(rootsThatMayMatchSelectedConfiguration);
        for (VirtualFile rootFile : roots) {
            if (hashSet.contains(rootFile)) {
                if (fallBack == null || !rootFile.equals(fallBack.getRootFile())) continue;
                return fallBack;
            }
            HashSet<OCResolveConfiguration> configurations = new HashSet<OCResolveConfiguration>();
            OCImportGraph.fillHeaderConfigurationsForRoot(project2, virtualHeaderFile, rootFile, configurations, null);
            c = OCInclusionContextUtil.findPreselectedOrSuitableConfiguration(project2, configurations);
            if (c.first == null) continue;
            return OCInclusionContextUtil.createResolveRootAndConfiguration(project2, (OCResolveConfiguration)c.first, rootFile);
        }
        return null;
    }

    @NotNull
    private static OCResolveRootAndConfiguration createResolveRootAndConfiguration(@NotNull Project project2, @Nullable OCResolveConfiguration configuration, @NotNull VirtualFile rootFile) {
        if (project2 == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(21);
        }
        if (rootFile == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(22);
        }
        OCLanguageKind kind = OCLanguageKindCalculator.calculateLanguageKind(configuration, rootFile, project2, false);
        OCResolveRootAndConfiguration oCResolveRootAndConfiguration = new OCResolveRootAndConfiguration(configuration, kind, rootFile);
        if (oCResolveRootAndConfiguration == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(23);
        }
        return oCResolveRootAndConfiguration;
    }

    @Nullable
    private static OCResolveConfiguration doGetPreselectedConfiguration(@NotNull VirtualFile virtualFile, @NotNull Project project2) {
        if (virtualFile == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(24);
        }
        if (project2 == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(25);
        }
        return (OCResolveConfiguration)OCInclusionContextUtil.findPreselectedOrSuitableConfiguration((Project)project2, OCInclusionContextUtil.getAllBuildConfigurationsForIndexing((VirtualFile)virtualFile, (Project)project2)).first;
    }

    public static void invalidateHeaderRootAndActiveConfigurationForAllExcept(@Nullable VirtualFile virtualFile, @NotNull Project project2) {
        if (project2 == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(26);
        }
        OCInclusionContextUtil.removeExcept((Map)HEADER_ROOT_AND_CONFIGURATION_KEY.getValue((UserDataHolder)project2), virtualFile);
        OCInclusionContextUtil.invalidateHeaderContextsExcept(virtualFile, project2);
    }

    public static void invalidateHeaderContextsExcept(@Nullable VirtualFile virtualFile, @NotNull Project project2) {
        if (project2 == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(27);
        }
        OCInclusionContextUtil.removeExcept((Map)HEADER_CONTEXT_KEY.getValue((UserDataHolder)project2), virtualFile);
        OCInclusionContextUtil.invalidateContextChangeCacheExcept(virtualFile, project2);
    }

    public static void invalidateContextChangeCacheExcept(@Nullable VirtualFile virtualFile, @NotNull Project project2) {
        if (project2 == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(28);
        }
        OCInclusionContextUtil.removeExcept((Map)CONTEXT_CHANGES_KEY.getValue((UserDataHolder)project2), virtualFile);
    }

    public static <K, V> void removeExcept(@NotNull Map<K, V> map2, @Nullable K key) {
        if (map2 == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(29);
        }
        if (key == null) {
            map2.clear();
        } else {
            map2.keySet().retainAll(Collections.singleton(key));
        }
    }

    public static void invalidateHeaderRootAndActiveConfigurationFor(@Nullable VirtualFile virtualFileInEditor, @NotNull Project project2) {
        if (project2 == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(30);
        }
        if (virtualFileInEditor == null) {
            return;
        }
        Map cached = (Map)HEADER_ROOT_AND_CONFIGURATION_KEY.getValue((UserDataHolder)project2);
        cached.remove(virtualFileInEditor);
        OCInclusionContextUtil.invalidateHeaderContextsExcept(null, project2);
    }

    @NotNull
    public static OCImmutableInclusionContext headerContext(@NotNull PsiFile file) {
        OCImmutableInclusionContext cached;
        PsiFile original;
        if (file == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(31);
        }
        if ((original = OCInclusionContextUtil.getOriginalFile(file)) == null) {
            OCInclusionContext oCInclusionContext = OCInclusionContextImpl.emptyWithBuiltinMacros(null, file);
            if (oCInclusionContext == null) {
                OCInclusionContextUtil.$$$reportNull$$$0(32);
            }
            return oCInclusionContext;
        }
        Project project2 = original.getProject();
        VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(original);
        Map cache = null;
        if (virtualFile != null && (cached = (OCImmutableInclusionContext)(cache = (Map)HEADER_CONTEXT_KEY.getValue((UserDataHolder)project2)).get(virtualFile)) != null) {
            OCImmutableInclusionContext oCImmutableInclusionContext = cached;
            if (oCImmutableInclusionContext == null) {
                OCInclusionContextUtil.$$$reportNull$$$0(33);
            }
            return oCImmutableInclusionContext;
        }
        OCInclusionContext result = OCInclusionContextUtil.innerCalculateHeaderContext(original, null);
        if (virtualFile != null) {
            cache.put(virtualFile, result);
        }
        OCInclusionContext oCInclusionContext = result;
        if (oCInclusionContext == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(34);
        }
        return oCInclusionContext;
    }

    public static OCInclusionContext calculateHeaderContext(@NotNull PsiFile file, @Nullable OCLanguageKind languageKind) {
        PsiFile original;
        if (file == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(35);
        }
        if ((original = OCInclusionContextUtil.getOriginalFile(file)) == null) {
            return OCInclusionContextImpl.emptyWithBuiltinMacros(languageKind, file);
        }
        return OCInclusionContextUtil.innerCalculateHeaderContext(original, languageKind);
    }

    @Nullable
    public static PsiFile getOriginalFile(@Nullable PsiFile file) {
        PsiFile psiFile;
        PsiFile physical;
        if (file == null) {
            return null;
        }
        PsiFile original = file.getOriginalFile();
        if (!(original instanceof OCFile)) {
            return null;
        }
        if (original.isPhysical()) {
            return file;
        }
        for (physical = original; physical != null && !physical.isPhysical(); physical = physical.getContext()) {
        }
        PsiFile psiFile2 = psiFile = physical != null ? physical.getContainingFile() : null;
        if (psiFile != null) {
            return psiFile;
        }
        return null;
    }

    @NotNull
    private static OCInclusionContext innerCalculateHeaderContext(@NotNull PsiFile original, @Nullable OCLanguageKind kind) {
        OCResolveConfiguration config;
        OCResolveRootAndConfiguration rootAndConfiguration;
        VirtualFile rootFile;
        OCFile importHolder;
        if (original == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(36);
        }
        Project project2 = original.getProject();
        VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(original);
        if (virtualFile != null && OCInclusionContextUtil.isNeedToFindRoot(virtualFile, project2) && (importHolder = (OCFile)ObjectUtils.tryCast((rootFile = (rootAndConfiguration = OCInclusionContextUtil.getResolveRootAndActiveConfiguration(virtualFile, project2)).getRootFile()) != null && rootFile.isValid() ? PsiManager.getInstance((Project)project2).findFile(rootFile) : null, OCFile.class)) != null && !rootFile.equals(virtualFile) && (config = rootAndConfiguration.getConfiguration()) != null) {
            OCImmutableInclusionContext precompiledContext = OCInclusionContext.tryFindInCachedPCHPrecompiledContexts(config, virtualFile, rootFile);
            if (precompiledContext == null) {
                precompiledContext = OCInclusionContext.initialPCHContextWithoutRoot(config, importHolder.getKind(), importHolder);
            } else {
                precompiledContext = precompiledContext.getParent();
                assert (precompiledContext != null && precompiledContext.getParent() == null);
            }
            OCInclusionContext result = precompiledContext.derive(importHolder);
            result.preprocessContextOf(importHolder, virtualFile);
            OCInclusionContext oCInclusionContext = result;
            if (oCInclusionContext == null) {
                OCInclusionContextUtil.$$$reportNull$$$0(37);
            }
            return oCInclusionContext;
        }
        OCInclusionContext oCInclusionContext = OCInclusionContextUtil.sourceFileContext((OCFile)original, kind);
        if (oCInclusionContext == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(38);
        }
        return oCInclusionContext;
    }

    @NotNull
    private static OCInclusionContext sourceFileContext(@NotNull OCFile file, @Nullable OCLanguageKind kindOrNullForDefault) {
        OCResolveConfiguration config;
        VirtualFile virtualFile;
        if (file == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(39);
        }
        if (kindOrNullForDefault == null) {
            kindOrNullForDefault = file.getKind();
        }
        if ((virtualFile = OCInclusionContextUtil.getVirtualFile(file)) != null && (config = OCInclusionContextUtil.doGetPreselectedConfiguration(virtualFile, file.getProject())) != null) {
            OCInclusionContext oCInclusionContext = OCInclusionContext.sourceParsingContext(config, kindOrNullForDefault, file);
            if (oCInclusionContext == null) {
                OCInclusionContextUtil.$$$reportNull$$$0(40);
            }
            return oCInclusionContext;
        }
        OCInclusionContext oCInclusionContext = OCInclusionContextImpl.emptyWithBuiltinMacros(kindOrNullForDefault, file);
        if (oCInclusionContext == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(41);
        }
        return oCInclusionContext;
    }

    public static void setUserSelectedConfiguration(@NotNull PsiFile psiFile, @Nullable OCResolveConfiguration config) {
        if (psiFile == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(42);
        }
        Project project2 = psiFile.getProject();
        project2.putUserData(PROJECT_USER_SELECTED_CONFIGURATION, (Object)config);
        psiFile.putCopyableUserData(FILE_ACTIVE_CONFIGURATION_CACHE, null);
        OCInclusionContextUtil.invalidateHeaderRootAndActiveConfigurationFor(OCInclusionContextUtil.getVirtualFile(psiFile), project2);
        VirtualFile file = psiFile.getVirtualFile();
        if (file != null) {
            FileContentUtil.reparseFiles((Project)project2, Collections.singletonList(file), (boolean)false);
        }
    }

    @Nullable
    private static OCResolveConfiguration getUserSelectedConfiguration(@NotNull Project project2) {
        if (project2 == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(43);
        }
        return (OCResolveConfiguration)project2.getUserData(PROJECT_USER_SELECTED_CONFIGURATION);
    }

    @Nullable
    public static OCResolveConfiguration getActiveConfiguration(@Nullable PsiElement element) {
        return element == null ? null : (OCResolveConfiguration)((CachedValue)FILE_ACTIVE_CONFIGURATION_CACHE.getValue((UserDataHolder)element.getContainingFile())).getValue();
    }

    @Nullable
    public static OCResolveConfiguration getActiveConfiguration(@Nullable VirtualFile file, @NotNull Project project2) {
        if (project2 == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(44);
        }
        return OCInclusionContextUtil.getActiveConfiguration(file == null ? null : PsiManager.getInstance((Project)project2).findFile(file));
    }

    @NotNull
    public static Collection<OCResolveConfiguration> getAllBuildConfigurationsForFile(@NotNull PsiFile file, @Nullable ProgressIndicator progress) {
        VirtualFile root;
        if (file == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(45);
        }
        if ((root = OCInclusionContextUtil.getVirtualFile(file)) != null && file instanceof OCFile && OCInclusionContextUtil.isNeedToFindRoot(file)) {
            Set<OCResolveConfiguration> set = OCImportGraph.getAllHeaderConfigurations((OCFile)file, progress);
            if (set == null) {
                OCInclusionContextUtil.$$$reportNull$$$0(46);
            }
            return set;
        }
        Collection<OCResolveConfiguration> collection = OCInclusionContextUtil.getAllBuildConfigurationsOfTargetsOfFile(root, file.getProject());
        if (collection == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(47);
        }
        return collection;
    }

    @NotNull
    public static Collection<OCResolveConfiguration> getAllBuildConfigurationsOfTargetsOfFile(@Nullable VirtualFile virtualFile, @NotNull Project project2) {
        Collection<OCResolveConfiguration> configOfPch;
        if (project2 == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(48);
        }
        if (!(configOfPch = OCInclusionContext.getBuildConfigurationByPchFile(virtualFile, project2)).isEmpty()) {
            Collection<OCResolveConfiguration> collection = configOfPch;
            if (collection == null) {
                OCInclusionContextUtil.$$$reportNull$$$0(49);
            }
            return collection;
        }
        List<OCResolveConfiguration> list = OCWorkspace.getInstance(project2).getConfigurationsForFile(virtualFile);
        if (list == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(50);
        }
        return list;
    }

    @NotNull
    public static Collection<OCResolveConfiguration> getAllBuildConfigurationsForIndexing(@Nullable VirtualFile virtualFile, @NotNull Project project2) {
        Collection<OCResolveConfiguration> result;
        if (project2 == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(51);
        }
        if (!(result = OCInclusionContextUtil.getAllBuildConfigurationsOfTargetsOfFile(virtualFile, project2)).isEmpty()) {
            Collection<OCResolveConfiguration> collection = result;
            if (collection == null) {
                OCInclusionContextUtil.$$$reportNull$$$0(52);
            }
            return collection;
        }
        OCResolveConfiguration preselected = (OCResolveConfiguration)OCInclusionContextUtil.findPreselectedOrSuitableConfiguration((Project)project2, OCWorkspace.getInstance((Project)project2).getConfigurations()).first;
        List list = ContainerUtil.createMaybeSingletonList((Object)preselected);
        if (list == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(53);
        }
        return list;
    }

    public static String pragmaOnceId(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(54);
        }
        return OCInclusionContextUtil.fileGuard(vFile, "__CIDR_pragma_once");
    }

    public static String inclusionId(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(55);
        }
        return OCInclusionContextUtil.fileGuard(vFile, "__CIDR_included");
    }

    private static String fileGuard(VirtualFile vFile, String prefix) {
        if (vFile instanceof VirtualFileWithId) {
            return prefix + "_id_" + ((VirtualFileWithId)vFile).getId();
        }
        return prefix + "_path_" + vFile.getPath();
    }

    public static void storeCachedContextChangeSet(@NotNull Project project2, @NotNull VirtualFile virtualFile, @NotNull OCContextChangeSet changeSet) {
        if (project2 == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(56);
        }
        if (virtualFile == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(57);
        }
        if (changeSet == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(58);
        }
        ((Map)CONTEXT_CHANGES_KEY.get((UserDataHolder)project2)).put(virtualFile, changeSet);
    }

    public static OCContextChangeSet cachedContextChangeSet(@NotNull Project project2, @Nullable VirtualFile virtualFile) {
        if (project2 == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(59);
        }
        if (virtualFile == null) {
            return null;
        }
        return (OCContextChangeSet)((Map)CONTEXT_CHANGES_KEY.getValue((UserDataHolder)project2)).get(virtualFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 23: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 52: 
            case 53: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 23: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 52: 
            case 53: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configs";
                break;
            }
            case 6: 
            case 7: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 23: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 52: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 31: 
            case 35: 
            case 39: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: 
            case 24: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualHeaderFile";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootFile";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findPreselectedOrSuitableConfiguration";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveRootAndActiveConfiguration";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCalculateParsedLanguageAndConfiguration";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createResolveRootAndConfiguration";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "headerContext";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "innerCalculateHeaderContext";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "sourceFileContext";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllBuildConfigurationsForFile";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllBuildConfigurationsOfTargetsOfFile";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllBuildConfigurationsForIndexing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computePreselectedConfiguration";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findPreselectedConfiguration";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findPreselectedOrSuitableConfiguration";
                break;
            }
            case 6: 
            case 7: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 23: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 52: 
            case 53: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isRoot";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isNeedToFindRoot";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getResolveRootAndActiveConfiguration";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getOrCalculateParsedLanguageAndConfiguration";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getResolveRootAndActiveConfigurationForHeader";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createResolveRootAndConfiguration";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "doGetPreselectedConfiguration";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "invalidateHeaderRootAndActiveConfigurationForAllExcept";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "invalidateHeaderContextsExcept";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "invalidateContextChangeCacheExcept";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "removeExcept";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "invalidateHeaderRootAndActiveConfigurationFor";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "headerContext";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "calculateHeaderContext";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "innerCalculateHeaderContext";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "sourceFileContext";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "setUserSelectedConfiguration";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getUserSelectedConfiguration";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getActiveConfiguration";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getAllBuildConfigurationsForFile";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getAllBuildConfigurationsOfTargetsOfFile";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getAllBuildConfigurationsForIndexing";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "pragmaOnceId";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "inclusionId";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "storeCachedContextChangeSet";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "cachedContextChangeSet";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 23: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 52: 
            case 53: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class VirtualFileComparator
    implements Comparator<VirtualFile> {
        private final Project myProject;
        private final String myHeaderNameWithoutExtension;

        public VirtualFileComparator(Project project2, String headerNameWithoutExtension) {
            this.myProject = project2;
            this.myHeaderNameWithoutExtension = headerNameWithoutExtension.toUpperCase(Locale.getDefault());
        }

        @Override
        public int compare(@NotNull VirtualFile root1, @NotNull VirtualFile root2) {
            int result;
            if (root1 == null) {
                VirtualFileComparator.$$$reportNull$$$0(0);
            }
            if (root2 == null) {
                VirtualFileComparator.$$$reportNull$$$0(1);
            }
            if ((result = Comparing.compare((boolean)OCInclusionContext.isPrecompiledHeader(root1, this.myProject), (boolean)OCInclusionContext.isPrecompiledHeader(root2, this.myProject))) != 0) {
                return -result;
            }
            result = Comparing.compare((boolean)OCFileTypeHelpers.isSourceFile(root1.getName()), (boolean)OCFileTypeHelpers.isSourceFile(root2.getName()));
            if (result != 0) {
                return -result;
            }
            String rootName1 = root1.getNameWithoutExtension().toUpperCase(Locale.getDefault());
            String rootName2 = root2.getNameWithoutExtension().toUpperCase(Locale.getDefault());
            result = Comparing.compare((boolean)this.myHeaderNameWithoutExtension.equals(rootName1), (boolean)this.myHeaderNameWithoutExtension.equals(rootName2));
            if (result != 0) {
                return -result;
            }
            result = Comparing.compare((Comparable)((Object)rootName1), (Comparable)((Object)rootName2));
            if (result != 0) {
                return result;
            }
            return Comparing.compare((Comparable)((Object)root1.getPath()), (Comparable)((Object)root2.getPath()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "root1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "root2";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil$VirtualFileComparator";
            objectArray[2] = "compare";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

