/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.util.Pair;
import com.intellij.util.SmartList;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCParsingNameScope {
    public static final int INDEX_BEFORE_FIRST = -1;
    private static final String LOCAL_SCOPE_NAME = "$LOCAL_SCOPE$";
    public static final String GLOBAL_SCOPE_NAME = "";
    private static final int LAST_COMPONENT_INDEX = 0x3FFFFFFF;
    @NotNull
    private final String myName;
    @NotNull
    private final THashSet<String> myProtocolNames;
    @NotNull
    private final THashMap<String, Kind> myNameKinds;
    @NotNull
    private final THashMap<String, OCParsingNameScope> myInnerScopes;
    @NotNull
    private final TIntObjectHashMap<ArrayList<String>> myTypedefIndices;
    @Nullable
    private List<OCParsingNameScope> myNamespaceUsings;
    @Nullable
    private OCParsingNameScope myParent;
    @Nullable
    private OCParsingNameScope myDelegate;
    @NotNull
    private List<Pair<String, Integer>> myTemplateTypeParameters;
    private List<Pair<String, Integer>> myTemplateValueParameters;

    @Nullable
    public OCParsingNameScope getDelegate() {
        return this.myDelegate;
    }

    public OCParsingNameScope() {
        this(GLOBAL_SCOPE_NAME, null);
    }

    @NotNull
    public OCParsingNameScope copy() {
        OCParsingNameScope oCParsingNameScope = this.delegatingCopy();
        if (oCParsingNameScope == null) {
            OCParsingNameScope.$$$reportNull$$$0(0);
        }
        return oCParsingNameScope;
    }

    @NotNull
    public OCParsingNameScope delegatingCopy() {
        OCParsingNameScope parent = this.getParent();
        OCParsingNameScope result = this.newScope(this.getName(), parent == null ? null : parent.delegatingCopy());
        result.myDelegate = this;
        OCParsingNameScope oCParsingNameScope = result;
        if (oCParsingNameScope == null) {
            OCParsingNameScope.$$$reportNull$$$0(1);
        }
        return oCParsingNameScope;
    }

    @NotNull
    protected OCParsingNameScope newScope(@NotNull String name2, @Nullable OCParsingNameScope parentCopy) {
        if (name2 == null) {
            OCParsingNameScope.$$$reportNull$$$0(2);
        }
        OCParsingNameScope oCParsingNameScope = new OCParsingNameScope(name2, parentCopy);
        if (oCParsingNameScope == null) {
            OCParsingNameScope.$$$reportNull$$$0(3);
        }
        return oCParsingNameScope;
    }

    private String getNiceName() {
        if (this.getName() == GLOBAL_SCOPE_NAME) {
            return "::";
        }
        if (this.getName() == LOCAL_SCOPE_NAME) {
            return "<local>";
        }
        return this.getName();
    }

    protected OCParsingNameScope(@NotNull String name2, @Nullable OCParsingNameScope parent) {
        if (name2 == null) {
            OCParsingNameScope.$$$reportNull$$$0(4);
        }
        this.myTypedefIndices = new TIntObjectHashMap();
        this.myTemplateTypeParameters = new ArrayList<Pair<String, Integer>>();
        this.myTemplateValueParameters = new ArrayList<Pair<String, Integer>>();
        this.myName = name2;
        this.myProtocolNames = new THashSet();
        this.myNameKinds = new THashMap();
        this.myInnerScopes = new THashMap();
        this.myParent = parent;
        if (parent != null) {
            OCParsingNameScope delegate;
            parent.myInnerScopes.put((Object)name2, (Object)this);
            if (parent.myDelegate != null && (delegate = (OCParsingNameScope)parent.myDelegate.myInnerScopes.get((Object)name2)) != null) {
                this.myDelegate = delegate;
            }
        }
    }

    public static Kind getTypeKind(boolean isTemplate) {
        return isTemplate ? Kind.TEMPLATE_TYPE : Kind.SIMPLE_TYPE;
    }

    public static boolean isTemplate(@Nullable Kind kind) {
        return kind == Kind.TEMPLATE_TYPE || kind == Kind.TEMPLATE_VALUE || kind == Kind.UNKNOWN;
    }

    public static boolean isType(@Nullable Kind kind) {
        return kind == Kind.SIMPLE_TYPE || kind == Kind.TEMPLATE_TYPE || kind == Kind.OBJC_INTERFACE || kind == Kind.TYPE_AND_VALUE || kind == Kind.UNKNOWN;
    }

    public static boolean isCppType(@Nullable Kind kind) {
        return kind == Kind.SIMPLE_TYPE || kind == Kind.TEMPLATE_TYPE || kind == Kind.TYPE_AND_VALUE || kind == Kind.UNKNOWN;
    }

    public static boolean isValue(@Nullable Kind kind) {
        return kind == Kind.SIMPLE_VALUE || kind == Kind.TEMPLATE_VALUE || kind == Kind.TYPE_AND_VALUE || kind == Kind.UNKNOWN;
    }

    @Nullable
    public OCParsingNameScope getParent() {
        return this.myParent;
    }

    public OCParsingNameScope dropAndGetParent() {
        if (this.myParent != null) {
            this.myParent.myInnerScopes.remove((Object)this.myName);
        }
        return this.myParent;
    }

    @Nullable
    public Kind getKind(String qualifiedName) {
        return this.getKind(Collections.singletonList(qualifiedName));
    }

    @Nullable
    public Kind getKind(List<String> qualifiedName) {
        ResolveContext context = new ResolveContext();
        if (qualifiedName.size() > 1 && qualifiedName.get(0).equals(GLOBAL_SCOPE_NAME)) {
            return this.getKindInGlobal(qualifiedName, context);
        }
        return this.getKindWithParents(qualifiedName, 0, context);
    }

    @Nullable
    private Kind getKindTerminal(@NotNull String qualifiedName, @Nullable ResolveContext context) {
        if (qualifiedName == null) {
            OCParsingNameScope.$$$reportNull$$$0(5);
        }
        Kind result = null;
        OCParsingNameScope scope = this;
        while (result == null && scope != null) {
            result = (Kind)((Object)scope.myNameKinds.get((Object)qualifiedName));
            if (result == null && scope.myNamespaceUsings != null) {
                if (context == null) {
                    context = new ResolveContext();
                }
                if (context.shouldCheckAtOffset(scope, 0x3FFFFFFF)) {
                    for (OCParsingNameScope using : scope.myNamespaceUsings) {
                        Kind r = using.getKindTerminal(qualifiedName, context);
                        if (!OCParsingNameScope.isType(r) && !OCParsingNameScope.isValue(r)) continue;
                        result = r;
                        break;
                    }
                }
            }
            scope = scope.myDelegate;
        }
        return result;
    }

    public boolean isProtocol(@Nullable String name2) {
        return this.isProtocol(name2, true);
    }

    protected boolean isProtocol(@Nullable String name2, boolean shouldCheckDelegates) {
        return this.myProtocolNames.contains((Object)name2) || shouldCheckDelegates && this.myDelegate != null && this.myDelegate.isProtocol(name2, true) || this.myParent != null && this.myParent.isProtocol(name2, this.myDelegate == null);
    }

    @Nullable
    protected Kind getKind(List<String> qualifiedName, int offset, ResolveContext context) {
        Kind result = this.getKindIfDecltype(qualifiedName, offset, context);
        if (result != null) {
            return result;
        }
        if (qualifiedName.size() == 1) {
            for (Pair<String, Integer> pair2 : this.myTemplateValueParameters) {
                if (!((String)pair2.first).equals(qualifiedName.get(0))) continue;
                return Kind.SIMPLE_VALUE;
            }
            for (Pair<String, Integer> pair2 : this.myTemplateTypeParameters) {
                if (!((String)pair2.first).equals(qualifiedName.get(0))) continue;
                return Kind.SIMPLE_TYPE;
            }
        }
        String namePart = qualifiedName.get(offset);
        if (qualifiedName.size() == offset + 1) {
            result = this.getKindTerminal(namePart, context);
        } else {
            OCParsingNameScope scope = this;
            while (result == null && scope != null) {
                OCParsingNameScope child = (OCParsingNameScope)scope.myInnerScopes.get((Object)namePart);
                if (child != null && (result = child.getKind(qualifiedName, offset + 1, context)) == null) {
                    result = Kind.UNKNOWN;
                }
                if (result == null && scope.myNamespaceUsings != null && context.shouldCheckAtOffset(scope, offset)) {
                    boolean foundNonType = false;
                    for (OCParsingNameScope using : scope.myNamespaceUsings) {
                        result = using.getKindWithParents(qualifiedName, offset, context);
                        if (result == Kind.NON_TYPE) {
                            foundNonType = true;
                            continue;
                        }
                        if (result == null) continue;
                        break;
                    }
                    if (result == null && foundNonType) {
                        result = Kind.NON_TYPE;
                    }
                }
                scope = scope.myDelegate;
            }
        }
        return result;
    }

    @Nullable
    private Kind getKindWithParents(List<String> qualifiedName, int offset, ResolveContext context) {
        Kind result = this.getKind(qualifiedName, offset, context);
        if (this.myParent != null) {
            if (result == null) {
                return this.myParent.getKindWithParents(qualifiedName, offset, context);
            }
            if (result == Kind.NON_TYPE) {
                Kind parentResult = this.myParent.getKindWithParents(qualifiedName, offset, context);
                return parentResult != null ? parentResult : Kind.NON_TYPE;
            }
        }
        return result;
    }

    @Nullable
    private Kind getKindInGlobal(List<String> qualifiedName, ResolveContext context) {
        if (this.myParent != null) {
            return this.myParent.getKindInGlobal(qualifiedName, context);
        }
        if (qualifiedName.size() > 1) {
            return this.getKind(qualifiedName, 1, context);
        }
        return Kind.TEMPLATE_TYPE;
    }

    private Kind getKindIfDecltype(List<String> qualifiedName, int offset, ResolveContext context) {
        assert (offset >= 0 && offset < qualifiedName.size());
        if (OCTokenTypes.DECLTYPE_CPP_KEYWORD.getName().contentEquals(qualifiedName.get(offset))) {
            return Kind.SIMPLE_TYPE;
        }
        return null;
    }

    public void undefineFromIndex(int index) {
        TIntObjectIterator iter = this.myTypedefIndices.iterator();
        while (iter.hasNext()) {
            iter.advance();
            int entryIndex = iter.key();
            if (entryIndex < index) continue;
            for (String name2 : (ArrayList)iter.value()) {
                this.myNameKinds.remove((Object)name2);
            }
            iter.remove();
        }
    }

    private void registerIndex(String qualifiedName, int index) {
        ArrayList<String> names = (ArrayList<String>)this.myTypedefIndices.get(index);
        if (names == null) {
            names = new ArrayList<String>();
            this.myTypedefIndices.put(index, names);
        }
        names.add(qualifiedName);
    }

    @Nullable
    public Kind defineType(@NotNull String qualifiedName, boolean isTemplate) {
        if (qualifiedName == null) {
            OCParsingNameScope.$$$reportNull$$$0(6);
        }
        return this.defineType(qualifiedName, isTemplate, false, -1);
    }

    @Nullable
    public Kind defineType(@NotNull String qualifiedName, boolean isTemplate, boolean isFriend, int index) {
        if (qualifiedName == null) {
            OCParsingNameScope.$$$reportNull$$$0(7);
        }
        Kind kind = isTemplate ? Kind.TEMPLATE_TYPE : Kind.SIMPLE_TYPE;
        Kind existing = this.getKindTerminal(qualifiedName, null);
        if (OCParsingNameScope.isValue(existing)) {
            kind = Kind.TYPE_AND_VALUE;
        } else {
            if (existing == Kind.TEMPLATE_TYPE) {
                return Kind.TEMPLATE_TYPE;
            }
            if (isFriend && this.getKind(qualifiedName) != null) {
                return this.getKind(qualifiedName);
            }
        }
        return this.registerKind(qualifiedName, index, kind);
    }

    @Nullable
    public Kind defineInterface(String qualifiedName) {
        return this.defineInterface(qualifiedName, -1);
    }

    @Nullable
    public Kind defineInterface(String qualifiedName, int index) {
        Kind kind = Kind.OBJC_INTERFACE;
        if (OCParsingNameScope.isValue(this.getKindTerminal(qualifiedName, null))) {
            kind = Kind.TYPE_AND_VALUE;
        }
        return this.registerKind(qualifiedName, index, kind);
    }

    public void defineProtocol(String name2) {
        this.defineProtocol(name2, -1);
    }

    public void defineProtocol(String name2, int index) {
        this.myProtocolNames.add((Object)name2);
        this.registerIndex(name2, index);
    }

    public Kind defineValue(String qualifiedName, boolean isTemplate) {
        return this.defineValue(qualifiedName, isTemplate, -1);
    }

    public Kind defineValue(String qualifiedName, boolean isTemplate, int index) {
        Kind kind = isTemplate ? Kind.TEMPLATE_VALUE : Kind.SIMPLE_VALUE;
        Kind existing = this.getKindTerminal(qualifiedName, null);
        if (OCParsingNameScope.isType(existing)) {
            kind = Kind.TYPE_AND_VALUE;
        } else if (existing == Kind.TEMPLATE_VALUE) {
            return Kind.TEMPLATE_VALUE;
        }
        return this.registerKind(qualifiedName, index, kind);
    }

    private Kind registerKind(String name2, int index, Kind kind) {
        this.registerIndex(name2, index);
        return (Kind)((Object)this.myNameKinds.put((Object)name2, (Object)kind));
    }

    public OCParsingNameScope defineNamespace(@NotNull String name2) {
        OCParsingNameScope scope;
        if (name2 == null) {
            OCParsingNameScope.$$$reportNull$$$0(8);
        }
        if ((scope = (OCParsingNameScope)this.myInnerScopes.get((Object)name2)) == null || scope.getParent() != this) {
            scope = this.newScope(name2, this);
        }
        return scope;
    }

    public OCParsingNameScope defineLocalScope() {
        return this.newScope(LOCAL_SCOPE_NAME, this);
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            OCParsingNameScope.$$$reportNull$$$0(9);
        }
        return string;
    }

    public String toString() {
        return "OCParsingNameScope{" + this.getNiceName() + "}";
    }

    public void defineNamespaceAlias(String alias, String namespaceName) {
        this.defineNamespaceAlias(alias, Collections.singletonList(namespaceName));
    }

    public void defineNamespaceAlias(String alias, List<String> namespaceName) {
        OCParsingNameScope scope = this.resolveNamespace(namespaceName);
        if (scope != null) {
            this.myInnerScopes.put((Object)alias, (Object)scope);
        }
    }

    public void defineNamespaceUsing(@NotNull List<String> qualifiedName) {
        OCParsingNameScope scope;
        if (qualifiedName == null) {
            OCParsingNameScope.$$$reportNull$$$0(10);
        }
        if (this.myNamespaceUsings == null) {
            this.myNamespaceUsings = new ArrayList<OCParsingNameScope>();
        }
        if ((scope = this.resolveNamespace(qualifiedName)) != null && scope != this && !this.myNamespaceUsings.contains(scope)) {
            this.myNamespaceUsings.add(scope);
        }
    }

    public void defineNamespaceUsing(@NotNull String name2) {
        if (name2 == null) {
            OCParsingNameScope.$$$reportNull$$$0(11);
        }
        this.defineNamespaceUsing(Collections.singletonList(name2));
    }

    public void defineSymbolUsing(@NotNull String name2) {
        if (name2 == null) {
            OCParsingNameScope.$$$reportNull$$$0(12);
        }
        this.defineSymbolUsing(Collections.singletonList(name2));
    }

    public void defineSymbolUsing(@NotNull List<String> qualifiedName) {
        Kind kind;
        boolean isType;
        if (qualifiedName == null) {
            OCParsingNameScope.$$$reportNull$$$0(13);
        }
        if (!(isType = OCParsingNameScope.isType(kind = this.getKind(qualifiedName))) && !OCParsingNameScope.isValue(kind)) {
            return;
        }
        String alias = qualifiedName.get(qualifiedName.size() - 1);
        this.registerKind(alias, Integer.MAX_VALUE, kind);
        if (isType) {
            this.defineNamespaceAlias(alias, qualifiedName);
        }
    }

    @NotNull
    public List<Pair<String, Integer>> getTemplateValueParameters() {
        List<Pair<String, Integer>> list = this.myTemplateValueParameters;
        if (list == null) {
            OCParsingNameScope.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    public List<Pair<String, Integer>> getTemplateTypeParameters() {
        List<Pair<String, Integer>> list = this.myTemplateTypeParameters;
        if (list == null) {
            OCParsingNameScope.$$$reportNull$$$0(15);
        }
        return list;
    }

    public void addTemplateValueParameter(@NotNull String qualifiedName, int index) {
        if (qualifiedName == null) {
            OCParsingNameScope.$$$reportNull$$$0(16);
        }
        this.myTemplateValueParameters.add((Pair<String, Integer>)Pair.create((Object)qualifiedName, (Object)index));
    }

    public void addTemplateTypeParameter(@NotNull String qualifiedName, int index) {
        if (qualifiedName == null) {
            OCParsingNameScope.$$$reportNull$$$0(17);
        }
        this.myTemplateTypeParameters.add((Pair<String, Integer>)Pair.create((Object)qualifiedName, (Object)index));
    }

    public void clearTemplateParameters() {
        this.myTemplateValueParameters.clear();
        this.myTemplateTypeParameters.clear();
    }

    @Nullable
    private OCParsingNameScope resolveNamespace(@NotNull List<String> qualifiedName) {
        OCParsingNameScope result;
        if (qualifiedName == null) {
            OCParsingNameScope.$$$reportNull$$$0(18);
        }
        ResolveContext context = new ResolveContext();
        if (qualifiedName.size() > 0 && qualifiedName.get(0).equals(GLOBAL_SCOPE_NAME)) {
            OCParsingNameScope global = this;
            while (global.myParent != null) {
                global = global.myParent;
            }
            result = global.resolveNamespace(qualifiedName, 1, context);
        } else {
            result = this.resolveNamespace(qualifiedName, 0, context);
        }
        return result;
    }

    @Nullable
    private OCParsingNameScope resolveNamespace(List<String> qualifiedName, int offset, ResolveContext context) {
        if (offset == qualifiedName.size()) {
            return this;
        }
        OCParsingNameScope result = null;
        String name2 = qualifiedName.get(offset);
        OCParsingNameScope scope = this;
        while (result == null && scope != null) {
            OCParsingNameScope child = (OCParsingNameScope)scope.myInnerScopes.get((Object)name2);
            if (child != null) {
                result = child.resolveNamespace(qualifiedName, offset + 1, context);
            }
            if (result == null && scope.myNamespaceUsings != null && context.shouldCheckAtOffset(scope, offset)) {
                OCParsingNameScope using;
                Iterator<OCParsingNameScope> iterator = scope.myNamespaceUsings.iterator();
                while (iterator.hasNext() && (result = (using = iterator.next()).resolveNamespace(qualifiedName, offset, context)) == null) {
                }
            }
            scope = scope.myDelegate;
        }
        if (result == null && this.myParent != null) {
            result = this.myParent.resolveNamespace(qualifiedName, offset, context);
        }
        return result;
    }

    public DeepEqual.Equality<OCParsingNameScope> equality() {
        return new DeepEquality();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/preprocessor/OCParsingNameScope";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "delegatingCopy";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/preprocessor/OCParsingNameScope";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "newScope";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateValueParameters";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateTypeParameters";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "newScope";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getKindTerminal";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "defineType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "defineNamespace";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "defineNamespaceUsing";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "defineSymbolUsing";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addTemplateValueParameter";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addTemplateTypeParameter";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "resolveNamespace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DeepEquality
    implements DeepEqual.Equality<OCParsingNameScope> {
        private DeepEquality() {
        }

        @Override
        public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull OCParsingNameScope first, @NotNull OCParsingNameScope second) {
            if (c == null) {
                DeepEquality.$$$reportNull$$$0(0);
            }
            if (first == null) {
                DeepEquality.$$$reportNull$$$0(1);
            }
            if (second == null) {
                DeepEquality.$$$reportNull$$$0(2);
            }
            if (!first.myName.equals(second.myName)) {
                return false;
            }
            if (!first.myNameKinds.equals((Object)second.myNameKinds)) {
                return false;
            }
            if (!first.myProtocolNames.equals((Object)second.myProtocolNames)) {
                return false;
            }
            if (!first.myTypedefIndices.equals((Object)second.myTypedefIndices)) {
                return false;
            }
            if (!c.equalLists(first.myNamespaceUsings, second.myNamespaceUsings)) {
                return false;
            }
            if (!c.equalObjects(first.myParent, second.myParent)) {
                return false;
            }
            return c.equalMaps((Map)first.myInnerScopes, (Map)second.myInnerScopes);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "c";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "first";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "second";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/preprocessor/OCParsingNameScope$DeepEquality";
            objectArray[2] = "deepEqualStep";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ResolveContext {
        private THashMap<OCParsingNameScope, List<Integer>> myCurrentOffsets;

        private ResolveContext() {
        }

        public boolean shouldCheckAtOffset(@NotNull OCParsingNameScope scope, int positionInName) {
            List checkedPositions;
            if (scope == null) {
                ResolveContext.$$$reportNull$$$0(0);
            }
            if (this.myCurrentOffsets == null) {
                this.myCurrentOffsets = new THashMap();
                checkedPositions = null;
            } else {
                checkedPositions = (List)this.myCurrentOffsets.get((Object)scope);
            }
            if (checkedPositions == null) {
                checkedPositions = new SmartList((Object)positionInName);
                this.myCurrentOffsets.put((Object)scope, (Object)checkedPositions);
            } else if (!checkedPositions.contains(positionInName)) {
                checkedPositions.add(positionInName);
            } else {
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/jetbrains/cidr/lang/preprocessor/OCParsingNameScope$ResolveContext", "shouldCheckAtOffset"));
        }
    }

    public static enum Kind {
        UNKNOWN,
        SIMPLE_TYPE,
        TEMPLATE_TYPE,
        SIMPLE_VALUE,
        TEMPLATE_VALUE,
        OBJC_INTERFACE,
        TYPE_AND_VALUE,
        NON_TYPE;

    }
}

