/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.lang.ForeignLeafType;
import com.intellij.lang.TokenWrapper;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.lexer.LexerUtil;
import com.intellij.lexer.LookAheadLexer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashMap;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.lexer.OCLexer;
import com.jetbrains.cidr.lang.lexer.OCLexerSettings;
import com.jetbrains.cidr.lang.parser.OCInnerIncludeElementType;
import com.jetbrains.cidr.lang.parser.OCParsing;
import com.jetbrains.cidr.lang.parser.OCPragmaOnceContentElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCBoostPPHelper;
import com.jetbrains.cidr.lang.preprocessor.OCContextChangeSet;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafType;
import com.jetbrains.cidr.lang.preprocessor.OCMacroReferenceTokenType;
import com.jetbrains.cidr.lang.preprocessor.OCSyntheticLeafType;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.SymbolTableProvider;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import com.jetbrains.cidr.lang.util.OCImmutableList;
import com.jetbrains.cidr.lang.util.OCStringLiteralUtil;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import gnu.trove.THashMap;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCPreprocessingLexer
extends LookAheadLexer {
    private static final String VARARG_MACRO_PARAMS_SEPARATOR = ",";
    private static final int MACRO_SUBSTITUTIONS_LIMIT_PER_FILE = 200000;
    public static final Key<Boolean> DONT_SUBSTITUTE_IN_DEFINES = Key.create((String)"DONT_SUBSTITUTE_IN_DEFINES");
    private static final String LINE_MACRO = "__LINE__";
    private static final String LINE_MACRO_STUB_START = "__CIDR_LINE_MACRO_STUB_";
    private static final Pattern LINE_MACRO_STUB_PATTERN = Pattern.compile("^\\s*__CIDR_LINE_MACRO_STUB_(\\d+)\\s*$");
    private static final String COUNTER_MACRO = "__COUNTER__";
    public static final String ELLIPSIS = "...";
    private static final Set<String> FORCE_SUBSTITUTION_MACROS = ContainerUtil.set((Object[])new String[]{"NSLocalizedString", "NSLocalizedStringFromTable", "NSLocalizedStringFromTableInBundle", "NSLocalizedStringWithDefaultValue"});
    @NotNull
    private final OCInclusionContext myState;
    @Nullable
    private OCContextChangeSet myChangeSet;
    private final boolean myEvalDefinedFunction;
    @Nullable
    private final OCFile myFile;
    private VirtualFile myCurrentFile;
    private PsiFile myIncludeAnchor;
    private int myMacroLevel;
    private Ref<Integer> myTotalMacroSubstitutionsCnt;
    @Nullable
    private CounterMacroHandler myCounterMacroHandler;
    private boolean myAtDefineDirective;
    private final boolean myAddTokensFromDirective;
    @Nullable
    private Stack<BraceState> myBraceStack;
    private QualifiedNameParser myCurrentNamespaceParser;
    private CurrentState myAtExternDeclaration;
    private boolean myDontSubstituteInDefines;
    private TObjectIntHashMap<PsiFile> myProcessingFiles;
    private int myIncludeLevel;
    private boolean myInsideIfCondition;
    @NotNull
    private final Ref<Long> myLineCount;
    @NotNull
    private final IncludePreprocessingMode myIncludePreprocessingMode;
    @Nullable
    private Lexer myPrefixLexer;
    @Nullable
    private Lexer mySuffixLexer;
    private static BraceState BRACE_STATE_OK = new BraceState(){

        @Override
        public boolean isSafeForInclude() {
            return true;
        }
    };
    private static BraceState BRACE_STATE_BAD = new BraceState(){};
    private final Function<CharSequence, Boolean> IF_EVAL;
    private final Function<CharSequence, Boolean> IFDEF_EVAL;
    private final Function<CharSequence, Boolean> IFNDEF_EVAL;
    private static final TokenSet SKIP_TOKENS = TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.CONDITIONALLY_NON_COMPILED_COMMENT, OCTokenTypes.EOL_ESCAPE});

    public OCPreprocessingLexer(@NotNull OCInclusionContext initialSubstitutions, @Nullable OCFile file) {
        if (initialSubstitutions == null) {
            OCPreprocessingLexer.$$$reportNull$$$0(0);
        }
        this(initialSubstitutions, file, false, 0, initialSubstitutions.getInclusionLevel(), (Ref<Integer>)Ref.create((Object)0), IncludePreprocessingMode.USE_SYMBOL_TABLE, (Ref<Long>)Ref.create((Object)1L), new CounterMacroUpdater(), false, false);
        this.myBraceStack = new Stack();
    }

    public OCPreprocessingLexer(@NotNull OCInclusionContext initialSubstitutions, @Nullable OCFile file, @NotNull IncludePreprocessingMode includePreprocessingMode) {
        if (initialSubstitutions == null) {
            OCPreprocessingLexer.$$$reportNull$$$0(1);
        }
        if (includePreprocessingMode == null) {
            OCPreprocessingLexer.$$$reportNull$$$0(2);
        }
        this(initialSubstitutions, file, false, 0, initialSubstitutions.getInclusionLevel(), (Ref<Integer>)Ref.create((Object)0), includePreprocessingMode, (Ref<Long>)Ref.create((Object)1L), new CounterMacroUpdater(), false, false);
        this.myBraceStack = new Stack();
    }

    public OCPreprocessingLexer(@NotNull OCInclusionContext initialSubstitutions, @Nullable OCFile file, boolean forcePreprocessingOfIncludes) {
        if (initialSubstitutions == null) {
            OCPreprocessingLexer.$$$reportNull$$$0(3);
        }
        this(initialSubstitutions, file, false, 0, initialSubstitutions.getInclusionLevel(), (Ref<Integer>)Ref.create((Object)0), forcePreprocessingOfIncludes ? IncludePreprocessingMode.FORCE_PREPROCESSING : IncludePreprocessingMode.USE_SYMBOL_TABLE, (Ref<Long>)Ref.create((Object)1L), new CounterMacroUpdater(), false, false);
        this.myBraceStack = new Stack();
    }

    public OCPreprocessingLexer(@NotNull OCInclusionContext initialSubstitutions, @Nullable OCFile file, int lineNumber) {
        if (initialSubstitutions == null) {
            OCPreprocessingLexer.$$$reportNull$$$0(4);
        }
        this(initialSubstitutions, file, false, 0, initialSubstitutions.getInclusionLevel(), (Ref<Integer>)Ref.create((Object)0), IncludePreprocessingMode.USE_SYMBOL_TABLE, (Ref<Long>)Ref.create((Object)new Long(lineNumber)), new CounterMacroUpdater(), false, false);
        this.myBraceStack = new Stack();
    }

    private OCPreprocessingLexer(@NotNull OCInclusionContext initialSubstitutions, @Nullable OCFile file, boolean evalDefined, int macroLevel, int includeLevel, Ref<Integer> totalMacroSubstitutions, @NotNull IncludePreprocessingMode includePreprocessingMode, @NotNull Ref<Long> lineCount, @Nullable CounterMacroHandler counterMacroHandler, boolean atDefineDirective, boolean addTokensFromDirective) {
        if (initialSubstitutions == null) {
            OCPreprocessingLexer.$$$reportNull$$$0(5);
        }
        if (includePreprocessingMode == null) {
            OCPreprocessingLexer.$$$reportNull$$$0(6);
        }
        if (lineCount == null) {
            OCPreprocessingLexer.$$$reportNull$$$0(7);
        }
        super((Lexer)new OCLexer(OCPreprocessingLexer.createLexerSettings(initialSubstitutions)));
        this.myProcessingFiles = new TObjectIntHashMap();
        this.IF_EVAL = charSequence -> this.evaluate((CharSequence)charSequence);
        this.IFDEF_EVAL = new Function<CharSequence, Boolean>(){

            public Boolean fun(CharSequence charSequence) {
                List words = StringUtil.getWordsIn((String)charSequence.toString());
                String identifier = words.isEmpty() ? charSequence.toString().trim() : (String)words.get(0);
                return OCPreprocessingLexer.this.myState.isDefined(identifier);
            }
        };
        this.IFNDEF_EVAL = new Function<CharSequence, Boolean>(){

            public Boolean fun(CharSequence charSequence) {
                List words = StringUtil.getWordsIn((String)charSequence.toString());
                String identifier = words.isEmpty() ? charSequence.toString().trim() : (String)words.get(0);
                return !OCPreprocessingLexer.this.myState.isDefined(identifier);
            }
        };
        this.myState = initialSubstitutions;
        this.myFile = file;
        this.myIncludeAnchor = file;
        this.myEvalDefinedFunction = evalDefined;
        this.myMacroLevel = macroLevel;
        this.myIncludeLevel = includeLevel;
        this.myTotalMacroSubstitutionsCnt = totalMacroSubstitutions;
        this.myCounterMacroHandler = counterMacroHandler;
        this.myIncludePreprocessingMode = includePreprocessingMode;
        this.myLineCount = lineCount;
        this.myAtDefineDirective = atDefineDirective;
        this.myAddTokensFromDirective = addTokensFromDirective;
        this.myAtExternDeclaration = CurrentState.NONE;
        this.myInsideIfCondition = false;
        this.myDontSubstituteInDefines = file != null && file.getProject().getUserData(DONT_SUBSTITUTE_IN_DEFINES) == Boolean.TRUE;
    }

    private static OCLexerSettings createLexerSettings(@NotNull OCInclusionContext context) {
        if (context == null) {
            OCPreprocessingLexer.$$$reportNull$$$0(8);
        }
        OCLexerSettings.Builder builder = OCLexerSettings.forContext(context);
        OCResolveConfiguration config = context.getConfiguration();
        if (config == null || OCCompilerKind.CLANG.equals((Object)config.getCompilerSettings().getCompiler(context.getLanguageKind()))) {
            builder.allowNullabilityKeywords();
        }
        return builder.build();
    }

    protected void lookAhead(@NotNull Lexer baseLexer) {
        String altCppP;
        if (baseLexer == null) {
            OCPreprocessingLexer.$$$reportNull$$$0(9);
        }
        this.addAllTokensAsSynthetic(this.myPrefixLexer, 0);
        IElementType baseToken = baseLexer.getTokenType();
        if (baseToken == OCTokenTypes.IDENTIFIER || OCTokenTypes.KEYWORDS.contains(baseToken) || (altCppP = OCElementUtil.getAlternativeCppPunctuator(baseToken)) != null && altCppP.contentEquals(LexerUtil.getTokenText((Lexer)baseLexer))) {
            String id = LexerUtil.getTokenText((Lexer)baseLexer).toString();
            if (this.myEvalDefinedFunction && "defined".equals(id)) {
                this.processDefinedFunction(baseLexer);
            } else if (this.myEvalDefinedFunction && "__has_include".equals(id)) {
                this.processHasInclude(baseLexer, false);
            } else if (this.myEvalDefinedFunction && "__has_include_next".equals(id)) {
                this.processHasInclude(baseLexer, true);
            } else {
                String numStr;
                OCMacroSymbol macro;
                if (!this.myInsideIfCondition && this.myEvalDefinedFunction) {
                    this.myState.isDefined(id);
                }
                if ((macro = this.myState.getDefinition(id)) == null && (numStr = OCPreprocessingLexer.lineNumberFromStub(id)) != null) {
                    macro = new OCMacroSymbol(this.myState.getProject(), null, -1L, id, null, numStr);
                }
                if (!this.myAtDefineDirective && macro != null) {
                    this.processMacroSubstitution(baseLexer, macro, true);
                } else {
                    this.addToken(baseToken);
                    baseLexer.advance();
                    if (!this.myDontSubstituteInDefines) {
                        this.myAtDefineDirective = false;
                    }
                    this.updateBraceStack(baseToken, id);
                }
            }
        } else if (baseToken == OCTokenTypes.DEFINE_DIRECTIVE) {
            this.processDefineDirective(baseLexer);
        } else if (baseToken == OCTokenTypes.UNDEF_DIRECTIVE) {
            this.processUndefineDirective(baseLexer);
        } else if (baseToken == OCTokenTypes.INCLUDE_DIRECTIVE) {
            this.processIncludeDirective(baseLexer, false, false);
        } else if (baseToken == OCTokenTypes.IMPORT_DIRECTIVE) {
            this.processIncludeDirective(baseLexer, true, false);
        } else if (baseToken == OCTokenTypes.INCLUDE_NEXT_DIRECTIVE) {
            this.processIncludeDirective(baseLexer, false, true);
        } else if (baseToken == OCTokenTypes.IF_DIRECTIVE) {
            this.processIfDirective(baseLexer, this.IF_EVAL);
        } else if (baseToken == OCTokenTypes.IFDEF_DIRECTIVE) {
            this.processIfDirective(baseLexer, this.IFDEF_EVAL);
        } else if (baseToken == OCTokenTypes.IFNDEF_DIRECTIVE) {
            this.processIfDirective(baseLexer, this.IFNDEF_EVAL);
        } else if (baseToken == OCTokenTypes.PRAGMA_DIRECTIVE) {
            this.processBaseDirective(baseLexer, 12);
        } else if (OCTokenTypes.DIRECTIVES.contains(baseToken)) {
            this.processBaseDirective(baseLexer, 8);
        } else {
            boolean hasNewLines;
            if (baseToken == OCTokenTypes.RBRACE) {
                this.emitCounterDefinitionIfRequired(baseLexer);
            } else if (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(baseToken) && (hasNewLines = this.adjustLineCount(LexerUtil.getTokenText((Lexer)baseLexer)))) {
                this.emitCounterDefinitionIfRequired(baseLexer);
            }
            this.updateBraceStack(baseToken, null);
            super.lookAhead(baseLexer);
        }
        if (baseLexer.getTokenType() == null) {
            this.emitCounterDefinitionIfRequired(baseLexer);
            this.addAllTokensAsSynthetic(this.mySuffixLexer, -1);
        }
    }

    private void emitCounterDefinitionIfRequired(@NotNull Lexer baseLexer) {
        if (baseLexer == null) {
            OCPreprocessingLexer.$$$reportNull$$$0(10);
        }
        if (this.myCounterMacroHandler != null) {
            this.myCounterMacroHandler.emitNewDefinitionIfRequired(this, baseLexer);
        }
    }

    private void addAllTokensAsSynthetic(@Nullable Lexer lexer, int offset) {
        while (lexer != null && lexer.getTokenType() != null) {
            IElementType token = lexer.getTokenType();
            String text = LexerUtil.getTokenText((Lexer)lexer).toString();
            OCSyntheticLeafType ft = new OCSyntheticLeafType(token, text);
            if (offset >= 0) {
                this.addToken(offset, (IElementType)ft);
            } else {
                this.addToken((IElementType)ft);
            }
            lexer.advance();
        }
    }

    @Nullable
    private static String lineNumberFromStub(String stub) {
        Matcher matcher;
        if (stub.length() > LINE_MACRO_STUB_START.length() && (matcher = LINE_MACRO_STUB_PATTERN.matcher(stub)).find()) {
            return matcher.group(1);
        }
        return null;
    }

    private boolean adjustLineCount(@NotNull CharSequence tokenText) {
        int lbCount;
        if (tokenText == null) {
            OCPreprocessingLexer.$$$reportNull$$$0(11);
        }
        if ((lbCount = StringUtil.countChars((CharSequence)tokenText, (char)'\n')) > 0) {
            this.myLineCount.set((Object)((Long)this.myLineCount.get() + (long)lbCount));
            return true;
        }
        return false;
    }

    private void updateBraceStack(IElementType baseToken, String name2) {
        if (this.myBraceStack == null) {
            return;
        }
        if (baseToken == OCTokenTypes.EXTERN_KEYWORD) {
            this.myAtExternDeclaration = CurrentState.AFTER_EXTERN;
        } else if (baseToken == OCTokenTypes.STRING_LITERAL && this.myAtExternDeclaration == CurrentState.AFTER_EXTERN) {
            this.myAtExternDeclaration = CurrentState.AFTER_EXTERN_C;
        } else if (baseToken == OCTokenTypes.AT) {
            this.myAtExternDeclaration = CurrentState.AFTER_AT;
        } else if (baseToken == OCTokenTypes.NAMESPACE_CPP_KEYWORD) {
            this.myCurrentNamespaceParser = new QualifiedNameParser();
            this.myAtExternDeclaration = CurrentState.AFTER_NAMESPACE;
        } else if (baseToken == OCTokenTypes.IMPORT_MODULE_KEYWORD && this.myAtExternDeclaration == CurrentState.AFTER_AT) {
            this.myAtExternDeclaration = CurrentState.AFTER_MODULE_IMPORT;
        } else if (this.myAtExternDeclaration == CurrentState.AFTER_MODULE_IMPORT) {
            if (baseToken != OCTokenTypes.DOT && !OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(baseToken) && !(baseToken instanceof OCMacroForeignLeafType)) {
                this.myAtExternDeclaration = CurrentState.NONE;
                ProgressManager.checkCanceled();
            }
        } else if (this.myAtExternDeclaration == CurrentState.AFTER_PROTOCOL) {
            if (baseToken == OCTokenTypes.IDENTIFIER || OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(baseToken)) {
                return;
            }
            if (baseToken == OCTokenTypes.SEMICOLON || baseToken == OCTokenTypes.COMMA) {
                this.popBraceStack();
            }
            this.myAtExternDeclaration = CurrentState.NONE;
        } else if (this.myAtExternDeclaration == CurrentState.AFTER_NAMESPACE) {
            if (baseToken == OCTokenTypes.IDENTIFIER) {
                this.myCurrentNamespaceParser.handleId(name2);
            } else if (baseToken == OCTokenTypes.COLON2X) {
                this.myCurrentNamespaceParser.handleDoubleColon();
            } else if (baseToken == OCTokenTypes.LBRACE) {
                List<String> ns = this.myCurrentNamespaceParser.getResult();
                if (ns != null && ns.size() > 0) {
                    for (String n : ns) {
                        this.myState.enterNamespace(n);
                    }
                    this.myBraceStack.push(new NamespaceBraceState(this.myState, ns));
                } else {
                    this.myBraceStack.push(BRACE_STATE_BAD);
                }
                this.myAtExternDeclaration = CurrentState.NONE;
            } else if (!OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(baseToken)) {
                this.myAtExternDeclaration = CurrentState.NONE;
            }
        } else {
            if (baseToken == OCTokenTypes.LBRACE) {
                this.myBraceStack.push(this.myAtExternDeclaration == CurrentState.AFTER_EXTERN_C ? BRACE_STATE_OK : BRACE_STATE_BAD);
            } else if (OCTokenTypes.OBJC_CLASS_KEYWORDS.contains(baseToken) && baseToken != OCTokenTypes.CLASS_KEYWORD) {
                this.myBraceStack.push(BRACE_STATE_BAD);
                if (baseToken == OCTokenTypes.PROTOCOL_KEYWORD) {
                    this.myAtExternDeclaration = CurrentState.AFTER_PROTOCOL;
                    return;
                }
            } else if (baseToken == OCTokenTypes.RBRACE || baseToken == OCTokenTypes.END_KEYWORD) {
                this.popBraceStack();
            }
            if (!OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(baseToken)) {
                this.myAtExternDeclaration = CurrentState.NONE;
            }
        }
    }

    private void popBraceStack() {
        assert (this.myBraceStack != null);
        if (!this.myBraceStack.empty()) {
            BraceState state = this.myBraceStack.pop();
            state.onExit();
        }
    }

    public void setChangeSet(@Nullable OCContextChangeSet changeSet) {
        this.myChangeSet = changeSet;
    }

    public void adjustNamespace() {
        List<String> namespace = this.myState.getCurrentNamespace();
        if (!namespace.isEmpty()) {
            Pair<Lexer, Lexer> result = this.createNamespaceAdjustmentLexers(namespace);
            this.myPrefixLexer = (Lexer)result.first;
            this.mySuffixLexer = (Lexer)result.second;
        }
    }

    @NotNull
    private Pair<Lexer, Lexer> createNamespaceAdjustmentLexers(@NotNull List<String> namespace) {
        if (namespace == null) {
            OCPreprocessingLexer.$$$reportNull$$$0(12);
        }
        Lexer prefixLexer = OCPreprocessingLexer.createNamespaceAdjustmentOpener(namespace);
        StringBuilder suffix = new StringBuilder("\n");
        for (int i = 0; i < namespace.size(); ++i) {
            suffix.append("}");
        }
        Lexer suffixLexer = OCPreprocessingLexer.createAdjustmentLexer(suffix.toString());
        Pair pair2 = Pair.create((Object)prefixLexer, (Object)suffixLexer);
        if (pair2 == null) {
            OCPreprocessingLexer.$$$reportNull$$$0(13);
        }
        return pair2;
    }

    @NotNull
    private static Lexer createNamespaceAdjustmentOpener(@NotNull List<String> namespace) {
        if (namespace == null) {
            OCPreprocessingLexer.$$$reportNull$$$0(14);
        }
        StringBuilder prefix = new StringBuilder();
        for (String n : namespace) {
            prefix.append("namespace ").append(n).append("{");
        }
        prefix.append("\n");
        Lexer lexer = OCPreprocessingLexer.createAdjustmentLexer(prefix.toString());
        if (lexer == null) {
            OCPreprocessingLexer.$$$reportNull$$$0(15);
        }
        return lexer;
    }

    @NotNull
    private static Lexer createAdjustmentLexer(String text) {
        OCLexer prefixLexer = new OCLexer(OCLexerSettings.forPreprocessor().build());
        prefixLexer.start(text);
        OCLexer oCLexer = prefixLexer;
        if (oCLexer == null) {
            OCPreprocessingLexer.$$$reportNull$$$0(16);
        }
        return oCLexer;
    }

    private void processBaseDirective(Lexer baseLexer, int initialState) {
        ProgressManager.checkCanceled();
        this.advanceLexer(baseLexer);
        if (OCPreprocessingLexer.atDirectiveContent(baseLexer)) {
            CharSequence content = LexerUtil.getTokenText((Lexer)baseLexer);
            this.addTokensFromDirective(baseLexer, content, false, false, initialState, false, null, null);
        }
        this.addToken(baseLexer.getTokenStart(), OCTokenTypes.END_OF_DIRECTIVE_CONTENT);
    }

    private void processHasInclude(Lexer lexer, boolean next) {
        if (this.myAddTokensFromDirective) {
            this.advanceLexer(lexer);
        } else {
            this.skipAsComment(lexer);
        }
        this.skipWhitespaces(lexer);
        int parsNesting = 0;
        if (lexer.getTokenType() == OCTokenTypes.LPAR) {
            this.skipAsComment(lexer);
            this.skipWhitespaces(lexer);
            ++parsNesting;
        }
        boolean inAnglePars = false;
        if (lexer.getTokenType() == OCTokenTypes.LT) {
            this.skipAsComment(lexer);
            this.skipWhitespaces(lexer);
            inAnglePars = true;
        }
        IElementType tokenType = lexer.getTokenType();
        StringBuilder name2 = new StringBuilder();
        if (inAnglePars) {
            name2.append("<");
        }
        while (tokenType == OCTokenTypes.IDENTIFIER || OCTokenTypes.KEYWORDS.contains(tokenType) || OCTokenTypes.LITERALS.contains(tokenType) || tokenType == OCTokenTypes.DOT || tokenType == OCTokenTypes.DIV || tokenType == OCTokenTypes.EOL_ESCAPE || OCTokenTypes.WHITESPACES.contains(tokenType) || tokenType == OCTokenTypes.LPAR || tokenType == OCTokenTypes.RPAR && parsNesting > 1) {
            if (tokenType == OCTokenTypes.LPAR) {
                ++parsNesting;
            } else if (tokenType == OCTokenTypes.RPAR) {
                --parsNesting;
            }
            name2.append(LexerUtil.getTokenText((Lexer)lexer).toString());
            if (this.myAddTokensFromDirective) {
                this.advanceLexer(lexer);
            } else {
                this.skipAsComment(lexer);
            }
            tokenType = lexer.getTokenType();
        }
        if (inAnglePars) {
            name2.append(">");
        }
        if (!this.myAddTokensFromDirective) {
            if (this.myIncludeAnchor != null) {
                VirtualFile file;
                String nameWithoutMacros = this.preprocess(name2, PreprocessingMode.DIRECTIVE_CONTENTS);
                OCIncludeSymbol.IncludePath path = OCInclusionContext.extractPath(nameWithoutMacros, true);
                VirtualFile virtualFile = file = next ? this.myState.resolveNextPath(path, this.myIncludeAnchor) : this.myState.resolvePath(path, this.myIncludeAnchor);
                if (file != null && file.exists()) {
                    this.addToken(OCTokenTypes.FAKE_TRUE);
                } else {
                    this.addToken(OCTokenTypes.FAKE_FALSE);
                }
            } else {
                this.addToken(OCTokenTypes.FAKE_FALSE);
            }
        }
        this.skipWhitespaces(lexer);
        if (inAnglePars && lexer.getTokenType() == OCTokenTypes.GT) {
            this.skipAsComment(lexer);
        }
        this.skipWhitespaces(lexer);
        if (parsNesting > 0 && lexer.getTokenType() == OCTokenTypes.RPAR) {
            this.skipAsComment(lexer);
        }
    }

    private void processDefinedFunction(Lexer lexer) {
        IElementType tokenType;
        if (this.myAddTokensFromDirective) {
            this.advanceLexer(lexer);
        } else {
            this.skipAsComment(lexer);
        }
        this.skipWhitespaces(lexer);
        boolean inPars = false;
        if (lexer.getTokenType() == OCTokenTypes.LPAR) {
            this.advanceLexer(lexer);
            this.skipWhitespaces(lexer);
            inPars = true;
        }
        if ((tokenType = lexer.getTokenType()) == OCTokenTypes.IDENTIFIER || OCTokenTypes.KEYWORDS.contains(tokenType)) {
            String macro = LexerUtil.getTokenText((Lexer)lexer).toString();
            if (this.myAddTokensFromDirective) {
                this.advanceLexer(lexer);
            } else {
                this.skipAsComment(lexer);
                this.addToken(lexer.getTokenStart(), this.myState.isDefined(macro) ? OCTokenTypes.FAKE_TRUE : OCTokenTypes.FAKE_FALSE);
            }
        }
        this.skipWhitespaces(lexer);
        if (inPars && lexer.getTokenType() == OCTokenTypes.RPAR) {
            this.advanceLexer(lexer);
        }
    }

    private void skipWhitespaces(Lexer lexer) {
        while (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(lexer.getTokenType())) {
            this.skipAsComment(lexer);
        }
    }

    private void processIfDirective(Lexer lexer, Function<CharSequence, Boolean> decisionEvaluator) {
        this.advanceLexer(lexer);
        if (OCPreprocessingLexer.atDirectiveContent(lexer)) {
            CharSequence content = LexerUtil.getTokenText((Lexer)lexer);
            boolean decision = (Boolean)decisionEvaluator.fun((Object)content);
            boolean dontSubstituteFirst = decisionEvaluator == this.IFDEF_EVAL || decisionEvaluator == this.IFNDEF_EVAL;
            this.myInsideIfCondition = true;
            this.addTokensFromDirective(lexer, content, dontSubstituteFirst, true);
            this.myInsideIfCondition = false;
            if (decision) {
                this.processConditionals(lexer);
                IElementType tt = lexer.getTokenType();
                if (tt == OCTokenTypes.ELSE_DIRECTIVE || tt == OCTokenTypes.ELIF_DIRECTIVE) {
                    this.skipDirectiveWithContent(lexer);
                    this.skipConditionals(lexer, false);
                }
            } else {
                this.skipConditionals(lexer, true);
                IElementType tt = lexer.getTokenType();
                if (tt == OCTokenTypes.ELSE_DIRECTIVE) {
                    this.skipDirectiveWithContent(lexer);
                    this.processConditionals(lexer);
                } else if (tt == OCTokenTypes.ELIF_DIRECTIVE) {
                    this.processIfDirective(lexer, this.IF_EVAL);
                    return;
                }
            }
            if (lexer.getTokenType() == OCTokenTypes.ENDIF_DIRECTIVE) {
                this.processBaseDirective(lexer, 8);
            }
        } else {
            this.addToken(lexer.getTokenStart(), OCTokenTypes.END_OF_DIRECTIVE_CONTENT);
        }
    }

    private static boolean atDirectiveContent(Lexer lexer) {
        IElementType tt = lexer.getTokenType();
        return tt == OCTokenTypes.DIRECTIVE_CONTENT || tt == OCTokenTypes.PRAGMA_DIRECTIVE_CONTENT || tt == OCTokenTypes.INCLUDE_DIRECTIVE_CONTENT;
    }

    private void skipDirectiveWithContent(Lexer lexer) {
        IElementType tt = lexer.getTokenType();
        this.advanceLexer(lexer);
        if (OCPreprocessingLexer.atDirectiveContent(lexer)) {
            CharSequence content = LexerUtil.getTokenText((Lexer)lexer);
            if (tt == OCTokenTypes.ELIF_DIRECTIVE) {
                this.myInsideIfCondition = true;
                this.addTokensFromDirective(lexer, content, false, true);
                this.myInsideIfCondition = false;
            } else {
                this.adjustLineCount(content);
                this.advanceLexer(lexer);
            }
        } else {
            this.addToken(lexer.getTokenStart(), OCTokenTypes.END_OF_DIRECTIVE_CONTENT);
        }
    }

    private void processConditionals(Lexer lexer) {
        IElementType tt;
        while ((tt = lexer.getTokenType()) != null && !OCTokenTypes.END_IF_DIRECTIVES.contains(tt)) {
            this.lookAhead(lexer);
        }
    }

    private void skipConditionals(Lexer lexer, boolean stopOnElse) {
        IElementType tt;
        int nesting = 1;
        while (OCTokenTypes.WHITESPACES.contains(lexer.getTokenType())) {
            this.adjustLineCount(LexerUtil.getTokenText((Lexer)lexer));
            this.advanceAs(lexer, TokenType.WHITE_SPACE);
        }
        LexerPosition beforeEnd = null;
        while ((tt = lexer.getTokenType()) != null) {
            if (tt == OCTokenTypes.IF_DIRECTIVE || tt == OCTokenTypes.IFDEF_DIRECTIVE || tt == OCTokenTypes.IFNDEF_DIRECTIVE) {
                ++nesting;
            } else if (stopOnElse && (tt == OCTokenTypes.ELIF_DIRECTIVE || tt == OCTokenTypes.ELSE_DIRECTIVE) || tt == OCTokenTypes.ENDIF_DIRECTIVE) {
                if (--nesting == 0) break;
                if (tt != OCTokenTypes.ENDIF_DIRECTIVE) {
                    ++nesting;
                }
            }
            if (OCTokenTypes.WHITESPACES.contains(tt)) {
                this.adjustLineCount(LexerUtil.getTokenText((Lexer)lexer));
            } else {
                beforeEnd = lexer.getCurrentPosition();
            }
            lexer.advance();
        }
        if (beforeEnd != null) {
            lexer.restore(beforeEnd);
            this.advanceAs(lexer, OCTokenTypes.CONDITIONALLY_NON_COMPILED_COMMENT);
        }
        while (OCTokenTypes.WHITESPACES.contains(lexer.getTokenType())) {
            this.advanceAs(lexer, TokenType.WHITE_SPACE);
        }
    }

    private boolean evaluate(CharSequence expr) {
        OCExpression expression;
        IElementType tt;
        OCPreprocessingLexer lexer = new OCPreprocessingLexer(this.myState.deriveButDontCopyTypes(false), this.myFile, true, 0, 0, this.myTotalMacroSubstitutionsCnt, this.myIncludePreprocessingMode, this.getLineCountCopy(), null, false, false);
        lexer.myIncludeAnchor = this.myIncludeAnchor;
        StringBuilder subst = new StringBuilder();
        lexer.start(expr, 0, expr.length(), 8);
        while ((tt = lexer.getTokenType()) != null) {
            if (tt == OCTokenTypes.FAKE_TRUE || tt == OCTokenTypes.TRUE_CPP_KEYWORD) {
                subst.append("1");
            } else if (tt == OCTokenTypes.FAKE_FALSE) {
                subst.append("0");
            } else if (tt != OCTokenTypes.BLOCK_COMMENT) {
                if (tt instanceof TokenWrapper) {
                    ForeignLeafType wrapper;
                    IElementType delegate;
                    if (tt instanceof ForeignLeafType && !((delegate = (wrapper = (ForeignLeafType)tt).getDelegate()) instanceof TokenWrapper)) {
                        if (delegate == OCTokenTypes.FAKE_TRUE || delegate == OCTokenTypes.TRUE_CPP_KEYWORD) {
                            subst.append("1");
                        } else if (delegate == OCTokenTypes.FAKE_FALSE || delegate == OCTokenTypes.IDENTIFIER || OCTokenTypes.KEYWORDS.contains(delegate)) {
                            subst.append("0");
                        } else {
                            subst.append(wrapper.getValue());
                        }
                    }
                } else if (tt == OCTokenTypes.IDENTIFIER || OCTokenTypes.KEYWORDS.contains(tt)) {
                    subst.append("0");
                } else {
                    subst.append(lexer.getTokenText());
                }
            }
            lexer.advance();
        }
        try {
            String substTrimmed = subst.toString().trim();
            if (substTrimmed.isEmpty()) {
                return false;
            }
            Project project2 = this.myState.getProject();
            expression = (OCExpression)PsiTreeUtil.getChildOfType((PsiElement)OCElementFactory.expressionCodeFragment(substTrimmed, project2, null, false, false, OCLanguageKind.C), OCExpression.class);
            if (expression == null) {
                return false;
            }
        }
        catch (Throwable t) {
            return false;
        }
        Number value = OCExpressionEvaluator.evaluate(expression);
        return value != null && OCExpressionEvaluator.singAsInC(value) != 0;
    }

    @NotNull
    private Ref<Long> getLineCountCopy() {
        Ref ref = new Ref(this.myLineCount.get());
        if (ref == null) {
            OCPreprocessingLexer.$$$reportNull$$$0(17);
        }
        return ref;
    }

    private void processIncludeDirective(Lexer baseLexer, boolean isImport, boolean isNext) {
        List<String> namespace;
        ProgressManager.checkCanceled();
        if (this.myBraceStack == null) {
            this.advanceLexer(baseLexer);
            return;
        }
        boolean inSafeForIncludeBlock = this.isInSafeForIncludeBlock();
        List<String> localStackNamespace = null;
        Lexer suffixLexer = null;
        if (inSafeForIncludeBlock && !(namespace = this.myState.getCurrentNamespace()).isEmpty()) {
            int nsCount = 0;
            ArrayList<String> localOpener = new ArrayList<String>();
            for (BraceState state : this.myBraceStack) {
                if (!(state instanceof NamespaceBraceState)) continue;
                NamespaceBraceState ns = (NamespaceBraceState)state;
                nsCount += ns.myNamespace.size();
                localOpener.add(StringUtil.join((Collection)ns.myNamespace, (String)"::"));
            }
            OCLog.LOG.assertTrue(namespace.size() >= nsCount);
            int localNSStart = namespace.size() - nsCount;
            localStackNamespace = namespace.subList(localNSStart, namespace.size());
            ArrayList<String> openerNS = new ArrayList<String>(namespace.subList(0, localNSStart));
            openerNS.addAll(localOpener);
            suffixLexer = OCPreprocessingLexer.createNamespaceAdjustmentOpener(openerNS);
            StringBuilder closer = new StringBuilder("\n");
            for (int i = 0; i < openerNS.size(); ++i) {
                closer.append("}");
            }
            this.addAllTokensAsSynthetic(OCPreprocessingLexer.createAdjustmentLexer(closer.toString()), baseLexer.getTokenStart());
        }
        this.advanceLexer(baseLexer);
        if (OCPreprocessingLexer.atDirectiveContent(baseLexer)) {
            CharSequence content = LexerUtil.getTokenText((Lexer)baseLexer);
            boolean hasPathLiteral = this.addTokensFromDirective(baseLexer, content, false, false, 10, false, OCTokenTypes.HEADER_PATH_LITERAL, null);
            String contextWithoutMacrosAndEOLEsc = this.preprocess(content.toString(), PreprocessingMode.DIRECTIVE_CONTENTS);
            String pathLiteralFromSubst = OCInclusionContext.extractFirstPathLiteralText(contextWithoutMacrosAndEOLEsc);
            if (!hasPathLiteral && pathLiteralFromSubst != null) {
                this.addToken(baseLexer.getTokenStart(), (IElementType)new OCMacroForeignLeafType(OCTokenTypes.HEADER_PATH_LITERAL, pathLiteralFromSubst, null, -1, null, 0));
            }
            if (this.myIncludeAnchor != null) {
                VirtualFile vFile;
                OCIncludeSymbol.IncludePath pathInfo = OCInclusionContext.extractPath(pathLiteralFromSubst, true);
                VirtualFile virtualFile = vFile = isNext ? this.myState.resolveNextPath(pathInfo, this.myIncludeAnchor) : this.myState.resolvePath(pathInfo, this.myIncludeAnchor);
                if (vFile != null && vFile.isValid()) {
                    PsiFile resolved;
                    PsiFile psiFile = resolved = this.myFile == null ? null : this.myFile.getManager().findFile(vFile);
                    if (!(resolved == null || this.myIncludePreprocessingMode != IncludePreprocessingMode.FORCE_PREPROCESSING && SymbolTableProvider.isSourceFile(resolved) && inSafeForIncludeBlock)) {
                        if (!OCCodeInsightUtil.isCodeInsightAvailable(resolved)) {
                            this.addToken(baseLexer.getTokenStart(), (IElementType)new OCMacroForeignLeafType(OCTokenTypes.HEADER_TOO_LONG_INLINED_PATH_LITERAL, pathLiteralFromSubst + ":" + resolved.getTextLength(), null, -1, null, 0));
                        } else if (this.myIncludeLevel < OCInclusionContext.getMaxInclusionLevel(this.myState.getProject()) && this.myState.reserveInclude(vFile, isImport) && this.myProcessingFiles.get((Object)resolved) < 10) {
                            IElementType type;
                            this.addToken(baseLexer.getTokenStart(), (IElementType)new OCMacroForeignLeafType(OCTokenTypes.HEADER_INLINED_PATH_LITERAL, pathLiteralFromSubst, null, -1, null, 0));
                            this.addToken(baseLexer.getTokenStart(), OCTokenTypes.END_OF_DIRECTIVE_CONTENT);
                            this.myProcessingFiles.put((Object)resolved, this.myProcessingFiles.get((Object)resolved) + 1);
                            VirtualFile includer = OCInclusionContextUtil.getVirtualFile(this.myIncludeAnchor);
                            if (includer != null) {
                                OCImportGraph.addHeaderIncluder(this.myIncludeAnchor.getProject(), vFile, includer);
                                this.myState.addProcessedFile(vFile);
                            }
                            OCPreprocessingLexer substLexer = new OCPreprocessingLexer(this.myState, this.myFile, this.myEvalDefinedFunction, this.myMacroLevel, this.myIncludeLevel + 1, this.myTotalMacroSubstitutionsCnt, this.myIncludePreprocessingMode, (Ref<Long>)Ref.create((Object)1L), this.myCounterMacroHandler, false, false);
                            substLexer.myCurrentFile = vFile;
                            substLexer.myIncludeAnchor = resolved;
                            substLexer.myProcessingFiles = this.myProcessingFiles;
                            substLexer.myBraceStack = this.myBraceStack;
                            substLexer.myInsideIfCondition = this.myInsideIfCondition;
                            substLexer.start(resolved.getText());
                            int offsetInSubstitution = 0;
                            boolean previousWhitespace = false;
                            while ((type = substLexer.getTokenType()) != null) {
                                if (type instanceof ForeignLeafType) {
                                    if (type instanceof OCMacroForeignLeafType) {
                                        ((OCMacroForeignLeafType)type).plungeIntoSubstitution(offsetInSubstitution);
                                    }
                                    this.addToken(baseLexer.getTokenStart(), type);
                                    ++offsetInSubstitution;
                                    previousWhitespace = false;
                                } else if (!OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(type)) {
                                    CharSequence tokenText = LexerUtil.getTokenText((Lexer)substLexer);
                                    this.addToken(baseLexer.getTokenStart(), (IElementType)new OCMacroForeignLeafType(type, tokenText, pathLiteralFromSubst, -1, null, offsetInSubstitution));
                                    ++offsetInSubstitution;
                                    previousWhitespace = false;
                                } else if (!previousWhitespace) {
                                    this.addToken(baseLexer.getTokenStart(), (IElementType)new OCMacroForeignLeafType(TokenType.WHITE_SPACE, " ", pathLiteralFromSubst, -1, null, offsetInSubstitution));
                                    ++offsetInSubstitution;
                                    previousWhitespace = true;
                                }
                                substLexer.advance();
                            }
                            return;
                        }
                    } else if (resolved instanceof OCFile && this.myIncludePreprocessingMode == IncludePreprocessingMode.USE_SYMBOL_TABLE) {
                        if (localStackNamespace != null) {
                            this.addToken(baseLexer.getTokenStart(), (IElementType)new OCInnerIncludeElementType(contextWithoutMacrosAndEOLEsc, localStackNamespace));
                        }
                        OCFile file = (OCFile)resolved;
                        file.markIncludedFrom(this.myFile);
                        this.myState.preprocessInclude(file, isImport, null, this.myIncludeLevel, baseLexer.getTokenStart(), this.myChangeSet);
                    }
                }
            }
        }
        this.addToken(baseLexer.getTokenStart(), OCTokenTypes.END_OF_DIRECTIVE_CONTENT);
        if (suffixLexer != null) {
            this.addAllTokensAsSynthetic(suffixLexer, baseLexer.getTokenStart());
        }
    }

    public boolean isInSafeForIncludeBlock() {
        OCLog.LOG.assertTrue(this.myBraceStack != null, (Object)"brace stack is null");
        for (BraceState state : this.myBraceStack) {
            if (state.isSafeForInclude()) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private List<String> buildSubstitutionArguments(Lexer baseLexer) {
        ArrayList<String> args = new ArrayList<String>();
        LexerPosition pos = baseLexer.getCurrentPosition();
        while (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(baseLexer.getTokenType())) {
            baseLexer.advance();
        }
        int level = 0;
        int templateLevel = 0;
        if (baseLexer.getTokenType() == OCTokenTypes.LPAR) {
            baseLexer.restore(pos);
            this.skipWhitespacesAndCommentByAdvance(baseLexer);
            this.skipMacroToken(baseLexer, false, false);
            StringBuilder builder = new StringBuilder();
            int argOffset = -1;
            LexerPosition restorePosition = null;
            int resetSize = 0;
            int builderLength = 0;
            while (true) {
                IElementType tt;
                if ((tt = baseLexer.getTokenType()) == null) {
                    if (restorePosition == null) break;
                    baseLexer.restore(restorePosition);
                    this.resetCacheSize(resetSize);
                    builder.setLength(builderLength);
                    break;
                }
                if (tt == OCTokenTypes.TEMPLATE_START_MARK) {
                    ++templateLevel;
                }
                if (tt == OCTokenTypes.TEMPLATE_STOP_MARK) {
                    --templateLevel;
                }
                if (tt == OCTokenTypes.RPAR && level == 0 && templateLevel == 0) break;
                if (tt == OCTokenTypes.COMMA && level == 0 && templateLevel == 0) {
                    args.add(builder.toString());
                    builder.setLength(0);
                    argOffset = -1;
                    this.skipMacroToken(baseLexer, false, false);
                    continue;
                }
                if (tt == OCTokenTypes.LPAR && templateLevel == 0) {
                    ++level;
                } else if (tt == OCTokenTypes.RPAR && templateLevel == 0) {
                    --level;
                } else if (restorePosition == null && (tt == OCTokenTypes.LBRACE || tt == OCTokenTypes.RBRACE || tt == OCTokenTypes.SEMICOLON)) {
                    resetSize = this.getCacheSize();
                    restorePosition = baseLexer.getCurrentPosition();
                    builderLength = builder.length();
                }
                if (argOffset == -1) {
                    argOffset = baseLexer.getTokenStart();
                }
                if (tt != OCTokenTypes.EOL_ESCAPE) {
                    CharSequence text;
                    if (OCTokenTypes.COMMENTS.contains(tt)) {
                        text = " ";
                    } else {
                        text = LexerUtil.getTokenText((Lexer)baseLexer);
                        if (StringUtil.equals((CharSequence)LINE_MACRO, (CharSequence)text)) {
                            text = LINE_MACRO_STUB_START + String.valueOf(this.myLineCount.get());
                        }
                    }
                    builder.append(text);
                }
                this.skipMacroToken(baseLexer, true, false);
            }
            args.add(builder.toString());
            this.skipMacroToken(baseLexer, false, false);
            return args;
        }
        baseLexer.restore(pos);
        return null;
    }

    private void skipWhitespacesAndCommentByAdvance(@NotNull Lexer baseLexer) {
        if (baseLexer == null) {
            OCPreprocessingLexer.$$$reportNull$$$0(18);
        }
        while (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(baseLexer.getTokenType())) {
            this.skipMacroToken(baseLexer, false, false);
        }
    }

    @Nullable
    private OCMacroReferenceTokenType skipMacroToken(Lexer baseLexer, boolean isParamToken, boolean isRoot) {
        OCMacroReferenceTokenType result = null;
        IElementType baseToken = baseLexer.getTokenType();
        if (baseToken != null) {
            if (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(baseToken)) {
                if (!isRoot) {
                    this.adjustLineCount(LexerUtil.getTokenText((Lexer)baseLexer));
                }
                this.advanceAs(baseLexer, baseToken);
            } else {
                CharSequence text = LexerUtil.getTokenText((Lexer)baseLexer);
                IElementType preprocessed = isRoot && (OCTokenTypes.KEYWORDS.contains(baseToken) || OCPreprocessingLexer.isAlternativeCppPunctuator(baseToken, text)) ? OCTokenTypes.IDENTIFIER : baseToken;
                result = new OCMacroReferenceTokenType(preprocessed, text, isParamToken, this.myMacroLevel, isRoot);
                this.advanceAs(baseLexer, (IElementType)result);
            }
        }
        return result;
    }

    private void skipAsComment(Lexer lexer) {
        this.advanceAs(lexer, OCTokenTypes.BLOCK_COMMENT);
    }

    private void processUndefineDirective(Lexer lexer) {
        this.advanceLexer(lexer);
        if (OCPreprocessingLexer.atDirectiveContent(lexer)) {
            CharSequence contents = LexerUtil.getTokenText((Lexer)lexer);
            this.addTokensFromDirective(lexer, contents, true, false);
            OCLexer l = new OCLexer(OCLexerSettings.forLanguage(OCLanguageKind.CPP).build());
            l.start(contents);
            while (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(l.getTokenType())) {
                l.advance();
            }
            if (l.getTokenType() == OCTokenTypes.IDENTIFIER) {
                this.myState.undef(LexerUtil.getTokenText((Lexer)l).toString());
            }
        } else {
            this.addToken(lexer.getTokenStart(), OCTokenTypes.END_OF_DIRECTIVE_CONTENT);
        }
    }

    private void processDefineDirective(Lexer baseLexer) {
        long offset = OCSymbolOffsetUtil.getComplexOffset(baseLexer.getTokenStart(), 0);
        this.advanceLexer(baseLexer);
        if (OCPreprocessingLexer.atDirectiveContent(baseLexer)) {
            CharSequence content = LexerUtil.getTokenText((Lexer)baseLexer);
            BiFunction<IElementType, Lexer, IElementType> tokenMapper = null;
            OCMacroSymbol def = OCMacroSymbol.parseFromDirectiveContent(content, this.myFile, offset, this.myState.getProject());
            if (def != null) {
                OCImmutableList<String> parameterNames = def.getParameterNames();
                tokenMapper = OCPreprocessingLexer.createMacroTokenMapper(parameterNames);
            }
            this.addTokensFromDirective(baseLexer, content, true, false, 8, true, null, tokenMapper);
            if (def != null) {
                this.myState.define(def);
            }
        } else {
            this.addToken(baseLexer.getTokenStart(), OCTokenTypes.END_OF_DIRECTIVE_CONTENT);
        }
    }

    @NotNull
    private static BiFunction<IElementType, Lexer, IElementType> createMacroTokenMapper(@NotNull Collection<String> parameterNames) {
        if (parameterNames == null) {
            OCPreprocessingLexer.$$$reportNull$$$0(19);
        }
        BiFunction<IElementType, Lexer, IElementType> biFunction = (type, lexer) -> {
            String tokenText;
            if (parameterNames == null) {
                OCPreprocessingLexer.$$$reportNull$$$0(34);
            }
            if (OCTokenTypes.UDL_SUFFIX == type && (parameterNames.contains(tokenText = lexer.getTokenText()) || parameterNames.contains(tokenText + ELLIPSIS))) {
                return OCTokenTypes.IDENTIFIER;
            }
            return type;
        };
        if (biFunction == null) {
            OCPreprocessingLexer.$$$reportNull$$$0(20);
        }
        return biFunction;
    }

    private void addTokensFromDirective(@NotNull Lexer lexer, @NotNull CharSequence content, boolean processFirstIdAsDeclaredMacroId, boolean evalDefined) {
        if (lexer == null) {
            OCPreprocessingLexer.$$$reportNull$$$0(21);
        }
        if (content == null) {
            OCPreprocessingLexer.$$$reportNull$$$0(22);
        }
        this.addTokensFromDirective(lexer, content, processFirstIdAsDeclaredMacroId, evalDefined, 8, true, null, null);
    }

    private boolean addTokensFromDirective(@NotNull Lexer baseLexer, @NotNull CharSequence content, boolean processFirstIdAsDeclaredMacroId, boolean evalDefined, int initialState, boolean addEndDirectiveToken, @Nullable IElementType typeToCheck, @Nullable BiFunction<IElementType, Lexer, IElementType> tokenMapper) {
        if (baseLexer == null) {
            OCPreprocessingLexer.$$$reportNull$$$0(23);
        }
        if (content == null) {
            OCPreprocessingLexer.$$$reportNull$$$0(24);
        }
        OCPreprocessingLexer lexer = new OCPreprocessingLexer(this.myState, this.myFile, evalDefined, 0, 0, this.myTotalMacroSubstitutionsCnt, this.myIncludePreprocessingMode, this.myLineCount, this.myCounterMacroHandler, processFirstIdAsDeclaredMacroId, true);
        lexer.myInsideIfCondition = this.myInsideIfCondition;
        lexer.start(content, 0, content.length(), initialState);
        int tokenStart = baseLexer.getTokenStart();
        boolean typeToCheckWasFound = false;
        while (lexer.getTokenType() != null) {
            Object mappedToken;
            IElementType originToken = lexer.getTokenType();
            typeToCheckWasFound |= typeToCheck == originToken;
            if (originToken == OCTokenTypes.PRAGMA_ONCE_LITERAL) {
                VirtualFile virtualFile;
                VirtualFile virtualFile2 = virtualFile = this.myCurrentFile == null ? OCInclusionContextUtil.getVirtualFile(this.myFile) : this.myCurrentFile;
                if (virtualFile != null && virtualFile.isValid()) {
                    String pragmaId = OCInclusionContextUtil.pragmaOnceId(virtualFile);
                    if (!this.myState.isDefined(pragmaId)) {
                        this.myState.define(OCMacroSymbol.inclusionGuard(pragmaId, this.myState.getProject()));
                    }
                } else {
                    virtualFile = null;
                }
                mappedToken = new OCPragmaOnceContentElementType(virtualFile);
            } else {
                mappedToken = OCTokenTypes.KEYWORDS.contains(originToken) ? OCTokenTypes.IDENTIFIER : (tokenMapper != null ? tokenMapper.apply(originToken, (Lexer)lexer) : originToken);
            }
            this.addToken(tokenStart + lexer.getTokenEnd(), (IElementType)mappedToken);
            lexer.advance();
        }
        if (addEndDirectiveToken) {
            this.addToken(baseLexer.getTokenEnd(), OCTokenTypes.END_OF_DIRECTIVE_CONTENT);
        }
        baseLexer.advance();
        return typeToCheckWasFound;
    }

    @NotNull
    public OCInclusionContext getContext() {
        OCInclusionContext oCInclusionContext = this.myState;
        if (oCInclusionContext == null) {
            OCPreprocessingLexer.$$$reportNull$$$0(25);
        }
        return oCInclusionContext;
    }

    @Nullable
    public OCFile getFile() {
        return this.myFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processMacroSubstitution(Lexer baseLexer, OCMacroSymbol macro, boolean advanceBaseLexer) {
        OCMacroSymbol possibleMacro;
        SubstitutionResult subst;
        ProgressManager.checkCanceled();
        this.myTotalMacroSubstitutionsCnt.set((Object)((Integer)this.myTotalMacroSubstitutionsCnt.get() + 1));
        String id = macro.getName();
        LexerPosition pos = baseLexer.getCurrentPosition();
        if (advanceBaseLexer) {
            baseLexer.advance();
        }
        while (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(baseLexer.getTokenType())) {
            baseLexer.advance();
        }
        boolean hasArgs = baseLexer.getTokenType() == OCTokenTypes.LPAR;
        baseLexer.restore(pos);
        if (macro.hasParameterList() && !hasArgs) {
            if (advanceBaseLexer) {
                this.advanceLexer(baseLexer);
            }
            return false;
        }
        if (advanceBaseLexer) {
            this.skipMacroToken(baseLexer, false, true);
        }
        OCImmutableList<String> params = macro.getParameterNames();
        List<String> args = macro.hasParameterList() ? this.buildSubstitutionArguments(baseLexer) : null;
        if ((Integer)this.myTotalMacroSubstitutionsCnt.get() > 200000) {
            return true;
        }
        if (this.myAddTokensFromDirective && !this.myInsideIfCondition) {
            return true;
        }
        Map<String, String> paramSubst = OCPreprocessingLexer.buildParameterSubstitutionMap(id, params, args);
        if (paramSubst == null) {
            subst = new SubstitutionResult();
            subst.append(id);
        } else {
            subst = this.substitute(macro, (List<String>)((Object)params), OCPreprocessingLexer.buildParamIndices(params), paramSubst);
        }
        ForeignLeafType lastToken = null;
        String lastTokenName = null;
        int lastCacheSize = 0;
        this.hideDefinition(id);
        try {
            OCPreprocessingLexer substLexer = new OCPreprocessingLexer(this.myState, this.myFile, this.myEvalDefinedFunction, this.myMacroLevel + 1, this.myIncludeLevel, this.myTotalMacroSubstitutionsCnt, this.myIncludePreprocessingMode, this.getLineCountCopy(), this.getCounterTracker(), false, false);
            substLexer.myInsideIfCondition = this.myInsideIfCondition;
            String substString = subst.getString();
            substLexer.start(substString, 0, substString.length(), 8);
            List<Pair<Integer, TextRange>> substitutions = subst.getSubstitutions();
            int curSubstitutionIndex = 0;
            int offsetInSubstitution = 0;
            while (true) {
                TextRange range;
                ProgressManager.checkCanceled();
                IElementType type = substLexer.getTokenType();
                if (type == null) {
                    break;
                }
                Pair<Integer, TextRange> curSubstitution = curSubstitutionIndex < substitutions.size() ? substitutions.get(curSubstitutionIndex) : null;
                TextRange textRange = range = curSubstitution != null ? (TextRange)curSubstitution.getSecond() : null;
                if (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(type)) {
                    this.addToken(baseLexer.getTokenStart(), type);
                } else if (type instanceof ForeignLeafType) {
                    if (type instanceof OCMacroForeignLeafType) {
                        ((OCMacroForeignLeafType)type).plungeIntoSubstitution(offsetInSubstitution);
                    }
                    this.updateBraceStack(((ForeignLeafType)type).getDelegate(), ((ForeignLeafType)type).getValue());
                    lastCacheSize = this.getCacheSize();
                    lastTokenName = ((ForeignLeafType)type).getValue();
                    lastToken = (ForeignLeafType)type;
                    this.addToken(baseLexer.getTokenStart(), type);
                    ++offsetInSubstitution;
                } else {
                    CharSequence tokenText = LexerUtil.getTokenText((Lexer)substLexer);
                    int macroArgumentIndex = -1;
                    TextRange rangeInMacroArgument = null;
                    if (range != null && substLexer.getTokenStart() >= range.getStartOffset()) {
                        if (curSubstitution.getFirst() != null) {
                            macroArgumentIndex = (Integer)curSubstitution.getFirst();
                        }
                        rangeInMacroArgument = new TextRange(substLexer.getTokenStart() - range.getStartOffset(), substLexer.getTokenEnd() - range.getStartOffset());
                    }
                    lastTokenName = tokenText.toString();
                    this.updateBraceStack(type, lastTokenName);
                    lastCacheSize = this.getCacheSize();
                    lastToken = new OCMacroForeignLeafType(type, tokenText, id, macroArgumentIndex, rangeInMacroArgument, offsetInSubstitution);
                    this.addToken(baseLexer.getTokenStart(), (IElementType)lastToken);
                    ++offsetInSubstitution;
                }
                substLexer.advance();
                if (range == null || substLexer.getTokenStart() < range.getEndOffset()) continue;
                ++curSubstitutionIndex;
            }
        }
        finally {
            this.revealDefinition(id);
        }
        if (lastTokenName != null && (possibleMacro = this.myState.getDefinition(lastTokenName)) != null && possibleMacro.hasParameterList() && possibleMacro != macro && this.processMacroSubstitution(baseLexer, possibleMacro, false)) {
            OCMacroForeignLeafType wrapped;
            OCMacroReferenceTokenType type = new OCMacroReferenceTokenType(lastToken.getDelegate(), lastTokenName, false, this.myMacroLevel, true);
            if (lastToken instanceof OCMacroForeignLeafType) {
                OCMacroForeignLeafType token = (OCMacroForeignLeafType)lastToken;
                wrapped = new OCMacroForeignLeafType((IElementType)type, lastTokenName, token.getMacroName(), lastToken.getIndex(), token.getRangeInMacroArgument(), token.getOffsetInTopSubstitution());
            } else {
                wrapped = new OCMacroForeignLeafType((IElementType)type, lastTokenName, null, 0, TextRange.EMPTY_RANGE, 0);
            }
            this.replaceCachedType(lastCacheSize, (IElementType)wrapped);
        }
        return true;
    }

    void revealDefinition(@NotNull String name2) {
        if (name2 == null) {
            OCPreprocessingLexer.$$$reportNull$$$0(26);
        }
        this.myState.revealDefinition(name2);
    }

    void hideDefinition(@NotNull String name2) {
        if (name2 == null) {
            OCPreprocessingLexer.$$$reportNull$$$0(27);
        }
        this.myState.hideDefinition(name2);
    }

    String preprocess(@NotNull CharSequence text, @NotNull PreprocessingMode mode) {
        IElementType tokenType;
        if (text == null) {
            OCPreprocessingLexer.$$$reportNull$$$0(28);
        }
        if (mode == null) {
            OCPreprocessingLexer.$$$reportNull$$$0(29);
        }
        OCPreprocessingLexer lexer = new OCPreprocessingLexer(this.myState, this.myFile, false, 0, 0, this.myTotalMacroSubstitutionsCnt, IncludePreprocessingMode.FORCE_PREPROCESSING, this.getLineCountCopy(), this.getCounterTracker(), false, false);
        if (mode == PreprocessingMode.FILE) {
            lexer.myBraceStack = new Stack();
        }
        lexer.start(text, 0, text.length(), mode == PreprocessingMode.FILE ? 0 : 1024);
        StringBuilder result = new StringBuilder();
        if (mode == PreprocessingMode.FIRST_MACRO_ARG || mode == PreprocessingMode.OTHER_MACRO_ARGS) {
            boolean hasLeadingWS = false;
            while (OCTokenTypes.WHITESPACES.contains(lexer.getTokenType())) {
                hasLeadingWS = true;
                lexer.advance();
            }
            if (hasLeadingWS && mode == PreprocessingMode.OTHER_MACRO_ARGS) {
                result.append(" ");
            }
        }
        int parenCount = 0;
        int directiveDepth = 0;
        int macroDepth = 0;
        boolean inMacro = false;
        while ((tokenType = lexer.getTokenType()) != null) {
            while (tokenType instanceof OCMacroForeignLeafType) {
                tokenType = ((OCMacroForeignLeafType)tokenType).getDelegate();
            }
            if (tokenType == OCTokenTypes.DEFINE_DIRECTIVE) {
                inMacro = true;
                macroDepth = directiveDepth++;
            } else if (OCTokenTypes.DIRECTIVES.contains(tokenType)) {
                ++directiveDepth;
            } else if (OCParsing.isEndOfDirective(tokenType)) {
                if (--directiveDepth == macroDepth) {
                    inMacro = false;
                }
            } else if (OCTokenTypes.END_IF_DIRECTIVES.contains(tokenType)) {
                --directiveDepth;
            } else if (tokenType instanceof OCMacroReferenceTokenType) {
                IElementType delegate = tokenType;
                while (delegate instanceof OCMacroReferenceTokenType) {
                    delegate = ((OCMacroReferenceTokenType)delegate).getDelegate();
                }
                if (delegate == OCTokenTypes.LPAR) {
                    ++parenCount;
                } else if (delegate == OCTokenTypes.RPAR) {
                    --parenCount;
                }
            } else if (parenCount == 0 && directiveDepth == 0 && !inMacro && !SKIP_TOKENS.contains(tokenType)) {
                String tokenText = OCPreprocessingLexer.getPreprocessedTokenText((Lexer)lexer, mode != PreprocessingMode.DIRECTIVE_CONTENTS);
                result.append(tokenText);
            }
            lexer.advance();
        }
        return result.toString();
    }

    private static String getPreprocessedTokenText(Lexer lexer, boolean skipComments) {
        IElementType tokenType = lexer.getTokenType();
        if (tokenType instanceof TokenWrapper) {
            return ((TokenWrapper)tokenType).getValue();
        }
        if (skipComments && OCTokenTypes.COMMENTS.contains(tokenType)) {
            return "";
        }
        String text = lexer.getBufferSequence().subSequence(lexer.getTokenStart(), lexer.getTokenEnd()).toString();
        if (tokenType == TokenType.WHITE_SPACE && StringUtil.isEmpty((String)text)) {
            return " ";
        }
        return text;
    }

    private SubstitutionResult substitute(OCMacroSymbol macro, List<String> params, Map<String, Integer> paramIndices, Map<String, String> paramSubst) {
        int curValue;
        String substitution = LINE_MACRO.equals(macro.getName()) ? String.valueOf(this.myLineCount.get()) : macro.getSubstitution();
        THashMap substitutionMap = new THashMap(params.size());
        SubstitutionResult r = OCBoostPPHelper.tryFastSubstitution(this, macro, params, paramIndices, paramSubst, (Map<String, String>)substitutionMap);
        if (r != null) {
            return r;
        }
        OCLexer lexer = new OCLexer(OCLexerSettings.forPreprocessor().build());
        lexer.start(substitution, 0, substitution.length(), 8);
        SubstitutionResult result = new SubstitutionResult();
        boolean haveHashPrefix = false;
        boolean haveHashHashPrefix = false;
        BiFunction<IElementType, Lexer, IElementType> tokenMapper = OCPreprocessingLexer.createMacroTokenMapper(macro.getParameterNames());
        while (lexer.getTokenType() != null) {
            boolean hasSpace;
            String token = LexerUtil.getTokenText((Lexer)lexer).toString();
            IElementType tt = tokenMapper.apply(lexer.getTokenType(), (Lexer)lexer);
            if (tt == OCTokenTypes.HASH) {
                haveHashPrefix = true;
                result.onHashOperator();
                lexer.advance();
                continue;
            }
            if (tt == OCTokenTypes.HASHHASH) {
                haveHashHashPrefix = true;
                lexer.advance();
                continue;
            }
            if (tt == OCTokenTypes.UNKNOWN_DIRECTIVE || tt == OCTokenTypes.IDENTIFIER || OCTokenTypes.KEYWORDS.contains(tt) || OCPreprocessingLexer.isAlternativeCppPunctuator(tt, token)) {
                lexer.advance();
                hasSpace = false;
                while (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(lexer.getTokenType())) {
                    lexer.advance();
                    hasSpace = true;
                }
                boolean substitute = !haveHashHashPrefix && lexer.getTokenType() != OCTokenTypes.HASHHASH;
                boolean hashPrefix = tt == OCTokenTypes.UNKNOWN_DIRECTIVE || haveHashPrefix;
                String tokenText = tt == OCTokenTypes.UNKNOWN_DIRECTIVE ? token.substring(1) : token;
                this.processIndent(paramSubst, paramIndices, result, hashPrefix, substitute, tokenText, (Map<String, String>)substitutionMap);
                if (!hasSpace || lexer.getTokenType() == OCTokenTypes.HASHHASH) continue;
                result.append(" ");
                continue;
            }
            hasSpace = false;
            while (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(lexer.getTokenType())) {
                lexer.advance();
                hasSpace = true;
            }
            if (hasSpace) {
                if (haveHashPrefix || haveHashHashPrefix || lexer.getTokenType() == OCTokenTypes.HASHHASH) continue;
                result.append(" ");
                continue;
            }
            lexer.advance();
            result.append(token);
            haveHashHashPrefix = false;
            haveHashPrefix = false;
        }
        if (COUNTER_MACRO.equals(macro.getName()) && (curValue = StringUtil.parseInt((String)result.getString().trim(), (int)-1)) >= 0) {
            int newCounter = 1 + curValue;
            this.myState.define(new OCMacroSymbol(this.myState.getProject(), null, -1L, COUNTER_MACRO, null, Long.toString(newCounter)));
            if (this.myCounterMacroHandler != null) {
                this.myCounterMacroHandler.onNewValue(newCounter);
            }
        }
        return result;
    }

    String substituteMacroParam(@NotNull Map<String, Integer> paramIndices, @NotNull Map<String, String> paramSubst, @NotNull Map<String, String> substitutionCache, @NotNull String param) {
        if (paramIndices == null) {
            OCPreprocessingLexer.$$$reportNull$$$0(30);
        }
        if (paramSubst == null) {
            OCPreprocessingLexer.$$$reportNull$$$0(31);
        }
        if (substitutionCache == null) {
            OCPreprocessingLexer.$$$reportNull$$$0(32);
        }
        if (param == null) {
            OCPreprocessingLexer.$$$reportNull$$$0(33);
        }
        SubstitutionResult pr = new SubstitutionResult();
        this.processIndent(paramSubst, paramIndices, pr, false, true, param, substitutionCache);
        return pr.getString();
    }

    private void processIndent(Map<String, String> paramSubst, Map<String, Integer> paramIndices, SubstitutionResult result, boolean haveHashPrefix, boolean substitute, String token, Map<String, String> substitutionCache) {
        Integer index;
        String varArgName;
        String subst = paramSubst.get(token);
        if (subst == null) {
            varArgName = token + ELLIPSIS;
            subst = paramSubst.get(varArgName);
            index = paramIndices.get(varArgName);
        } else {
            varArgName = null;
            index = paramIndices.get(token);
        }
        if (subst != null) {
            if (haveHashPrefix) {
                String content = OCPreprocessingLexer.stringify(OCPreprocessingLexer.revertMacroStubs(subst));
                if (index != null) {
                    result.addSubstitution(index, content.length());
                }
                result.append(content);
            } else {
                if (substitute) {
                    if (substitutionCache.containsKey(subst)) {
                        subst = substitutionCache.get(subst);
                    } else {
                        String processed = this.preprocess(subst, PreprocessingMode.FIRST_MACRO_ARG);
                        substitutionCache.put(subst, processed);
                        subst = processed;
                    }
                } else {
                    subst = StringUtil.trimLeading((String)OCPreprocessingLexer.revertMacroStubs(subst));
                    if (varArgName != null && subst.isEmpty()) {
                        result.removeLastComma();
                    }
                }
                if (index != null) {
                    if (varArgName != null) {
                        String curSubst;
                        int newIndex = index;
                        int i = 0;
                        while ((curSubst = paramSubst.get(varArgName + i)) != null) {
                            if (!curSubst.equals(VARARG_MACRO_PARAMS_SEPARATOR)) {
                                result.addSubstitution(newIndex++, curSubst.length());
                            }
                            PreprocessingMode mode = i == 0 ? PreprocessingMode.FIRST_MACRO_ARG : PreprocessingMode.OTHER_MACRO_ARGS;
                            result.append(this.preprocess(curSubst, mode));
                            ++i;
                        }
                    } else {
                        result.addSubstitution(index, subst.length());
                        result.append(subst);
                    }
                } else {
                    result.append(subst);
                }
            }
        } else {
            result.append(token);
        }
    }

    private static String revertMacroStubs(String subst) {
        return OCPreprocessingLexer.lineNumberFromStub(subst) != null ? LINE_MACRO : subst;
    }

    private static String stringify(String source) {
        OCLexer lexer = new OCLexer(OCLexerSettings.forPreprocessor().build());
        lexer.start(source);
        while (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(lexer.getTokenType())) {
            lexer.advance();
        }
        if (lexer.getTokenType() == null) {
            return "\"\"";
        }
        StringBuilder acc = new StringBuilder();
        acc.append("\"");
        boolean wasSpace = false;
        while (lexer.getTokenType() != null) {
            if (wasSpace) {
                acc.append(" ");
            }
            IElementType tt = lexer.getTokenType();
            String content = lexer.getTokenText();
            if (tt == OCTokenTypes.STRING_LITERAL || tt == OCTokenTypes.CHARACTER_LITERAL) {
                content = StringUtil.escapeStringCharacters((String)content);
            }
            acc.append(content);
            lexer.advance();
            wasSpace = false;
            while (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(lexer.getTokenType())) {
                lexer.advance();
                wasSpace = true;
            }
        }
        acc.append("\"");
        return acc.toString();
    }

    private static Map<String, Integer> buildParamIndices(List<String> params) {
        if (params == null || params.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap answer = new HashMap();
        int count = 0;
        for (String param : params) {
            answer.put((Object)param, (Object)count++);
        }
        return answer;
    }

    private static Map<String, String> buildParameterSubstitutionMap(String macroName, List<String> parameterNames, List<String> args) {
        if (args == null || args.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap paramSubst = new HashMap();
        int count = 0;
        for (String name2 : parameterNames) {
            if (name2.endsWith(ELLIPSIS)) {
                StringBuilder opts = new StringBuilder();
                int extraArgsCnt = 0;
                boolean first = true;
                while (count < args.size()) {
                    String argText = args.get(count);
                    if (first) {
                        first = false;
                    } else {
                        opts.append(VARARG_MACRO_PARAMS_SEPARATOR);
                        paramSubst.put(name2 + extraArgsCnt++, VARARG_MACRO_PARAMS_SEPARATOR);
                    }
                    if (count == args.size() - 1) {
                        argText = StringUtil.trimTrailing((String)argText);
                    }
                    opts.append(argText);
                    paramSubst.put(name2 + extraArgsCnt++, argText);
                    ++count;
                }
                paramSubst.put(name2, opts.toString());
                break;
            }
            if (count < args.size()) {
                paramSubst.put(name2, StringUtil.trimTrailing((String)args.get(count)));
            } else if (FORCE_SUBSTITUTION_MACROS.contains(macroName)) {
                paramSubst.put(name2, "");
            } else {
                return null;
            }
            ++count;
        }
        if (!(count >= args.size() || parameterNames.isEmpty() && args.size() == 1 && StringUtil.isEmptyOrSpaces((String)args.get(0)) || FORCE_SUBSTITUTION_MACROS.contains(macroName))) {
            return null;
        }
        return paramSubst;
    }

    @Contract(value="null, _ -> false; _, null -> false")
    public static boolean isAlternativeCppPunctuator(@Nullable IElementType tt, @Nullable CharSequence token) {
        if (token == null) {
            return false;
        }
        String p = OCElementUtil.getAlternativeCppPunctuator(tt);
        return p != null && token.equals(p);
    }

    @Nullable
    private CounterMacroHandler getCounterTracker() {
        return this.myCounterMacroHandler == null ? null : this.myCounterMacroHandler.getTracker();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialSubstitutions";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includePreprocessingMode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineCount";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: 
            case 10: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseLexer";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenText";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/preprocessor/OCPreprocessingLexer";
                break;
            }
            case 19: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterNames";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexer";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramIndices";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramSubst";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutionCache";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "param";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/preprocessor/OCPreprocessingLexer";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createNamespaceAdjustmentLexers";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createNamespaceAdjustmentOpener";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createAdjustmentLexer";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineCountCopy";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createMacroTokenMapper";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createLexerSettings";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lookAhead";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "emitCounterDefinitionIfRequired";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "adjustLineCount";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createNamespaceAdjustmentLexers";
                break;
            }
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 25: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createNamespaceAdjustmentOpener";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "skipWhitespacesAndCommentByAdvance";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createMacroTokenMapper";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addTokensFromDirective";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "revealDefinition";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "hideDefinition";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "preprocess";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "substituteMacroParam";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createMacroTokenMapper$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class SubstitutionResult {
        private StringBuilder myString = new StringBuilder();
        private List<Pair<Integer, TextRange>> mySubstitutions = new ArrayList<Pair<Integer, TextRange>>();

        SubstitutionResult() {
        }

        public String getString() {
            return this.myString.toString();
        }

        public void append(String string) {
            this.myString.append(string);
        }

        private void addSubstitution(int argumentIndex, int substLength) {
            this.mySubstitutions.add((Pair<Integer, TextRange>)new Pair((Object)argumentIndex, (Object)new TextRange(this.myString.length(), this.myString.length() + substLength)));
        }

        public List<Pair<Integer, TextRange>> getSubstitutions() {
            return this.mySubstitutions;
        }

        public void removeLastComma() {
            int lastIndex;
            for (lastIndex = this.myString.length() - 1; lastIndex >= 0 && this.myString.charAt(lastIndex) == ' '; --lastIndex) {
            }
            if (lastIndex >= 0 && this.myString.charAt(lastIndex) == ',') {
                this.myString.setLength(lastIndex);
            }
        }

        public void onHashOperator() {
            int end;
            int scanPos;
            for (scanPos = end = this.myString.length(); scanPos > 0 && Character.isJavaIdentifierPart(this.myString.charAt(scanPos - 1)); --scanPos) {
            }
            if (scanPos != end && OCStringLiteralUtil.isStringLiteralPrefix(this.myString.substring(scanPos, end))) {
                this.myString.append(" ");
            }
        }
    }

    private static final class CounterMacroUpdater
    implements CounterMacroHandler {
        @NotNull
        private final CounterMacroTracker myTracker = new CounterMacroTracker();

        private CounterMacroUpdater() {
        }

        @Override
        public void onNewValue(int newCounter) {
            this.myTracker.onNewValue(newCounter);
        }

        @Override
        public void emitNewDefinitionIfRequired(@NotNull OCPreprocessingLexer pp, @NotNull Lexer baseLexer) {
            int newCounter;
            if (pp == null) {
                CounterMacroUpdater.$$$reportNull$$$0(0);
            }
            if (baseLexer == null) {
                CounterMacroUpdater.$$$reportNull$$$0(1);
            }
            if ((newCounter = this.myTracker.myNewCounter) >= 0) {
                int offset = baseLexer.getTokenStart();
                pp.addToken(offset, (IElementType)CounterMacroUpdater.foreign(TokenType.WHITE_SPACE, "\n", 0));
                pp.addToken(offset, (IElementType)CounterMacroUpdater.foreign(OCTokenTypes.DEFINE_DIRECTIVE, "#define", 1));
                pp.addToken(offset, (IElementType)CounterMacroUpdater.foreign(TokenType.WHITE_SPACE, " ", 2));
                pp.addToken(offset, (IElementType)CounterMacroUpdater.foreign(OCTokenTypes.IDENTIFIER, OCPreprocessingLexer.COUNTER_MACRO, 3));
                pp.addToken(offset, (IElementType)CounterMacroUpdater.foreign(TokenType.WHITE_SPACE, " ", 4));
                pp.addToken(offset, (IElementType)CounterMacroUpdater.foreign(OCTokenTypes.INTEGER_LITERAL, Integer.toString(newCounter), 5));
                pp.addToken(offset, (IElementType)CounterMacroUpdater.foreign(OCTokenTypes.END_OF_DIRECTIVE_CONTENT, "", 6));
                pp.addToken(offset, (IElementType)CounterMacroUpdater.foreign(TokenType.WHITE_SPACE, "\n", 7));
                this.myTracker.myNewCounter = -1;
            }
        }

        @NotNull
        private static OCMacroForeignLeafType foreign(IElementType type, String text, int offInSubstitution) {
            OCMacroForeignLeafType oCMacroForeignLeafType = new OCMacroForeignLeafType(type, text, null, -1, null, offInSubstitution);
            if (oCMacroForeignLeafType == null) {
                CounterMacroUpdater.$$$reportNull$$$0(2);
            }
            return oCMacroForeignLeafType;
        }

        @Override
        @NotNull
        public CounterMacroHandler getTracker() {
            CounterMacroTracker counterMacroTracker = this.myTracker;
            if (counterMacroTracker == null) {
                CounterMacroUpdater.$$$reportNull$$$0(3);
            }
            return counterMacroTracker;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pp";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseLexer";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/preprocessor/OCPreprocessingLexer$CounterMacroUpdater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/preprocessor/OCPreprocessingLexer$CounterMacroUpdater";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "foreign";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTracker";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "emitNewDefinitionIfRequired";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class CounterMacroTracker
    implements CounterMacroHandler {
        private int myNewCounter = -1;

        private CounterMacroTracker() {
        }

        @Override
        public void emitNewDefinitionIfRequired(@NotNull OCPreprocessingLexer pp, @NotNull Lexer baseLexer) {
            if (pp == null) {
                CounterMacroTracker.$$$reportNull$$$0(0);
            }
            if (baseLexer == null) {
                CounterMacroTracker.$$$reportNull$$$0(1);
            }
        }

        @Override
        public void onNewValue(int newCounter) {
            this.myNewCounter = newCounter;
        }

        @Override
        @NotNull
        public CounterMacroHandler getTracker() {
            CounterMacroTracker counterMacroTracker = this;
            if (counterMacroTracker == null) {
                CounterMacroTracker.$$$reportNull$$$0(2);
            }
            return counterMacroTracker;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pp";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseLexer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/preprocessor/OCPreprocessingLexer$CounterMacroTracker";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/preprocessor/OCPreprocessingLexer$CounterMacroTracker";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTracker";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "emitNewDefinitionIfRequired";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface CounterMacroHandler {
        public void emitNewDefinitionIfRequired(@NotNull OCPreprocessingLexer var1, @NotNull Lexer var2);

        public void onNewValue(int var1);

        @NotNull
        public CounterMacroHandler getTracker();
    }

    static enum PreprocessingMode {
        FILE,
        DIRECTIVE_CONTENTS,
        FIRST_MACRO_ARG,
        OTHER_MACRO_ARGS;

    }

    private static enum CurrentState {
        NONE,
        AFTER_EXTERN,
        AFTER_EXTERN_C,
        AFTER_PROTOCOL,
        AFTER_AT,
        AFTER_MODULE_IMPORT,
        AFTER_NAMESPACE;

    }

    private static class QualifiedNameParser {
        private boolean myIsIdExpected = true;
        private List<String> myResult = new ArrayList<String>();

        private QualifiedNameParser() {
        }

        public void handleId(String name2) {
            if (this.myResult == null || !this.myIsIdExpected) {
                this.myResult = null;
            } else {
                this.myResult.add(name2);
                this.myIsIdExpected = false;
            }
        }

        public void handleDoubleColon() {
            if (this.myResult == null || this.myIsIdExpected) {
                this.myResult = null;
            } else {
                this.myIsIdExpected = true;
            }
        }

        public List<String> getResult() {
            return this.myResult != null && this.myResult.isEmpty() ? Collections.singletonList("") : this.myResult;
        }
    }

    private static class NamespaceBraceState
    extends BraceState {
        @NotNull
        private OCInclusionContext myState;
        private final List<String> myNamespace;

        private NamespaceBraceState(@NotNull OCInclusionContext state, List<String> ns) {
            if (state == null) {
                NamespaceBraceState.$$$reportNull$$$0(0);
            }
            this.myState = state;
            this.myNamespace = ns;
        }

        @Override
        boolean isSafeForInclude() {
            return true;
        }

        @Override
        void onExit() {
            for (int i = 0; i < this.myNamespace.size(); ++i) {
                this.myState.exitNamespace();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/jetbrains/cidr/lang/preprocessor/OCPreprocessingLexer$NamespaceBraceState", "<init>"));
        }
    }

    private static abstract class BraceState {
        private BraceState() {
        }

        boolean isSafeForInclude() {
            return false;
        }

        void onExit() {
        }
    }

    public static enum IncludePreprocessingMode {
        USE_SYMBOL_TABLE,
        FORCE_PREPROCESSING,
        SKIP;

    }
}

