/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.daemon.OCAnnotatorSink;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCThrowExpression;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.resolve.OCExprValueCategory;
import com.jetbrains.cidr.lang.resolve.v2.Conversions;
import com.jetbrains.cidr.lang.resolve.v2.TypeProperties;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCConditionalExpressionImpl
extends OCExpressionBase
implements OCConditionalExpression {
    public OCConditionalExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            OCConditionalExpressionImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    @NotNull
    public OCExpression getCondition() {
        OCExpression cond = this.findExpression(0);
        assert (cond != null);
        OCExpression oCExpression = cond;
        if (oCExpression == null) {
            OCConditionalExpressionImpl.$$$reportNull$$$0(1);
        }
        return oCExpression;
    }

    @Override
    public OCExpression getPositiveExpression(boolean returnConditionIfNull) {
        OCExpression expression = this.findExpression(1);
        return expression != null || !returnConditionIfNull ? expression : this.getCondition();
    }

    @Override
    public OCExpression getNegativeExpression() {
        return this.findExpression(2);
    }

    @Nullable
    private OCExpression findExpression(int n) {
        int count = 0;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (OCElementTypes.EXPRESSIONS.contains(tt) && count == n) {
                return (OCExpression)child.getPsi();
            }
            if (count == 0 && tt == OCTokenTypes.QUEST) {
                count = 1;
                continue;
            }
            if (count != 1 || tt != OCTokenTypes.COLON) continue;
            count = 2;
        }
        return null;
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        if (visitor == null) {
            OCConditionalExpressionImpl.$$$reportNull$$$0(2);
        }
        visitor.visitConditionalExpression(this);
    }

    @Override
    @NotNull
    public OCType getType(@NotNull OCResolveContext context) {
        if (context == null) {
            OCConditionalExpressionImpl.$$$reportNull$$$0(3);
        }
        OCExpression leftExpr = this.getPositiveExpression(true);
        OCExpression rightExpr = this.getNegativeExpression();
        if (leftExpr != null && rightExpr != null) {
            OCType oCType = OCConditionalExpressionImpl.calcAndAnnotateConditionalExprType(leftExpr.getResolvedType(context), leftExpr, rightExpr.getResolvedType(context), rightExpr, this, null, context);
            if (oCType == null) {
                OCConditionalExpressionImpl.$$$reportNull$$$0(4);
            }
            return oCType;
        }
        OCUnknownType oCUnknownType = OCUnknownType.INSTANCE;
        if (oCUnknownType == null) {
            OCConditionalExpressionImpl.$$$reportNull$$$0(5);
        }
        return oCUnknownType;
    }

    public static OCType calcAndAnnotateConditionalExprType(@NotNull OCType lTy, @NotNull OCTypeOwner lhs, @NotNull OCType rTy, @NotNull OCTypeOwner rhs, @NotNull OCTypeOwner wholeExpr, @Nullable OCAnnotatorSink sink, @NotNull OCResolveContext context) {
        if (lTy == null) {
            OCConditionalExpressionImpl.$$$reportNull$$$0(6);
        }
        if (lhs == null) {
            OCConditionalExpressionImpl.$$$reportNull$$$0(7);
        }
        if (rTy == null) {
            OCConditionalExpressionImpl.$$$reportNull$$$0(8);
        }
        if (rhs == null) {
            OCConditionalExpressionImpl.$$$reportNull$$$0(9);
        }
        if (wholeExpr == null) {
            OCConditionalExpressionImpl.$$$reportNull$$$0(10);
        }
        if (context == null) {
            OCConditionalExpressionImpl.$$$reportNull$$$0(11);
        }
        lTy = OCTypeUtils.getCppReferencedType(lTy);
        rTy = OCTypeUtils.getCppReferencedType(rTy);
        CalcTypeResult result = OCConditionalExpressionImpl.calcConditionalExprTypeImpl(lTy, lhs, rTy, rhs, wholeExpr, sink, context);
        if (sink != null && result.needToAnnotateIndividualParameters) {
            rTy.checkCompatible(lTy, lhs, (OCExpression)lhs, true, context).annotate(sink);
            lTy.checkCompatible(rTy, rhs, (OCExpression)rhs, true, context).annotate(sink);
        }
        return OCType.updateWithCommonGuessedType(lTy, rTy, result.type, context);
    }

    private static CalcTypeResult calcConditionalExprTypeImpl(@NotNull OCType lTy, @NotNull OCTypeOwner lhs, @NotNull OCType rTy, @NotNull OCTypeOwner rhs, @NotNull OCTypeOwner wholeExpr, @Nullable OCAnnotatorSink sink, @NotNull OCResolveContext context) {
        boolean same;
        if (lTy == null) {
            OCConditionalExpressionImpl.$$$reportNull$$$0(12);
        }
        if (lhs == null) {
            OCConditionalExpressionImpl.$$$reportNull$$$0(13);
        }
        if (rTy == null) {
            OCConditionalExpressionImpl.$$$reportNull$$$0(14);
        }
        if (rhs == null) {
            OCConditionalExpressionImpl.$$$reportNull$$$0(15);
        }
        if (wholeExpr == null) {
            OCConditionalExpressionImpl.$$$reportNull$$$0(16);
        }
        if (context == null) {
            OCConditionalExpressionImpl.$$$reportNull$$$0(17);
        }
        if (lTy.isVoid() || rTy.isVoid()) {
            if (OCConditionalExpressionImpl.isThrow(lhs)) {
                return CalcTypeResult.ok(rTy);
            }
            if (OCConditionalExpressionImpl.isThrow(rhs)) {
                return CalcTypeResult.ok(lTy);
            }
            if (!(!context.isCpp() || lTy.isVoid() && rTy.isVoid())) {
                return CalcTypeResult.fail();
            }
            return CalcTypeResult.ok(OCVoidType.instance());
        }
        if ((lTy.isCppStructType(context) || rTy.isCppStructType(context)) && !OCConditionalExpressionImpl.areLeftAndRightEqual(lTy, rTy, context)) {
            boolean haveR2L = OCConditionalExpressionImpl.hasStructConversion(lTy, rTy, rhs, context);
            boolean haveL2R = OCConditionalExpressionImpl.hasStructConversion(rTy, lTy, lhs, context);
            if (haveL2R && haveR2L) {
                OCConditionalExpressionImpl.annotateAmbiguousStructs(lTy, rTy, (OCExpression)wholeExpr, sink, context);
                return new CalcTypeResult(OCUnknownType.INSTANCE, false);
            }
            if (haveL2R) {
                lTy = rTy;
            } else if (haveR2L) {
                rTy = lTy;
            }
        }
        OCExprValueCategory lvc = OCExprValueCategory.classify(lhs, context);
        OCExprValueCategory rvc = OCExprValueCategory.classify(rhs, context);
        if (!OCConditionalExpressionImpl.areLeftAndRightEqual(lTy, rTy, context) && lvc == rvc && lvc != OCExprValueCategory.PRValue) {
            if (OCConditionalExpressionImpl.areRefCompatible(lTy, rTy, context)) {
                rTy = lTy;
            } else if (OCConditionalExpressionImpl.areRefCompatible(rTy, lTy, context)) {
                lTy = rTy;
            }
        }
        if ((same = OCConditionalExpressionImpl.areLeftAndRightEqual(lTy, rTy, context)) && lvc == rvc && lvc != OCExprValueCategory.PRValue) {
            return CalcTypeResult.ok(lTy.isMagicInside(context) ? lTy : rTy);
        }
        if ((lTy.isCppStructType(context) || rTy.isCppStructType(context)) && !same) {
            return CalcTypeResult.fail();
        }
        if (OCConditionalExpressionImpl.areLeftAndRightEqual(lTy = OCTypeUtils.decayType(lTy, context.getProject(), false), rTy = OCTypeUtils.decayType(rTy, context.getProject(), false), context)) {
            return CalcTypeResult.ok(lTy.isMagicInside(context) ? lTy : rTy);
        }
        if (TypeProperties.isArithmeticType(lTy) && TypeProperties.isArithmeticType(rTy)) {
            return CalcTypeResult.ok(lTy.getLeastCommonType(rTy, context));
        }
        if (lTy.isPointer() && OCExpressionEvaluator.isLikeNil(rhs, context)) {
            return CalcTypeResult.ok(lTy);
        }
        if (rTy.isPointer() && OCExpressionEvaluator.isLikeNil(lhs, context)) {
            return CalcTypeResult.ok(rTy);
        }
        if (lTy.isPointer() || rTy.isPointer()) {
            return OCConditionalExpressionImpl.getCommonPointerType(lTy, rTy, context);
        }
        return CalcTypeResult.fail();
    }

    private static boolean hasStructConversion(@NotNull OCType destType, @NotNull OCType sourceType, @NotNull OCTypeOwner sourceExpr, @NotNull OCResolveContext context) {
        if (destType == null) {
            OCConditionalExpressionImpl.$$$reportNull$$$0(18);
        }
        if (sourceType == null) {
            OCConditionalExpressionImpl.$$$reportNull$$$0(19);
        }
        if (sourceExpr == null) {
            OCConditionalExpressionImpl.$$$reportNull$$$0(20);
        }
        if (context == null) {
            OCConditionalExpressionImpl.$$$reportNull$$$0(21);
        }
        return sourceType.getCVQualifiers().isSuperset(destType.getCVQualifiers()) && !destType.checkCompatible(sourceType, sourceExpr, context.getElement(), true, context).getState().isError(context.getElement());
    }

    private static void annotateAmbiguousStructs(@NotNull OCType LTy, @NotNull OCType RTy, @NotNull OCExpression wholeExpr, @Nullable OCAnnotatorSink sink, @NotNull OCResolveContext context) {
        if (LTy == null) {
            OCConditionalExpressionImpl.$$$reportNull$$$0(22);
        }
        if (RTy == null) {
            OCConditionalExpressionImpl.$$$reportNull$$$0(23);
        }
        if (wholeExpr == null) {
            OCConditionalExpressionImpl.$$$reportNull$$$0(24);
        }
        if (context == null) {
            OCConditionalExpressionImpl.$$$reportNull$$$0(25);
        }
        if (sink != null) {
            sink.addErrorAnnotation(wholeExpr, "err_conditional_ambiguous", String.format("Ambiguous conditional operator: '%s' and '%s' can be converted to each other", LTy.getName(context), RTy.getName(context)));
        }
    }

    private static boolean areRefCompatible(@NotNull OCType LTy, @NotNull OCType RTy, @NotNull OCResolveContext context) {
        Ref objCLifetimeConversion;
        Ref objCConversion;
        Ref derivedToBase;
        Conversions.ReferenceCompareResult refRel;
        if (LTy == null) {
            OCConditionalExpressionImpl.$$$reportNull$$$0(26);
        }
        if (RTy == null) {
            OCConditionalExpressionImpl.$$$reportNull$$$0(27);
        }
        if (context == null) {
            OCConditionalExpressionImpl.$$$reportNull$$$0(28);
        }
        return (refRel = Conversions.CompareReferenceRelationship(LTy, RTy, (Ref<Boolean>)(derivedToBase = Ref.create()), (Ref<Boolean>)(objCConversion = Ref.create()), (Ref<Boolean>)(objCLifetimeConversion = Ref.create()), context)).ordinal() >= Conversions.ReferenceCompareResult.Ref_Compatible_With_Added_Qualification.ordinal() && (Boolean)derivedToBase.get() == false && (Boolean)objCConversion.get() == false && (Boolean)objCLifetimeConversion.get() == false;
    }

    @NotNull
    private static CalcTypeResult getCommonPointerType(@NotNull OCType lTy, @NotNull OCType rTy, @NotNull OCResolveContext context) {
        if (lTy == null) {
            OCConditionalExpressionImpl.$$$reportNull$$$0(29);
        }
        if (rTy == null) {
            OCConditionalExpressionImpl.$$$reportNull$$$0(30);
        }
        if (context == null) {
            OCConditionalExpressionImpl.$$$reportNull$$$0(31);
        }
        assert (lTy.isPointer() || rTy.isPointer());
        if (lTy.isPointerToObject() && rTy.isPointerToObject()) {
            CalcTypeResult calcTypeResult = new CalcTypeResult(lTy.getLeastCommonType(rTy, context), true);
            if (calcTypeResult == null) {
                OCConditionalExpressionImpl.$$$reportNull$$$0(32);
            }
            return calcTypeResult;
        }
        if (lTy.isPointer() && rTy.isPointer()) {
            OCType rPointee;
            OCPointerType lp = (OCPointerType)lTy;
            OCPointerType rp = (OCPointerType)rTy;
            OCType lPointee = lp.getRefType();
            OCType commonUnqualifiedPointee = OCConditionalExpressionImpl.getBaseType(lPointee, rPointee = rp.getRefType(), context);
            if (commonUnqualifiedPointee != null) {
                CVQualifiers mergedPointeesCV = lPointee.getCVQualifiers().or(rPointee.getCVQualifiers());
                CVQualifiers mergedPointersCV = lp.getCVQualifiers().or(rp.getCVQualifiers());
                OCType commonQualifiedPointee = commonUnqualifiedPointee.cloneWithAddedCVQualifiers(mergedPointeesCV, context.getProject());
                OCPointerType resultType = OCPointerType.to(commonQualifiedPointee, lp.getARCAttribute(), lp.getClassQualifier(), lp.getNullability(), mergedPointersCV.isConst(), mergedPointersCV.isVolatile());
                CalcTypeResult calcTypeResult = CalcTypeResult.ok(resultType);
                if (calcTypeResult == null) {
                    OCConditionalExpressionImpl.$$$reportNull$$$0(33);
                }
                return calcTypeResult;
            }
        }
        if (!context.isCpp()) {
            if (lTy.isNumberCompatible(context)) {
                CalcTypeResult calcTypeResult = new CalcTypeResult(rTy, true);
                if (calcTypeResult == null) {
                    OCConditionalExpressionImpl.$$$reportNull$$$0(34);
                }
                return calcTypeResult;
            }
            if (rTy.isNumberCompatible(context)) {
                CalcTypeResult calcTypeResult = new CalcTypeResult(lTy, true);
                if (calcTypeResult == null) {
                    OCConditionalExpressionImpl.$$$reportNull$$$0(35);
                }
                return calcTypeResult;
            }
        }
        CalcTypeResult calcTypeResult = CalcTypeResult.fail();
        if (calcTypeResult == null) {
            OCConditionalExpressionImpl.$$$reportNull$$$0(36);
        }
        return calcTypeResult;
    }

    @Nullable
    private static OCType getBaseType(@NotNull OCType lPointee, @NotNull OCType rPointee, @NotNull OCResolveContext context) {
        if (lPointee == null) {
            OCConditionalExpressionImpl.$$$reportNull$$$0(37);
        }
        if (rPointee == null) {
            OCConditionalExpressionImpl.$$$reportNull$$$0(38);
        }
        if (context == null) {
            OCConditionalExpressionImpl.$$$reportNull$$$0(39);
        }
        if (TypeProperties.hasSameUnqualifiedType(lPointee, rPointee, context) || TypeProperties.IsDerivedFrom(rPointee, lPointee, context)) {
            return lPointee.cloneWithoutCVQualifiers(context.getProject());
        }
        if (TypeProperties.IsDerivedFrom(lPointee, rPointee, context)) {
            return rPointee.cloneWithoutCVQualifiers(context.getProject());
        }
        if (lPointee.isVoid() || rPointee.isVoid()) {
            return OCVoidType.instance();
        }
        return null;
    }

    private static boolean areLeftAndRightEqual(@NotNull OCType LTy, @NotNull OCType RTy, @NotNull OCResolveContext context) {
        if (LTy == null) {
            OCConditionalExpressionImpl.$$$reportNull$$$0(40);
        }
        if (RTy == null) {
            OCConditionalExpressionImpl.$$$reportNull$$$0(41);
        }
        if (context == null) {
            OCConditionalExpressionImpl.$$$reportNull$$$0(42);
        }
        return new OCTypeEqualityVisitor(RTy, true, false, context).equal(LTy);
    }

    private static boolean isThrow(@NotNull OCTypeOwner expr) {
        if (expr == null) {
            OCConditionalExpressionImpl.$$$reportNull$$$0(43);
        }
        OCTypeOwner inner = OCParenthesesUtils.diveIntoParentheses(expr);
        return inner instanceof OCThrowExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/psi/impl/OCConditionalExpressionImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 3: 
            case 11: 
            case 17: 
            case 21: 
            case 25: 
            case 28: 
            case 31: 
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 12: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lTy";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lhs";
                break;
            }
            case 8: 
            case 14: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rTy";
                break;
            }
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rhs";
                break;
            }
            case 10: 
            case 16: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wholeExpr";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destType";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceExpr";
                break;
            }
            case 22: 
            case 26: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "LTy";
                break;
            }
            case 23: 
            case 27: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "RTy";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lPointee";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rPointee";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/psi/impl/OCConditionalExpressionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCondition";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonPointerType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "calcAndAnnotateConditionalExprType";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "calcConditionalExprTypeImpl";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "hasStructConversion";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "annotateAmbiguousStructs";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "areRefCompatible";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getCommonPointerType";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getBaseType";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "areLeftAndRightEqual";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isThrow";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CalcTypeResult {
        public final OCType type;
        public final boolean needToAnnotateIndividualParameters;

        public CalcTypeResult(OCType type, boolean needToAnnotateIndividualParameters) {
            this.type = type;
            this.needToAnnotateIndividualParameters = needToAnnotateIndividualParameters;
        }

        public static CalcTypeResult ok(OCType type) {
            return new CalcTypeResult(type, false);
        }

        public static CalcTypeResult fail() {
            return new CalcTypeResult(OCUnknownType.INSTANCE, true);
        }
    }
}

