/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCMacroParameterList;
import com.jetbrains.cidr.lang.psi.impl.OCDirectiveImpl;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.OCSymbolImpl;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class OCDefineDirectiveImpl
extends OCDirectiveImpl
implements OCDefineDirective {
    public OCDefineDirectiveImpl(@NotNull ASTNode node) {
        if (node == null) {
            OCDefineDirectiveImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @NotNull
    public String getName() {
        OCMacroSymbol def = this.getSymbol();
        String string = OCSymbolImpl.getSymbolName(def);
        if (string == null) {
            OCDefineDirectiveImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public OCMacroSymbol getSymbol() {
        PsiElement identifier;
        if (this.isValid() && (identifier = this.getNameIdentifier()) != null) {
            int offset = identifier.getTextOffset() - super.getTextOffset();
            String text = this.getText();
            if (offset > 0 && offset < text.length()) {
                return OCMacroSymbol.parseFromDirectiveContent(text.substring(offset), this.getContainingOCFile(), OCSymbolOffsetUtil.getComplexOffset(this), this.getProject());
            }
        }
        return null;
    }

    public PsiElement getNameIdentifier() {
        return this.findChildByType(OCTokenTypes.IDENTIFIER);
    }

    @Override
    public OCMacroParameterList getMacroParameters() {
        return (OCMacroParameterList)this.findChildByType(OCElementTypes.MACRO_PARAMETER_LIST);
    }

    @Override
    public int getTextOffset() {
        PsiElement content = this.getNameIdentifier();
        if (content == null) {
            return super.getTextOffset();
        }
        return content.getNode().getStartOffset();
    }

    @Override
    public long getComplexOffset() {
        PsiElement content = this.getNameIdentifier();
        if (content == null) {
            return super.getComplexOffset();
        }
        return OCSymbolOffsetUtil.getComplexOffset(content);
    }

    public PsiElement setName(@NonNls @NotNull String name2) throws IncorrectOperationException {
        if (name2 == null) {
            OCDefineDirectiveImpl.$$$reportNull$$$0(2);
        }
        OCElementUtil.replaceWithIdentifier(this.getNameIdentifier(), name2, this);
        return this;
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        if (visitor == null) {
            OCDefineDirectiveImpl.$$$reportNull$$$0(3);
        }
        visitor.visitDefineDirective(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/psi/impl/OCDefineDirectiveImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/psi/impl/OCDefineDirectiveImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

