/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCClassPredeclaration;
import com.jetbrains.cidr.lang.psi.OCConfigurationOwner;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCParsedLanguageAndConfiguration;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCFileGlobalSymbolsCache;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceLikeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.OCMembersContainer;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.OCDeprecatedWorkspace;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFileImpl
extends PsiFileBase
implements OCFile,
OCConfigurationOwner {
    private int myAnnotationSessionDepthsCounter = 0;
    private AnnotationSession myCurrentAnnotationSession = null;
    private final Object myAnnotationSessionLock = new Object();
    private final Set<OCFile> myIncludedFrom = new THashSet();
    @Nullable
    private volatile OCLanguageKind myFileKindCache;
    @Nullable
    private volatile FileSymbolTable mySymbolTableCache;
    @Nullable
    private volatile OCParsedLanguageAndConfiguration myParsedLanguageAndConfiguration;

    public OCFileImpl(FileViewProvider viewProvider) {
        super(viewProvider, (Language)OCLanguage.getInstance());
    }

    @NotNull
    public FileType getFileType() {
        OCFileType oCFileType = OCFileType.INSTANCE;
        if (oCFileType == null) {
            OCFileImpl.$$$reportNull$$$0(0);
        }
        return oCFileType;
    }

    @Override
    public boolean isHeader() {
        return OCFileImpl.isHeaderFile(this.getName());
    }

    public static boolean isHeaderFile(String fileName) {
        return OCFileTypeHelpers.isHeaderFile(fileName);
    }

    public static boolean isSourceCodeFile(String fileName) {
        return OCFileTypeHelpers.isSourceFile(fileName);
    }

    public void subtreeChanged() {
        super.subtreeChanged();
    }

    @Override
    @Nullable
    public OCFile getAssociatedFile() {
        class StopException
        extends RuntimeException {
            StopException() {
            }
        }
        String nameWithoutExtension = FileUtil.getNameWithoutExtension((String)this.getName());
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        final OCCommonProcessors.OrderedProcessor processor2 = new OCCommonProcessors.OrderedProcessor(finder, true, (Condition<T>[])new Condition[]{file -> FileUtil.getNameWithoutExtension((String)file.getName()).equals(nameWithoutExtension), Conditions.alwaysTrue()});
        try {
            this.accept(new OCRecursiveVisitor(){

                @Override
                public void visitFunctionDeclaration(OCFunctionDeclaration declaration) {
                    this.processSymbol(declaration.getSymbol());
                    super.visitFunctionDeclaration(declaration);
                }

                @Override
                public void visitFunctionDefinition(OCFunctionDefinition definition) {
                    this.processSymbol(definition.getSymbol());
                    super.visitFunctionDefinition(definition);
                }

                @Override
                public void visitClassDeclaration(OCClassDeclaration dcl) {
                    this.processSymbol(dcl.getSymbol());
                    super.visitClassDeclaration(dcl);
                }

                private void processSymbol(OCSymbol<?> symbol) {
                    if (symbol != null) {
                        symbol.processSameSymbols((Processor<OCSymbol>)((Processor)symbol1 -> {
                            OCFile file = symbol1.getContainingOCFile(OCFileImpl.this.getProject());
                            if (file != null && file.isHeader() != OCFileImpl.this.isHeader() && !processor2.process(file)) {
                                throw new StopException();
                            }
                            return true;
                        }), OCFileImpl.this.getProject());
                    }
                }
            });
        }
        catch (StopException stopException) {
            // empty catch block
        }
        processor2.finish();
        if (finder.isFound()) {
            return (OCFile)finder.getFoundValue();
        }
        return this.getAssociatedFileWithSameName();
    }

    @Override
    @Nullable
    public OCFile getAssociatedFileWithSameName() {
        OCWorkspace workspace = OCWorkspace.getInstance(this.getProject());
        VirtualFile virtualFile = this.getVirtualFile();
        HashSet<String> associatedExts = new HashSet<String>(this.isHeader() ? OCFileTypeHelpers.sourceExtensions() : OCFileTypeHelpers.headerExtensions());
        associatedExts.remove("pch");
        for (String ext : associatedExts) {
            String associatedName = FileUtil.getNameWithoutExtension((String)this.getName()) + "." + ext;
            CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
            OCCommonProcessors.OrderedProcessor processor2 = new OCCommonProcessors.OrderedProcessor(finder, true, (Condition<T>[])new Condition[]{curFile -> curFile == null || virtualFile == null || Comparing.equal((Object)virtualFile.getParent(), (Object)curFile.getParent()), each -> workspace instanceof OCDeprecatedWorkspace && ((OCDeprecatedWorkspace)workspace).areFromSameProject(virtualFile, (VirtualFile)each), Conditions.alwaysTrue()});
            ContainerUtil.process(OCSearchUtil.getProjectVirtualFilesByName(this.getProject(), associatedName), file -> !file.isValid() || processor2.process(file));
            processor2.finish();
            if (!finder.isFound()) continue;
            PsiFile file2 = PsiManager.getInstance((Project)this.getProject()).findFile((VirtualFile)finder.getFoundValue());
            return file2 instanceof OCFile ? (OCFile)file2 : null;
        }
        return null;
    }

    @Override
    public boolean isCpp() {
        return this.getKind().isCpp();
    }

    @Override
    @NotNull
    public final OCLanguageKind getKind() {
        OCLanguageKind result = this.myFileKindCache;
        if (result == null) {
            this.myFileKindCache = result = OCLanguageKindCalculator.calculateLanguageKind(this);
        }
        OCLanguageKind oCLanguageKind = result;
        if (oCLanguageKind == null) {
            OCFileImpl.$$$reportNull$$$0(1);
        }
        return oCLanguageKind;
    }

    public void clearCaches() {
        this.myFileKindCache = null;
        this.mySymbolTableCache = null;
        super.clearCaches();
    }

    @Override
    public boolean isInProjectSources() {
        return OCSearchScope.isInProjectSources(this);
    }

    @Override
    public boolean isInLibraries() {
        return OCSearchScope.isInLibraries(this);
    }

    @Override
    public boolean processSymbolsRecursively(@NotNull Processor<OCSymbol> processor2) {
        if (processor2 == null) {
            OCFileImpl.$$$reportNull$$$0(2);
        }
        return this.processSymbolsRecursively(null, processor2);
    }

    public boolean processSymbolsRecursively(@Nullable OCImmutableInclusionContext inclusionContext, final @NotNull Processor<OCSymbol> processor2) {
        PsiElement context;
        if (processor2 == null) {
            OCFileImpl.$$$reportNull$$$0(3);
        }
        if ((context = this.getContext()) instanceof OCElement && !((OCElement)context).getContainingOCFile().processSymbolsRecursively(processor2)) {
            return false;
        }
        FileSymbolTable table = this.getSymbolTable(inclusionContext == null ? null : inclusionContext.derive());
        return table == null || table.shallowProcessSymbols(new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                if (!processor2.process((Object)symbol)) {
                    return false;
                }
                if (symbol instanceof OCMembersContainer) {
                    return ((OCMembersContainer)((Object)symbol)).processMembers(null, this);
                }
                return true;
            }
        });
    }

    @Override
    @Nullable
    public <T extends OCSymbol> T findSymbol(@NotNull OCElement element, @NotNull Class<T> symbolClass) {
        PsiElement context;
        if (element == null) {
            OCFileImpl.$$$reportNull$$$0(4);
        }
        if (symbolClass == null) {
            OCFileImpl.$$$reportNull$$$0(5);
        }
        if ((context = this.getContext()) instanceof OCElement) {
            return ((OCElement)context).getContainingOCFile().findSymbol(element, symbolClass);
        }
        FileSymbolTable table = this.getSymbolTable(null);
        return table != null ? (T)table.findSymbol(element, symbolClass) : null;
    }

    @Override
    @Nullable
    public <T extends OCSymbol> T findSymbol(@Nullable String name2, Class<T> symbolClass) {
        PsiElement context = this.getContext();
        if (context instanceof OCElement) {
            return ((OCElement)context).getContainingOCFile().findSymbol(name2, symbolClass);
        }
        FileSymbolTable table = this.getSymbolTable(null);
        return table != null ? (T)table.findSymbol(name2, symbolClass) : null;
    }

    @Nullable
    public FileSymbolTable getSymbolTable(@Nullable OCInclusionContext context) {
        if (context != null) {
            return FileSymbolTable.forFile(this, context);
        }
        FileSymbolTable result = this.mySymbolTableCache;
        if (result == null) {
            this.mySymbolTableCache = result = FileSymbolTable.forFile(this, OCInclusionContextUtil.headerContext(this).derive());
        }
        return result;
    }

    @Override
    @NotNull
    public OCNamespaceLikeSymbol getMembersContainer(boolean onlyTypes) {
        OCFileGlobalSymbolsCache cache = OCFileGlobalSymbolsCache.getInstance(this.getProject());
        OCNamespaceLikeSymbol oCNamespaceLikeSymbol = onlyTypes ? cache.typesOnlyTableForFile(this) : cache.lightTableForFile(this);
        if (oCNamespaceLikeSymbol == null) {
            OCFileImpl.$$$reportNull$$$0(6);
        }
        return oCNamespaceLikeSymbol;
    }

    @Override
    @Nullable
    public OCSymbol getSameNamedClass() {
        final String name2 = this.getMainClassName();
        CommonProcessors.FindFirstProcessor<OCSymbol> finder = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                return (symbol instanceof OCClassSymbol || symbol instanceof OCStructSymbol && !((OCStructSymbol)symbol).isInnerClass()) && name2.equals(symbol.getName());
            }
        };
        this.processSymbolsRecursively((Processor<OCSymbol>)finder);
        return (OCSymbol)finder.getFoundValue();
    }

    @Override
    public String getMainClassName() {
        int minus;
        String name2 = FileUtil.getNameWithoutExtension((String)this.getName());
        int plus = name2.indexOf(43);
        if (plus != -1) {
            name2 = name2.substring(0, plus);
        }
        if ((minus = name2.indexOf(45)) != -1) {
            name2 = name2.substring(0, minus);
        }
        return name2;
    }

    @Override
    @Nullable
    public OCSymbolDeclarator findFirstClass() {
        return this.findClass(null);
    }

    @Override
    @Nullable
    public OCSymbolDeclarator findClass(final String name2) {
        final Ref result = new Ref();
        this.accept(new OCRecursiveVisitor(){

            @Override
            public void visitClassDeclaration(OCClassDeclaration dcl) {
                if (!(dcl instanceof OCClassPredeclaration) && result.isNull() && (name2 == null || name2.equals(dcl.getCanonicalName()))) {
                    result.set((Object)dcl);
                }
                super.visitClassDeclaration(dcl);
            }

            @Override
            public void visitStruct(OCStruct struct) {
                if (result.isNull() && (name2 == null || name2.equals(struct.getName()))) {
                    result.set((Object)struct);
                }
                super.visitStruct(struct);
            }
        });
        return (OCSymbolDeclarator)result.get();
    }

    @Override
    public List<OCIncludeDirective> findIncludeDirectives() {
        final ArrayList<OCIncludeDirective> answer = new ArrayList<OCIncludeDirective>();
        this.acceptChildren(new OCRecursiveVisitor(){

            @Override
            public void visitImportDirective(OCIncludeDirective directive) {
                answer.add(directive);
            }
        });
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushAnnotationSession(AnnotationSession session) {
        Object object = this.myAnnotationSessionLock;
        synchronized (object) {
            if (this.myAnnotationSessionDepthsCounter == 0) {
                this.myCurrentAnnotationSession = session;
            }
            ++this.myAnnotationSessionDepthsCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void popAnnotationSession() {
        Object object = this.myAnnotationSessionLock;
        synchronized (object) {
            --this.myAnnotationSessionDepthsCounter;
            if (this.myAnnotationSessionDepthsCounter == 0) {
                this.myCurrentAnnotationSession = null;
            }
        }
    }

    @Override
    @Nullable
    public AnnotationSession getCurrentAnnotationSession() {
        return this.myCurrentAnnotationSession;
    }

    @Override
    @NotNull
    public Object getAnnotationSessionLock() {
        Object object = this.myAnnotationSessionLock;
        if (object == null) {
            OCFileImpl.$$$reportNull$$$0(7);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markIncludedFrom(OCFile from) {
        if (from != null) {
            Set<OCFile> set = this.myIncludedFrom;
            synchronized (set) {
                this.myIncludedFrom.add(from);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<OCFile> resetIncludingFiles() {
        Set<OCFile> set = this.myIncludedFrom;
        synchronized (set) {
            ArrayList<OCFile> answer = new ArrayList<OCFile>(this.myIncludedFrom);
            this.myIncludedFrom.clear();
            return answer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<OCFile> getIncludingFiles() {
        Set<OCFile> set = this.myIncludedFrom;
        synchronized (set) {
            return new ArrayList<OCFile>(this.myIncludedFrom);
        }
    }

    @Override
    @Nullable
    public OCIncludeDirective findIncludeDirective(@Nullable VirtualFile file) {
        if (file == null) {
            return null;
        }
        for (PsiElement child : this.getChildren()) {
            OCIncludeDirective directive;
            PsiFile importedFile;
            if (!(child instanceof OCIncludeDirective) || !Comparing.equal((Object)file, (Object)OCElementUtil.getFilePath(importedFile = (directive = (OCIncludeDirective)child).getIncludedFile()))) continue;
            return directive;
        }
        return null;
    }

    public String toString() {
        return "OCFile:" + this.getName();
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            OCFileImpl.$$$reportNull$$$0(8);
        }
        if (visitor instanceof OCVisitor) {
            ((OCVisitor)visitor).visitOCFile(this);
        } else {
            visitor.visitFile((PsiFile)this);
        }
    }

    @Override
    @NotNull
    public TextRange getRangeWithMacros() {
        TextRange textRange = this.getTextRange();
        if (textRange == null) {
            OCFileImpl.$$$reportNull$$$0(9);
        }
        return textRange;
    }

    @Override
    public OCFile getContainingOCFile() {
        return this;
    }

    @Override
    public String getTextWithMacros() {
        return this.getText();
    }

    @Override
    public boolean isEmpty() {
        for (PsiElement child : this.getChildren()) {
            if (child instanceof OCDefineDirective || child instanceof OCMacroCall) continue;
            return false;
        }
        return true;
    }

    @Override
    public long getComplexOffset() {
        return this.getTextOffset();
    }

    @Override
    public boolean hasExtraTopLevelDefinitions() {
        OCSymbol mainClass = this.getSameNamedClass();
        if (mainClass == null) {
            return false;
        }
        for (PsiElement child : this.getChildren()) {
            OCType type;
            if (child instanceof OCClassDeclaration && ((OCClassDeclaration)child).getSymbol() != mainClass) {
                return true;
            }
            if (!(child instanceof OCDeclaration) || (type = ((OCDeclaration)child).getType()) instanceof OCStructType && ((OCStructType)type).getSymbol().equals(mainClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public OCParsedLanguageAndConfiguration getParsedLanguageAndConfiguration() {
        return this.myParsedLanguageAndConfiguration;
    }

    public void setParsedLanguageAndConfiguration(@Nullable OCParsedLanguageAndConfiguration languageAndConfiguration) {
        this.myParsedLanguageAndConfiguration = languageAndConfiguration;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/psi/impl/OCFileImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/psi/impl/OCFileImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMembersContainer";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationSessionLock";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeWithMacros";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processSymbolsRecursively";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findSymbol";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

