/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCondition;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.impl.OCElementBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCIfStatementImpl
extends OCElementBase
implements OCIfStatement {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.cidr.lang.psi.impl.OCIfStatementImpl");

    public OCIfStatementImpl(@NotNull ASTNode node) {
        if (node == null) {
            OCIfStatementImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    @Nullable
    public OCElement getInitStatement() {
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            ASTNode node = child.getNode();
            assert (node != null);
            if (child instanceof OCCondition) {
                return null;
            }
            if (!(child instanceof OCDeclarationStatement) && !(child instanceof OCExpressionStatement)) continue;
            return (OCElement)child;
        }
        return null;
    }

    @Override
    @Nullable
    public OCCondition getCondition() {
        return (OCCondition)this.findChildByType(OCElementTypes.CONDITION);
    }

    @Override
    @Nullable
    public OCStatement getThenBranch() {
        boolean conditionPassed = false;
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            ASTNode node = child.getNode();
            assert (node != null);
            if (child instanceof OCCondition) {
                conditionPassed = true;
                continue;
            }
            if (!conditionPassed) continue;
            IElementType tt = node.getElementType();
            if (tt == OCTokenTypes.ELSE_KEYWORD) {
                return null;
            }
            if (!(child instanceof OCStatement)) continue;
            return (OCStatement)child;
        }
        return null;
    }

    @Override
    @Nullable
    public OCStatement getElseBranch() {
        boolean elsePassed = false;
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            ASTNode node = child.getNode();
            assert (node != null);
            IElementType tt = node.getElementType();
            if (tt == OCTokenTypes.ELSE_KEYWORD) {
                elsePassed = true;
                continue;
            }
            if (!elsePassed || !(child instanceof OCStatement)) continue;
            return (OCStatement)child;
        }
        return null;
    }

    @Override
    public void setCondition(@NotNull OCElement newCondition) {
        if (newCondition == null) {
            OCIfStatementImpl.$$$reportNull$$$0(1);
        }
        if (!(newCondition instanceof OCCondition || newCondition instanceof OCExpression || newCondition instanceof OCDeclaration)) {
            throw new IllegalArgumentException("newCondition must be inherited from OCExpression/OCDeclaration/OCCondition");
        }
        ASTNode ifKeyword = this.getNode().findChildByType((IElementType)OCTokenTypes.IF_KEYWORD);
        LOG.assertTrue(ifKeyword != null);
        String tempIfStatementText = newCondition instanceof OCDeclaration ? "if(int x = 1){}" : "if(true){}";
        OCIfStatement tempIfStatement = (OCIfStatement)OCElementFactory.statementFromText(tempIfStatementText, this);
        if (newCondition instanceof OCCondition) {
            OCChangeUtil.replaceHandlingMacros(tempIfStatement.getCondition(), newCondition);
        } else if (newCondition instanceof OCDeclaration) {
            OCChangeUtil.replaceHandlingMacros(tempIfStatement.getCondition().getDeclaration(), newCondition);
        } else {
            OCChangeUtil.replaceHandlingMacros(tempIfStatement.getCondition().getExpression(), newCondition);
        }
        if (this.getLParenth() == null) {
            OCChangeUtil.addAfter(this, tempIfStatement.getLParenth().getPsi(), ifKeyword.getPsi());
        }
        if (this.getCondition() == null) {
            OCChangeUtil.addAfter(this, tempIfStatement.getCondition(), this.getLParenth().getPsi());
        } else {
            OCChangeUtil.replaceHandlingMacros(this.getCondition(), tempIfStatement.getCondition());
        }
        if (this.getRParenth() == null) {
            OCChangeUtil.addAfter(this, tempIfStatement.getRParenth().getPsi(), this.getCondition());
        }
    }

    @Override
    public void setElse(@NotNull OCStatement newElseStatement) {
        OCStatement elseBranch;
        if (newElseStatement == null) {
            OCIfStatementImpl.$$$reportNull$$$0(2);
        }
        OCIfStatement tempIfStatement = (OCIfStatement)OCElementFactory.statementFromText("if(true) { } else { }", this);
        if (this.getElseKeyword() == null) {
            PsiElement elseKeyword = tempIfStatement.getElseKeyword().getPsi();
            OCChangeUtil.addAfter(this, elseKeyword, this.getLastChild());
            OCChangeUtil.addAfter(this, elseKeyword.getNextSibling(), this.getLastChild());
        }
        if ((elseBranch = this.getElseBranch()) != null) {
            OCChangeUtil.replaceHandlingMacros(elseBranch, newElseStatement);
        } else {
            OCChangeUtil.addAfter(this, newElseStatement, this.getLastChild());
        }
    }

    @Override
    public void setThen(@NotNull OCStatement newThenStatement) {
        OCStatement thenBranch;
        ASTNode ifKeyword;
        if (newThenStatement == null) {
            OCIfStatementImpl.$$$reportNull$$$0(3);
        }
        LOG.assertTrue((ifKeyword = this.getNode().findChildByType((IElementType)OCTokenTypes.IF_KEYWORD)) != null);
        OCIfStatement tempIfStatement = (OCIfStatement)OCElementFactory.statementFromText("if(){}", this);
        if (this.getLParenth() == null) {
            OCChangeUtil.addAfter(this, tempIfStatement.getLParenth().getPsi(), ifKeyword.getPsi());
        }
        if (this.getRParenth() == null) {
            OCCondition anchor = this.getCondition() == null ? this.getLParenth().getPsi() : this.getCondition();
            OCChangeUtil.addAfter(this, tempIfStatement.getRParenth().getPsi(), anchor);
        }
        if ((thenBranch = this.getThenBranch()) == null) {
            OCChangeUtil.addAfter(this, newThenStatement, this.getRParenth().getPsi());
        } else {
            OCChangeUtil.replaceHandlingMacros(thenBranch, newThenStatement);
        }
    }

    @Override
    @Nullable
    public ASTNode getLParenth() {
        return this.getNode().findChildByType((IElementType)OCTokenTypes.LPAR);
    }

    @Override
    @Nullable
    public ASTNode getRParenth() {
        return this.getNode().findChildByType((IElementType)OCTokenTypes.RPAR);
    }

    @Override
    @Nullable
    public ASTNode getElseKeyword() {
        return this.getNode().findChildByType((IElementType)OCTokenTypes.ELSE_KEYWORD);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        if (visitor == null) {
            OCIfStatementImpl.$$$reportNull$$$0(4);
        }
        visitor.visitIfStatement(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newCondition";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElseStatement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newThenStatement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/psi/impl/OCIfStatementImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setCondition";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setElse";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setThen";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

