/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ContributedReferenceHost;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionWithReferenceBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.util.OCCharLiteral;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCFloatLiteral;
import com.jetbrains.cidr.lang.util.OCIntegerLiteral;
import com.jetbrains.cidr.lang.util.OCLiteral;
import com.jetbrains.cidr.lang.util.OCStringLiteral;
import com.jetbrains.cidr.lang.util.OCStringLiteralUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLiteralExpressionImpl
extends OCExpressionWithReferenceBase
implements OCLiteralExpression,
ContributedReferenceHost {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.cidr.lang.psi.impl.OCLiteralExpressionImpl");

    @NotNull
    private String getLiteralText(@NotNull LiteralPresentation presentation) {
        ASTNode firstChild;
        IElementType tt;
        OCLiteral literal;
        if (presentation == null) {
            OCLiteralExpressionImpl.$$$reportNull$$$0(0);
        }
        if ((literal = OCLiteralExpressionImpl.getLiteral(tt = (firstChild = this.getNode().getFirstChildNode()).getElementType(), this.getRawLiteralTextElements())) instanceof OCStringLiteral) {
            OCStringLiteral stringLiteral = (OCStringLiteral)literal;
            String string = stringLiteral.getContents(presentation == LiteralPresentation.TEXT_ESCAPED);
            if (string == null) {
                OCLiteralExpressionImpl.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (literal instanceof OCCharLiteral) {
            OCCharLiteral charLiteral = (OCCharLiteral)literal;
            String string = charLiteral.getContents(presentation == LiteralPresentation.TEXT_ESCAPED);
            if (string == null) {
                OCLiteralExpressionImpl.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = this.getRawLiteralText();
        if (string == null) {
            OCLiteralExpressionImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    private static OCLiteral getLiteral(@NotNull IElementType tt, @NotNull List<String> childTextElements) {
        if (tt == null) {
            OCLiteralExpressionImpl.$$$reportNull$$$0(4);
        }
        if (childTextElements == null) {
            OCLiteralExpressionImpl.$$$reportNull$$$0(5);
        }
        if (tt == OCTokenTypes.AT || OCTokenTypes.ALL_STRINGS.contains(tt)) {
            if (childTextElements.isEmpty()) {
                return OCStringLiteral.BAD_LITERAL;
            }
            if (childTextElements.size() == 1) {
                return OCStringLiteralUtil.parseStringLiteral(childTextElements.get(0));
            }
            int elementsSize = childTextElements.size();
            OCStringLiteral[] stringLiterals = new OCStringLiteral[elementsSize];
            for (int i = 0; i < elementsSize; ++i) {
                stringLiterals[i] = OCStringLiteralUtil.parseStringLiteral(childTextElements.get(i));
            }
            return OCStringLiteralUtil.concatStrings(stringLiterals);
        }
        String childText = StringUtil.join(childTextElements, (String)"");
        if (tt == OCTokenTypes.CHARACTER_LITERAL) {
            return OCStringLiteralUtil.parseCharLiteral(childText);
        }
        if (tt == OCTokenTypes.INTEGER_LITERAL) {
            return new OCIntegerLiteral(childText);
        }
        if (tt == OCTokenTypes.FLOAT_LITERAL) {
            return new OCFloatLiteral(childText);
        }
        return null;
    }

    public OCLiteralExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            OCLiteralExpressionImpl.$$$reportNull$$$0(6);
        }
        super(node);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        if (visitor == null) {
            OCLiteralExpressionImpl.$$$reportNull$$$0(7);
        }
        visitor.visitLiteralExpression(this);
    }

    @Override
    @NotNull
    public String getUnescapedLiteralText() {
        String string = this.getLiteralText(LiteralPresentation.TEXT_UNESCAPED);
        if (string == null) {
            OCLiteralExpressionImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @NotNull
    public String getEscapedLiteralText() {
        String string = this.getLiteralText(LiteralPresentation.TEXT_ESCAPED);
        if (string == null) {
            OCLiteralExpressionImpl.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    @NotNull
    public String getRawLiteralText() {
        String string = StringUtil.join(this.getRawLiteralTextElements(), (String)"");
        if (string == null) {
            OCLiteralExpressionImpl.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public List<ASTNode> findStringLiteralNodes() {
        ArrayList<ASTNode> nodes = new ArrayList<ASTNode>();
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (!OCTokenTypes.ALL_STRINGS.contains(child.getElementType())) continue;
            nodes.add(child);
        }
        ArrayList<ASTNode> arrayList = nodes;
        if (arrayList == null) {
            OCLiteralExpressionImpl.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    private List<String> getRawLiteralTextElements() {
        ASTNode firstChild = this.getNode().getFirstChildNode();
        IElementType tt = firstChild.getElementType();
        if (tt == OCTokenTypes.AT || OCTokenTypes.ALL_STRINGS.contains(tt)) {
            List list = ContainerUtil.map(this.findStringLiteralNodes(), node -> node.getText());
            if (list == null) {
                OCLiteralExpressionImpl.$$$reportNull$$$0(12);
            }
            return list;
        }
        List<String> list = Collections.singletonList(firstChild.getText());
        if (list == null) {
            OCLiteralExpressionImpl.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    public PsiReference[] getReferences() {
        PsiReferenceService service = PsiReferenceService.getService();
        PsiReference[] ret = null;
        if (service != null) {
            ret = service.getContributedReferences((PsiElement)this);
        }
        if (ret == null) {
            ret = PsiReference.EMPTY_ARRAY;
            LOG.assertTrue(ret.length == 0);
        }
        if (ret == null) {
            OCLiteralExpressionImpl.$$$reportNull$$$0(14);
        }
        return ret;
    }

    @Nullable
    public PsiReference createReference() {
        PsiReference[] references = this.getReferences();
        return references.length == 1 ? references[0] : null;
    }

    @Override
    @NotNull
    public OCType getType(@NotNull OCResolveContext context) {
        OCMacroRange macroRange;
        if (context == null) {
            OCLiteralExpressionImpl.$$$reportNull$$$0(15);
        }
        IElementType tt = this.getNode().getFirstChildNode().getElementType();
        String literalText = this.getRawLiteralText();
        if (tt == OCTokenTypes.INTEGER_LITERAL && ("0".equals(literalText) || "1".equals(literalText)) && (macroRange = OCElementUtil.getRangeInMacroCall(this)) != null) {
            String macroText = macroRange.getMacroCall().getText();
            if (macroText.equals("TRUE") || macroText.equals("FALSE") || macroText.equals("YES") || macroText.equals("NO")) {
                OCIntType oCIntType = OCIntType.BOOL;
                if (oCIntType == null) {
                    OCLiteralExpressionImpl.$$$reportNull$$$0(16);
                }
                return oCIntType;
            }
            if (macroText.equals("true") || macroText.equals("false")) {
                OCIntType oCIntType = OCIntType.BOOL_NATIVE;
                if (oCIntType == null) {
                    OCLiteralExpressionImpl.$$$reportNull$$$0(17);
                }
                return oCIntType;
            }
        }
        if (tt == OCElementTypes.NS_ARRAY_LITERAL) {
            OCPointerType oCPointerType = OCPointerType.to(OCReferenceType.fromText("NSArray"));
            if (oCPointerType == null) {
                OCLiteralExpressionImpl.$$$reportNull$$$0(18);
            }
            return oCPointerType;
        }
        if (tt == OCElementTypes.NS_DICTIONARY_LITERAL) {
            OCPointerType oCPointerType = OCPointerType.to(OCReferenceType.fromText("NSDictionary"));
            if (oCPointerType == null) {
                OCLiteralExpressionImpl.$$$reportNull$$$0(19);
            }
            return oCPointerType;
        }
        if (this.isNSNumberLiteral()) {
            OCPointerType oCPointerType = OCPointerType.to(OCReferenceType.fromText("NSNumber"));
            if (oCPointerType == null) {
                OCLiteralExpressionImpl.$$$reportNull$$$0(20);
            }
            return oCPointerType;
        }
        if (this.isNSStringLiteral()) {
            OCPointerType oCPointerType = OCPointerType.to(OCReferenceType.fromText("NSString"));
            if (oCPointerType == null) {
                OCLiteralExpressionImpl.$$$reportNull$$$0(21);
            }
            return oCPointerType;
        }
        OCType oCType = OCLiteralExpressionImpl.getLiteralTypeFromTT(tt, this.getContainingFile(), OCLiteralExpressionImpl.getLiteral(tt, this.getRawLiteralTextElements()), this.getProject());
        if (oCType == null) {
            OCLiteralExpressionImpl.$$$reportNull$$$0(22);
        }
        return oCType;
    }

    public static OCType getLiteralType(IElementType tt, List<String> childTextElements, @NotNull PsiFile file) {
        if (file == null) {
            OCLiteralExpressionImpl.$$$reportNull$$$0(23);
        }
        return OCLiteralExpressionImpl.getLiteralTypeFromTT(tt, file, OCLiteralExpressionImpl.getLiteral(tt, childTextElements), file.getProject());
    }

    private static OCType getLiteralTypeFromTT(IElementType tt, @Nullable PsiFile file, @Nullable OCLiteral literal, @NotNull Project project2) {
        if (project2 == null) {
            OCLiteralExpressionImpl.$$$reportNull$$$0(24);
        }
        if (tt == OCTokenTypes.TRUE_CPP_KEYWORD || tt == OCTokenTypes.FALSE_CPP_KEYWORD) {
            return OCIntType.BOOL_NATIVE;
        }
        if (tt == OCTokenTypes.NULL_CPP_KEYWORD) {
            return OCPointerType.NULLPTR_T;
        }
        if (literal != null) {
            return literal.getType(file, OCCodeInsightUtil.isInPlainOldC((PsiElement)file), project2);
        }
        if (tt == OCTokenTypes.WRONG_INTEGER_LITERAL) {
            return OCIntType.INT;
        }
        if (tt == OCTokenTypes.WRONG_FLOAT_LITERAL) {
            return OCRealType.FLOAT;
        }
        if (tt == OCTokenTypes.TEMPLATE_START_MARK) {
            return OCUnknownType.INSTANCE;
        }
        if (tt == OCTokenTypes.FAKE_FALSE || tt == OCTokenTypes.FAKE_TRUE) {
            return OCIntType.INT;
        }
        if (tt == OCTokenTypes.__NULL_KEYWORD) {
            return OCPointerType.to(OCVoidType.instance());
        }
        return OCUnknownType.INSTANCE;
    }

    @Override
    public boolean isNSNumberLiteral() {
        IElementType tt = this.getNode().getFirstChildNode().getElementType();
        if (tt == OCTokenTypes.AT) {
            IElementType type = this.getNode().getLastChildNode().getElementType();
            return type == OCTokenTypes.INTEGER_LITERAL || type == OCTokenTypes.FLOAT_LITERAL || type == OCTokenTypes.CHARACTER_LITERAL;
        }
        return false;
    }

    @Override
    public boolean isNSStringLiteral() {
        IElementType tt = this.getNode().getFirstChildNode().getElementType();
        if (tt == OCTokenTypes.AT) {
            IElementType type = this.getNode().getLastChildNode().getElementType();
            return type == OCTokenTypes.STRING_LITERAL;
        }
        return false;
    }

    @Override
    public boolean isStringLiteral() {
        return !this.findStringLiteralNodes().isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/psi/impl/OCLiteralExpressionImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tt";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTextElements";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/psi/impl/OCLiteralExpressionImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiteralText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnescapedLiteralText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getEscapedLiteralText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawLiteralText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findStringLiteralNodes";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawLiteralTextElements";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLiteralText";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLiteral";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getLiteralType";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getLiteralTypeFromTT";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum LiteralPresentation {
        TEXT_ESCAPED,
        TEXT_UNESCAPED;

    }
}

