/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCLocalizedString;
import com.jetbrains.cidr.lang.psi.OCStringsFile;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.objc.OCLocalizedStringSymbol;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class OCLocalizedStringImpl
extends ASTWrapperPsiElement
implements OCLocalizedString {
    public OCLocalizedStringImpl(@NotNull ASTNode node) {
        if (node == null) {
            OCLocalizedStringImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    @NotNull
    public String getKey() {
        String string = this.getLiteralValue(0);
        if (string == null) {
            OCLocalizedStringImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String getValue() {
        String string = this.getLiteralValue(1);
        if (string == null) {
            OCLocalizedStringImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.getKey();
        if (string == null) {
            OCLocalizedStringImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    public PsiElement setName(@NonNls @NotNull String name2) throws IncorrectOperationException {
        PsiElement literal;
        if (name2 == null) {
            OCLocalizedStringImpl.$$$reportNull$$$0(4);
        }
        if ((literal = this.getFirstChild()) != null) {
            OCChangeUtil.changeText(this.getProject(), this.getContainingFile(), literal.getTextOffset() + 1, literal.getTextLength() - 2, name2, false, false);
        }
        return this;
    }

    @Override
    public OCLocalizedStringSymbol getSymbol() {
        return new OCLocalizedStringSymbol(this.getProject(), this.getContainingFile().getVirtualFile(), OCSymbolOffsetUtil.getComplexOffset(this), this.getName(), Collections.emptyList());
    }

    @NotNull
    private String getLiteralValue(int literalIndex) {
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType type = child.getElementType();
            if (type != OCTokenTypes.STRING_LITERAL && type != OCTokenTypes.IDENTIFIER || literalIndex-- != 0) continue;
            String string = type == OCTokenTypes.STRING_LITERAL ? StringUtil.unquoteString((String)child.getText()) : child.getText();
            if (string == null) {
                OCLocalizedStringImpl.$$$reportNull$$$0(5);
            }
            return string;
        }
        assert (false);
        if (null == null) {
            OCLocalizedStringImpl.$$$reportNull$$$0(6);
        }
        return null;
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public Icon getIcon(boolean open) {
                return null;
            }

            public String getPresentableText() {
                return OCLocalizedStringImpl.this.getValue();
            }

            public String getLocationString() {
                return ((OCStringsFile)OCLocalizedStringImpl.this.getContainingFile()).getLocalizationName();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/psi/impl/OCLocalizedStringImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/psi/impl/OCLocalizedStringImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiteralValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

