/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.codeInsight.completion.BasicInsertHandler;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.editor.completion.SymbolLookupBuilderUtil;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCPropertyAttribute;
import com.jetbrains.cidr.lang.psi.OCPropertyAttributesList;
import com.jetbrains.cidr.lang.psi.OCReference;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.impl.OCElementWithReferenceBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCPropertyAttributeImpl
extends OCElementWithReferenceBase
implements OCPropertyAttribute {
    public OCPropertyAttributeImpl(@NotNull ASTNode node) {
        if (node == null) {
            OCPropertyAttributeImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        if (visitor == null) {
            OCPropertyAttributeImpl.$$$reportNull$$$0(1);
        }
        visitor.visitPropertyAttribute(this);
    }

    @NotNull
    public String getName() {
        PsiElement ident = this.getNameIdentifier();
        String string = ident == null ? "<unnamed>" : ident.getText();
        if (string == null) {
            OCPropertyAttributeImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    public PsiElement setName(@NonNls @NotNull String name2) throws IncorrectOperationException {
        if (name2 == null) {
            OCPropertyAttributeImpl.$$$reportNull$$$0(3);
        }
        OCElementUtil.replaceWithIdentifier(this.getNameIdentifier(), name2, this);
        return this;
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        return this.findChildByType(OCTokenTypes.IDENTIFIER);
    }

    @Override
    @Nullable
    public PsiElement getValueElement() {
        List names = this.findChildrenByType(OCTokenTypes.IDENTIFIER);
        return names.size() == 2 ? (PsiElement)names.get(1) : null;
    }

    @Override
    @Nullable
    public String getValue() {
        PsiElement element = this.getValueElement();
        if (element == null) {
            return null;
        }
        String result = element.getText();
        return this.getName().equals("setter") && !result.endsWith(":") ? result + ":" : result;
    }

    @Override
    @Nullable
    public PsiElement getColon() {
        return this.findChildByType(OCTokenTypes.COLON);
    }

    @Override
    @Nullable
    public OCProperty getParentProperty() {
        PsiElement property;
        PsiElement list = this.getParent();
        if (list instanceof OCPropertyAttributesList && (property = list.getParent()) instanceof OCProperty) {
            return (OCProperty)property;
        }
        return null;
    }

    @Override
    public void setValue(String value) {
        List names = this.findChildrenByType(OCTokenTypes.IDENTIFIER);
        if (names.size() == 2) {
            ((PsiElement)names.get(1)).replace(OCElementFactory.createIdentifier(value, this));
        }
    }

    @Nullable
    protected PsiReference createReference() {
        PsiElement valueElement = this.getValueElement();
        String keyName = this.getName();
        if ((keyName.equals("getter") || keyName.equals("setter")) && valueElement != null) {
            return new AccessorMethodReference();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/psi/impl/OCPropertyAttributeImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/psi/impl/OCPropertyAttributeImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class AccessorMethodReference
    implements OCReference {
        private AccessorMethodReference() {
        }

        @Override
        public OCSymbol resolveToSymbol() {
            OCImplementationSymbol classSymbol = this.getClassSymbol();
            CommonProcessors.FindFirstProcessor<OCMethodSymbol> finder = new CommonProcessors.FindFirstProcessor<OCMethodSymbol>(){

                public boolean process(OCMethodSymbol symbol) {
                    if (!symbol.isStatic()) {
                        return super.process((Object)symbol);
                    }
                    return true;
                }
            };
            if (classSymbol != null) {
                classSymbol.processMembers(this.getCanonicalText(), OCMethodSymbol.class, finder);
            }
            return (OCSymbol)finder.getFoundValue();
        }

        @Nullable
        private OCImplementationSymbol getClassSymbol() {
            OCClassDeclaration classDeclaration = (OCClassDeclaration)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), OCClassDeclaration.class);
            if (classDeclaration == null) {
                return null;
            }
            OCClassSymbol classSymbol = classDeclaration.getSymbol();
            if (classSymbol == null) {
                return null;
            }
            return classSymbol.getImplementation(OCPropertyAttributeImpl.this.getProject());
        }

        public PsiElement getElement() {
            return OCPropertyAttributeImpl.this;
        }

        public TextRange getRangeInElement() {
            return OCElementUtil.getRangeInParent(OCPropertyAttributeImpl.this.getValueElement());
        }

        public PsiElement resolve() {
            OCSymbol symbol = this.resolveToSymbol();
            return symbol != null ? (PsiElement)symbol.locateDefinition(OCPropertyAttributeImpl.this.getProject()) : null;
        }

        @NotNull
        public String getCanonicalText() {
            String string = OCPropertyAttributeImpl.this.getValue();
            if (string == null) {
                AccessorMethodReference.$$$reportNull$$$0(0);
            }
            return string;
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            if (!OCPropertyAttributeImpl.this.getName().equals(newElementName)) {
                return OCPropertyAttributeImpl.this.getValueElement().replace(OCElementFactory.createIdentifier(newElementName, OCPropertyAttributeImpl.this));
            }
            return this.getElement();
        }

        @Override
        public PsiElement bindToSymbol(@NotNull OCSymbol symbol) {
            if (symbol == null) {
                AccessorMethodReference.$$$reportNull$$$0(1);
            }
            assert (symbol instanceof OCMethodSymbol);
            return this.handleElementRename(symbol.getName());
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            Object symbol;
            if (element == null) {
                AccessorMethodReference.$$$reportNull$$$0(2);
            }
            return (symbol = ((OCSymbolDeclarator)element).getSymbol()) != null ? this.bindToSymbol((OCSymbol)symbol) : element;
        }

        public boolean isReferenceTo(PsiElement element) {
            if (!(element instanceof OCSymbolDeclarator)) {
                return false;
            }
            Object symbol = ((OCSymbolDeclarator)element).getSymbol();
            OCSymbol refSymbol = this.resolveToSymbol();
            return symbol instanceof OCMethodSymbol && (Comparing.equal((Object)refSymbol, symbol) || Comparing.equal((Object)refSymbol, (Object)((OCMethodSymbol)symbol).getAssociatedSymbol(element.getProject())));
        }

        @NotNull
        public Object[] getVariants() {
            OCImplementationSymbol classSymbol = this.getClassSymbol();
            boolean isSetter = OCPropertyAttributeImpl.this.getName().equals("setter");
            ArrayList result = new ArrayList();
            if (classSymbol != null) {
                classSymbol.processMembers(null, OCMethodSymbol.class, symbol -> {
                    OCResolveContext context = OCResolveContext.forSymbol(symbol, OCPropertyAttributeImpl.this.getProject());
                    if (symbol.isGetter(context) && !isSetter || symbol.isSetter(context) && isSetter) {
                        result.add(SymbolLookupBuilderUtil.lookup(symbol, OCPropertyAttributeImpl.this.getProject()).withInsertHandler((InsertHandler)new BasicInsertHandler()));
                    }
                    return true;
                });
            }
            Object[] objectArray = result.toArray();
            if (objectArray == null) {
                AccessorMethodReference.$$$reportNull$$$0(3);
            }
            return objectArray;
        }

        public boolean isSoft() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/psi/impl/OCPropertyAttributeImpl$AccessorMethodReference";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "symbol";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCanonicalText";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/psi/impl/OCPropertyAttributeImpl$AccessorMethodReference";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToSymbol";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToElement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

