/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCClassDeclarationBase;
import com.jetbrains.cidr.lang.psi.OCPolyVariantReference;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionWithReferenceBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.resolve.OCSelectorAdHocResolver;
import com.jetbrains.cidr.lang.resolve.references.OCPolyVariantReferenceImpl;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCSelectorExpressionImpl
extends OCExpressionWithReferenceBase<OCPolyVariantReference<OCMethodSymbol>>
implements OCSelectorExpression {
    public OCSelectorExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            OCSelectorExpressionImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    @NotNull
    public String getSelector() {
        StringBuilder builder = new StringBuilder();
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (tt == OCElementTypes.OBJC_KEYWORD || tt == OCTokenTypes.LPAR || tt == OCTokenTypes.RPAR || OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(tt)) continue;
            builder.append(child.getText());
        }
        String string = builder.toString().trim();
        if (string == null) {
            OCSelectorExpressionImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public OCType getExpectedReturnType() {
        OCSendMessageExpression sendMessageExpr;
        if (OCSelectorAdHocResolver.getActionTargetContext(this) != null && (sendMessageExpr = (OCSendMessageExpression)PsiTreeUtil.getParentOfType((PsiElement)this, OCSendMessageExpression.class)) != null && OCSelectorAdHocResolver.isPerformSelectorMethod(sendMessageExpr.getMessageSelector())) {
            OCType oCType = OCExpectedTypeUtil.getExpectedType(sendMessageExpr);
            if (oCType == null) {
                OCSelectorExpressionImpl.$$$reportNull$$$0(2);
            }
            return oCType;
        }
        OCVoidType oCVoidType = OCVoidType.instance();
        if (oCVoidType == null) {
            OCSelectorExpressionImpl.$$$reportNull$$$0(3);
        }
        return oCVoidType;
    }

    @Override
    public String getExpectedMethodSignature() {
        StringBuilder result = new StringBuilder();
        result.append("-(");
        result.append(this.getExpectedReturnType().getBestNameInContext(this));
        result.append(")");
        String lastID = null;
        HashSet<String> paramNames = new HashSet<String>();
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (tt == OCTokenTypes.IDENTIFIER) {
                lastID = child.getText();
                result.append(lastID);
                continue;
            }
            if (tt != OCTokenTypes.COLON && tt != OCTokenTypes.COLON2X) continue;
            for (int i = 0; i < (tt == OCTokenTypes.COLON2X ? 2 : 1); ++i) {
                String paramName = OCNameSuggester.suggestUniqueName(OCSymbolKind.PARAMETER, lastID, null, paramNames);
                paramNames.add(paramName);
                result.append(":(id)").append(paramName).append(' ');
            }
        }
        return result.toString();
    }

    @Override
    @NotNull
    public TextRange getSelectorRange() {
        TextRange range;
        int startOffset = 0;
        int endOffset = 0;
        ASTNode child = this.getNode().getFirstChildNode();
        ASTNode childPrev = null;
        IElementType ttPrev = null;
        int parentOffset = this.getNode().getStartOffset();
        while (child != null) {
            IElementType tt = child.getElementType();
            if (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(tt)) {
                child = child.getTreeNext();
                continue;
            }
            if (ttPrev == OCTokenTypes.LPAR) {
                startOffset = child.getStartOffset();
            }
            if (tt == OCTokenTypes.RPAR) {
                endOffset = childPrev.getTextRange().getEndOffset();
            }
            childPrev = child;
            ttPrev = tt;
            child = child.getTreeNext();
        }
        if (endOffset < startOffset) {
            endOffset = startOffset;
        }
        TextRange textRange = (range = new TextRange(startOffset, endOffset)).isEmpty() ? range : range.shiftRight(-parentOffset);
        if (textRange == null) {
            OCSelectorExpressionImpl.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    @Override
    public List<PsiElement> getSelectorParts() {
        return this.findChildrenByType(OCTokenTypes.IDENTIFIER);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        if (visitor == null) {
            OCSelectorExpressionImpl.$$$reportNull$$$0(5);
        }
        visitor.visitSelectorExpression(this);
    }

    @Override
    @NotNull
    public OCType getType(@NotNull OCResolveContext context) {
        if (context == null) {
            OCSelectorExpressionImpl.$$$reportNull$$$0(6);
        }
        OCReferenceType oCReferenceType = OCReferenceType.fromText("SEL");
        if (oCReferenceType == null) {
            OCSelectorExpressionImpl.$$$reportNull$$$0(7);
        }
        return oCReferenceType;
    }

    @Override
    @NotNull
    protected OCPolyVariantReference<OCMethodSymbol> createReference() {
        SelectorReference selectorReference = new SelectorReference();
        if (selectorReference == null) {
            OCSelectorExpressionImpl.$$$reportNull$$$0(8);
        }
        return selectorReference;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/psi/impl/OCSelectorExpressionImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/psi/impl/OCSelectorExpressionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelector";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedReturnType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectorRange";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SelectorReference
    extends OCPolyVariantReferenceImpl<OCMethodSymbol> {
        private SelectorReference() {
        }

        public PsiElement getElement() {
            return OCSelectorExpressionImpl.this;
        }

        public TextRange getRangeInElement() {
            return OCSelectorExpressionImpl.this.getSelectorRange();
        }

        @Override
        public boolean isReferenceTo(PsiElement element) {
            if (!(element instanceof OCSymbolDeclarator)) {
                return false;
            }
            Object symbol = ((OCSymbolDeclarator)element).getSymbol();
            List<OCMethodSymbol> symbols = this.resolveToSymbols();
            if (symbol instanceof OCMethodSymbol) {
                return symbols.contains(symbol) || symbols.contains(((OCMethodSymbol)symbol).getAssociatedSymbol(element.getProject()));
            }
            if (symbol != null) {
                for (OCMethodSymbol methodSymbol : symbols) {
                    OCMethodSymbol associatedSymbol = methodSymbol.getAssociatedSymbol(element, OCSelectorExpressionImpl.this.getProject());
                    if (!symbol.equals(methodSymbol.getOriginalSymbol()) && (associatedSymbol == null || !symbol.equals(associatedSymbol.getOriginalSymbol()))) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        @NotNull
        public List<OCMethodSymbol> resolveToSymbols() {
            OCObjectTypeContext targetContext = OCSelectorAdHocResolver.getActionTargetContext(OCSelectorExpressionImpl.this);
            if (targetContext != null) {
                targetContext.setStaticDoesntMatter();
                List<OCMethodSymbol> list = targetContext.getProbableResponders(OCSelectorExpressionImpl.this.getSelector(), OCSelectorExpressionImpl.this.getProject()).getAllResponders();
                if (list == null) {
                    SelectorReference.$$$reportNull$$$0(0);
                }
                return list;
            }
            HashMap result = new HashMap();
            OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(OCSelectorExpressionImpl.this.getProject(), (Processor<OCSymbol>)((Processor)symbol -> {
                if (symbol instanceof OCMethodSymbol) {
                    OCMethodSymbol oldMethod;
                    OCMethodSymbol method = this.validateSymbol((OCMethodSymbol)symbol);
                    String parentName = ((OCClassSymbol)method.getParent()).getPresentableName();
                    if (method.getParent() instanceof OCProtocolSymbol) {
                        parentName = "protocol#" + parentName;
                    }
                    if ((oldMethod = (OCMethodSymbol)result.get(parentName)) == null || oldMethod.getParent() instanceof OCImplementationSymbol && method.getParent() instanceof OCInterfaceSymbol) {
                        result.put(parentName, method);
                    }
                }
                return true;
            }), OCSelectorExpressionImpl.this.getSelector());
            ArrayList<OCMethodSymbol> arrayList = new ArrayList<OCMethodSymbol>(result.values());
            if (arrayList == null) {
                SelectorReference.$$$reportNull$$$0(1);
            }
            return arrayList;
        }

        private OCMethodSymbol validateSymbol(OCMethodSymbol symbol) {
            OCClassDeclarationBase parentDecl = (OCClassDeclarationBase)((OCClassSymbol)symbol.getParent()).locateDefinition(this.getElement().getProject());
            if (parentDecl == null) {
                return symbol;
            }
            CommonProcessors.FindFirstProcessor<OCMemberSymbol> finder = new CommonProcessors.FindFirstProcessor<OCMemberSymbol>(){

                protected boolean accept(OCMemberSymbol symbol) {
                    return symbol instanceof OCMethodSymbol;
                }
            };
            OCResolveUtil.processMemberSymbols(symbol.getName(), parentDecl.getLastChild(), (Processor<? super OCMemberSymbol>)finder);
            return finder.isFound() ? (OCMethodSymbol)finder.getFoundValue() : symbol;
        }

        @NotNull
        public String getCanonicalText() {
            String string = OCSelectorExpressionImpl.this.getSelector();
            if (string == null) {
                SelectorReference.$$$reportNull$$$0(2);
            }
            return string;
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            OCSelectorExpressionImpl element = OCSelectorExpressionImpl.this;
            newElementName = OCNameSuggester.isObjCSetter(OCSelectorExpressionImpl.this.getSelector()) && !OCNameSuggester.isObjCSetter(newElementName) ? OCNameSuggester.getObjCSetterFromGetter(newElementName) : newElementName;
            return OCChangeUtil.replaceHandlingMacros(element, OCElementFactory.expressionFromText("@selector(" + newElementName + ")", element));
        }

        @Override
        public PsiElement bindToSymbol(@NotNull OCSymbol symbol) {
            if (symbol == null) {
                SelectorReference.$$$reportNull$$$0(3);
            }
            assert (symbol instanceof OCMethodSymbol || symbol instanceof OCPropertySymbol);
            return this.handleElementRename(symbol.getName());
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            Object symbol;
            if (element == null) {
                SelectorReference.$$$reportNull$$$0(4);
            }
            return (symbol = ((OCSymbolDeclarator)element).getSymbol()) != null ? this.bindToSymbol((OCSymbol)symbol) : element;
        }

        public boolean isSoft() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/psi/impl/OCSelectorExpressionImpl$SelectorReference";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "symbol";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolveToSymbols";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCanonicalText";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/psi/impl/OCSelectorExpressionImpl$SelectorReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToSymbol";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToElement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

