/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl.symbols;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.impl.OCFileImpl;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCFileGlobalSymbols;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCLightFileGlobalSymbols;
import com.jetbrains.cidr.lang.psi.impl.symbols.SLRUSynchronizedCache;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceLikeSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFileGlobalSymbolsCache {
    private static final Logger LOG = Logger.getInstance((String)"com.jetbrains.cidr.lang.psi.impl.symbols.OCFileGlobalSymbolsCache");
    private static final int CACHE_SIZE = 2 * Runtime.getRuntime().availableProcessors();
    private final CachedValue<Cache> myCache;

    public static OCFileGlobalSymbolsCache getInstance(Project project2) {
        return (OCFileGlobalSymbolsCache)project2.getComponent(OCFileGlobalSymbolsCache.class);
    }

    public OCFileGlobalSymbols forFile(OCFile file) {
        return (OCFileGlobalSymbols)this.getCache().main.get(file);
    }

    public OCNamespaceLikeSymbol lightTableForFile(OCFile file) {
        Cache cache = this.getCache();
        OCFileGlobalSymbols symbols = (OCFileGlobalSymbols)cache.main.getIfCached(file);
        if (symbols != null) {
            return symbols;
        }
        return (OCNamespaceLikeSymbol)cache.lightCache.get(file);
    }

    public OCNamespaceLikeSymbol typesOnlyTableForFile(OCFile file) {
        Cache cache = this.getCache();
        OCFileGlobalSymbols symbols = (OCFileGlobalSymbols)cache.main.getIfCached(file);
        if (symbols != null) {
            return symbols;
        }
        OCLightFileGlobalSymbols lSymbols = (OCLightFileGlobalSymbols)cache.lightCache.getIfCached(file);
        if (lSymbols != null) {
            return lSymbols;
        }
        return (OCNamespaceLikeSymbol)cache.typesOnlyCache.get(file);
    }

    private Cache getCache() {
        return (Cache)this.myCache.getValue();
    }

    public OCFileGlobalSymbolsCache(Project project2, PsiManager psiManager, FileSymbolTablesCache fileSymbolTablesCache) {
        this.myCache = CachedValuesManager.getManager((Project)project2).createCachedValue(() -> new CachedValueProvider.Result((Object)new Cache(), new Object[]{psiManager.getModificationTracker().getOutOfCodeBlockModificationTracker()}), false);
    }

    public static void processFile(OCFileImpl file, Processor<OCSymbol> symbols, @Nullable Map<OCSymbol, VirtualFile> importsMap) {
        if (!OCFileGlobalSymbolsCache.processFileImpl(file, symbols, importsMap) && !OCFileGlobalSymbolsCache.processFileImpl(file, symbols, importsMap)) {
            LOG.error("Symbols were collected incorrectly");
        }
    }

    public static boolean processFileImpl(@NotNull OCFileImpl file, Processor<OCSymbol> symbols, @Nullable Map<OCSymbol, VirtualFile> importsMap) {
        FileSymbolTable table;
        if (file == null) {
            OCFileGlobalSymbolsCache.$$$reportNull$$$0(0);
        }
        if (!FileSymbolTablesCache.areSymbolsLoaded(file.getProject())) {
            return true;
        }
        VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(file);
        THashSet processed = new THashSet();
        List<Object> precompiledHeaders = Collections.emptyList();
        OCImmutableInclusionContext precompiledContext = null;
        OCInclusionContext initial = null;
        OCImmutableInclusionContext context = OCInclusionContextUtil.headerContext(file);
        PsiFile importHolder = context.getRootFile();
        OCResolveConfiguration configuration = context.getConfiguration();
        if (configuration != null) {
            OCLanguageKind contextKind = context.getLanguageKind();
            precompiledContext = OCInclusionContext.initialPCHContextWithoutRoot(configuration, contextKind, importHolder);
            precompiledHeaders = precompiledContext.getPrecompiledHeaders();
            initial = OCInclusionContext.beforePCHFileContext(configuration, contextKind, importHolder);
        }
        if (initial == null) {
            initial = OCInclusionContext.beforePCHFileContext(file);
        }
        boolean contextWasProcessed = false;
        for (OCFile pch : precompiledHeaders) {
            FileSymbolTable tableForPch = FileSymbolTable.forFile(pch, initial);
            if (tableForPch == null) continue;
            if (!precompiledContext.isProcessed(virtualFile)) {
                tableForPch.processSymbols(symbols, null, (Set<FileSymbolTable>)processed, importsMap, OCElementUtil.getFilePath(pch), initial, null);
                continue;
            }
            tableForPch.processSymbols(symbols, null, (Set<FileSymbolTable>)processed, importsMap, OCElementUtil.getFilePath(pch), initial, virtualFile);
            contextWasProcessed = true;
            break;
        }
        VirtualFile vfImportHolder = OCInclusionContextUtil.getVirtualFile(importHolder);
        if (!contextWasProcessed && vfImportHolder != null && !vfImportHolder.equals(virtualFile) && (table = FileSymbolTable.forFile(importHolder, initial)) != null) {
            table.processSymbols(symbols, null, (Set<FileSymbolTable>)processed, importsMap, null, initial, virtualFile);
            if (initial.isProcessed(virtualFile)) {
                return false;
            }
        }
        if ((table = file.getSymbolTable(initial)) != null) {
            table.processSymbols(symbols, null, (Set<FileSymbolTable>)processed, importsMap, null, initial, null);
        }
        return true;
    }

    static /* synthetic */ int access$000() {
        return CACHE_SIZE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/psi/impl/symbols/OCFileGlobalSymbolsCache", "processFileImpl"));
    }

    static class Cache {
        private final SLRUSynchronizedCache<OCFile, OCFileGlobalSymbols> main = new SLRUSynchronizedCache<OCFile, OCFileGlobalSymbols>(OCFileGlobalSymbolsCache.access$000(), OCFileGlobalSymbolsCache.access$000()){

            @Override
            @NotNull
            public OCFileGlobalSymbols createValue(OCFile key) {
                OCFileGlobalSymbols oCFileGlobalSymbols = OCFileGlobalSymbols.buildSymbols((OCFileImpl)key);
                if (oCFileGlobalSymbols == null) {
                    1.$$$reportNull$$$0(0);
                }
                return oCFileGlobalSymbols;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/symbols/OCFileGlobalSymbolsCache$Cache$1", "createValue"));
            }
        };
        private final SLRUSynchronizedCache<OCFile, OCLightFileGlobalSymbols> lightCache = new SLRUSynchronizedCache<OCFile, OCLightFileGlobalSymbols>(20, 20){

            @Override
            @NotNull
            public OCLightFileGlobalSymbols createValue(OCFile key) {
                OCLightFileGlobalSymbols oCLightFileGlobalSymbols = OCLightFileGlobalSymbols.buildSymbols((OCFileImpl)key, false);
                if (oCLightFileGlobalSymbols == null) {
                    2.$$$reportNull$$$0(0);
                }
                return oCLightFileGlobalSymbols;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/symbols/OCFileGlobalSymbolsCache$Cache$2", "createValue"));
            }
        };
        private final SLRUSynchronizedCache<OCFile, OCLightFileGlobalSymbols> typesOnlyCache = new SLRUSynchronizedCache<OCFile, OCLightFileGlobalSymbols>(150, 150){

            @Override
            @NotNull
            public OCLightFileGlobalSymbols createValue(OCFile key) {
                OCLightFileGlobalSymbols oCLightFileGlobalSymbols = OCLightFileGlobalSymbols.buildSymbols((OCFileImpl)key, true);
                if (oCLightFileGlobalSymbols == null) {
                    3.$$$reportNull$$$0(0);
                }
                return oCLightFileGlobalSymbols;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/psi/impl/symbols/OCFileGlobalSymbolsCache$Cache$3", "createValue"));
            }
        };

        Cache() {
        }
    }
}

