/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCAddTypeModifierIntentionAction
extends OCSymbolQuickFix<OCSymbol<?>> {
    private OCElementType myModifier;
    private String mySubject;
    private boolean myProcessSameSymbols;

    public OCAddTypeModifierIntentionAction(@NotNull OCSymbolWithQualifiedName symbol, OCElementType modifier, @Nullable String subject, boolean processSameSymbols) {
        if (symbol == null) {
            OCAddTypeModifierIntentionAction.$$$reportNull$$$0(0);
        }
        super(symbol);
        this.myProcessSameSymbols = true;
        this.myModifier = modifier;
        this.mySubject = subject;
        this.myProcessSameSymbols = processSameSymbols;
    }

    public OCAddTypeModifierIntentionAction(@NotNull OCSymbolWithQualifiedName symbol, OCElementType modifier, boolean processSameSymbols) {
        if (symbol == null) {
            OCAddTypeModifierIntentionAction.$$$reportNull$$$0(1);
        }
        this(symbol, modifier, symbol.getNameWithKindLowercase(OCCompilationContext.create(symbol, symbol.getProject())), processSameSymbols);
    }

    public OCAddTypeModifierIntentionAction(@NotNull OCSymbolWithQualifiedName symbol, OCElementType modifier) {
        if (symbol == null) {
            OCAddTypeModifierIntentionAction.$$$reportNull$$$0(2);
        }
        this(symbol, modifier, symbol.getNameWithKindLowercase(OCCompilationContext.create(symbol, symbol.getProject())), true);
    }

    @Override
    protected String getTextInternal() {
        return "Make " + this.mySubject + " " + this.myModifier.getName();
    }

    @NotNull
    public String getFamilyName() {
        String string = "Add '" + this.myModifier.getName() + "'";
        if (string == null) {
            OCAddTypeModifierIntentionAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public boolean isAvailable() {
        if (!super.isAvailable()) {
            return false;
        }
        if (this.myModifier == OCTokenTypes.CONST_KEYWORD && (((OCDeclaratorSymbol)this.mySymbol).isConst() || this.mySymbol.getKind() == OCSymbolKind.ENUM_CONST)) {
            return false;
        }
        if (this.myModifier == OCTokenTypes.BLOCK_KEYWORD && (((OCDeclaratorSymbol)this.mySymbol).isBlockModifiable() || this.mySymbol.getKind() != OCSymbolKind.LOCAL_VARIABLE)) {
            return false;
        }
        return this.myModifier != OCTokenTypes.VIRTUAL_CPP_KEYWORD || !((OCFunctionSymbol)this.mySymbol).isVirtual();
    }

    @Override
    protected void invoke(@NotNull Project project2, Editor editor) {
        if (project2 == null) {
            OCAddTypeModifierIntentionAction.$$$reportNull$$$0(4);
        }
        if (!OCCodeInsightUtil.isValid(this.mySymbol.locateDefinition(project2))) {
            return;
        }
        ArrayList nodesToUpdate = new ArrayList();
        Processor processor2 = symbol1 -> {
            Object element;
            if (project2 == null) {
                OCAddTypeModifierIntentionAction.$$$reportNull$$$0(5);
            }
            if ((element = symbol1.locateDefinition(project2)) == null || !(element.getParent() instanceof OCDeclaration)) {
                return true;
            }
            OCTypeElement typeElement = ((OCDeclaration)element.getParent()).getTypeElement();
            if (typeElement == null) {
                return true;
            }
            ASTNode typeNode = typeElement.getNode();
            if (typeNode != null && typeNode.getFirstChildNode() != null && typeNode.findChildByType((IElementType)this.myModifier) == null) {
                nodesToUpdate.add(typeNode);
            }
            return true;
        };
        if (this.myProcessSameSymbols) {
            this.mySymbol.processSameSymbols((Processor<OCSymbol>)processor2, project2);
        } else {
            processor2.process((Object)this.mySymbol);
        }
        OCFile context = this.mySymbol.getContainingOCFile(project2);
        for (ASTNode node : nodesToUpdate) {
            node.addChild(OCElementFactory.spaceFromText(context).getNode(), node.getFirstChildNode());
            CodeEditUtil.addChild((ASTNode)node, (ASTNode)OCElementFactory.typeModifierFromText(this.myModifier.getName(), context), (ASTNode)node.getFirstChildNode());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCAddTypeModifierIntentionAction";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCAddTypeModifierIntentionAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

