/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementsQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCChangeElementIntentionAction
extends OCPsiElementsQuickFix {
    private String myIntentionName;
    private String myFamilyName;

    public OCChangeElementIntentionAction(PsiElement element, PsiElement newElement, String intentionName) {
        this(element, newElement, intentionName, intentionName);
    }

    public OCChangeElementIntentionAction(PsiElement element, PsiElement newElement, String intentionName, String familyName) {
        super(element, newElement);
        this.myIntentionName = intentionName;
        this.myFamilyName = familyName;
    }

    public OCChangeElementIntentionAction(PsiElement element, List<? extends PsiElement> newElements, String intentionName) {
        super(ContainerUtil.concat(Collections.singletonList(element), newElements));
        this.myIntentionName = intentionName;
        this.myFamilyName = intentionName;
    }

    @Override
    protected String getTextInternal() {
        return this.myIntentionName;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.myFamilyName;
        if (string == null) {
            OCChangeElementIntentionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public boolean isAvailable() {
        return OCCodeInsightUtil.isValid(((SmartPsiElementPointer)this.myElementPointers.get(0)).getElement());
    }

    @Override
    protected void invoke(PsiFile file, @NotNull Project project2) {
        if (project2 == null) {
            OCChangeElementIntentionAction.$$$reportNull$$$0(1);
        }
        List<? extends PsiElement> elements = this.getElements();
        PsiElement oldElement = elements.get(0);
        if (elements.size() == 2) {
            PsiElement newElement = elements.get(1);
            if (oldElement instanceof OCExpression && newElement instanceof OCExpression) {
                OCParenthesesUtils.replaceExpressionAndAppendParentheses((OCExpression)oldElement, (OCExpression)newElement);
            } else {
                OCChangeUtil.replaceHandlingMacros(oldElement, newElement);
            }
        } else {
            PsiElement anchor = oldElement;
            for (int i = 1; i < elements.size(); ++i) {
                anchor = OCChangeUtil.addAfter(anchor.getParent(), elements.get(i), anchor);
            }
            OCChangeUtil.delete(oldElement);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCChangeElementIntentionAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCChangeElementIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

