/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureActionHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class OCChangeFunctionSignatureIntentionAction
extends OCSymbolQuickFix<OCSymbol<?>> {
    private OCFunctionType myNewType;
    private final String myText;

    public OCChangeFunctionSignatureIntentionAction(@NotNull OCSymbol functionSymbol, OCFunctionType newType, @NotNull OCResolveContext context) {
        if (functionSymbol == null) {
            OCChangeFunctionSignatureIntentionAction.$$$reportNull$$$0(0);
        }
        if (context == null) {
            OCChangeFunctionSignatureIntentionAction.$$$reportNull$$$0(1);
        }
        super(functionSymbol);
        this.myNewType = newType;
        this.myText = "Change signature of " + this.mySymbol.getNameWithKindLowercase(context) + " to '" + this.myNewType.getName(context) + "'";
    }

    @Override
    protected String getTextInternal() {
        return this.myText;
    }

    @NotNull
    public String getFamilyName() {
        if ("Change function signature" == null) {
            OCChangeFunctionSignatureIntentionAction.$$$reportNull$$$0(2);
        }
        return "Change function signature";
    }

    @Override
    public boolean isAvailable() {
        return super.isAvailable() && !this.mySymbol.isSynthetic() && this.myNewType.getParameterTypes().stream().allMatch(OCType::isInstanceable);
    }

    @Override
    protected void invoke(@NotNull Project project2, Editor editor) {
        Object declarator;
        if (project2 == null) {
            OCChangeFunctionSignatureIntentionAction.$$$reportNull$$$0(3);
        }
        if (!((declarator = this.mySymbol.locateDefinition(project2)) instanceof OCDeclarator) || !(declarator.getParent() instanceof OCFunctionDeclaration)) {
            return;
        }
        OCFunctionDeclaration function = (OCFunctionDeclaration)declarator.getParent();
        OCChangeSignatureHandler handler = OCChangeSignatureActionHandler.getHandler(function, function, false, true, true, false);
        OCParameterList parameterList = ((OCDeclarator)declarator).getParameterList();
        if (parameterList == null) {
            return;
        }
        handler.setReturnType(this.myNewType.getReturnType());
        HashSet<String> createdNames = new HashSet<String>();
        Iterator<OCType> newTypesItr = this.myNewType.getParameterTypes(true).iterator();
        ArrayList<Pair> newArguments = new ArrayList<Pair>();
        for (OCParameterDeclaration param : parameterList.getParameterDeclarations()) {
            OCDeclarator paramDecl = param.getDeclarator();
            String paramName = paramDecl != null ? paramDecl.getName() : null;
            handler.removeParameter(0);
            if (paramName != null) {
                createdNames.add(paramName);
            }
            if (!newTypesItr.hasNext()) continue;
            newArguments.add(Pair.create((Object)(paramName != null ? paramName : ""), (Object)newTypesItr.next()));
        }
        OCResolveContext context = OCResolveContext.forPsi(declarator);
        while (newTypesItr.hasNext()) {
            OCType newType = newTypesItr.next();
            Collection<String> suggestedNames = OCNameSuggester.suggestForType(newType, declarator, createdNames, context);
            String suggestedName = suggestedNames.isEmpty() ? "param" : suggestedNames.iterator().next();
            createdNames.add(suggestedName);
            newArguments.add(Pair.create((Object)suggestedName, (Object)newType));
        }
        int index = 0;
        for (Pair argument : newArguments) {
            handler.addParameter((String)argument.getFirst(), (OCType)argument.getSecond(), index++);
        }
        handler.invokeSynchronously();
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionSymbol";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCChangeFunctionSignatureIntentionAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCChangeFunctionSignatureIntentionAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

