/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.daemon.OCAnnotatorSink;
import com.jetbrains.cidr.lang.daemon.OCGetSymbolVisitor;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.quickfixes.OCQuickFix;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCNormalizeUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityAfterResolvingVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCChangeTypeIntentionAction
extends OCQuickFix {
    @NotNull
    private OCSymbol<?> mySymbol;
    private OCType mySubstitutionType;
    private String mySubject;
    private String myMessageSuffix;
    private boolean myReturnTypeMode;
    private boolean myChangeAssociatedSymbol;
    private boolean myChangeProperty;
    protected final Project myProject;

    public OCChangeTypeIntentionAction(@NotNull OCSymbol symbol, OCType substitutionType, @NotNull OCCompilationContext context) {
        if (symbol == null) {
            OCChangeTypeIntentionAction.$$$reportNull$$$0(0);
        }
        if (context == null) {
            OCChangeTypeIntentionAction.$$$reportNull$$$0(1);
        }
        this.myMessageSuffix = "";
        this.myChangeAssociatedSymbol = true;
        this.mySymbol = symbol;
        this.mySubstitutionType = substitutionType;
        this.mySubject = this.mySymbol.getNameWithKindLowercase(context);
        this.myProject = context.getProject();
    }

    public OCChangeTypeIntentionAction(@NotNull OCSymbol symbol, OCType substitutionType, boolean returnTypeMode, @NotNull OCCompilationContext context) {
        if (symbol == null) {
            OCChangeTypeIntentionAction.$$$reportNull$$$0(2);
        }
        if (context == null) {
            OCChangeTypeIntentionAction.$$$reportNull$$$0(3);
        }
        this(symbol, substitutionType, returnTypeMode, null, context);
    }

    public OCChangeTypeIntentionAction(@NotNull OCSymbol symbol, OCType substitutionType, boolean returnTypeMode, @Nullable String subject, @NotNull OCCompilationContext context) {
        if (symbol == null) {
            OCChangeTypeIntentionAction.$$$reportNull$$$0(4);
        }
        if (context == null) {
            OCChangeTypeIntentionAction.$$$reportNull$$$0(5);
        }
        this(symbol, substitutionType, subject, context);
        this.myReturnTypeMode = returnTypeMode;
        if (this.myReturnTypeMode && symbol.getKind().isFunction() && substitutionType.getTerminalType() instanceof OCFunctionType) {
            this.mySubstitutionType = OCPointerType.to(OCVoidType.instance());
        }
    }

    public OCChangeTypeIntentionAction(@NotNull OCSymbol symbol, OCType substitutionType, @Nullable String subject, @NotNull OCCompilationContext context) {
        if (symbol == null) {
            OCChangeTypeIntentionAction.$$$reportNull$$$0(6);
        }
        if (context == null) {
            OCChangeTypeIntentionAction.$$$reportNull$$$0(7);
        }
        this(symbol, substitutionType, context);
        if (subject != null) {
            this.mySubject = subject;
        }
    }

    public OCChangeTypeIntentionAction(@NotNull OCSymbol symbol, OCType substitutionType, String messageSuffix, boolean changeAssociatedSymbol, @NotNull OCCompilationContext context) {
        if (symbol == null) {
            OCChangeTypeIntentionAction.$$$reportNull$$$0(8);
        }
        if (context == null) {
            OCChangeTypeIntentionAction.$$$reportNull$$$0(9);
        }
        this(symbol, substitutionType, context);
        this.myMessageSuffix = messageSuffix;
        this.myChangeAssociatedSymbol = changeAssociatedSymbol;
    }

    public static void registerChangeTypeFix(@NotNull OCExpression expression, OCType substitutionType, Annotation annotation, OCAnnotatorSink sink) {
        if (expression == null) {
            OCChangeTypeIntentionAction.$$$reportNull$$$0(10);
        }
        OCGetSymbolVisitor visitor = new OCGetSymbolVisitor(true);
        expression.accept(visitor);
        OCSymbol symbol = visitor.getSymbol();
        if (symbol != null) {
            boolean returnTypeMode = OCParenthesesUtils.diveIntoParentheses(expression) instanceof OCCallExpression;
            if (!returnTypeMode) {
                substitutionType = OCPointerType.to(substitutionType, visitor.getNumOfDereferences());
            }
            sink.registerQuickFix(annotation, new OCChangeTypeIntentionAction(symbol, substitutionType, returnTypeMode, OCCompilationContext.create(expression)));
        }
    }

    @Override
    protected String getTextInternal() {
        return "Change " + (this.myReturnTypeMode || this.mySymbol instanceof OCMethodSymbol ? "return " : "") + "type of " + this.mySubject + " to '" + this.mySubstitutionType.getName(OCResolveContext.forSymbol(this.mySymbol, this.myProject)) + "'" + this.myMessageSuffix;
    }

    @NotNull
    public String getFamilyName() {
        if ("Change type" == null) {
            OCChangeTypeIntentionAction.$$$reportNull$$$0(11);
        }
        return "Change type";
    }

    @Override
    public boolean isAvailable() {
        if (!(OCSearchScope.isInProjectSources(this.mySymbol, this.myProject) && (OCCodeInsightUtil.isValid(this.mySymbol.locateDefinition(this.myProject)) || this.mySymbol instanceof OCInstanceVariableSymbol && ((OCInstanceVariableSymbol)this.mySymbol).isClang4ImplicitIvar(this.myProject)))) {
            return false;
        }
        OCType type = this.mySymbol.getType();
        if (this.mySymbol instanceof OCDeclaratorSymbol && type instanceof OCStructType && !((OCStructType)type).isPredeclaration()) {
            return this.mySubstitutionType instanceof OCPointerType && ((OCPointerType)this.mySubstitutionType).getRefType().getName().equals(type.getName());
        }
        if (this.mySymbol instanceof OCFunctionSymbol && type instanceof OCFunctionType && this.mySubstitutionType instanceof OCPointerType && ((OCPointerType)this.mySubstitutionType).getRefType() instanceof OCPointerType) {
            return false;
        }
        return this.mySubstitutionType.isInstanceable() || this.mySymbol.isCallable() && (this.mySubstitutionType instanceof OCFunctionType || this.mySubstitutionType instanceof OCVoidType);
    }

    @Override
    protected void invoke(PsiFile file, @NotNull Project project2) {
        if (project2 == null) {
            OCChangeTypeIntentionAction.$$$reportNull$$$0(12);
        }
        ArrayList<OCSymbol> symbolsToChange = new ArrayList<OCSymbol>();
        OCSymbol associatedSymbol = this.mySymbol.getAssociatedSymbol(project2);
        if (this.mySymbol instanceof OCMemberSymbol && this.myChangeAssociatedSymbol) {
            ((OCClassSymbol)((OCMemberSymbol)this.mySymbol).getParent()).processMembersInAllCategories(this.mySymbol.getName(), this.mySymbol.getClass(), member -> {
                if (member != associatedSymbol && !member.isSynthetic() && this.needToChangeType((OCSymbol)member, file)) {
                    symbolsToChange.add((OCSymbol)member);
                }
                return true;
            }, false, project2);
        } else if ((this.mySymbol instanceof OCFunctionSymbol || this.mySymbol instanceof OCDeclaratorSymbol) && this.myChangeAssociatedSymbol) {
            this.mySymbol.processSameSymbols((Processor<OCSymbol>)((Processor)symbol -> {
                if (this.needToChangeType((OCSymbol)symbol, file)) {
                    symbolsToChange.add((OCSymbol)symbol);
                }
                return true;
            }), project2);
        } else {
            symbolsToChange.add(this.mySymbol);
        }
        if (this.myChangeAssociatedSymbol) {
            OCPropertySymbol property;
            if (associatedSymbol != null && this.needToChangeType(associatedSymbol, file)) {
                symbolsToChange.add(associatedSymbol);
            }
            OCResolveContext context = OCResolveContext.forPsi((PsiElement)file);
            if (this.mySymbol instanceof OCPropertySymbol) {
                ((OCPropertySymbol)this.mySymbol).processAccessorMethods((Processor<? super OCMethodSymbol>)((Processor)method -> {
                    if (method.isGetter(context)) {
                        symbolsToChange.add((OCSymbol)method);
                    } else if (method.isSetter(context)) {
                        symbolsToChange.add(method.getSelectors().get(0).getParameter());
                    }
                    return true;
                }), true, project2);
                OCInstanceVariableSymbol ivar = ((OCPropertySymbol)this.mySymbol).getAssociatedIvar(project2);
                if (ivar != null && this.needToChangeType(ivar, file)) {
                    int code;
                    String message = "Do you want to change type of " + ivar.getNameWithKindLowercase(context) + " as well?";
                    int n = code = ApplicationManager.getApplication().isUnitTestMode() || ivar.isClang4ImplicitIvar(project2) ? 0 : Messages.showYesNoCancelDialog((String)message, (String)"Change Type", (Icon)Messages.getQuestionIcon());
                    if (code == 0) {
                        symbolsToChange.add(ivar);
                    } else if (code == 2) {
                        return;
                    }
                }
            } else if (this.mySymbol instanceof OCInstanceVariableSymbol && (property = ((OCInstanceVariableSymbol)this.mySymbol).getAssociatedProperty(project2)) != null && this.needToChangeType(property, file)) {
                if (((OCInstanceVariableSymbol)this.mySymbol).getGeneratedFromProperty() != null) {
                    symbolsToChange.add(property);
                    this.myChangeProperty = true;
                } else {
                    int code;
                    String message = "Do you want to change type of " + property.getNameWithKindLowercase(context) + " as well?";
                    int n = code = ApplicationManager.getApplication().isUnitTestMode() ? 0 : Messages.showYesNoCancelDialog((String)message, (String)"Change Type", (Icon)Messages.getQuestionIcon());
                    if (code == 0) {
                        symbolsToChange.add(property);
                        this.myChangeProperty = true;
                    } else if (code == 2) {
                        return;
                    }
                }
            }
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (project2 == null) {
                OCChangeTypeIntentionAction.$$$reportNull$$$0(14);
            }
            HashMap<OCSymbol, SmartPsiElementPointer> elementPtrs = new HashMap<OCSymbol, SmartPsiElementPointer>();
            for (OCSymbol symbol : symbolsToChange) {
                PsiElement element = symbol != null ? (PsiElement)symbol.locateDefinition(project2) : null;
                if (element == null) continue;
                elementPtrs.put(symbol, SmartPointerManager.getInstance((Project)project2).createSmartPsiElementPointer(element));
            }
            for (OCSymbol symbol : elementPtrs.keySet()) {
                this.doChangeType(((SmartPsiElementPointer)elementPtrs.get(symbol)).getElement(), symbol);
            }
        });
    }

    private boolean needToChangeType(OCSymbol symbol, @NotNull PsiFile file) {
        OCType type;
        if (file == null) {
            OCChangeTypeIntentionAction.$$$reportNull$$$0(13);
        }
        OCType oCType = type = symbol instanceof OCMethodSymbol ? ((OCMethodSymbol)symbol).getReturnType(file.getProject()) : symbol.getType();
        if (this.myReturnTypeMode) {
            if (!(type instanceof OCFunctionType)) {
                return true;
            }
            type = ((OCFunctionType)type).getReturnType();
        }
        if (type.resolve((PsiElement)file) instanceof OCTypeParameterType) {
            return false;
        }
        OCResolveContext resolveContext = OCResolveContext.forPsi((PsiElement)file);
        return !new OCTypeEqualityAfterResolvingVisitor(this.mySubstitutionType, false, false, false, false, resolveContext).equal(type);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doChangeType(PsiElement element22, OCSymbol symbol) {
        void element22;
        OCTypeElement typeElement;
        if (!FileModificationService.getInstance().prepareFileForWrite(element22.getContainingFile())) {
            return;
        }
        OCDeclarator myDeclarator = null;
        OCType type = this.mySubstitutionType;
        if (element22 instanceof OCDeclarator) {
            myDeclarator = (OCDeclarator)element22;
            typeElement = ((OCDeclaration)element22.getParent()).getTypeElement();
        } else if (element22 instanceof OCMethodSelectorPart) {
            typeElement = ((OCMethodSelectorPart)element22).getTypeElement();
        } else if (element22 instanceof OCMethod) {
            typeElement = ((OCMethod)element22).getReturnTypeElement();
        } else if (element22 instanceof OCBlockExpression) {
            typeElement = ((OCBlockExpression)element22).getReturnTypeElement();
        } else if (element22 instanceof OCLambdaExpression) {
            typeElement = ((OCLambdaExpression)element22).getReturnTypeElement();
        } else {
            if (!(element22 instanceof OCReferenceElement) || !(element22.getParent() instanceof OCSynthesizeProperty) || !this.myChangeProperty) return;
            Object element22 = (symbol = ((OCInstanceVariableSymbol)((Object)symbol)).getAssociatedProperty(element22.getProject())).locateDefinition(element22.getProject());
            if (!(element22 instanceof OCDeclarator)) return;
            myDeclarator = (OCDeclarator)element22;
            typeElement = ((OCDeclaration)element22.getParent()).getTypeElement();
        }
        if (typeElement == null) {
            void var7_14;
            void element22;
            if (!(element22 instanceof OCBlockExpression)) return;
            OCTypeElement newTypeElement = OCElementFactory.typeElementFromText(type.getBestNameInContext((PsiElement)element22), (PsiElement)element22);
            OCParameterList oCParameterList = ((OCBlockExpression)element22).getParameterList();
            if (oCParameterList == null) {
                OCBlockStatement oCBlockStatement = ((OCBlockExpression)element22).getBody();
            }
            element22.addBefore((PsiElement)newTypeElement, (PsiElement)var7_14);
            return;
        }
        if (myDeclarator != null) {
            OCDeclaration declaration = OCNormalizeUtil.normalizeDeclarator(myDeclarator);
            if (declaration == null) {
                return;
            }
            PsiElement element22 = declaration.getDeclarators().get(0);
            PsiElement psiElement = OCElementFactory.binaryOperatorFromText("*", element22);
            PsiElement roof = OCElementFactory.binaryOperatorFromText("^", element22);
            PsiElement ampersand = OCElementFactory.binaryOperatorFromText("&", element22);
            PsiElement doubleAmpersand = OCElementFactory.binaryOperatorFromText("&&", element22);
            PsiElement constKeyword = OCElementFactory.create(OCTokenTypes.CONST_KEYWORD, element22);
            PsiElement volatileKeyword = OCElementFactory.create(OCTokenTypes.VOLATILE_KEYWORD, element22);
            ArrayList<PsiElement> declaratorModifiers = new ArrayList<PsiElement>();
            boolean isBlockType = type instanceof OCBlockPointerType;
            if (!this.myReturnTypeMode) {
                while ((type instanceof OCPointerType && !type.isPointerToID() || type instanceof OCCppReferenceType) && type.getAliasName() == null) {
                    if (type.isConst()) {
                        declaratorModifiers.add(0, constKeyword);
                    }
                    if (type.isVolatile()) {
                        declaratorModifiers.add(0, volatileKeyword);
                    }
                    if (type instanceof OCCppReferenceType) {
                        OCCppReferenceType referenceType = (OCCppReferenceType)type;
                        declaratorModifiers.add(0, referenceType.isRvalueRef() ? doubleAmpersand : ampersand);
                        type = referenceType.getRefType();
                        continue;
                    }
                    declaratorModifiers.add(0, isBlockType && declaratorModifiers.isEmpty() ? roof : psiElement);
                    type = ((OCPointerType)type).getRefType();
                }
                for (OCDeclarator declarator : declaration.getDeclarators()) {
                    boolean isPointerToFunction = declarator.isPointerToFunction();
                    this.removeAllModifiers(declarator);
                    if (declaration instanceof OCFunctionDeclaration && !isPointerToFunction) continue;
                    for (PsiElement token : declaratorModifiers) {
                        OCChangeTypeIntentionAction.addModifier(declarator, token.copy());
                    }
                }
                if (type instanceof OCFunctionType) {
                    if (((OCDeclarator)element22).getParameterList() != null) {
                        OCChangeTypeIntentionAction.changeFunctionType((OCDeclarator)element22, (OCFunctionType)type);
                        return;
                    } else {
                        OCDeclarationStatement newDeclaration = OCElementFactory.declarationStatement(myDeclarator.getName(), this.mySubstitutionType, myDeclarator.getInitializer(), declaration);
                        OCChangeUtil.replaceHandlingMacros(declaration, newDeclaration.getDeclaration());
                    }
                    return;
                }
            } else if (declaration instanceof OCFunctionDeclaration) {
                for (OCDeclarator declarator : declaration.getDeclarators()) {
                    this.removeAllModifiers(declarator);
                }
            }
            typeElement = declaration.getTypeElement();
            this.removeAllModifiers(typeElement);
            if (typeElement == null || typeElement.getType().equals(type, OCResolveContext.forPsi(typeElement))) {
                return;
            }
        }
        if (element22 instanceof OCBlockExpression && type.isVoid()) {
            OCChangeUtil.delete(typeElement);
            return;
        } else {
            OCTypeElement newTypeElement = OCElementFactory.typeElementFromText(type.getBestNameInContext(typeElement), (PsiElement)element22);
            OCElementUtil.replaceDeclarationQualifiers(newTypeElement, typeElement);
            typeElement = (OCTypeElement)OCChangeUtil.replaceHandlingMacros(typeElement, newTypeElement);
            OCImportSymbolFix.fixAllSymbolsRecursively(typeElement);
        }
    }

    private static void changeFunctionType(OCDeclarator declarator, OCFunctionType newFunctionType) {
        OCFunctionDeclaration functionDef;
        OCParameterList parameterList = declarator.getParameterList();
        OCResolveContext context = OCResolveContext.forPsi(declarator);
        if (declarator.getParent() instanceof OCFunctionDeclaration && !(functionDef = (OCFunctionDeclaration)declarator.getParent()).getReturnType().equalsAfterResolving(newFunctionType.getReturnType(), context)) {
            OCTypeElement newTypeElement = OCElementFactory.typeElementFromText(newFunctionType.getReturnType().getBestNameInContext(context), declarator);
            OCChangeUtil.replaceHandlingMacros(functionDef.getTypeElement(), newTypeElement);
        }
        if (parameterList == null) {
            return;
        }
        Iterator<OCType> newTypesItr = newFunctionType.getParameterTypes(true).iterator();
        HashSet<String> createdNames = new HashSet<String>();
        for (OCParameterDeclaration param : parameterList.getParameterDeclarations()) {
            if (newTypesItr.hasNext()) {
                OCType newType = newTypesItr.next();
                OCDeclarator paramDeclarator = param.getDeclarator();
                if (paramDeclarator != null) {
                    if (paramDeclarator.getType().equalsAfterResolving(newType, context)) continue;
                    String paramName = paramDeclarator.getNameIdentifier() != null ? paramDeclarator.getName() : "";
                    OCChangeUtil.replaceHandlingMacros(param, OCElementFactory.paramDeclarationByNameAndType(paramName, newType, declarator));
                    continue;
                }
                String newName = OCNameSuggester.suggestForType(newType, (PsiElement)declarator, createdNames, context).iterator().next();
                createdNames.add(newName);
                param.replace(OCElementFactory.paramDeclarationByNameAndType(newName, newType, declarator));
                continue;
            }
            OCChangeUtil.delete(param);
        }
        while (newTypesItr.hasNext()) {
            OCType type = newTypesItr.next();
            String newName = OCNameSuggester.suggestForType(type, (PsiElement)declarator, createdNames, context).iterator().next();
            createdNames.add(newName);
            OCChangeUtil.add(parameterList, OCElementFactory.paramDeclarationByNameAndType(newName, type, declarator));
        }
        if (newFunctionType.isConst()) {
            declarator.getParent().addAfter(OCElementFactory.create(OCTokenTypes.CONST_KEYWORD, declarator), (PsiElement)declarator);
        }
        if (newFunctionType.isVolatile()) {
            declarator.getParent().addAfter(OCElementFactory.create(OCTokenTypes.VOLATILE_KEYWORD, declarator), (PsiElement)declarator);
        }
    }

    private void removeAllModifiers(PsiElement element) {
        if (element == null) {
            return;
        }
        ASTNode parent = element.getNode();
        ASTNode child = parent.getFirstChildNode();
        ArrayList<PsiElement> elemsToRemove = new ArrayList<PsiElement>();
        ArrayList<Pair> rangesToRemove = new ArrayList<Pair>();
        PsiElement rangeStart = null;
        while (child != null) {
            IElementType tt = child.getElementType();
            ASTNode nextChild = child.getTreeNext();
            if (this.myReturnTypeMode && tt == OCElementTypes.PARAMETER_LIST) break;
            if (OCTokenTypes.DECLARATOR_MODIFIERS.contains(tt)) {
                elemsToRemove.add(child.getPsi());
            } else if (tt == OCTokenTypes.LBRACKET) {
                rangeStart = child.getPsi();
            } else if (tt == OCTokenTypes.RBRACKET) {
                if (rangeStart != null) {
                    rangesToRemove.add(Pair.create((Object)rangeStart, (Object)child.getPsi()));
                }
                rangeStart = null;
            }
            child = nextChild;
        }
        for (PsiElement psiElement : elemsToRemove) {
            psiElement.delete();
        }
        for (Pair pair2 : rangesToRemove) {
            element.deleteChildRange((PsiElement)pair2.getFirst(), (PsiElement)pair2.getSecond());
        }
    }

    private static void addModifier(PsiElement element, PsiElement token) {
        if (element == null) {
            return;
        }
        ASTNode parent = element.getNode();
        for (ASTNode child = parent.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() != OCTokenTypes.IDENTIFIER) continue;
            CodeEditUtil.addChild((ASTNode)parent, (ASTNode)token.getNode(), (ASTNode)child);
            return;
        }
        CodeEditUtil.addChild((ASTNode)parent, (ASTNode)token.getNode(), null);
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCChangeTypeIntentionAction";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCChangeTypeIntentionAction";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "registerChangeTypeFix";
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "needToChangeType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

