/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.psi.OCNSArrayLiteral;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCConvertObjCLiteralIntentionAction
extends OCPsiElementQuickFix<OCSendMessageExpression> {
    private static final Converter[] CONVERTERS = new Converter[]{new Converter(Feature.CONSTANT, "NSNumber", "numberWith*", "Switch to @()", "@#P0"), new Converter(Feature.CONSTANT, "NSNumber", "numberWith*", "Switch to @()", "@(#P0)"), new Converter(Feature.COLLECTION, "NSArray", "arrayWithObject:", "Switch to @[]", "@[#P0]"), new Converter(Feature.COLLECTION, "NSArray", "arrayWithObjects:", "Switch to @[]", "@[#P0#*]", ",#P0", true, null), new Converter(Feature.COLLECTION, "NSArray", "initWithObjects:", "Switch to @[]", "@[#P0#*]", ",#P0", true, null), new Converter(Feature.COLLECTION, "NSMutableArray", "arrayWithObject:", "Switch to @[]", "[@[#P0] mutableCopy]"), new Converter(Feature.COLLECTION, "NSMutableArray", "arrayWithObjects:", "Switch to @[]", "[@[#P0#*] mutableCopy]", ",#P0", true, null), new Converter(Feature.COLLECTION, "NSMutableArray", "initWithObjects:", "Switch to @[]", "[@[#P0#*] mutableCopy]", ",#P0", true, null), new Converter(Feature.COLLECTION, "NSDictionary", "dictionaryWithObject:forKey:", "Switch to @{}", "@{#P1:#P0}"), new Converter(Feature.COLLECTION, "NSDictionary", "dictionaryWithObjects:forKeys:", "Switch to @{}", "@{#P1:#P0#*}", ",#P1:#P0", false, SpecialFlag.UNPACK_ARRAYS), new Converter(Feature.COLLECTION, "NSDictionary", "initWithObjects:forKeys:", "Switch to @{}", "@{#P1:#P0#*}", ",#P1:#P0", false, SpecialFlag.UNPACK_ARRAYS), new Converter(Feature.COLLECTION, "NSDictionary", "dictionaryWithObjectsAndKeys:", "Switch to @{}", "@{#P1:#P0#*}", ",#P1:#P0", true, SpecialFlag.INTERLEAVE), new Converter(Feature.COLLECTION, "NSDictionary", "initWithObjectsAndKeys:", "Switch to @{}", "@{#P1:#P0#*}", ",#P1:#P0", true, SpecialFlag.INTERLEAVE), new Converter(Feature.COLLECTION, "NSMutableDictionary", "dictionaryWithObject:forKey:", "Switch to @{}", "[@{#P1:#P0} mutableCopy]"), new Converter(Feature.COLLECTION, "NSMutableDictionary", "dictionaryWithObjects:forKeys:", "Switch to @{}", "[@{#P1:#P0#*} mutableCopy]", ",#P1:#P0", false, SpecialFlag.UNPACK_ARRAYS), new Converter(Feature.COLLECTION, "NSMutableDictionary", "initWithObjects:forKeys:", "Switch to @{}", "[@{#P1:#P0#*} mutableCopy]", ",#P1:#P0", false, SpecialFlag.UNPACK_ARRAYS), new Converter(Feature.COLLECTION, "NSMutableDictionary", "dictionaryWithObjectsAndKeys:", "Switch to @{}", "[@{#P1:#P0#*} mutableCopy]", ",#P1:#P0", true, SpecialFlag.INTERLEAVE), new Converter(Feature.COLLECTION, "NSMutableDictionary", "initWithObjectsAndKeys:", "Switch to @{}", "[@{#P1:#P0#*} mutableCopy]", ",#P1:#P0", true, SpecialFlag.INTERLEAVE), new Converter(Feature.SUBSCRIPTING, "NSArray", "objectAtIndex:", "Switch to []", "#R[#P0]"), new Converter(Feature.SUBSCRIPTING, "NSArray", "objectAtIndexedSubscript:", "Switch to []", "#R[#P0]"), new Converter(Feature.SUBSCRIPTING, "NSMutableArray", "objectAtIndex:", "Switch to []", "#R[#P0]"), new Converter(Feature.SUBSCRIPTING, "NSMutableArray", "objectAtIndexedSubscript:", "Switch to []", "#R[#P0]"), new Converter(Feature.SUBSCRIPTING, "NSMutableArray", "replaceObjectAtIndex:withObject:", "Switch to []", "#R[#P0] = #P1"), new Converter(Feature.SUBSCRIPTING, "NSMutableArray", "setObject:atIndexedSubscript:", "Switch to []", "#R[#P1] = #P0"), new Converter(Feature.SUBSCRIPTING, "NSDictionary", "objectForKey:", "Switch to []", "#R[#P0]"), new Converter(Feature.SUBSCRIPTING, "NSMutableDictionary", "objectForKey:", "Switch to []", "#R[#P0]"), new Converter(Feature.SUBSCRIPTING, "NSMutableDictionary", "setObject:forKey:", "Switch to []", "#R[#P1] = #P0"), new Converter(Feature.SUBSCRIPTING, "NSMutableDictionary", "setObject:forKeyedSubscript:", "Switch to []", "#R[#P1] = #P0")};
    private static final MultiMap<String, Converter> ourConverters;
    private static final Converter NUMBER_CONST_CONVERTER;
    private static final Converter NUMBER_CONVERTER;
    private Converter myConverter;

    public OCConvertObjCLiteralIntentionAction(@NotNull OCSendMessageExpression element, Converter converter) {
        if (element == null) {
            OCConvertObjCLiteralIntentionAction.$$$reportNull$$$0(0);
        }
        super(element);
        this.myConverter = converter;
    }

    @NotNull
    public String getFamilyName() {
        if ("Switch to Objective-C literal" == null) {
            OCConvertObjCLiteralIntentionAction.$$$reportNull$$$0(1);
        }
        return "Switch to Objective-C literal";
    }

    @Override
    protected String getTextInternal() {
        return this.myConverter.getIntentionName();
    }

    @Override
    public boolean isAvailable(@NotNull OCSendMessageExpression element) {
        if (element == null) {
            OCConvertObjCLiteralIntentionAction.$$$reportNull$$$0(2);
        }
        return this.getReplacement(element) != null;
    }

    @Override
    protected void invoke(PsiFile file, @NotNull OCSendMessageExpression expr) {
        OCExpression newExpr;
        if (expr == null) {
            OCConvertObjCLiteralIntentionAction.$$$reportNull$$$0(3);
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.convertToLiteral");
        String replacement = this.getReplacement(expr);
        OCExpression oCExpression = newExpr = replacement != null ? OCElementFactory.expressionFromText(replacement, expr) : null;
        if (newExpr != null) {
            OCChangeUtil.replaceHandlingMacros(expr, newExpr);
        }
    }

    @Nullable
    public String getReplacement(@Nullable OCSendMessageExpression expr) {
        Converter converter = OCConvertObjCLiteralIntentionAction.findConverter(expr);
        if (converter == null) {
            return null;
        }
        List<List<OCExpression>> arguments = OCConvertObjCLiteralIntentionAction.getArguments(expr, converter);
        String replacement = converter.getReplacement();
        OCExpression receiver = OCParenthesesUtils.diveIntoParentheses(expr.getReceiverExpression());
        boolean isEmpty = false;
        boolean isFirst = true;
        if (arguments == null || arguments.isEmpty()) {
            return null;
        }
        if (receiver != null) {
            replacement = replacement.replace("#R", this.tryGetReplacement(receiver, receiver, true, 2));
        }
        while (!isEmpty) {
            for (int i = 0; i < arguments.size(); ++i) {
                String argReplacement;
                List<OCExpression> curArguments = arguments.get(i);
                OCExpression argument = OCParenthesesUtils.diveIntoParentheses((OCExpression)ContainerUtil.getFirstItem(curArguments));
                if (argument != null) {
                    argReplacement = "";
                    if (converter.getSpecialFlag() == SpecialFlag.INTERLEAVE && arguments.size() == 2) {
                        OCExpression coArgument = OCParenthesesUtils.diveIntoParentheses((OCExpression)ContainerUtil.getFirstItem(arguments.get(1 - i)));
                        if (coArgument != null) {
                            argReplacement = this.tryGetReplacement(argument, coArgument, isFirst && i == 1, -1);
                        }
                    } else {
                        argReplacement = this.tryGetReplacement(argument, argument, isFirst && i == 0, -1);
                    }
                } else {
                    return null;
                }
                replacement = replacement.replace("#P" + i, argReplacement + OCConvertObjCLiteralIntentionAction.getLiteralSuffix(converter, expr.getMessageSelector(), argument));
            }
            for (List<OCExpression> curArguments : arguments) {
                curArguments.remove(0);
                isEmpty |= curArguments.isEmpty();
            }
            replacement = replacement.replace("#*", isEmpty ? "" : converter.getReplacementLoop() + "#*");
            isFirst = false;
        }
        return replacement;
    }

    private static String getLiteralSuffix(Converter converter, String selector, OCExpression argument) {
        if (converter == NUMBER_CONST_CONVERTER) {
            Number number = OCExpressionEvaluator.evaluate(argument);
            if (OCExpressionEvaluator.isIntValue(number)) {
                if (selector.equals("numberWithFloat:")) {
                    return ".0F";
                }
                if (selector.equals("numberWithDouble:")) {
                    return ".0";
                }
            } else if (selector.equals("numberWithFloat:")) {
                return "F";
            }
        }
        return "";
    }

    @NotNull
    public String tryGetReplacement(@NotNull OCExpression expr, @NotNull OCExpression spacesAndCommentsFrom, boolean skipWhitespaces, int parentPrecedence) {
        if (expr == null) {
            OCConvertObjCLiteralIntentionAction.$$$reportNull$$$0(4);
        }
        if (spacesAndCommentsFrom == null) {
            OCConvertObjCLiteralIntentionAction.$$$reportNull$$$0(5);
        }
        String replacement = expr instanceof OCSendMessageExpression ? this.getReplacement((OCSendMessageExpression)expr) : null;
        int precedence = OCParenthesesUtils.getPrecedence(expr, false);
        if (replacement == null) {
            replacement = parentPrecedence != -1 && precedence > parentPrecedence ? "(" + expr.getTextWithMacros() + ")" : expr.getTextWithMacros();
        }
        String string = OCElementUtil.getLeadingCommentsAndWhitespaces(spacesAndCommentsFrom, skipWhitespaces) + replacement + OCElementUtil.getTrailingCommentsAndWhitespaces(spacesAndCommentsFrom, skipWhitespaces);
        if (string == null) {
            OCConvertObjCLiteralIntentionAction.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public static Converter findConverter(@Nullable OCSendMessageExpression expr) {
        if (expr == null || OCElementUtil.containsDirectives(expr)) {
            return null;
        }
        OCExpression receiver = expr.getReceiverExpression();
        OCType receiverType = receiver != null ? receiver.getResolvedType().getGuessedType() : null;
        String selector = expr.getMessageSelector();
        if (selector.startsWith("numberWith")) {
            OCMethodSymbol responder = expr.getProbableResponders().getKnownResponder();
            OCExpression argument = (OCExpression)ContainerUtil.getFirstItem(expr.getArgumentExpressions());
            String argumentText = argument != null ? argument.getTextWithMacros() : null;
            OCDeclaratorSymbol paramSymbol = responder != null ? (OCDeclaratorSymbol)ContainerUtil.getFirstItem(responder.getParameterSymbols()) : null;
            OCResolveContext context = OCResolveContext.forPsi(expr);
            if (paramSymbol == null || argument == null || !paramSymbol.getType().resolve(context).checkCompatible(argument.getResolvedType(), argument, argument, context).getState().isOK()) {
                return null;
            }
            if (argument instanceof OCLiteralExpression || "YES".equals(argumentText) || "NO".equals(argumentText)) {
                return NUMBER_CONST_CONVERTER;
            }
            return NUMBER_CONVERTER;
        }
        if (receiverType instanceof OCPointerType) {
            receiverType = ((OCPointerType)receiverType).getRefType();
        }
        String receiverTypeName = receiverType instanceof OCObjectType ? ((OCObjectType)receiverType).getClassName() : null;
        boolean supportsObjectLiterals = OCCompilerFeatures.supportsObjectLiterals(expr.getContainingFile());
        boolean supportsSubscripting = OCCompilerFeatures.supportsSubscripting(expr.getContainingFile());
        for (Converter converter : ourConverters.get((Object)selector)) {
            if (converter.getFeature() == Feature.COLLECTION && !supportsObjectLiterals || converter.getFeature() == Feature.SUBSCRIPTING && !supportsSubscripting || !converter.getReceiverType().equals(receiverTypeName)) continue;
            if (converter.getFeature() != Feature.CONSTANT) {
                for (OCExpression argument : expr.getArgumentExpressions()) {
                    OCType type = argument.getResolvedType();
                    OCResolveContext context = OCResolveContext.forPsi(argument);
                    if (type.isPointerToObject() || type.isUnknown() || OCExpressionEvaluator.isLikeNil(argument, context) || type.isIntegerCompatible(context)) continue;
                    return null;
                }
            }
            return converter;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static List<List<OCExpression>> getArguments(OCSendMessageExpression expr, Converter converter) {
        ArrayList<List<OCExpression>> allArguments = new ArrayList<List<OCExpression>>();
        ArrayList<OCExpression> arguments = null;
        for (OCMessageArgument argument : expr.getArguments()) {
            String string = argument.getArgumentSelector().getSelectorName();
            OCExpression argExpr = argument.getArgumentExpression();
            if (argExpr == null) continue;
            if (!string.isEmpty() || arguments == null) {
                if (arguments != null) {
                    allArguments.add((List<OCExpression>)arguments);
                }
                arguments = new ArrayList<OCExpression>();
            }
            if (converter.getSpecialFlag() == SpecialFlag.UNPACK_ARRAYS) {
                Converter subConverter;
                List items;
                if (argExpr instanceof OCLiteralExpression && argExpr.getFirstChild() instanceof OCNSArrayLiteral) {
                    arguments.addAll(((OCNSArrayLiteral)argExpr.getFirstChild()).getElements());
                    continue;
                }
                if (!(argExpr instanceof OCSendMessageExpression) || !((OCSendMessageExpression)argExpr).getMessageSelector().startsWith("arrayWithObject") || (items = (subConverter = OCConvertObjCLiteralIntentionAction.findConverter((OCSendMessageExpression)argExpr)) != null ? (List)ContainerUtil.getFirstItem(OCConvertObjCLiteralIntentionAction.getArguments((OCSendMessageExpression)argExpr, subConverter)) : null) == null) continue;
                arguments.addAll(items);
                continue;
            }
            if (converter.isRequireNilTermination() && OCCodeInsightUtil.isLikeNull(argExpr.getTextWithMacros())) continue;
            arguments.add(argExpr);
        }
        if (arguments != null) {
            if (converter.getSpecialFlag() == SpecialFlag.INTERLEAVE) {
                void var6_9;
                ArrayList<OCExpression> args1 = new ArrayList<OCExpression>();
                ArrayList<OCExpression> args2 = new ArrayList<OCExpression>();
                boolean bl = false;
                while (var6_9 < arguments.size()) {
                    OCExpression argument = (OCExpression)arguments.get((int)var6_9);
                    if (var6_9 % 2 == false) {
                        args1.add(argument);
                    } else {
                        args2.add(argument);
                    }
                    ++var6_9;
                }
                allArguments.add(args1);
                allArguments.add(args2);
            } else {
                allArguments.add(arguments);
            }
        }
        int length = -1;
        for (List list : allArguments) {
            if (length == -1) {
                length = list.size();
                continue;
            }
            if (length == list.size()) continue;
            return null;
        }
        return length > 0 ? allArguments : null;
    }

    static {
        NUMBER_CONST_CONVERTER = CONVERTERS[0];
        NUMBER_CONVERTER = CONVERTERS[1];
        ourConverters = new MultiMap();
        for (Converter converter : CONVERTERS) {
            ourConverters.putValue((Object)converter.getMessageName(), (Object)converter);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCConvertObjCLiteralIntentionAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spacesAndCommentsFrom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCConvertObjCLiteralIntentionAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "tryGetReplacement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "tryGetReplacement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Converter {
        private Feature myFeature;
        private String myReceiverType;
        private String myMessageName;
        private String myIntentionName;
        private String myReplacement;
        private String myReplacementLoop;
        private boolean myRequireNilTermination;
        private SpecialFlag mySpecialFlag;

        private Converter(Feature feature, String receiverType, String messageName, String intentionName, String replacement) {
            this.myFeature = feature;
            this.myReceiverType = receiverType;
            this.myMessageName = messageName;
            this.myIntentionName = intentionName;
            this.myReplacement = replacement;
        }

        private Converter(Feature feature, String receiverType, String messageName, String intentionName, String replacement, @Nullable String loop, boolean requireNilTermination, @Nullable SpecialFlag flag) {
            this(feature, receiverType, messageName, intentionName, replacement);
            this.myReplacementLoop = loop;
            this.myRequireNilTermination = requireNilTermination;
            this.mySpecialFlag = flag;
        }

        public Feature getFeature() {
            return this.myFeature;
        }

        public String getMessageName() {
            return this.myMessageName;
        }

        public String getIntentionName() {
            return this.myIntentionName;
        }

        public String getReplacement() {
            return this.myReplacement;
        }

        public String getReplacementLoop() {
            return this.myReplacementLoop;
        }

        public String getReceiverType() {
            return this.myReceiverType;
        }

        public boolean isRequireNilTermination() {
            return this.myRequireNilTermination;
        }

        public SpecialFlag getSpecialFlag() {
            return this.mySpecialFlag;
        }
    }

    private static enum SpecialFlag {
        UNPACK_ARRAYS,
        INTERLEAVE;

    }

    private static enum Feature {
        CONSTANT,
        COLLECTION,
        SUBSCRIPTING;

    }
}

