/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCTollFreeBridges;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeCheckState;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCConvertTypeIntentionAction
extends OCPsiElementQuickFix<OCExpression>
implements HighPriorityAction {
    private OCType myType;

    public OCConvertTypeIntentionAction(@NotNull OCExpression expression, OCType type) {
        if (expression == null) {
            OCConvertTypeIntentionAction.$$$reportNull$$$0(0);
        }
        super(expression);
        this.myType = type;
        OCType nsType = OCTollFreeBridges.getResolvedNSCounterpart(this.myType.getName(), expression);
        if (nsType instanceof OCPointerType) {
            this.myType = nsType;
        }
    }

    @Override
    protected String getTextInternal() {
        OCMethodSymbol method = this.getMethod();
        assert (method != null);
        return "Call " + method.getNameWithParent(OCResolveContext.forSymbol(method, this.getProject()));
    }

    @NotNull
    public String getFamilyName() {
        if ("Convert type" == null) {
            OCConvertTypeIntentionAction.$$$reportNull$$$0(1);
        }
        return "Convert type";
    }

    @Override
    protected boolean isAvailable(@NotNull OCExpression expression) {
        if (expression == null) {
            OCConvertTypeIntentionAction.$$$reportNull$$$0(2);
        }
        return this.getMethod() != null;
    }

    @Override
    protected void invoke(PsiFile file, @NotNull OCExpression expression) {
        OCMethodSymbol method;
        if (expression == null) {
            OCConvertTypeIntentionAction.$$$reportNull$$$0(3);
        }
        if ((method = this.getMethod()) == null) {
            return;
        }
        String className = ((OCClassSymbol)method.getParent()).getName();
        if (method.getName().endsWith(":") && !method.getName().equals("getValue:")) {
            OCSendMessageExpression sendMessageExpression = this.wrapWithMethodCall(expression, null, method.getName(), className, expression, expression);
            if (!method.isStatic() && sendMessageExpression != null) {
                this.wrapWithMethodCall(sendMessageExpression.getReceiverExpression(), null, "alloc", className, null, expression);
            }
        } else {
            this.wrapWithMethodCall(expression, expression, method.getName(), className, null, expression);
        }
    }

    @Nullable
    private OCSendMessageExpression wrapWithMethodCall(PsiElement oldElement, @Nullable PsiElement receiver, String methodName, String className, @Nullable PsiElement argument, @NotNull OCExpression expression) {
        OCSendMessageExpression sendMessageExpr;
        String receiverText;
        if (expression == null) {
            OCConvertTypeIntentionAction.$$$reportNull$$$0(4);
        }
        String string = receiverText = receiver != null ? receiver.getText() : className;
        if (methodName.equals("getValue:")) {
            OCStatement curStatement = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)oldElement, OCStatement.class);
            if (curStatement != null) {
                String varName = OCNameSuggester.suggestUniqueName(OCSymbolKind.LOCAL_VARIABLE, "value", oldElement);
                OCDeclarationStatement declaration = OCElementFactory.declarationStatement(varName, this.myType, null, oldElement);
                String sendMessageText = "[ " + receiverText + " " + methodName + "&" + varName + " ]";
                OCExpressionStatement unbox = (OCExpressionStatement)OCElementFactory.statementFromText(sendMessageText, oldElement);
                if (receiver != null) {
                    OCChangeUtil.replaceHandlingMacros(((OCSendMessageExpression)unbox.getExpression()).getReceiverExpression(), receiver);
                }
                OCChangeUtil.addBefore(curStatement.getParent(), declaration, curStatement);
                OCChangeUtil.addBefore(curStatement.getParent(), unbox, curStatement);
                OCChangeUtil.replaceHandlingMacros(oldElement, OCElementFactory.expressionFromText(varName, oldElement));
            }
            return null;
        }
        String argumentText = "";
        if (argument != null) {
            argumentText = argument.getText();
            PsiElement prevElement = argument.getPrevSibling();
            if (prevElement instanceof OCMacroCall) {
                argumentText = prevElement.getText() + argumentText;
            }
        }
        if (methodName.equals("value:withObjCType:")) {
            String typeName = expression.getResolvedType().getBestNameInContext(expression);
            String sendMessageText = "[ " + receiverText + " value: " + argumentText + " withObjCType: @encode(" + typeName + ")]";
            sendMessageExpr = (OCSendMessageExpression)OCElementFactory.expressionFromText(sendMessageText, oldElement);
            if (receiver != null) {
                OCChangeUtil.replaceHandlingMacros(sendMessageExpr.getReceiverExpression(), receiver);
            }
            OCUnaryExpression addressExpr = (OCUnaryExpression)OCElementFactory.expressionFromText("&" + argumentText, oldElement);
            OCChangeUtil.replaceHandlingMacros(addressExpr.getOperand(), argument);
            OCChangeUtil.replaceHandlingMacros(sendMessageExpr.getArguments().get(0).getArgumentExpression(), addressExpr);
        } else {
            String sendMessageText = "[ " + receiverText + " " + methodName + argumentText + " ] ";
            sendMessageExpr = (OCSendMessageExpression)OCElementFactory.expressionFromText(sendMessageText, oldElement);
            if (receiver != null) {
                OCChangeUtil.replaceHandlingMacros(sendMessageExpr.getReceiverExpression(), receiver);
            }
            if (argument != null) {
                OCChangeUtil.replaceHandlingMacros(sendMessageExpr.getArguments().get(0).getArgumentExpression(), argument);
            }
        }
        return (OCSendMessageExpression)OCChangeUtil.replaceHandlingMacros(oldElement, sendMessageExpr);
    }

    @Nullable
    private OCMethodSymbol getMethod() {
        OCExpression expression = (OCExpression)this.myElementPtr.getElement();
        if (expression == null) {
            return null;
        }
        OCType exprType = expression.getResolvedType().getGuessedType();
        if (this.myType.isPointerToObject()) {
            if (exprType.getName().startsWith("NS") && this.myType.getName().equals("NSMutable" + exprType.getName().substring(2))) {
                CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
                ((OCObjectType)exprType.getTerminalType()).processMembers("mutableCopy", OCMethodSymbol.class, finder);
                return (OCMethodSymbol)finder.getFoundValue();
            }
            String prefix = exprType.isPointerToChar() ? "stringWith" : (exprType instanceof OCStructType ? "valueWith" : "numberWith");
            BoxingProcessor processor2 = new BoxingProcessor(exprType, prefix);
            ((OCObjectType)this.myType.getTerminalType()).processMembers(OCMethodSymbol.class, processor2);
            if (!processor2.isFound() && this.myType.isObjCRootType()) {
                OCType nsNumber = OCReferenceType.resolvedFromText("NSNumber", expression);
                OCType nsString = OCReferenceType.resolvedFromText("NSString", expression);
                if (nsNumber instanceof OCObjectType) {
                    ((OCObjectType)nsNumber).processMembers(OCMethodSymbol.class, processor2);
                }
                if (nsString instanceof OCObjectType) {
                    ((OCObjectType)nsString).processMembers(OCMethodSymbol.class, processor2);
                }
            }
            if (!processor2.isFound()) {
                processor2 = new BoxingProcessor(exprType, "initWith");
                ((OCObjectType)this.myType.getTerminalType()).processMembers(OCMethodSymbol.class, processor2);
            }
            return (OCMethodSymbol)processor2.getFoundValue();
        }
        if (exprType.isPointerToObject()) {
            OCType nsNumber;
            UnboxingProcessor processor3 = new UnboxingProcessor("Value", OCResolveContext.forPsi(expression));
            ((OCObjectType)exprType.getTerminalType()).processMembers(OCMethodSymbol.class, processor3);
            if (!processor3.isFound() && "id".equals(exprType.getName()) && (nsNumber = OCReferenceType.resolvedFromText("NSNumber", expression)) instanceof OCObjectType) {
                ((OCObjectType)nsNumber).processMembers(OCMethodSymbol.class, processor3);
            }
            return (OCMethodSymbol)processor3.getFoundValue();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCConvertTypeIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCConvertTypeIntentionAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithMethodCall";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class UnboxingProcessor
    extends CommonProcessors.FindFirstProcessor<OCMethodSymbol> {
        private final String myMethodSuffix;
        @NotNull
        private final OCResolveContext myContext;

        public UnboxingProcessor(@NotNull String methodSuffix, OCResolveContext context) {
            if (context == null) {
                UnboxingProcessor.$$$reportNull$$$0(0);
            }
            this.myMethodSuffix = methodSuffix;
            this.myContext = context;
        }

        public boolean process(OCMethodSymbol method) {
            if (method.getName().equals("pointerValue") && OCConvertTypeIntentionAction.this.myType instanceof OCPointerType && !OCConvertTypeIntentionAction.this.myType.isPointerToObject() && OCTollFreeBridges.getNSCounterpart(OCConvertTypeIntentionAction.this.myType.getName()) == null || method.getName().equals("getValue:") && OCConvertTypeIntentionAction.this.myType instanceof OCStructType && !OCTollFreeBridges.hasCFCounterpart(OCConvertTypeIntentionAction.this.myType.getName()) || method.getName().endsWith(this.myMethodSuffix) && method.getReturnType(this.myContext.getProject()).equalsWithAliasName(OCConvertTypeIntentionAction.this.myType, this.myContext) && !method.isStatic()) {
                return super.process((Object)method);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/quickfixes/OCConvertTypeIntentionAction$UnboxingProcessor", "<init>"));
        }
    }

    private class BoxingProcessor
    extends CommonProcessors.FindFirstProcessor<OCMethodSymbol> {
        private final OCType myExprType;
        private final String myMethodPrefix;

        public BoxingProcessor(OCType exprType, String methodPrefix) {
            this.myExprType = exprType;
            this.myMethodPrefix = methodPrefix;
        }

        public boolean process(OCMethodSymbol method) {
            OCDeclaratorSymbol declarator;
            if (method.getName().equals("valueWithPointer:") && this.myExprType instanceof OCPointerType && OCTollFreeBridges.getNSCounterpart(this.myExprType.getName()) == null || method.getName().equals("value:withObjCType:") && this.myExprType instanceof OCStructType && !OCTollFreeBridges.hasCFCounterpart(this.myExprType.getName())) {
                return super.process((Object)method);
            }
            if (method.getName().startsWith(this.myMethodPrefix) && method.getSelectors().size() == 1 && !method.isDeprecated() && (declarator = method.getSelectors().get(0).getParameter()) != null) {
                OCResolveContext context;
                OCType declType = declarator.getResolvedType(OCResolveContext.forSymbol(declarator, OCConvertTypeIntentionAction.this.getProject()));
                OCExpression element = (OCExpression)OCConvertTypeIntentionAction.this.myElementPtr.getElement();
                if (element != null && (declType.equalsWithAliasName(this.myExprType, context = OCResolveContext.forPsi(element)) || this.validateConstPointerTypes(declType, context))) {
                    return super.process((Object)method);
                }
            }
            return true;
        }

        private boolean validateConstPointerTypes(OCType declType, @NotNull OCResolveContext context) {
            if (context == null) {
                BoxingProcessor.$$$reportNull$$$0(0);
            }
            return declType instanceof OCPointerType && Comparing.equal((String)declType.getAliasName(), (String)this.myExprType.getAliasName()) && ((OCPointerType)declType).validateConstPointers(this.myExprType, context).getState() == OCTypeCheckState.OK;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/quickfixes/OCConvertTypeIntentionAction$BoxingProcessor", "validateConstPointerTypes"));
        }
    }
}

