/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCCreateDefinitionIntentionAction
implements IntentionAction {
    protected OCSymbolKind mySymbolKind;
    @NotNull
    protected PsiElement myUsage;
    protected OCSymbol myParent;

    public OCCreateDefinitionIntentionAction(OCSymbolKind symbolKind, @NotNull PsiElement usage, OCSymbol parent) {
        if (usage == null) {
            OCCreateDefinitionIntentionAction.$$$reportNull$$$0(0);
        }
        this.mySymbolKind = symbolKind;
        this.myUsage = usage;
        this.myParent = parent;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            OCCreateDefinitionIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file) {
        if (project2 == null) {
            OCCreateDefinitionIntentionAction.$$$reportNull$$$0(2);
        }
        if (!OCCodeInsightUtil.isValid(this.myUsage) || this.myParent != null && !OCSearchScope.isInProjectSources(this.myParent, project2)) {
            return false;
        }
        switch (this.mySymbolKind) {
            case FUNCTION_DECLARATION: 
            case METHOD: 
            case GLOBAL_VARIABLE: 
            case LOCAL_VARIABLE: 
            case PROPERTY: 
            case MACRO: {
                return true;
            }
            case STRUCT_FIELD: {
                return this.myParent != null;
            }
            case ENUM_CONST: {
                return this.myParent != null && this.myParent.getKind() == OCSymbolKind.ENUM;
            }
            case INSTANCE_VARIABLE: {
                OCMethod method = (OCMethod)PsiTreeUtil.getParentOfType((PsiElement)this.myUsage, OCMethod.class);
                return method == null || this.myUsage instanceof OCQualifiedExpression || method.isInstanceMethod();
            }
        }
        return false;
    }

    @Nullable
    protected abstract PsiElement getDefinition(Project var1, Editor var2, PsiFile var3);

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project2 == null) {
            OCCreateDefinitionIntentionAction.$$$reportNull$$$0(3);
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        ArrayList<PsiFile> filesToWrite = new ArrayList<PsiFile>();
        filesToWrite.add(file);
        if (this.mySymbolKind == OCSymbolKind.STRUCT_FIELD || this.mySymbolKind == OCSymbolKind.ENUM_CONST) {
            filesToWrite.add(this.myParent.getContainingOCFile(project2));
        }
        if (FileModificationService.getInstance().preparePsiElementsForWrite(filesToWrite)) {
            this.doCreate(project2, editor, file);
        }
    }

    protected boolean doCreate(Project project2, Editor editor, PsiFile file) {
        PsiElement result;
        PsiElement parentElement = this.myParent != null ? (PsiElement)this.myParent.locateDefinition(project2) : null;
        PsiElement definition = this.getDefinition(project2, editor, file);
        if (definition == null) {
            return false;
        }
        if (this.mySymbolKind == OCSymbolKind.FUNCTION_DECLARATION || this.mySymbolKind == OCSymbolKind.METHOD || this.mySymbolKind == OCSymbolKind.GLOBAL_VARIABLE || this.mySymbolKind == OCSymbolKind.LOCAL_VARIABLE || this.mySymbolKind == OCSymbolKind.MACRO || this.mySymbolKind == OCSymbolKind.ENUM_CONST && this.myParent != null) {
            Object parent = this.myParent != null ? this.myParent.locateDefinition(project2) : OCChangeUtil.getAppropriateParent(this.mySymbolKind, this.myUsage);
            if (parent == null) {
                return false;
            }
            result = OCChangeUtil.addBefore(parent, definition, this.myUsage);
        } else if (this.mySymbolKind == OCSymbolKind.STRUCT_FIELD || this.mySymbolKind == OCSymbolKind.PROPERTY) {
            if (this.myParent == null || parentElement == null) {
                return false;
            }
            result = OCChangeUtil.add(parentElement, definition);
        } else if (this.mySymbolKind == OCSymbolKind.INSTANCE_VARIABLE) {
            if (this.myParent == null || parentElement == null) {
                return false;
            }
            result = OCChangeUtil.add(((OCClassDeclaration)parentElement).getInstanceVariablesList(), definition);
        } else {
            return false;
        }
        if (result != null && this.mySymbolKind != OCSymbolKind.FUNCTION_DECLARATION && this.mySymbolKind != OCSymbolKind.METHOD) {
            if (editor != null && this.mySymbolKind == OCSymbolKind.GLOBAL_VARIABLE && definition instanceof OCDeclaration) {
                editor.getCaretModel().moveToOffset(((OCDeclaration)result).getDeclarators().get(0).getTextRange().getEndOffset());
                editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
            } else {
                OCCodeInsightUtil.selectElement(result);
            }
        }
        return true;
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCCreateDefinitionIntentionAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCCreateDefinitionIntentionAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

