/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.actions.newFile.OCNewClassAction;
import com.jetbrains.cidr.lang.actions.newFile.OCNewCppClassAction;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.actions.newFile.OCNewProtocolAction;
import com.jetbrains.cidr.lang.formatting.OCFormattingModelBuilder;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCppNewExpression;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.quickfixes.OCCreateDefinitionIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureActionHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.introduce.OCBaseIntroduceHandler;
import com.jetbrains.cidr.lang.refactoring.introduce.OCIntroduceIvarAction;
import com.jetbrains.cidr.lang.refactoring.introduce.OCIntroduceParameterAction;
import com.jetbrains.cidr.lang.refactoring.introduce.OCIntroducePropertyAction;
import com.jetbrains.cidr.lang.refactoring.introduce.OCIntroduceVariableAction;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import com.jetbrains.cidr.lang.types.OCBracedInitListType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCBooleanTypeVisitor;
import com.jetbrains.cidr.lang.types.visitors.names.OCTypeNameVisitor;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCreateNewDefinitionIntentionAction
extends OCCreateDefinitionIntentionAction {
    private String myName;
    private OCType myType;
    private OCObjectType myReceiverType;
    private OCPropertySymbol myPropertySymbol;
    private OCExpectedTypeUtil.Expectable myExpectableType;
    private boolean myIsStaticMember;
    private boolean mySilentMode;
    private String myMessageSignature;

    public OCCreateNewDefinitionIntentionAction(OCSymbolKind symbolKind, @NotNull PsiElement usage, @Nullable OCPropertySymbol propertySymbol, OCSymbol parent, String name2, OCType type, boolean staticMember) {
        if (usage == null) {
            OCCreateNewDefinitionIntentionAction.$$$reportNull$$$0(0);
        }
        super(symbolKind, usage, parent);
        this.mySilentMode = ApplicationManager.getApplication().isUnitTestMode();
        this.myName = name2;
        this.myType = type;
        this.myPropertySymbol = propertySymbol;
        this.myIsStaticMember = staticMember;
    }

    public OCCreateNewDefinitionIntentionAction(OCSymbolKind symbolKind, @NotNull PsiElement usage, OCSymbol parent, String name2, OCType type) {
        if (usage == null) {
            OCCreateNewDefinitionIntentionAction.$$$reportNull$$$0(1);
        }
        this(symbolKind, usage, null, parent, name2, type, false);
    }

    public OCCreateNewDefinitionIntentionAction(@NotNull PsiElement usage, OCSymbol parent, String name2, String messageSignature, OCType returnType, @Nullable OCObjectType receiverType) {
        if (usage == null) {
            OCCreateNewDefinitionIntentionAction.$$$reportNull$$$0(2);
        }
        this(OCSymbolKind.METHOD, usage, null, parent, name2, returnType, false);
        this.myMessageSignature = messageSignature;
        this.myReceiverType = receiverType;
        if (receiverType instanceof OCIdType) {
            this.myParent = null;
            for (OCProtocolSymbol protocolSymbol : receiverType.getAllProtocols()) {
                if (!OCSearchScope.isInProjectSources(protocolSymbol, usage.getProject()) || protocolSymbol.isPredeclaration()) continue;
                this.myParent = protocolSymbol;
                break;
            }
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            OCSymbol parentInProject = this.getParentInProject();
            this.myParent = parentInProject != null ? parentInProject : this.myParent;
        }
    }

    public OCCreateNewDefinitionIntentionAction(OCSymbolContext symbolContext, PsiElement usage, String name2) {
        super(symbolContext.getSymbolKind(), usage, symbolContext.getParent());
        this.mySilentMode = ApplicationManager.getApplication().isUnitTestMode();
        this.myName = name2;
        this.myExpectableType = symbolContext.getExpectable();
        this.myIsStaticMember = symbolContext instanceof OCSymbolContext.StructMemberContext && ((OCSymbolContext.StructMemberContext)symbolContext).isStatic();
        this.myPropertySymbol = null;
    }

    public void setSilentMode(boolean silentMode) {
        this.mySilentMode = silentMode;
    }

    @NotNull
    public String getText() {
        String subject = "";
        if (this.mySymbolKind == OCSymbolKind.INTERFACE) {
            subject = "class";
        } else {
            if (this.myIsStaticMember) {
                switch (this.mySymbolKind) {
                    case INSTANCE_VARIABLE: 
                    case PROPERTY: 
                    case METHOD: {
                        subject = "class ";
                        break;
                    }
                    default: {
                        subject = "static ";
                    }
                }
            }
            subject = this.mySymbolKind == OCSymbolKind.STRUCT ? "C++ class" : subject + this.mySymbolKind.getNameLowercase();
        }
        StringBuilder builder = new StringBuilder();
        if (this.myParent != null && this.myReceiverType != null && this.getParentInProject() == null) {
            builder.append("Create new category on ").append(this.myParent.getName()).append(" with ");
        } else {
            builder.append("Create new ");
        }
        builder.append(subject).append(" '");
        if (this.mySymbolKind.isFunctionOrConstructor() && this.myType instanceof OCFunctionType) {
            builder.append(OCTypeNameVisitor.getFunctionSignature(OCResolveContext.forPsi(this.myUsage), (OCFunctionType)this.myType, this.myName, false, null));
        } else {
            builder.append(this.myName);
        }
        String string = builder.append("'").toString();
        if (string == null) {
            OCCreateNewDefinitionIntentionAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file) {
        if (project2 == null) {
            OCCreateNewDefinitionIntentionAction.$$$reportNull$$$0(4);
        }
        if (this.myName == null || !OCCodeInsightUtil.isValid(this.myUsage) || this.myParent != null && !OCSearchScope.isInProjectSources(this.myParent, project2) && this.mySymbolKind != OCSymbolKind.METHOD) {
            return false;
        }
        if (!this.mySymbolKind.isClass() && this.mySymbolKind != OCSymbolKind.STRUCT && this.myUsage instanceof OCReferenceElement && !(this.myUsage.getParent() instanceof OCReferenceExpression) && !(this.myUsage.getParent() instanceof OCSynthesizeProperty)) {
            return false;
        }
        if (this.myType == null && this.myExpectableType != null) {
            this.myType = this.myExpectableType.getExpectedType();
        }
        if (this.myType != null && this.myType.accept(new OCBooleanTypeVisitor(){

            @Override
            public Boolean visitUnknownType(OCUnknownType type) {
                return true;
            }
        }).booleanValue()) {
            return false;
        }
        if (this.hasBracedInitListParams()) {
            return false;
        }
        boolean isFunctionType = this.myType instanceof OCFunctionType;
        switch (this.mySymbolKind) {
            case CPP_CONSTRUCTOR_DECLARATION: {
                if (!isFunctionType || this.myParent == null || this.myParent.isPredeclaration()) {
                    return false;
                }
                if (this.myUsage instanceof OCReferenceExpression) {
                    this.myUsage = ((OCReferenceExpression)this.myUsage).getReferenceElement();
                }
                return !(this.myUsage instanceof OCReferenceElement) || ((OCReferenceElement)this.myUsage).getName().equals(this.myParent.getName());
            }
            case FUNCTION_DECLARATION: {
                return isFunctionType && (this.myParent == null || !this.myParent.isPredeclaration());
            }
            case PARAMETER: {
                return this.myParent != null && !isFunctionType;
            }
            case METHOD: {
                return (this.myParent == null || this.myParent instanceof OCClassSymbol && !this.myParent.isPredeclaration()) && this.myMessageSignature != null && (this.myMessageSignature.startsWith("+") || this.myMessageSignature.startsWith("-"));
            }
            case INTERFACE: 
            case PROTOCOL: {
                return (file == null || file instanceof OCFile && ((OCFile)file).getKind().isObjC()) && OCNewFileActionBase.isNewFileActionSupported() && !ApplicationManager.getApplication().isUnitTestMode();
            }
            case STRUCT: {
                return (file == null || file instanceof OCFile && ((OCFile)file).getKind().isCpp()) && OCNewFileActionBase.isNewFileActionSupported() && !ApplicationManager.getApplication().isUnitTestMode();
            }
            case INSTANCE_VARIABLE: 
            case PROPERTY: {
                if (this.myParent != null && !this.myParent.isPredeclaration()) break;
                return false;
            }
        }
        return super.isAvailable(project2, editor, file) && this.myType != null && !isFunctionType;
    }

    private boolean hasBracedInitListParams() {
        return this.myType instanceof OCFunctionType && ((OCFunctionType)this.myType).getParameterTypes().stream().anyMatch(type -> type instanceof OCBracedInitListType);
    }

    @Nullable
    private OCSymbol getParentInProject() {
        Project project2 = this.myUsage.getProject();
        if (this.myParent == null || OCSearchScope.isInProjectSources(this.myParent, project2) || this.myReceiverType == null) {
            return this.myParent;
        }
        for (OCProtocolSymbol oCProtocolSymbol : this.myReceiverType.getAugmentedProtocols()) {
            if (!OCSearchScope.isInProjectSources(oCProtocolSymbol, project2)) continue;
            return oCProtocolSymbol;
        }
        for (OCInterfaceSymbol oCInterfaceSymbol : this.myReceiverType.getCategoryInterfaces()) {
            if (!OCSearchScope.isInProjectSources(oCInterfaceSymbol, project2)) continue;
            return oCInterfaceSymbol;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doCreate(final Project project2, Editor editor, final PsiFile file) {
        OCNewFileActionBase action = null;
        OCBaseIntroduceHandler introduceHandler = null;
        if (this.mySymbolKind == OCSymbolKind.INTERFACE) {
            action = new OCNewClassAction();
        } else if (this.mySymbolKind == OCSymbolKind.PROTOCOL) {
            action = new OCNewProtocolAction();
        } else if (this.mySymbolKind == OCSymbolKind.STRUCT) {
            action = new OCNewCppClassAction();
            this.createCppConstructor(action);
        } else if (this.mySymbolKind == OCSymbolKind.LOCAL_VARIABLE) {
            introduceHandler = (OCBaseIntroduceHandler)new OCIntroduceVariableAction().getHandler();
        } else if (this.mySymbolKind == OCSymbolKind.PARAMETER) {
            introduceHandler = (OCBaseIntroduceHandler)new OCIntroduceParameterAction().getHandler();
        } else if (this.mySymbolKind == OCSymbolKind.INSTANCE_VARIABLE) {
            introduceHandler = (OCBaseIntroduceHandler)new OCIntroduceIvarAction().getHandler();
        } else if (this.mySymbolKind == OCSymbolKind.PROPERTY) {
            introduceHandler = (OCBaseIntroduceHandler)new OCIntroducePropertyAction().getHandler();
        } else {
            if (this.mySymbolKind.isFunctionOrConstructor()) {
                return this.createFunction();
            }
            if (this.mySymbolKind == OCSymbolKind.METHOD) {
                return this.createMethod();
            }
            return super.doCreate(project2, editor, file);
        }
        if (introduceHandler != null) {
            OCBaseIntroduceHandler finalIntroduceHandler = introduceHandler;
            Runnable runnable2 = () -> {
                OCElement usage = null;
                if (this.mySymbolKind == OCSymbolKind.PROPERTY || this.mySymbolKind == OCSymbolKind.INSTANCE_VARIABLE) {
                    usage = (OCElement)PsiTreeUtil.getParentOfType((PsiElement)this.myUsage, OCElement.class, (boolean)false);
                } else if (this.myUsage instanceof OCReferenceElement && this.myUsage.getParent() instanceof OCReferenceExpression) {
                    usage = (OCReferenceExpression)this.myUsage.getParent();
                }
                if (usage != null) {
                    finalIntroduceHandler.invoke(project2, editor, usage, this.myType.resolve(usage), true, false, this.myName, this.myParent);
                }
            };
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                runnable2.run();
            } else {
                ApplicationManager.getApplication().invokeLater(runnable2);
            }
            return true;
        }
        if (action != null && action.performAction(project2, file.getParent(), file, this.myName) == null) {
            return false;
        }
        if (this.myUsage instanceof OCReferenceElement && this.myUsage.getText().equals(this.myName)) {
            final OCImportSymbolFix importFix = new OCImportSymbolFix((OCReferenceElement)this.myUsage);
            try {
                OCFormattingModelBuilder.requestAlwaysCreateFullModel();
                new WriteCommandAction(project2, new PsiFile[0]){

                    protected void run(@NotNull Result result) throws Throwable {
                        if (result == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        importFix.fixFirstItem(project2, file);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/cidr/lang/quickfixes/OCCreateNewDefinitionIntentionAction$2", "run"));
                    }
                }.execute();
            }
            finally {
                OCFormattingModelBuilder.releaseAlwaysCreateFullModel();
            }
        }
        return true;
    }

    private void createCppConstructor(OCNewFileActionBase action) {
        OCArgumentList argumentList;
        PsiElement constructorUsage;
        PsiElement parent = this.myUsage.getParent();
        if (parent instanceof OCReferenceExpression && parent.getParent() instanceof OCCallExpression) {
            constructorUsage = parent;
            argumentList = ((OCCallExpression)parent.getParent()).getArgumentList();
        } else if (parent.getParent() instanceof OCCppNewExpression) {
            constructorUsage = parent.getParent();
            argumentList = ((OCCppNewExpression)constructorUsage).getArgumentList();
        } else {
            constructorUsage = null;
            argumentList = null;
        }
        if (argumentList != null) {
            action.addAuxAction(createdElements -> {
                PsiFile psiFile;
                OCSymbol clazz = null;
                PsiFile[] psiFileArray = createdElements;
                int n = psiFileArray.length;
                for (int i = 0; i < n && (clazz = ((OCFile)(psiFile = psiFileArray[i])).getSameNamedClass()) == null; ++i) {
                }
                if (clazz != null) {
                    OCFunctionType type = new OCFunctionType(OCVoidType.instance(), argumentList.getArgumentTypes(OCResolveContext.forPsi(this.myUsage)));
                    OCCreateNewDefinitionIntentionAction constructorAction = new OCCreateNewDefinitionIntentionAction(OCSymbolKind.CPP_CONSTRUCTOR_DECLARATION, constructorUsage, clazz, this.myName, type);
                    constructorAction.setSilentMode(true);
                    Project project2 = this.myUsage.getProject();
                    OCFile file = clazz.getContainingOCFile(project2);
                    if (constructorAction.isAvailable(project2, null, file)) {
                        constructorAction.invoke(project2, null, file);
                    }
                }
            });
        }
    }

    private boolean createMethod() {
        PsiElement parent;
        if (this.myType == null || this.myType == OCUnknownType.INSTANCE) {
            this.myType = OCVoidType.instance();
        }
        PsiElement insertionPoint = (parent = OCChangeUtil.getAppropriateParent(this.mySymbolKind, this.myUsage)) != null ? OCChangeUtil.getRealAnchorForInsertion(parent, this.myUsage) : null;
        insertionPoint = insertionPoint != null ? insertionPoint : this.myUsage;
        OCMethod method = (OCMethod)WriteAction.compute(() -> {
            String functionText = OCCallableUtil.methodWithSignature(this.myType, this.myMessageSignature, this.myUsage);
            return OCElementFactory.methodFromText(functionText, this.myUsage, true);
        });
        OCChangeSignatureHandler handler = OCChangeSignatureActionHandler.getHandler((OCCallable)method, insertionPoint);
        handler.getGeneratedInfo().setMethodReference(this.myUsage);
        List auxParents = this.myReceiverType != null ? this.myReceiverType.getAugmentedProtocols() : Collections.emptyList();
        handler.setParentClass(this.myParent, true, auxParents);
        handler.setChangeUsages(false);
        handler.getGeneratedInfo().setSelectMethod(!this.mySilentMode);
        handler.setTitle("Create new method");
        handler.setRefactorButtonText("Create");
        if (this.myParent == null || this.myReceiverType == null) {
            handler.setChangeParentClassPossible(true);
        }
        if (this.mySilentMode) {
            handler.invokeSynchronously();
        } else {
            handler.invoke();
        }
        return true;
    }

    private boolean createFunction() {
        PsiElement declaration;
        OCSymbolWithQualifiedName callerParent;
        if (!(this.myType instanceof OCFunctionType)) {
            return false;
        }
        Project project2 = this.myUsage.getProject();
        Object parent = this.myParent != null ? this.myParent.locateDefinition(project2) : OCChangeUtil.getAppropriateParent(this.mySymbolKind, this.myUsage);
        OCFunctionDefinition caller = (OCFunctionDefinition)PsiTreeUtil.getParentOfType((PsiElement)this.myUsage, OCFunctionDefinition.class);
        OCFunctionSymbol callerSymbol = caller != null ? caller.getSymbol() : null;
        PsiElement insertionPoint = (PsiElement)ObjectUtils.notNull((Object)OCChangeUtil.getRealAnchorForInsertion(parent, this.myUsage), (Object)this.myUsage);
        if (callerSymbol != null && (callerParent = callerSymbol.getResolvedOwner(OCResolveContext.forPsi(this.myUsage))) != null && callerParent.isSameSymbol(this.myParent, project2)) {
            this.myType = this.myType.cloneWithAddedCVQualifiers(callerSymbol.getType().getCVQualifiers(), project2);
        }
        boolean signatureOnly = this.myUsage instanceof OCDeclarator ? (declaration = this.myUsage.getParent()) instanceof OCFunctionDeclaration && ((OCFunctionDeclaration)declaration).getBody() != null : false;
        String signature = this.getFunctionSignature(insertionPoint);
        OCCallable function = (OCCallable)WriteAction.compute(() -> {
            OCDeclaration declaration;
            if (this.mySymbolKind.isConstructorOrDestructor()) {
                declaration = OCElementFactory.constructorFromText(signature, this.myUsage, true);
            } else if (this.myParent instanceof OCStructSymbol) {
                declaration = (OCDeclaration)OCElementFactory.topLevelDeclarationFromText(signature, this.myUsage, true);
            } else {
                String functionText = signatureOnly ? signature : OCCallableUtil.functionWithSignature(((OCFunctionType)this.myType).getReturnType(), signature, this.myUsage);
                declaration = (OCDeclaration)OCElementFactory.topLevelDeclarationFromText(functionText, this.myUsage, true);
            }
            OCLog.LOG.assertTrue(declaration instanceof OCCallable, (Object)declaration.getTextWithMacros());
            return (OCCallable)((Object)declaration);
        });
        OCChangeSignatureHandler handler = this.mySymbolKind.isConstructorOrDestructor() ? OCChangeSignatureActionHandler.getHandler(function, insertionPoint, false, this.mySilentMode, !this.mySilentMode, true) : OCChangeSignatureActionHandler.getHandler(function, insertionPoint, this.mySilentMode);
        handler.getGeneratedInfo().setMethodReference(this.myUsage);
        handler.setParentClass(this.myParent, false, Collections.emptyList());
        handler.getGeneratedInfo().setSelectMethod(!this.mySilentMode);
        handler.setTitle(this.mySymbolKind.isConstructorOrDestructor() ? "Create new constructor" : "Create new function");
        handler.setRefactorButtonText("Create");
        if (this.mySilentMode) {
            handler.invokeSynchronously();
        } else {
            handler.invoke();
        }
        return true;
    }

    protected String getFunctionSignature(@NotNull PsiElement insertionPoint) {
        if (insertionPoint == null) {
            OCCreateNewDefinitionIntentionAction.$$$reportNull$$$0(5);
        }
        StringBuilder signature = new StringBuilder();
        OCResolveContext context = OCResolveContext.forPsi(insertionPoint);
        signature.append(OCCallableUtil.getFunctionTemplateHeader(this.myType, context));
        if (!this.mySymbolKind.isConstructorOrDestructor()) {
            if (this.myIsStaticMember) {
                signature.append("static ");
            }
            signature.append(((OCFunctionType)this.myType).getReturnType().getBestNameInContext(context));
            signature.append(' ');
        }
        signature.append(this.myName);
        List<OCExpression> arguments = this.myUsage instanceof OCReferenceElement && this.myUsage.getParent().getParent() instanceof OCCallExpression ? ((OCCallExpression)this.myUsage.getParent().getParent()).getArguments() : null;
        return OCTypeNameVisitor.getFunctionSignature(context, (OCFunctionType)this.myType, signature.toString(), true, arguments);
    }

    @Override
    @Nullable
    public PsiElement getDefinition(Project project2, Editor editor, PsiFile file) {
        OCResolveContext context = OCResolveContext.forNullablePsi((PsiElement)file, project2);
        switch (this.mySymbolKind) {
            case INSTANCE_VARIABLE: 
            case GLOBAL_VARIABLE: 
            case LOCAL_VARIABLE: {
                ARCAttribute ivarAttribute;
                OCPropertySymbol.PropertyAttribute propAttribute;
                OCType type;
                String modifier = null;
                OCType oCType = type = this.myPropertySymbol != null ? this.myPropertySymbol.getResolvedType(context) : null;
                if (this.myPropertySymbol instanceof OCPropertySymbol && OCCompilerFeatures.isArcEnabled(file) && type.isPointerToObjectCompatible() && (propAttribute = this.myPropertySymbol.getAttributeOfGroup(OCPropertySymbol.PropertyAttribute.ASSIGN, type, (PsiElement)file)) != null && !(ivarAttribute = propAttribute.getIvarCompatibleARCAttribute()).isDefault()) {
                    modifier = ivarAttribute.getTokenName();
                }
                return OCElementFactory.declaration(modifier, this.myName, this.myType, this.myUsage);
            }
            case STRUCT_FIELD: 
            case ENUM_CONST: {
                if (this.myParent != null && this.myParent.getKind() == OCSymbolKind.ENUM) {
                    return OCElementFactory.enumConst(this.myName, (PsiElement)file);
                }
                return OCElementFactory.declaration(this.myIsStaticMember ? "static" : null, this.myName, this.myType, this.myUsage);
            }
            case PROPERTY: {
                return OCElementFactory.propertyDeclaration(this.myName, this.myType.resolve(context), (PsiElement)file);
            }
            case MACRO: {
                return OCElementFactory.macroDeclarationFromText(this.myName, this.myType.resolve(context).getDefaultValue(context), file);
            }
        }
        return null;
    }

    @Override
    public boolean startInWriteAction() {
        switch (this.mySymbolKind) {
            case INSTANCE_VARIABLE: 
            case PROPERTY: 
            case METHOD: 
            case CPP_CONSTRUCTOR_DECLARATION: 
            case FUNCTION_DECLARATION: 
            case PARAMETER: 
            case INTERFACE: 
            case PROTOCOL: 
            case STRUCT: 
            case LOCAL_VARIABLE: 
            case FUNCTION_PREDECLARATION: 
            case CPP_CONSTRUCTOR_PREDECLARATION: {
                return false;
            }
        }
        return super.startInWriteAction();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCCreateNewDefinitionIntentionAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertionPoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCCreateNewDefinitionIntentionAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionSignature";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

