/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import org.jetbrains.annotations.NotNull;

public class OCMakeFunctionVirtualFix
extends OCSymbolQuickFix<OCFunctionSymbol> {
    private boolean isPure;

    public OCMakeFunctionVirtualFix(@NotNull OCFunctionSymbol symbol, boolean pure) {
        if (symbol == null) {
            OCMakeFunctionVirtualFix.$$$reportNull$$$0(0);
        }
        super(symbol);
        this.isPure = pure;
    }

    @Override
    public boolean isAvailable() {
        return super.isAvailable() && ((OCFunctionSymbol)this.mySymbol).getParent() != null && !((OCFunctionSymbol)this.mySymbol).isCppConstructor() && !((OCFunctionSymbol)this.mySymbol).isFriendOrStatic();
    }

    @Override
    protected String getTextInternal() {
        return "Make " + ((OCFunctionSymbol)this.mySymbol).getParent().getName() + "::" + ((OCFunctionSymbol)this.mySymbol).getName() + (this.isPure ? " pure virtual" : " virtual");
    }

    @NotNull
    public String getFamilyName() {
        if ("Make function virtual" == null) {
            OCMakeFunctionVirtualFix.$$$reportNull$$$0(1);
        }
        return "Make function virtual";
    }

    @Override
    protected void invoke(@NotNull Project project2, Editor editor) {
        OCFunctionDeclaration function;
        if (project2 == null) {
            OCMakeFunctionVirtualFix.$$$reportNull$$$0(2);
        }
        if ((function = ((OCFunctionSymbol)this.mySymbol).locateFunctionDefinition(project2)) != null) {
            int offset;
            if (this.isPure) {
                offset = function.getDeclarator().getTextRange().getEndOffset();
                OCChangeUtil.changeText(function.getProject(), function.getContainingFile(), offset, 0, "= 0", false);
            }
            if (!((OCFunctionSymbol)this.mySymbol).isVirtual()) {
                offset = function.getTextRange().getStartOffset();
                OCChangeUtil.changeText(function.getProject(), function.getContainingFile(), offset, 0, "virtual ", false);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCMakeFunctionVirtualFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCMakeFunctionVirtualFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

