/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.quickfixes.OCCreateDefinitionIntentionAction;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCNormalizeUtil;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import org.jetbrains.annotations.NotNull;

public class OCMoveDefinitionIntentionAction
extends OCCreateDefinitionIntentionAction {
    private OCSymbol myOldDefinitionSymbol;
    private String myIntentionNameSuffix;
    private PsiElement myOldDefinition;

    public OCMoveDefinitionIntentionAction(OCSymbolKind symbolKind, PsiElement usage, OCSymbol parent, OCSymbol oldDefinitionSymbol, String intentionNameSuffix) {
        super(symbolKind, usage, parent);
        this.myOldDefinitionSymbol = oldDefinitionSymbol;
        this.myIntentionNameSuffix = intentionNameSuffix;
    }

    public OCMoveDefinitionIntentionAction(OCSymbolKind symbolKind, PsiElement context, @NotNull OCSymbol parent, OCSymbol oldDefinitionSymbol) {
        if (parent == null) {
            OCMoveDefinitionIntentionAction.$$$reportNull$$$0(0);
        }
        super(symbolKind, context, parent);
        this.myOldDefinitionSymbol = oldDefinitionSymbol;
        this.myIntentionNameSuffix = " to " + parent.getNameWithKindLowercase(OCCompilationContext.create(this.myUsage));
    }

    @Override
    public PsiElement getDefinition(Project project2, Editor editor, PsiFile file) {
        Object definition = this.myOldDefinitionSymbol.locateDefinition(project2);
        if (definition == null) {
            return null;
        }
        if (definition instanceof OCDeclarator) {
            definition = OCNormalizeUtil.normalizeDeclarator((OCDeclarator)definition);
        }
        if (definition == null) {
            return null;
        }
        if (this.mySymbolKind == OCSymbolKind.PROPERTY) {
            definition = PsiTreeUtil.getContextOfType(definition, (Class[])new Class[]{OCProperty.class});
        }
        this.myOldDefinition = definition;
        return this.myOldDefinition;
    }

    @NotNull
    public String getText() {
        if (this.myOldDefinitionSymbol == null) {
            if ("Invalid" == null) {
                OCMoveDefinitionIntentionAction.$$$reportNull$$$0(1);
            }
            return "Invalid";
        }
        String string = "Move declaration of " + this.myOldDefinitionSymbol.getNameWithKindLowercase(OCCompilationContext.create(this.myUsage)) + this.myIntentionNameSuffix;
        if (string == null) {
            OCMoveDefinitionIntentionAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected boolean doCreate(Project project2, Editor editor, PsiFile file) {
        if (super.doCreate(project2, editor, file)) {
            OCChangeUtil.delete(this.myOldDefinition);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCMoveDefinitionIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCMoveDefinitionIntentionAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

