/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolGroupContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import org.jetbrains.annotations.NotNull;

public class OCPredeclareSymbolIntentionAction
extends OCPsiElementQuickFix<OCReferenceElement> {
    private String myName;
    private OCSymbolKind mySymbolKind;

    public OCPredeclareSymbolIntentionAction(@NotNull OCReferenceElement element) {
        if (element == null) {
            OCPredeclareSymbolIntentionAction.$$$reportNull$$$0(0);
        }
        super(element);
        this.myName = element.getName();
        OCSymbolGroupContext context = element.getSymbolContext();
        if (context != null && context.isSuitableSymbolKind(OCSymbolKind.PROTOCOL)) {
            this.mySymbolKind = OCSymbolKind.PROTOCOL;
        } else if (context != null && context.isSuitableSymbolKind(OCSymbolKind.INTERFACE)) {
            this.mySymbolKind = OCSymbolKind.INTERFACE;
        } else if (context != null && context.isSuitableSymbolKind(OCSymbolKind.STRUCT) && !(element.getParent().getParent() instanceof OCCallExpression)) {
            this.mySymbolKind = OCSymbolKind.STRUCT;
        }
    }

    @Override
    protected String getTextInternal() {
        return "Predeclare " + (this.mySymbolKind == OCSymbolKind.PROTOCOL ? "protocol '" : "class '") + this.myName + "'";
    }

    @NotNull
    public String getFamilyName() {
        if ("Import/predeclare symbol" == null) {
            OCPredeclareSymbolIntentionAction.$$$reportNull$$$0(1);
        }
        return "Import/predeclare symbol";
    }

    @Override
    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file) {
        if (project2 == null) {
            OCPredeclareSymbolIntentionAction.$$$reportNull$$$0(2);
        }
        return file instanceof OCFile && !(file instanceof OCCodeFragment) && OCCodeInsightUtil.isValid((PsiElement)file) && this.mySymbolKind != null;
    }

    @Override
    protected void invoke(PsiFile file, @NotNull OCReferenceElement element) {
        if (element == null) {
            OCPredeclareSymbolIntentionAction.$$$reportNull$$$0(3);
        }
        String text = this.mySymbolKind == OCSymbolKind.PROTOCOL ? "@protocol " + this.myName + ";" : (this.mySymbolKind == OCSymbolKind.INTERFACE ? "@class " + this.myName + ";" : "class " + this.myName + ";");
        OCChangeUtil.addBefore((PsiElement)file, OCElementFactory.topLevelDeclarationFromText(text, (PsiElement)file), element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCPredeclareSymbolIntentionAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCPredeclareSymbolIntentionAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

